/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V100;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItemLists;
import ca.spottedleaf.dataconverter.minecraft.walkers.itemstack.DataWalkerItems;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;

public final class V3808 {
    private static final int VERSION = 3808;

    public static void register() {
        class BodyArmorConverter
        extends DataConverter<MapType<String>, MapType<String>> {
            private final String path;
            private final boolean clearArmor;

            public BodyArmorConverter(int toVersion, String path, boolean clearArmor) {
                this(toVersion, 0, path, clearArmor);
            }

            public BodyArmorConverter(int toVersion, int versionStep, String path, boolean clearArmor) {
                super(toVersion, versionStep);
                this.path = path;
                this.clearArmor = clearArmor;
            }

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType prev = data.getMap(this.path);
                if (prev == null) {
                    return null;
                }
                data.remove(this.path);
                data.setMap("body_armor_item", prev);
                data.setFloat("body_armor_drop_chance", 2.0f);
                if (this.clearArmor) {
                    ListType chances;
                    ListType armor = data.getList("ArmorItems", ObjectType.MAP);
                    if (armor.size() > 2) {
                        armor.setMap(2, data.getTypeUtil().createEmptyMap());
                    }
                    if ((chances = data.getList("ArmorDropChances", ObjectType.FLOAT)).size() > 2) {
                        chances.setFloat(2, 0.085f);
                    }
                }
                return null;
            }
        }
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:horse", new BodyArmorConverter(3808, "ArmorItem", true));
        MCTypeRegistry.ENTITY.addWalker(3808, "minecraft:horse", new DataWalkerItems("SaddleItem"));
        V100.registerEquipment(3808, "minecraft:horse");
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:llama", new BodyArmorConverter(3808, 1, "DecorItem", false));
        MCTypeRegistry.ENTITY.addWalker(3808, 1, "minecraft:llama", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(3808, 1, "minecraft:llama", new DataWalkerItems("SaddleItem"));
        V100.registerEquipment(3808, 1, "minecraft:llama");
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:trader_llama", new BodyArmorConverter(3808, 2, "DecorItem", false));
        MCTypeRegistry.ENTITY.addWalker(3808, 2, "minecraft:trader_llama", new DataWalkerItemLists("Items"));
        MCTypeRegistry.ENTITY.addWalker(3808, 2, "minecraft:trader_llama", new DataWalkerItems("SaddleItem"));
        V100.registerEquipment(3808, 2, "minecraft:trader_llama");
    }

    private V3808() {
    }
}

