/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V3807;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;

public final class V3813 {
    private static final int VERSION = 3813;
    private static final String[] PATROLLING_MOBS = new String[]{"minecraft:witch", "minecraft:ravager", "minecraft:pillager", "minecraft:illusioner", "minecraft:evoker", "minecraft:vindicator"};

    public static void register() {
        class RootPositionConverter
        extends DataConverter<MapType<String>, MapType<String>> {
            private final RenamePair[] convert;

            public RootPositionConverter(int toVersion, RenamePair[] convert) {
                this(toVersion, 0, convert);
            }

            public RootPositionConverter(int toVersion, int versionStep, RenamePair[] convert) {
                super(toVersion, versionStep);
                this.convert = convert;
            }

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                for (RenamePair rename : this.convert) {
                    V3807.flattenBlockPos(data, rename.from);
                    RenameHelper.renameSingle(data, rename.from, rename.to);
                }
                return null;
            }
        }
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:bee", new RootPositionConverter(3813, new RenamePair[]{new RenamePair("HivePos", "hive_pos"), new RenamePair("FlowerPos", "flower_pos")}));
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:end_crystal", new RootPositionConverter(3813, new RenamePair[]{new RenamePair("BeamTarget", "beam_target")}));
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:wandering_trader", new RootPositionConverter(3813, new RenamePair[]{new RenamePair("WanderTarget", "wander_target")}));
        RootPositionConverter patrolConverter = new RootPositionConverter(3813, new RenamePair[]{new RenamePair("PatrolTarget", "patrol_target")});
        for (String id : PATROLLING_MOBS) {
            MCTypeRegistry.ENTITY.addConverterForId(id, patrolConverter);
        }
        MCTypeRegistry.ENTITY.addStructureConverter(new RootPositionConverter(3813, new RenamePair[]{new RenamePair("Leash", "leash")}));
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:beehive", new RootPositionConverter(3813, new RenamePair[]{new RenamePair("FlowerPos", "flower_pos")}));
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:end_gateway", new RootPositionConverter(3813, new RenamePair[]{new RenamePair("ExitPortal", "exit_portal")}));
        MCTypeRegistry.SAVED_DATA_MAP_DATA.addStructureConverter(new DataConverter<MapType<String>, MapType<String>>(3813){

            @Override
            public MapType<String> convert(MapType<String> root, long sourceVersion, long toVersion) {
                MapType data = root.getMap("data");
                if (data == null) {
                    return null;
                }
                ListType frames = data.getList("frames", ObjectType.MAP);
                if (frames != null) {
                    int len = frames.size();
                    for (int i = 0; i < len; ++i) {
                        MapType<String> frame = frames.getMap(i);
                        V3807.flattenBlockPos(frame, "Pos");
                        RenameHelper.renameSingle(frame, "Pos", "pos");
                        RenameHelper.renameSingle(frame, "Rotation", "rotation");
                        RenameHelper.renameSingle(frame, "EntityId", "entity_id");
                    }
                }
                ListType banners = data.getList("banners", ObjectType.MAP);
                int len = banners.size();
                for (int i = 0; i < len; ++i) {
                    MapType<String> banner = banners.getMap(i);
                    RenameHelper.renameSingle(banner, "Pos", "pos");
                    RenameHelper.renameSingle(banner, "Color", "color");
                    RenameHelper.renameSingle(banner, "Name", "name");
                }
                return null;
            }
        });
        MCTypeRegistry.ITEM_STACK.addConverterForId("minecraft:compass", new DataConverter<MapType<String>, MapType<String>>(3813){

            @Override
            public MapType<String> convert(MapType<String> data, long sourceVersion, long toVersion) {
                MapType<String> tag = data.getMap("tag");
                if (tag == null) {
                    return null;
                }
                V3807.flattenBlockPos(tag, "LodestonePos");
                return null;
            }
        });
    }

    private V3813() {
    }

    private record RenamePair(String from, String to) {
    }
}

