/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.nbt;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.Types;
import ca.spottedleaf.dataconverter.types.nbt.NBTListType;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public final class NBTMapType
implements MapType<String> {
    private final CompoundTag map;

    public NBTMapType() {
        this.map = new CompoundTag();
    }

    public NBTMapType(CompoundTag tag) {
        this.map = tag;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != NBTMapType.class) {
            return false;
        }
        return this.map.equals(((NBTMapType)obj).map);
    }

    @Override
    public TypeUtil getTypeUtil() {
        return Types.NBT;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return "NBTMapType{map=" + String.valueOf(this.map) + "}";
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.getAllKeys().clear();
    }

    @Override
    public Set<String> keys() {
        return this.map.getAllKeys();
    }

    public CompoundTag getTag() {
        return this.map;
    }

    @Override
    public MapType<String> copy() {
        return new NBTMapType(this.map.copy());
    }

    @Override
    public boolean hasKey(String key) {
        return this.map.get(key) != null;
    }

    @Override
    public boolean hasKey(String key, ObjectType type) {
        Tag tag = this.map.get(key);
        if (tag == null) {
            return false;
        }
        ObjectType valueType = NBTListType.getType(tag.getId());
        return valueType == type || type == ObjectType.NUMBER && valueType.isNumber();
    }

    @Override
    public void remove(String key) {
        this.map.remove(key);
    }

    @Override
    public Object getGeneric(String key) {
        Tag tag = this.map.get(key);
        if (tag == null) {
            return null;
        }
        switch (NBTListType.getType(tag.getId())) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ((NumericTag)tag).getAsNumber();
            }
            case MAP: {
                return new NBTMapType((CompoundTag)tag);
            }
            case LIST: {
                return new NBTListType((ListTag)tag);
            }
            case STRING: {
                return ((StringTag)tag).getAsString();
            }
            case BYTE_ARRAY: {
                return ((ByteArrayTag)tag).getAsByteArray();
            }
            case INT_ARRAY: {
                return ((IntArrayTag)tag).getAsIntArray();
            }
            case LONG_ARRAY: {
                return ((LongArrayTag)tag).getAsLongArray();
            }
        }
        throw new IllegalStateException("Unrecognized type " + String.valueOf(tag));
    }

    @Override
    public Number getNumber(String key) {
        return this.getNumber(key, (Number)null);
    }

    @Override
    public Number getNumber(String key, Number dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsNumber();
        }
        return dfl;
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getByte(key) != 0;
    }

    @Override
    public boolean getBoolean(String key, boolean dfl) {
        return this.getByte(key, dfl ? (byte)1 : 0) != 0;
    }

    @Override
    public void setBoolean(String key, boolean val) {
        this.setByte(key, val ? (byte)1 : 0);
    }

    @Override
    public byte getByte(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsByte();
        }
        return 0;
    }

    @Override
    public byte getByte(String key, byte dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsByte();
        }
        return dfl;
    }

    @Override
    public void setByte(String key, byte val) {
        this.map.putByte(key, val);
    }

    @Override
    public short getShort(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsShort();
        }
        return 0;
    }

    @Override
    public short getShort(String key, short dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsShort();
        }
        return dfl;
    }

    @Override
    public void setShort(String key, short val) {
        this.map.putShort(key, val);
    }

    @Override
    public int getInt(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsInt();
        }
        return 0;
    }

    @Override
    public int getInt(String key, int dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsInt();
        }
        return dfl;
    }

    @Override
    public void setInt(String key, int val) {
        this.map.putInt(key, val);
    }

    @Override
    public long getLong(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsLong();
        }
        return 0L;
    }

    @Override
    public long getLong(String key, long dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsLong();
        }
        return dfl;
    }

    @Override
    public void setLong(String key, long val) {
        this.map.putLong(key, val);
    }

    @Override
    public float getFloat(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsFloat();
        }
        return 0.0f;
    }

    @Override
    public float getFloat(String key, float dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsFloat();
        }
        return dfl;
    }

    @Override
    public void setFloat(String key, float val) {
        this.map.putFloat(key, val);
    }

    @Override
    public double getDouble(String key) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsDouble();
        }
        return 0.0;
    }

    @Override
    public double getDouble(String key, double dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof NumericTag) {
            return ((NumericTag)tag).getAsDouble();
        }
        return dfl;
    }

    @Override
    public void setDouble(String key, double val) {
        this.map.putDouble(key, val);
    }

    @Override
    public byte[] getBytes(String key) {
        return this.getBytes(key, (byte[])null);
    }

    @Override
    public byte[] getBytes(String key, byte[] dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof ByteArrayTag) {
            return ((ByteArrayTag)tag).getAsByteArray();
        }
        return dfl;
    }

    @Override
    public void setBytes(String key, byte[] val) {
        this.map.putByteArray(key, val);
    }

    @Override
    public short[] getShorts(String key) {
        return this.getShorts(key, (short[])null);
    }

    @Override
    public short[] getShorts(String key, short[] dfl) {
        return dfl;
    }

    @Override
    public void setShorts(String key, short[] val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getInts(String key) {
        return this.getInts(key, (int[])null);
    }

    @Override
    public int[] getInts(String key, int[] dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof IntArrayTag) {
            return ((IntArrayTag)tag).getAsIntArray();
        }
        return dfl;
    }

    @Override
    public void setInts(String key, int[] val) {
        this.map.putIntArray(key, val);
    }

    @Override
    public long[] getLongs(String key) {
        return this.getLongs(key, (long[])null);
    }

    @Override
    public long[] getLongs(String key, long[] dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof LongArrayTag) {
            return ((LongArrayTag)tag).getAsLongArray();
        }
        return dfl;
    }

    @Override
    public void setLongs(String key, long[] val) {
        this.map.putLongArray(key, val);
    }

    @Override
    public ListType getListUnchecked(String key) {
        return this.getListUnchecked(key, (ListType)null);
    }

    @Override
    public ListType getListUnchecked(String key, ListType dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof ListTag) {
            return new NBTListType((ListTag)tag);
        }
        return dfl;
    }

    @Override
    public void setList(String key, ListType val) {
        this.map.put(key, ((NBTListType)val).getTag());
    }

    @Override
    public MapType<String> getMap(String key) {
        return this.getMap(key, (MapType)null);
    }

    @Override
    public MapType<String> getMap(String key, MapType dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof CompoundTag) {
            return new NBTMapType((CompoundTag)tag);
        }
        return dfl;
    }

    @Override
    public void setMap(String key, MapType<?> val) {
        this.map.put(key, ((NBTMapType)val).getTag());
    }

    @Override
    public String getString(String key) {
        return this.getString(key, (String)null);
    }

    @Override
    public String getString(String key, String dfl) {
        Tag tag = this.map.get(key);
        if (tag instanceof StringTag) {
            return ((StringTag)tag).getAsString();
        }
        return dfl;
    }

    @Override
    public String getForcedString(String key) {
        return this.getForcedString(key, (String)null);
    }

    @Override
    public String getForcedString(String key, String dfl) {
        Tag tag = this.map.get(key);
        if (tag != null) {
            return tag.getAsString();
        }
        return dfl;
    }

    @Override
    public void setString(String key, String val) {
        this.map.putString(key, val);
    }
}

