/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.util;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.custom.V3818_Commands;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.Pair;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.ExecuteCommand;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class CommandArgumentUpgrader {
    private final CommandDispatcher<CommandSourceStack> dispatcher;
    private final CommandBuildContext context;
    private final CommandSourceStack source;
    private final Map<Class<?>, BiFunction<ArgumentType<?>, CommandBuildContext, ArgumentType<?>>> replacements;

    public static CommandArgumentUpgrader upgrader_1_20_4_to_1_20_5(int functionPermissionLevel) {
        return new CommandArgumentUpgrader(functionPermissionLevel, builder -> {
            builder.registerReplacement(ItemArgument.class, (argument, ctx) -> new ItemParser_1_20_4());
            builder.registerReplacement(ComponentArgument.class, (argument, ctx) -> new ComponentParser_1_20_4());
            builder.registerExtraCommand(CommandArgumentUpgrader::registerSummon_1_20_4_to_1_20_5);
        });
    }

    public CommandArgumentUpgrader(int functionPermissionLevel, Consumer<ReplacementsBuilder> consumer) {
        this(new Commands(Commands.CommandSelection.DEDICATED, CommandArgumentUpgrader.makeDummyCommandBuildContext()).getDispatcher(), functionPermissionLevel, consumer);
    }

    private CommandArgumentUpgrader(CommandDispatcher<CommandSourceStack> dispatcher, int functionPermissionLevel, Consumer<ReplacementsBuilder> consumer) {
        ReplacementsBuilder builder = new ReplacementsBuilder();
        consumer.accept(builder);
        this.replacements = Map.copyOf(builder.replacements);
        CommandBuildContext context = CommandArgumentUpgrader.makeDummyCommandBuildContext();
        this.dispatcher = new CommandDispatcher();
        this.context = context;
        ArrayList<CommandNode<CommandSourceStack>> aliases = new ArrayList<CommandNode<CommandSourceStack>>();
        for (CommandNode commandNode : dispatcher.getRoot().getChildren()) {
            CopyResult result = this.copyCommand((CommandNode<CommandSourceStack>)this.dispatcher.getRoot(), commandNode, null);
            if (result.replaced()) {
                this.dispatcher.getRoot().addChild(result.root);
            }
            aliases.addAll(result.aliases);
        }
        aliases.forEach(redirectNode -> {
            CommandNode toNode = this.dispatcher.getRoot().getChild(redirectNode.getRedirect().getName());
            if (toNode != null) {
                this.dispatcher.getRoot().addChild((CommandNode)new LiteralCommandNode(redirectNode.getName(), null, toNode.getRequirement(), toNode, redirectNode.getRedirectModifier(), redirectNode.isFork()));
            }
        });
        for (Consumer consumer2 : builder.extra) {
            consumer2.accept(this.dispatcher);
        }
        ExecuteCommand.register(this.dispatcher, context);
        ReturnCommand.register(this.dispatcher);
        this.source = new CommandSourceStack(CommandSource.NULL, Vec3.ZERO, Vec2.ZERO, null, functionPermissionLevel, "", CommonComponents.EMPTY, null, null);
    }

    public String upgradeCommandArguments(String command, boolean leadingSlash) {
        ParseResults<CommandSourceStack> parseResult;
        com.mojang.brigadier.StringReader reader = new com.mojang.brigadier.StringReader(command);
        if (leadingSlash && reader.peek() == '/') {
            reader.skip();
        }
        if (!(parseResult = this.dispatcher.parse(reader, this.source)).getExceptions().isEmpty()) {
            return command;
        }
        LinkedHashMap<StringRange, String> replacements = new LinkedHashMap<StringRange, String>();
        ArrayList mergedArguments = new ArrayList();
        CommandArgumentUpgrader.addArguments(mergedArguments, (CommandContextBuilder<CommandSourceStack>)parseResult.getContext());
        for (int i = 0; i < mergedArguments.size(); ++i) {
            Pair pair = (Pair)mergedArguments.get(i);
            Object object = ((ParsedArgument)pair.value()).getResult();
            if (object instanceof UpgradedArgument) {
                UpgradedArgument upgraded = (UpgradedArgument)object;
                replacements.put(((ParsedArgument)pair.value()).getRange(), upgraded.upgraded());
                continue;
            }
            object = ((ParsedArgument)pair.value()).getResult();
            if (!(object instanceof UpgradableArgument)) continue;
            UpgradableArgument upgradable = (UpgradableArgument)object;
            replacements.put(((ParsedArgument)pair.value()).getRange(), upgradable.upgrade(i, mergedArguments));
        }
        Object upgradedCommand = command;
        while (!replacements.isEmpty()) {
            Map.Entry next = replacements.entrySet().iterator().next();
            replacements.remove(next.getKey());
            upgradedCommand = ((String)upgradedCommand).substring(0, ((StringRange)next.getKey()).getStart()) + (String)next.getValue() + ((String)upgradedCommand).substring(((StringRange)next.getKey()).getEnd());
            int diff = ((String)next.getValue()).length() - ((StringRange)next.getKey()).getLength();
            LinkedHashMap<StringRange, String> replacementsCopy = new LinkedHashMap<StringRange, String>(replacements);
            replacements.clear();
            replacementsCopy.forEach((range, value) -> replacements.put(new StringRange(range.getStart() + diff, range.getEnd() + diff), (String)value));
        }
        return upgradedCommand;
    }

    public String upgradeSingleArgument(Function<CommandBuildContext, ? extends ArgumentType<?>> argumentFactory, String input) {
        ArgumentType<?> replaced;
        ArgumentType<?> argument = argumentFactory.apply(this.context);
        if (argument == (replaced = this.replaceArgumentType(this.context, argument))) {
            return input;
        }
        try {
            UpgradedArgument parsed = (UpgradedArgument)replaced.parse(new com.mojang.brigadier.StringReader(input));
            return parsed.upgraded();
        }
        catch (CommandSyntaxException e) {
            return input;
        }
    }

    private static void addArguments(List<Pair<String, ParsedArgument<CommandSourceStack, ?>>> mergedArguments, @Nullable CommandContextBuilder<CommandSourceStack> context) {
        if (context == null) {
            return;
        }
        context.getArguments().forEach((name, argument) -> mergedArguments.add(Pair.of((Object)name, (Object)argument)));
        CommandArgumentUpgrader.addArguments(mergedArguments, (CommandContextBuilder<CommandSourceStack>)context.getChild());
    }

    private ArgumentType<?> replaceArgumentType(CommandBuildContext ctx, ArgumentType<?> type) {
        BiFunction<ArgumentType<?>, CommandBuildContext, ArgumentType<?>> upgrader = this.replacements.get(type.getClass());
        if (upgrader != null) {
            return upgrader.apply(type, ctx);
        }
        return type;
    }

    private CopyResult copyCommand(CommandNode<CommandSourceStack> parent, CommandNode<CommandSourceStack> node, @Nullable CopyResult result) {
        boolean replaced;
        LiteralCommandNode copy;
        if (node instanceof LiteralCommandNode) {
            LiteralCommandNode literal = (LiteralCommandNode)node;
            if (node.getName().equals("execute") || node.getName().equals("return")) {
                return new CopyResult(parent, false, new ArrayList<CommandNode<CommandSourceStack>>());
            }
            if (node.getRedirect() != null) {
                if (result != null) {
                    throw new IllegalStateException("Cannot handle non-root redirects");
                }
                ArrayList<CommandNode<CommandSourceStack>> aliases = new ArrayList<CommandNode<CommandSourceStack>>();
                aliases.add(node);
                return new CopyResult(parent, false, aliases);
            }
            copy = new LiteralCommandNode(literal.getLiteral(), node.getCommand(), node.getRequirement(), null, node.getRedirectModifier(), node.isFork());
            replaced = false;
        } else if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argument = (ArgumentCommandNode)node;
            ArgumentType<?> replacedType = this.replaceArgumentType(this.context, argument.getType());
            replaced = replacedType != argument.getType();
            copy = new ArgumentCommandNode(node.getName(), replacedType, node.getCommand(), node.getRequirement(), null, node.getRedirectModifier(), node.isFork(), argument.getCustomSuggestions());
        } else {
            throw new UnsupportedOperationException();
        }
        if (result == null) {
            result = new CopyResult((CommandNode<CommandSourceStack>)copy, false, new ArrayList<CommandNode<CommandSourceStack>>());
        }
        if (replaced) {
            result = result.replacedResult();
        }
        for (CommandNode<CommandSourceStack> child : node.getChildren()) {
            result = this.copyCommand((CommandNode<CommandSourceStack>)copy, child, result);
        }
        if (parent != this.dispatcher.getRoot()) {
            parent.addChild((CommandNode<CommandSourceStack>)copy);
        }
        return result;
    }

    public static void registerSummon_1_20_4_to_1_20_5(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal("summon").then(((RequiredArgumentBuilder)Commands.argument("entity", ResourceLocationArgument.id()).executes(commandContext -> 1)).then(((RequiredArgumentBuilder)Commands.argument("pos", Vec3Argument.vec3()).executes(commandContext -> 1)).then(Commands.argument("nbt", new ArgumentType<UpgradableArgument>(){

            public UpgradableArgument parse(com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
                CompoundTag tag = CompoundTagArgument.compoundTag().parse(reader);
                return (index, args) -> {
                    CompoundTag tagCopy = tag.copy();
                    Pair entityTypePair = (Pair)args.get(index - 2);
                    ResourceLocation entityType = (ResourceLocation)((ParsedArgument)entityTypePair.value()).getResult();
                    tagCopy.putString("id", entityType.toString());
                    CompoundTag convertedTag = MCDataConverter.convertTag(MCTypeRegistry.ENTITY, tagCopy, 3700, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                    convertedTag.remove("id");
                    return convertedTag.toString();
                };
            }
        }).executes(commandContext -> 1))))));
    }

    private static CommandBuildContext makeDummyCommandBuildContext() {
        return Commands.createValidationContext(new HolderLookup.Provider(){

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                return Stream.of(new ResourceKey[0]);
            }

            @Override
            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(final ResourceKey<? extends Registry<? extends T>> registryRef) {
                return Optional.of(new HolderLookup.RegistryLookup<T>(){

                    @Override
                    public ResourceKey<? extends Registry<? extends T>> key() {
                        return registryRef;
                    }

                    @Override
                    public Lifecycle registryLifecycle() {
                        return Lifecycle.stable();
                    }

                    @Override
                    public Stream<Holder.Reference<T>> listElements() {
                        return Stream.of(new Holder.Reference[0]);
                    }

                    @Override
                    public Stream<HolderSet.Named<T>> listTags() {
                        return Stream.of(new HolderSet.Named[0]);
                    }

                    @Override
                    public Optional<Holder.Reference<T>> get(ResourceKey<T> key) {
                        return Optional.of(Holder.Reference.createStandAlone(this, key));
                    }

                    @Override
                    public Optional<HolderSet.Named<T>> get(TagKey<T> tag) {
                        return Optional.of(HolderSet.emptyNamed(this, tag));
                    }
                });
            }
        });
    }

    public static final class ReplacementsBuilder {
        private final Map<Class<?>, BiFunction<ArgumentType<?>, CommandBuildContext, ArgumentType<?>>> replacements = new HashMap();
        private final List<Consumer<CommandDispatcher<CommandSourceStack>>> extra = new ArrayList<Consumer<CommandDispatcher<CommandSourceStack>>>();

        private ReplacementsBuilder() {
        }

        public <A extends ArgumentType<?>> void registerReplacement(Class<A> type, BiFunction<A, CommandBuildContext, ? extends ArgumentType<UpgradedArgument>> upgrader) {
            this.replacements.put(type, upgrader);
        }

        public void registerExtraCommand(Consumer<CommandDispatcher<CommandSourceStack>> consumer) {
            this.extra.add(consumer);
        }
    }

    record CopyResult(CommandNode<CommandSourceStack> root, boolean replaced, List<CommandNode<CommandSourceStack>> aliases) {
        CopyResult replacedResult() {
            if (this.replaced) {
                return this;
            }
            return new CopyResult(this.root, true, new ArrayList<CommandNode<CommandSourceStack>>(this.aliases));
        }
    }

    public record UpgradedArgument(String upgraded) {
    }

    public static interface UpgradableArgument {
        public String upgrade(int var1, List<Pair<String, ParsedArgument<CommandSourceStack, ?>>> var2);
    }

    private static final class ComponentParser_1_20_4
    implements ArgumentType<UpgradedArgument> {
        private static final Field JSON_READER_POS = Util.make(() -> {
            try {
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException var1) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", var1);
            }
        });
        private static final Field JSON_READER_LINESTART = Util.make(() -> {
            try {
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException var1) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", var1);
            }
        });

        private ComponentParser_1_20_4() {
        }

        public UpgradedArgument parse(com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
            JsonElement element;
            try {
                element = ComponentParser_1_20_4.parseJson(reader);
            }
            catch (Exception e) {
                throw new SimpleCommandExceptionType((Message)new LiteralMessage(e.getMessage())).createWithContext((ImmutableStringReader)reader);
            }
            V3818_Commands.walkComponent(element);
            return new UpgradedArgument(GsonHelper.toStableString(element));
        }

        public static JsonElement parseJson(com.mojang.brigadier.StringReader stringReader) {
            JsonElement jsonElement;
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(stringReader.getRemaining()));
            jsonReader.setLenient(false);
            try {
                jsonElement = Streams.parse((JsonReader)jsonReader);
            }
            catch (StackOverflowError var9) {
                throw new JsonParseException((Throwable)var9);
            }
            finally {
                stringReader.setCursor(stringReader.getCursor() + ComponentParser_1_20_4.getPos(jsonReader));
            }
            return jsonElement;
        }

        private static int getPos(JsonReader jsonReader) {
            try {
                return JSON_READER_POS.getInt(jsonReader) - JSON_READER_LINESTART.getInt(jsonReader);
            }
            catch (IllegalAccessException var2) {
                throw new IllegalStateException("Couldn't read position of JsonReader", var2);
            }
        }
    }

    private static final class ItemParser_1_20_4
    implements ArgumentType<UpgradedArgument> {
        private ItemParser_1_20_4() {
        }

        public UpgradedArgument parse(com.mojang.brigadier.StringReader reader) throws CommandSyntaxException {
            ResourceLocation id = ResourceLocation.read(reader);
            CompoundTag itemNBT = new CompoundTag();
            itemNBT.putString("id", id.toString());
            itemNBT.putInt("Count", 1);
            if (reader.canRead() && reader.peek() == '{') {
                itemNBT.put("tag", new TagParser(reader).readStruct());
            }
            CompoundTag converted = MCDataConverter.convertTag(MCTypeRegistry.ITEM_STACK, itemNBT, 3700, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
            String newId = converted.getString("id");
            if (converted.contains("components", 10)) {
                return new UpgradedArgument(newId + V3818_Commands.toCommandFormat(converted.getCompound("components")));
            }
            return new UpgradedArgument(newId);
        }
    }
}

