/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity;

import com.destroystokyo.paper.entity.Pathfinder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;

public class PaperPathfinder
implements Pathfinder {
    private net.minecraft.world.entity.Mob entity;

    public PaperPathfinder(net.minecraft.world.entity.Mob entity) {
        this.entity = entity;
    }

    public Mob getEntity() {
        return this.entity.getBukkitMob();
    }

    public void setHandle(net.minecraft.world.entity.Mob entity) {
        this.entity = entity;
    }

    public void stopPathfinding() {
        this.entity.getNavigation().stop();
    }

    public boolean hasPath() {
        return this.entity.getNavigation().getPath() != null && !this.entity.getNavigation().getPath().isDone();
    }

    @Nullable
    public Pathfinder.PathResult getCurrentPath() {
        Path path = this.entity.getNavigation().getPath();
        return path != null && !path.isDone() ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(Location loc) {
        Validate.notNull((Object)loc, (String)"Location can not be null");
        Path path = this.entity.getNavigation().createPath(loc.getX(), loc.getY(), loc.getZ(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(LivingEntity target) {
        Validate.notNull((Object)target, (String)"Target can not be null");
        Path path = this.entity.getNavigation().createPath(((CraftLivingEntity)target).getHandle(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    public boolean moveTo(@Nonnull Pathfinder.PathResult path, double speed) {
        Validate.notNull((Object)path, (String)"PathResult can not be null");
        Path pathEntity = ((PaperPathResult)path).path;
        return this.entity.getNavigation().moveTo(pathEntity, speed);
    }

    public boolean canOpenDoors() {
        return this.entity.getNavigation().pathFinder.nodeEvaluator.canOpenDoors();
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.entity.getNavigation().pathFinder.nodeEvaluator.setCanOpenDoors(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.entity.getNavigation().pathFinder.nodeEvaluator.canPassDoors();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.entity.getNavigation().pathFinder.nodeEvaluator.setCanPassDoors(canPassDoors);
    }

    public boolean canFloat() {
        return this.entity.getNavigation().pathFinder.nodeEvaluator.canFloat();
    }

    public void setCanFloat(boolean canFloat) {
        this.entity.getNavigation().pathFinder.nodeEvaluator.setCanFloat(canFloat);
    }

    private Location toLoc(Node point) {
        return new Location((World)this.entity.level().getWorld(), (double)point.x, (double)point.y, (double)point.z);
    }

    public class PaperPathResult
    implements Pathfinder.PathResult {
        private final Path path;

        PaperPathResult(Path path) {
            this.path = path;
        }

        @Nullable
        public Location getFinalPoint() {
            Node point = this.path.getEndNode();
            return point != null ? PaperPathfinder.this.toLoc(point) : null;
        }

        public boolean canReachFinalPoint() {
            return this.path.canReach();
        }

        public List<Location> getPoints() {
            ArrayList<Location> points = new ArrayList<Location>();
            for (Node point : this.path.nodes) {
                points.add(PaperPathfinder.this.toLoc(point));
            }
            return points;
        }

        public int getNextPointIndex() {
            return this.path.getNextNodeIndex();
        }

        @Nullable
        public Location getNextPoint() {
            if (!this.path.hasNext()) {
                return null;
            }
            return PaperPathfinder.this.toLoc(this.path.nodes.get(this.path.getNextNodeIndex()));
        }
    }
}

