/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.ai;

import com.destroystokyo.paper.entity.RangedEntity;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.papermc.paper.entity.SchoolableFish;
import io.papermc.paper.util.MappingEnvironment;
import io.papermc.paper.util.ObfHelper;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.raid.Raider;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Camel;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Flying;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Illager;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Monster;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.ZombieVillager;

public class MobGoalHelper {
    private static final BiMap<String, String> deobfuscationMap = HashBiMap.create();
    private static final Map<Class<? extends Goal>, Class<? extends org.bukkit.entity.Mob>> entityClassCache = new HashMap<Class<? extends Goal>, Class<? extends org.bukkit.entity.Mob>>();
    private static final Map<Class<? extends Mob>, Class<? extends org.bukkit.entity.Mob>> bukkitMap = new HashMap<Class<? extends Mob>, Class<? extends org.bukkit.entity.Mob>>();
    static final Set<String> ignored = new HashSet<String>();

    public static String getUsableName(Class<?> clazz) {
        String name = MappingEnvironment.reobf() ? ObfHelper.INSTANCE.deobfClassName(clazz.getName()) : clazz.getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        boolean flag = false;
        if (name.contains("$")) {
            String cut = name.substring(name.indexOf("$") + 1);
            if (cut.length() <= 2) {
                name = name.replace("Entity", "");
                name = name.replace("$", "_");
                flag = true;
            } else {
                name = cut;
            }
        }
        name = name.replace("PathfinderGoal", "");
        name = name.replace("TargetGoal", "");
        name = name.replace("Goal", "");
        StringBuilder sb = new StringBuilder();
        for (char c : name.toCharArray()) {
            if (c >= 'A' && c <= 'Z') {
                sb.append("_");
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        name = sb.toString();
        name = name.replaceFirst("_", "");
        if (flag && !deobfuscationMap.containsKey((Object)name.toLowerCase(Locale.ROOT)) && !ignored.contains(name)) {
            System.out.println("need to map " + clazz.getName() + " (" + name.toLowerCase(Locale.ROOT) + ")");
        }
        return (String)deobfuscationMap.getOrDefault((Object)name, (Object)name);
    }

    public static EnumSet<GoalType> vanillaToPaper(Goal goal) {
        EnumSet<GoalType> goals = EnumSet.noneOf(GoalType.class);
        for (GoalType type : GoalType.values()) {
            if (!goal.getFlags().contains(MobGoalHelper.paperToVanilla(type))) continue;
            goals.add(type);
        }
        return goals;
    }

    public static GoalType vanillaToPaper(Goal.Flag type) {
        switch (type) {
            case MOVE: {
                return GoalType.MOVE;
            }
            case LOOK: {
                return GoalType.LOOK;
            }
            case JUMP: {
                return GoalType.JUMP;
            }
            case UNKNOWN_BEHAVIOR: {
                return GoalType.UNKNOWN_BEHAVIOR;
            }
            case TARGET: {
                return GoalType.TARGET;
            }
        }
        throw new IllegalArgumentException("Unknown vanilla mob goal type " + type.name());
    }

    public static EnumSet<Goal.Flag> paperToVanilla(EnumSet<GoalType> types) {
        EnumSet<Goal.Flag> goals = EnumSet.noneOf(Goal.Flag.class);
        for (GoalType type : types) {
            goals.add(MobGoalHelper.paperToVanilla(type));
        }
        return goals;
    }

    public static Goal.Flag paperToVanilla(GoalType type) {
        switch (type) {
            case MOVE: {
                return Goal.Flag.MOVE;
            }
            case LOOK: {
                return Goal.Flag.LOOK;
            }
            case JUMP: {
                return Goal.Flag.JUMP;
            }
            case UNKNOWN_BEHAVIOR: {
                return Goal.Flag.UNKNOWN_BEHAVIOR;
            }
            case TARGET: {
                return Goal.Flag.TARGET;
            }
        }
        throw new IllegalArgumentException("Unknown paper mob goal type " + type.name());
    }

    public static <T extends org.bukkit.entity.Mob> GoalKey<T> getKey(Class<? extends Goal> goalClass) {
        String name = MobGoalHelper.getUsableName(goalClass);
        if (ignored.contains(name)) {
            return GoalKey.of(org.bukkit.entity.Mob.class, (NamespacedKey)NamespacedKey.minecraft((String)name));
        }
        return GoalKey.of(MobGoalHelper.getEntity(goalClass), (NamespacedKey)NamespacedKey.minecraft((String)name));
    }

    public static <T extends org.bukkit.entity.Mob> Class<T> getEntity(Class<? extends Goal> goalClass) {
        return entityClassCache.computeIfAbsent(goalClass, key -> {
            for (Constructor<?> ctor : key.getDeclaredConstructors()) {
                for (int i = 0; i < ctor.getParameterCount(); ++i) {
                    Class<?> param = ctor.getParameterTypes()[i];
                    if (Mob.class.isAssignableFrom(param)) {
                        return MobGoalHelper.toBukkitClass(param);
                    }
                    if (!RangedAttackMob.class.isAssignableFrom(param)) continue;
                    return RangedEntity.class;
                }
            }
            throw new RuntimeException("Can't figure out applicable entity for mob goal " + String.valueOf(goalClass));
        });
    }

    public static Class<? extends org.bukkit.entity.Mob> toBukkitClass(Class<? extends Mob> nmsClass) {
        Class<? extends org.bukkit.entity.Mob> bukkitClass = bukkitMap.get(nmsClass);
        if (bukkitClass == null) {
            throw new RuntimeException("Can't figure out applicable bukkit entity for nms entity " + String.valueOf(nmsClass));
        }
        return bukkitClass;
    }

    static {
        deobfuscationMap.put((Object)"abstract_skeleton_1", (Object)"abstract_skeleton_melee");
        ignored.add("goal_selector_1");
        ignored.add("goal_selector_2");
        ignored.add("selector_1");
        ignored.add("selector_2");
        ignored.add("wrapped");
        bukkitMap.put(Mob.class, org.bukkit.entity.Mob.class);
        bukkitMap.put(AgeableMob.class, Ageable.class);
        bukkitMap.put(AmbientCreature.class, Ambient.class);
        bukkitMap.put(Animal.class, Animals.class);
        bukkitMap.put(net.minecraft.world.entity.ambient.Bat.class, Bat.class);
        bukkitMap.put(Bee.class, org.bukkit.entity.Bee.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Blaze.class, Blaze.class);
        bukkitMap.put(Cat.class, org.bukkit.entity.Cat.class);
        bukkitMap.put(net.minecraft.world.entity.monster.CaveSpider.class, CaveSpider.class);
        bukkitMap.put(Chicken.class, org.bukkit.entity.Chicken.class);
        bukkitMap.put(Cod.class, org.bukkit.entity.Cod.class);
        bukkitMap.put(Cow.class, org.bukkit.entity.Cow.class);
        bukkitMap.put(PathfinderMob.class, Creature.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Creeper.class, Creeper.class);
        bukkitMap.put(Dolphin.class, org.bukkit.entity.Dolphin.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Drowned.class, Drowned.class);
        bukkitMap.put(EnderDragon.class, org.bukkit.entity.EnderDragon.class);
        bukkitMap.put(EnderMan.class, Enderman.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Endermite.class, Endermite.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Evoker.class, Evoker.class);
        bukkitMap.put(AbstractFish.class, Fish.class);
        bukkitMap.put(AbstractSchoolingFish.class, SchoolableFish.class);
        bukkitMap.put(FlyingMob.class, Flying.class);
        bukkitMap.put(Fox.class, org.bukkit.entity.Fox.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Ghast.class, Ghast.class);
        bukkitMap.put(Giant.class, org.bukkit.entity.Giant.class);
        bukkitMap.put(AbstractGolem.class, Golem.class);
        bukkitMap.put(Guardian.class, org.bukkit.entity.Guardian.class);
        bukkitMap.put(net.minecraft.world.entity.monster.ElderGuardian.class, ElderGuardian.class);
        bukkitMap.put(Horse.class, org.bukkit.entity.Horse.class);
        bukkitMap.put(net.minecraft.world.entity.animal.horse.AbstractHorse.class, AbstractHorse.class);
        bukkitMap.put(AbstractChestedHorse.class, ChestedHorse.class);
        bukkitMap.put(Donkey.class, org.bukkit.entity.Donkey.class);
        bukkitMap.put(Mule.class, org.bukkit.entity.Mule.class);
        bukkitMap.put(net.minecraft.world.entity.animal.horse.SkeletonHorse.class, SkeletonHorse.class);
        bukkitMap.put(ZombieHorse.class, org.bukkit.entity.ZombieHorse.class);
        bukkitMap.put(net.minecraft.world.entity.animal.camel.Camel.class, Camel.class);
        bukkitMap.put(AbstractIllager.class, Illager.class);
        bukkitMap.put(Illusioner.class, org.bukkit.entity.Illusioner.class);
        bukkitMap.put(SpellcasterIllager.class, Spellcaster.class);
        bukkitMap.put(net.minecraft.world.entity.animal.IronGolem.class, IronGolem.class);
        bukkitMap.put(Llama.class, org.bukkit.entity.Llama.class);
        bukkitMap.put(net.minecraft.world.entity.animal.horse.TraderLlama.class, TraderLlama.class);
        bukkitMap.put(net.minecraft.world.entity.monster.MagmaCube.class, MagmaCube.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Monster.class, Monster.class);
        bukkitMap.put(PatrollingMonster.class, org.bukkit.entity.Raider.class);
        bukkitMap.put(net.minecraft.world.entity.animal.MushroomCow.class, MushroomCow.class);
        bukkitMap.put(Ocelot.class, org.bukkit.entity.Ocelot.class);
        bukkitMap.put(net.minecraft.world.entity.animal.Panda.class, Panda.class);
        bukkitMap.put(Parrot.class, org.bukkit.entity.Parrot.class);
        bukkitMap.put(ShoulderRidingEntity.class, org.bukkit.entity.Parrot.class);
        bukkitMap.put(Phantom.class, org.bukkit.entity.Phantom.class);
        bukkitMap.put(Pig.class, org.bukkit.entity.Pig.class);
        bukkitMap.put(ZombifiedPiglin.class, PigZombie.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Pillager.class, Pillager.class);
        bukkitMap.put(PolarBear.class, org.bukkit.entity.PolarBear.class);
        bukkitMap.put(Pufferfish.class, PufferFish.class);
        bukkitMap.put(Rabbit.class, org.bukkit.entity.Rabbit.class);
        bukkitMap.put(Raider.class, org.bukkit.entity.Raider.class);
        bukkitMap.put(Ravager.class, org.bukkit.entity.Ravager.class);
        bukkitMap.put(Salmon.class, org.bukkit.entity.Salmon.class);
        bukkitMap.put(net.minecraft.world.entity.animal.Sheep.class, Sheep.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Shulker.class, Shulker.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Silverfish.class, Silverfish.class);
        bukkitMap.put(Skeleton.class, org.bukkit.entity.Skeleton.class);
        bukkitMap.put(AbstractSkeleton.class, org.bukkit.entity.AbstractSkeleton.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Stray.class, Stray.class);
        bukkitMap.put(WitherSkeleton.class, org.bukkit.entity.WitherSkeleton.class);
        bukkitMap.put(Slime.class, org.bukkit.entity.Slime.class);
        bukkitMap.put(SnowGolem.class, Snowman.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Spider.class, Spider.class);
        bukkitMap.put(Squid.class, org.bukkit.entity.Squid.class);
        bukkitMap.put(TamableAnimal.class, Tameable.class);
        bukkitMap.put(TropicalFish.class, org.bukkit.entity.TropicalFish.class);
        bukkitMap.put(Turtle.class, org.bukkit.entity.Turtle.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Vex.class, Vex.class);
        bukkitMap.put(net.minecraft.world.entity.npc.Villager.class, Villager.class);
        bukkitMap.put(AbstractVillager.class, org.bukkit.entity.AbstractVillager.class);
        bukkitMap.put(net.minecraft.world.entity.npc.WanderingTrader.class, WanderingTrader.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Vindicator.class, Vindicator.class);
        bukkitMap.put(WaterAnimal.class, WaterMob.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Witch.class, Witch.class);
        bukkitMap.put(WitherBoss.class, Wither.class);
        bukkitMap.put(net.minecraft.world.entity.animal.Wolf.class, Wolf.class);
        bukkitMap.put(Zombie.class, org.bukkit.entity.Zombie.class);
        bukkitMap.put(Husk.class, org.bukkit.entity.Husk.class);
        bukkitMap.put(net.minecraft.world.entity.monster.ZombieVillager.class, ZombieVillager.class);
        bukkitMap.put(net.minecraft.world.entity.monster.hoglin.Hoglin.class, Hoglin.class);
        bukkitMap.put(net.minecraft.world.entity.monster.piglin.Piglin.class, Piglin.class);
        bukkitMap.put(AbstractPiglin.class, PiglinAbstract.class);
        bukkitMap.put(PiglinBrute.class, org.bukkit.entity.PiglinBrute.class);
        bukkitMap.put(Strider.class, org.bukkit.entity.Strider.class);
        bukkitMap.put(net.minecraft.world.entity.monster.Zoglin.class, Zoglin.class);
        bukkitMap.put(net.minecraft.world.entity.GlowSquid.class, GlowSquid.class);
        bukkitMap.put(Axolotl.class, org.bukkit.entity.Axolotl.class);
        bukkitMap.put(Goat.class, org.bukkit.entity.Goat.class);
        bukkitMap.put(Frog.class, org.bukkit.entity.Frog.class);
        bukkitMap.put(net.minecraft.world.entity.animal.frog.Tadpole.class, Tadpole.class);
        bukkitMap.put(Warden.class, org.bukkit.entity.Warden.class);
        bukkitMap.put(net.minecraft.world.entity.animal.allay.Allay.class, Allay.class);
        bukkitMap.put(net.minecraft.world.entity.animal.sniffer.Sniffer.class, Sniffer.class);
        bukkitMap.put(Breeze.class, org.bukkit.entity.Breeze.class);
        bukkitMap.put(Armadillo.class, org.bukkit.entity.Armadillo.class);
        bukkitMap.put(Bogged.class, org.bukkit.entity.Bogged.class);
    }
}

