/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.network;

import com.destroystokyo.paper.network.PaperServerListPingEventImpl;
import com.destroystokyo.paper.network.PaperStatusClient;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.adventure.AdventureComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.util.CraftIconCache;
import org.bukkit.event.Event;

public final class StandardPaperServerListPingEventImpl
extends PaperServerListPingEventImpl {
    private static final UUID FAKE_UUID = new UUID(0L, 0L);
    private List<GameProfile> originalSample;

    private StandardPaperServerListPingEventImpl(MinecraftServer server, Connection networkManager, ServerStatus ping) {
        super(server, new PaperStatusClient(networkManager), ping.version().map(ServerStatus.Version::protocol).orElse(-1), server.server.getServerIcon());
        this.originalSample = ping.players().map(ServerStatus.Players::sample).orElse(null);
    }

    @Nonnull
    public List<PlayerProfile> getPlayerSample() {
        List sample = super.getPlayerSample();
        if (this.originalSample != null) {
            for (GameProfile profile : this.originalSample) {
                sample.add(CraftPlayerProfile.asBukkitCopy(profile));
            }
            this.originalSample = null;
        }
        return sample;
    }

    private List<GameProfile> getPlayerSampleHandle() {
        if (this.originalSample != null) {
            return this.originalSample;
        }
        List entries = super.getPlayerSample();
        if (entries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GameProfile> profiles = new ArrayList<GameProfile>();
        for (PlayerProfile profile : entries) {
            if (profile.getId() != null && profile.getName() != null) {
                profiles.add(CraftPlayerProfile.asAuthlib(profile));
                continue;
            }
            profiles.add(new GameProfile((UUID)MoreObjects.firstNonNull((Object)profile.getId(), (Object)FAKE_UUID), Strings.nullToEmpty((String)profile.getName())));
        }
        return profiles;
    }

    public static void processRequest(MinecraftServer server, Connection networkManager) {
        StandardPaperServerListPingEventImpl event = new StandardPaperServerListPingEventImpl(server, networkManager, server.getStatus());
        server.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            networkManager.disconnect(null);
            return;
        }
        AdventureComponent description = new AdventureComponent(event.motd());
        Optional<ServerStatus.Players> players = !event.shouldHidePlayers() ? Optional.of(new ServerStatus.Players(event.getMaxPlayers(), event.getNumPlayers(), event.getPlayerSampleHandle())) : Optional.empty();
        ServerStatus.Version version = new ServerStatus.Version(event.getVersion(), event.getProtocolVersion());
        Optional<ServerStatus.Favicon> favicon = event.getServerIcon() != null ? Optional.of(new ServerStatus.Favicon(((CraftIconCache)event.getServerIcon()).value)) : Optional.empty();
        ServerStatus ping = new ServerStatus(description, players, Optional.of(version), favicon, server.enforceSecureProfile());
        networkManager.send(new ClientboundStatusResponsePacket(ping));
    }
}

