/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.util.misc;

import com.destroystokyo.paper.util.misc.AreaMap;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import io.papermc.paper.util.IntegerUtil;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import net.minecraft.world.level.ChunkPos;

public abstract class DistanceTrackingAreaMap<E>
extends AreaMap<E> {
    protected final Long2IntOpenHashMap chunkToNearestDistance = new Long2IntOpenHashMap(1024, 0.7f);
    protected final DistanceChangeCallback<E> distanceChangeCallback;

    public DistanceTrackingAreaMap() {
        this(new PooledLinkedHashSets());
    }

    public DistanceTrackingAreaMap(PooledLinkedHashSets<E> pooledHashSets) {
        this(pooledHashSets, (AreaMap.ChangeCallback<E>)null, (AreaMap.ChangeCallback<E>)null, (DistanceChangeCallback<E>)null);
    }

    public DistanceTrackingAreaMap(PooledLinkedHashSets<E> pooledHashSets, AreaMap.ChangeCallback<E> addCallback, AreaMap.ChangeCallback<E> removeCallback, DistanceChangeCallback<E> distanceChangeCallback) {
        super(pooledHashSets, addCallback, removeCallback);
        this.chunkToNearestDistance.defaultReturnValue(-1);
        this.distanceChangeCallback = distanceChangeCallback;
    }

    public final int getNearestObjectDistance(long key) {
        return this.chunkToNearestDistance.get(key);
    }

    public final int getNearestObjectDistance(ChunkPos chunkPos) {
        return this.chunkToNearestDistance.get(MCUtil.getCoordinateKey(chunkPos));
    }

    public final int getNearestObjectDistance(int chunkX, int chunkZ) {
        return this.chunkToNearestDistance.get(MCUtil.getCoordinateKey(chunkX, chunkZ));
    }

    protected final void recalculateDistance(int chunkX, int chunkZ) {
        long key = MCUtil.getCoordinateKey(chunkX, chunkZ);
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet state = (PooledLinkedHashSets.PooledObjectLinkedOpenHashSet)this.areaMap.get(key);
        if (state == null) {
            int oldDistance = this.chunkToNearestDistance.remove(key);
            if (oldDistance == -1) {
                return;
            }
            if (this.distanceChangeCallback != null) {
                this.distanceChangeCallback.accept(chunkX, chunkZ, oldDistance, -1, null);
            }
            return;
        }
        int newDistance = Integer.MAX_VALUE;
        for (Object raw : state.getBackingSet()) {
            Object object;
            long location;
            int distance;
            if (raw == null || (distance = Math.max(IntegerUtil.branchlessAbs(chunkX - MCUtil.getCoordinateX(location = this.objectToLastCoordinate.getLong(object = raw))), IntegerUtil.branchlessAbs(chunkZ - MCUtil.getCoordinateZ(location)))) >= newDistance) continue;
            newDistance = distance;
        }
        int oldDistance = this.chunkToNearestDistance.put(key, newDistance);
        if (oldDistance != newDistance && this.distanceChangeCallback != null) {
            this.distanceChangeCallback.accept(chunkX, chunkZ, oldDistance, newDistance, state);
        }
    }

    @Override
    protected void addObjectCallback(E object, int chunkX, int chunkZ, int viewDistance) {
        int maxX = chunkX + viewDistance;
        int maxZ = chunkZ + viewDistance;
        int minX = chunkX - viewDistance;
        int minZ = chunkZ - viewDistance;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                this.recalculateDistance(x, z);
            }
        }
    }

    @Override
    protected void removeObjectCallback(E object, int chunkX, int chunkZ, int viewDistance) {
        int maxX = chunkX + viewDistance;
        int maxZ = chunkZ + viewDistance;
        int minX = chunkX - viewDistance;
        int minZ = chunkZ - viewDistance;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                this.recalculateDistance(x, z);
            }
        }
    }

    @Override
    protected void updateObjectCallback(E object, long oldPosition, long newPosition, int oldViewDistance, int newViewDistance) {
        int totalZ;
        if (oldPosition == newPosition && newViewDistance == oldViewDistance) {
            return;
        }
        int toX = MCUtil.getCoordinateX(newPosition);
        int toZ = MCUtil.getCoordinateZ(newPosition);
        int fromX = MCUtil.getCoordinateX(oldPosition);
        int fromZ = MCUtil.getCoordinateZ(oldPosition);
        int totalX = IntegerUtil.branchlessAbs(fromX - toX);
        if (Math.max(totalX, totalZ = IntegerUtil.branchlessAbs(fromZ - toZ)) > 2 * Math.max(newViewDistance, oldViewDistance)) {
            this.removeObjectCallback(object, fromX, fromZ, oldViewDistance);
            this.addObjectCallback(object, toX, toZ, newViewDistance);
            return;
        }
        int minX = Math.min(fromX - oldViewDistance, toX - newViewDistance);
        int maxX = Math.max(fromX + oldViewDistance, toX + newViewDistance);
        int minZ = Math.min(fromZ - oldViewDistance, toZ - newViewDistance);
        int maxZ = Math.max(fromZ + oldViewDistance, toZ + newViewDistance);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int distZNew;
                int distZOld;
                int distXOld = IntegerUtil.branchlessAbs(x - fromX);
                if (Math.max(distXOld, distZOld = IntegerUtil.branchlessAbs(z - fromZ)) <= oldViewDistance) {
                    this.recalculateDistance(x, z);
                    continue;
                }
                int distXNew = IntegerUtil.branchlessAbs(x - toX);
                if (Math.max(distXNew, distZNew = IntegerUtil.branchlessAbs(z - toZ)) > newViewDistance) continue;
                this.recalculateDistance(x, z);
            }
        }
    }

    @FunctionalInterface
    public static interface DistanceChangeCallback<E> {
        public void accept(int var1, int var2, int var3, int var4, PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<E> var5);
    }
}

