/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure;

import io.papermc.paper.adventure.LazyChatAudienceSet;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AbstractChatEvent;
import io.papermc.paper.event.player.AsyncChatEvent;
import io.papermc.paper.event.player.ChatEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.Optionull;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.LazyPlayerSet;
import org.bukkit.craftbukkit.util.Waitable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.leavesmc.leaves.LeavesConfig;

public final class ChatProcessor {
    static final ResourceKey<ChatType> PAPER_RAW = ResourceKey.create(Registries.CHAT_TYPE, new ResourceLocation("paper", "raw"));
    static final String DEFAULT_LEGACY_FORMAT = "<%1$s> %2$s";
    final MinecraftServer server;
    final ServerPlayer player;
    final PlayerChatMessage message;
    final boolean async;
    final String craftbukkit$originalMessage;
    final Component paper$originalMessage;
    final OutgoingChatMessage outgoing;
    static final int MESSAGE_CHANGED = 1;
    static final int FORMAT_CHANGED = 2;
    static final int SENDER_CHANGED = 3;
    private final BitSet flags = new BitSet(3);

    public ChatProcessor(MinecraftServer server, ServerPlayer player, PlayerChatMessage message, boolean async) {
        this.server = server;
        this.player = player;
        this.message = message;
        this.async = async;
        this.craftbukkit$originalMessage = message.unsignedContent() != null ? LegacyComponentSerializer.legacySection().serialize(PaperAdventure.asAdventure(message.unsignedContent())) : message.signedContent();
        this.paper$originalMessage = PaperAdventure.asAdventure(this.message.decoratedContent());
        this.outgoing = OutgoingChatMessage.create(this.message);
    }

    public void process() {
        boolean listenersOnAsyncEvent = ChatProcessor.canYouHearMe(AsyncPlayerChatEvent.getHandlerList());
        boolean listenersOnSyncEvent = ChatProcessor.canYouHearMe(PlayerChatEvent.getHandlerList());
        if (listenersOnAsyncEvent || listenersOnSyncEvent) {
            CraftPlayer player = this.player.getBukkitEntity();
            AsyncPlayerChatEvent ae = new AsyncPlayerChatEvent(this.async, (Player)player, this.craftbukkit$originalMessage, (Set)new LazyPlayerSet(this.server));
            this.post((Event)ae);
            if (listenersOnSyncEvent) {
                final PlayerChatEvent se = new PlayerChatEvent((Player)player, ae.getMessage(), ae.getFormat(), ae.getRecipients());
                se.setCancelled(ae.isCancelled());
                this.queueIfAsyncOrRunImmediately(new Waitable<Void>(){

                    @Override
                    protected Void evaluate() {
                        ChatProcessor.this.post((Event)se);
                        return null;
                    }
                });
                this.readLegacyModifications(se.getMessage(), se.getFormat(), se.getPlayer());
                this.processModern(this.modernRenderer(se.getFormat()), this.viewersFromLegacy(se.getRecipients()), this.modernMessage(se.getMessage()), se.getPlayer(), se.isCancelled());
            } else {
                this.readLegacyModifications(ae.getMessage(), ae.getFormat(), ae.getPlayer());
                this.processModern(this.modernRenderer(ae.getFormat()), this.viewersFromLegacy(ae.getRecipients()), this.modernMessage(ae.getMessage()), ae.getPlayer(), ae.isCancelled());
            }
        } else {
            this.processModern((ChatRenderer)ChatProcessor.defaultRenderer(), new LazyChatAudienceSet(this.server), this.paper$originalMessage, this.player.getBukkitEntity(), false);
        }
    }

    private ChatRenderer modernRenderer(String format) {
        if (this.flags.get(2)) {
            return ChatProcessor.legacyRenderer(format);
        }
        return ChatProcessor.defaultRenderer();
    }

    private Component modernMessage(String legacyMessage) {
        if (this.flags.get(1)) {
            return LegacyComponentSerializer.legacySection().deserialize(legacyMessage);
        }
        return this.paper$originalMessage;
    }

    private void readLegacyModifications(String message, String format, Player playerSender) {
        this.flags.set(1, !message.equals(this.craftbukkit$originalMessage));
        this.flags.set(2, !format.equals(DEFAULT_LEGACY_FORMAT));
        this.flags.set(3, playerSender != this.player.getBukkitEntity());
    }

    private void processModern(final ChatRenderer renderer, Set<Audience> viewers, Component message, final Player player, boolean cancelled) {
        final PlayerChatMessage.AdventureView signedMessage = this.message.adventureView();
        final AsyncChatEvent ae = new AsyncChatEvent(this.async, player, viewers, renderer, message, this.paper$originalMessage, (SignedMessage)signedMessage);
        ae.setCancelled(cancelled);
        this.post((Event)ae);
        boolean listenersOnSyncEvent = ChatProcessor.canYouHearMe(ChatEvent.getHandlerList());
        if (listenersOnSyncEvent) {
            this.queueIfAsyncOrRunImmediately(new Waitable<Void>(){

                @Override
                protected Void evaluate() {
                    ChatEvent se = new ChatEvent(player, ae.viewers(), ae.renderer(), ae.message(), ChatProcessor.this.paper$originalMessage, (SignedMessage)signedMessage);
                    se.setCancelled(ae.isCancelled());
                    ChatProcessor.this.post((Event)se);
                    ChatProcessor.this.readModernModifications((AbstractChatEvent)se, renderer);
                    ChatProcessor.this.complete((AbstractChatEvent)se);
                    return null;
                }
            });
        } else {
            this.readModernModifications((AbstractChatEvent)ae, renderer);
            this.complete((AbstractChatEvent)ae);
        }
    }

    private void readModernModifications(AbstractChatEvent chatEvent, ChatRenderer originalRenderer) {
        this.flags.set(1, !chatEvent.message().equals((Object)this.paper$originalMessage));
        if (originalRenderer != chatEvent.renderer()) {
            this.flags.set(2, true);
        }
    }

    private void complete(AbstractChatEvent event) {
        LazyChatAudienceSet lazyAudienceSet;
        ViewersOutgoingChat outgoingChat;
        if (event.isCancelled()) {
            return;
        }
        CraftPlayer player = (CraftPlayer)event.getPlayer();
        Component displayName = ChatProcessor.displayName(player);
        Component message = event.message();
        ChatRenderer renderer = event.renderer();
        Set viewers = event.viewers();
        ResourceKey<ChatType> chatTypeKey = renderer instanceof ChatRenderer.Default ? ChatType.CHAT : PAPER_RAW;
        ChatType.Bound chatType = ChatType.bind(chatTypeKey, this.player.level().registryAccess(), PaperAdventure.asVanilla(ChatProcessor.displayName(player)));
        OutgoingChat outgoingChat2 = outgoingChat = viewers instanceof LazyChatAudienceSet && (lazyAudienceSet = (LazyChatAudienceSet)viewers).isLazy() ? new ServerOutgoingChat() : new ViewersOutgoingChat();
        if (this.flags.get(2)) {
            if (renderer instanceof ChatRenderer.ViewerUnaware) {
                unaware = (ChatRenderer.ViewerUnaware)renderer;
                outgoingChat.sendFormatChangedViewerUnaware(player, PaperAdventure.asVanilla(unaware.render((Player)player, displayName, message)), viewers, chatType);
            } else {
                outgoingChat.sendFormatChangedViewerAware(player, displayName, message, renderer, viewers, chatType);
            }
        } else if (this.flags.get(1)) {
            if (!(renderer instanceof ChatRenderer.ViewerUnaware)) {
                throw new IllegalStateException("BUG: This should be a ViewerUnaware renderer at this point");
            }
            unaware = (ChatRenderer.ViewerUnaware)renderer;
            Component renderedComponent = chatTypeKey == ChatType.CHAT ? message : unaware.render((Player)player, displayName, message);
            outgoingChat.sendMessageChanged(player, PaperAdventure.asVanilla(renderedComponent), viewers, chatType);
        } else {
            outgoingChat.sendOriginal(player, viewers, chatType);
        }
    }

    private Set<Audience> viewersFromLegacy(Set<Player> recipients) {
        LazyPlayerSet lazyPlayerSet;
        if (recipients instanceof LazyPlayerSet && (lazyPlayerSet = (LazyPlayerSet)recipients).isLazy()) {
            return new LazyChatAudienceSet(this.server);
        }
        HashSet<Player> viewers = new HashSet<Player>(recipients);
        viewers.add((Player)this.server.console);
        return viewers;
    }

    static String legacyDisplayName(CraftPlayer player) {
        if (((CraftWorld)player.getWorld()).getHandle().paperConfig().scoreboards.useVanillaWorldScoreboardNameColoring || LeavesConfig.mcTechnicalMode) {
            return LegacyComponentSerializer.legacySection().serialize(player.teamDisplayName()) + String.valueOf(ChatFormatting.RESET);
        }
        return player.getDisplayName();
    }

    static Component displayName(CraftPlayer player) {
        if (((CraftWorld)player.getWorld()).getHandle().paperConfig().scoreboards.useVanillaWorldScoreboardNameColoring || LeavesConfig.mcTechnicalMode) {
            return player.teamDisplayName();
        }
        return player.displayName();
    }

    private static ChatRenderer.Default defaultRenderer() {
        return (ChatRenderer.Default)ChatRenderer.defaultRenderer();
    }

    private static ChatRenderer legacyRenderer(String format) {
        if (DEFAULT_LEGACY_FORMAT.equals(format)) {
            return ChatProcessor.defaultRenderer();
        }
        return ChatRenderer.viewerUnaware((player, sourceDisplayName, message) -> LegacyComponentSerializer.legacySection().deserialize(ChatProcessor.legacyFormat(format, player, LegacyComponentSerializer.legacySection().serialize(message))));
    }

    static String legacyFormat(String format, Player player, String message) {
        return String.format(format, ChatProcessor.legacyDisplayName((CraftPlayer)player), message);
    }

    private void queueIfAsyncOrRunImmediately(Waitable<Void> waitable) {
        if (this.async) {
            this.server.processQueue.add(waitable);
        } else {
            waitable.run();
        }
        try {
            waitable.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception processing chat", e.getCause());
        }
    }

    private void post(Event event) {
        this.server.server.getPluginManager().callEvent(event);
    }

    static boolean canYouHearMe(HandlerList handlers) {
        return handlers.getRegisteredListeners().length > 0;
    }

    final class ServerOutgoingChat
    implements OutgoingChat {
        ServerOutgoingChat() {
        }

        @Override
        public void sendFormatChangedViewerAware(CraftPlayer player, Component displayName, Component message, ChatRenderer renderer, Set<Audience> viewers, ChatType.Bound chatType) {
            ChatProcessor.this.server.getPlayerList().broadcastChatMessage(ChatProcessor.this.message, ChatProcessor.this.player, chatType, viewer -> PaperAdventure.asVanilla(renderer.render((Player)player, displayName, message, viewer)));
        }

        @Override
        public void sendMessageChanged(CraftPlayer player, net.minecraft.network.chat.Component renderedMessage, Set<Audience> viewers, ChatType.Bound chatType) {
            ChatProcessor.this.server.getPlayerList().broadcastChatMessage(ChatProcessor.this.message.withUnsignedContent(renderedMessage), ChatProcessor.this.player, chatType);
        }

        @Override
        public void sendOriginal(CraftPlayer player, Set<Audience> viewers, ChatType.Bound chatType) {
            ChatProcessor.this.server.getPlayerList().broadcastChatMessage(ChatProcessor.this.message, ChatProcessor.this.player, chatType);
        }
    }

    final class ViewersOutgoingChat
    implements OutgoingChat {
        private static final Map<String, net.kyori.adventure.chat.ChatType> BUILT_IN_CHAT_TYPES = Util.make(() -> {
            HashMap<String, net.kyori.adventure.chat.ChatType> map = new HashMap<String, net.kyori.adventure.chat.ChatType>();
            for (Field declaredField : net.kyori.adventure.chat.ChatType.class.getDeclaredFields()) {
                if (!Modifier.isStatic(declaredField.getModifiers()) || !declaredField.getType().equals(ChatType.class)) continue;
                try {
                    net.kyori.adventure.chat.ChatType type = (net.kyori.adventure.chat.ChatType)declaredField.get(null);
                    map.put(type.key().asString(), type);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
            return map;
        });

        ViewersOutgoingChat() {
        }

        @Override
        public void sendFormatChangedViewerAware(CraftPlayer player, Component displayName, Component message, ChatRenderer renderer, Set<Audience> viewers, ChatType.Bound chatType) {
            this.broadcastToViewers(viewers, chatType, v -> PaperAdventure.asVanilla(renderer.render((Player)player, displayName, message, v)));
        }

        @Override
        public void sendMessageChanged(CraftPlayer player, net.minecraft.network.chat.Component renderedMessage, Set<Audience> viewers, ChatType.Bound chatType) {
            this.broadcastToViewers(viewers, chatType, $ -> renderedMessage);
        }

        @Override
        public void sendOriginal(CraftPlayer player, Set<Audience> viewers, ChatType.Bound chatType) {
            this.broadcastToViewers(viewers, chatType, null);
        }

        private void broadcastToViewers(Collection<Audience> viewers, ChatType.Bound chatType, @Nullable Function<Audience, net.minecraft.network.chat.Component> msgFunction) {
            for (Audience viewer : viewers) {
                if (ViewersOutgoingChat.acceptsNative(viewer)) {
                    this.sendNative(viewer, chatType, msgFunction);
                    continue;
                }
                @Nullable net.minecraft.network.chat.Component unsigned = Optionull.map(msgFunction, f -> (net.minecraft.network.chat.Component)f.apply(viewer));
                PlayerChatMessage msg = unsigned == null ? ChatProcessor.this.message : ChatProcessor.this.message.withUnsignedContent(unsigned);
                viewer.sendMessage((SignedMessage)msg.adventureView(), this.adventure(chatType));
            }
        }

        private ChatType.Bound adventure(ChatType.Bound chatType) {
            String stringKey = Objects.requireNonNull(chatType.chatType().unwrapKey().orElseThrow().location(), () -> "No key for '%s' in CHAT_TYPE registry.".formatted(chatType)).toString();
            @Nullable net.kyori.adventure.chat.ChatType adventure = BUILT_IN_CHAT_TYPES.get(stringKey);
            if (adventure == null) {
                adventure = net.kyori.adventure.chat.ChatType.chatType((Keyed)Key.key((String)stringKey));
            }
            return adventure.bind((ComponentLike)PaperAdventure.asAdventure(chatType.name()), (ComponentLike)chatType.targetName().map(PaperAdventure::asAdventure).orElse(null));
        }

        private static boolean acceptsNative(Audience viewer) {
            if (viewer instanceof Player || viewer instanceof ConsoleCommandSender) {
                return true;
            }
            if (viewer instanceof ForwardingAudience.Single) {
                ForwardingAudience.Single single = (ForwardingAudience.Single)viewer;
                return ViewersOutgoingChat.acceptsNative(single.audience());
            }
            return false;
        }

        private void sendNative(Audience viewer, ChatType.Bound chatType, @Nullable Function<Audience, net.minecraft.network.chat.Component> msgFunction) {
            if (viewer instanceof ConsoleCommandSender) {
                this.sendToServer(chatType, msgFunction);
            } else if (viewer instanceof CraftPlayer) {
                CraftPlayer craftPlayer = (CraftPlayer)viewer;
                craftPlayer.getHandle().sendChatMessage(ChatProcessor.this.outgoing, ChatProcessor.this.player.shouldFilterMessageTo(craftPlayer.getHandle()), chatType, Optionull.map(msgFunction, f -> (net.minecraft.network.chat.Component)f.apply(viewer)));
            } else if (viewer instanceof ForwardingAudience.Single) {
                ForwardingAudience.Single single = (ForwardingAudience.Single)viewer;
                this.sendNative(single.audience(), chatType, msgFunction);
            } else {
                throw new IllegalStateException("Should only be a Player or Console or ForwardingAudience.Single pointing to one!");
            }
        }

        private void sendToServer(ChatType.Bound chatType, @Nullable Function<Audience, net.minecraft.network.chat.Component> msgFunction) {
            PlayerChatMessage toConsoleMessage = msgFunction == null ? ChatProcessor.this.message : ChatProcessor.this.message.withUnsignedContent(msgFunction.apply((Audience)ChatProcessor.this.server.console));
            ChatProcessor.this.server.logChatMessage(toConsoleMessage.decoratedContent(), chatType, ChatProcessor.this.server.getPlayerList().verifyChatTrusted(toConsoleMessage) || LeavesConfig.noChatSign ? null : "Not Secure");
        }
    }

    static interface OutgoingChat {
        default public void sendFormatChangedViewerUnaware(CraftPlayer player, net.minecraft.network.chat.Component renderedMessage, Set<Audience> viewers, ChatType.Bound chatType) {
            this.sendMessageChanged(player, renderedMessage, viewers, chatType);
        }

        public void sendFormatChangedViewerAware(CraftPlayer var1, Component var2, Component var3, ChatRenderer var4, Set<Audience> var5, ChatType.Bound var6);

        public void sendMessageChanged(CraftPlayer var1, net.minecraft.network.chat.Component var2, Set<Audience> var3, ChatType.Bound var4);

        public void sendOriginal(CraftPlayer var1, Set<Audience> var2, ChatType.Bound var3);
    }
}

