/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.adventure.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import org.jetbrains.annotations.NotNull;

public class ClickCallbackProviderImpl
implements ClickCallback.Provider {
    public static final CallbackManager CALLBACK_MANAGER = new CallbackManager();

    @NotNull
    public ClickEvent create(@NotNull ClickCallback<Audience> callback, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ClickCallback.Options options) {
        return ClickEvent.runCommand((String)("/paper:callback " + String.valueOf(CALLBACK_MANAGER.addCallback(callback, options))));
    }

    public static final class CallbackManager {
        private final Map<UUID, StoredCallback> callbacks = new HashMap<UUID, StoredCallback>();
        private final Queue<StoredCallback> queue = new ConcurrentLinkedQueue<StoredCallback>();

        private CallbackManager() {
        }

        public UUID addCallback(@NotNull ClickCallback<Audience> callback, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ClickCallback.Options options) {
            UUID id = UUID.randomUUID();
            this.queue.add(new StoredCallback(callback, options, id));
            return id;
        }

        public void handleQueue(int currentTick) {
            StoredCallback callback2;
            if (currentTick % 100 == 0) {
                this.callbacks.values().removeIf(callback -> !callback.valid());
            }
            while ((callback2 = this.queue.poll()) != null) {
                this.callbacks.put(callback2.id(), callback2);
            }
        }

        public void runCallback(@NotNull Audience audience, UUID id) {
            StoredCallback callback = this.callbacks.get(id);
            if (callback != null && callback.valid()) {
                callback.takeUse();
                callback.callback.accept(audience);
            }
        }
    }

    private static final class StoredCallback {
        private final long startedAt = System.nanoTime();
        private final ClickCallback<Audience> callback;
        private final long lifetime;
        private final UUID id;
        private int remainingUses;

        private StoredCallback(@NotNull ClickCallback<Audience> callback, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ClickCallback.Options options, UUID id) {
            this.callback = callback;
            this.lifetime = options.lifetime().toNanos();
            this.remainingUses = options.uses();
            this.id = id;
        }

        public void takeUse() {
            if (this.remainingUses != -1) {
                --this.remainingUses;
            }
        }

        public boolean hasRemainingUses() {
            return this.remainingUses == -1 || this.remainingUses > 0;
        }

        public boolean expired() {
            return System.nanoTime() - this.startedAt >= this.lifetime;
        }

        public boolean valid() {
            return this.hasRemainingUses() && !this.expired();
        }

        public UUID id() {
            return this.id;
        }
    }
}

