/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.slf4j.Logger;

public final class ChunkSystem {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void scheduleChunkTask(ServerLevel level, int chunkX, int chunkZ, Runnable run) {
        ChunkSystem.scheduleChunkTask(level, chunkX, chunkZ, run, PrioritisedExecutor.Priority.NORMAL);
    }

    public static void scheduleChunkTask(ServerLevel level, int chunkX, int chunkZ, Runnable run, PrioritisedExecutor.Priority priority) {
        level.chunkTaskScheduler.scheduleChunkTask(chunkX, chunkZ, run, priority);
    }

    public static void scheduleChunkLoad(ServerLevel level, int chunkX, int chunkZ, boolean gen, ChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<ChunkAccess> onComplete) {
        level.chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, gen, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleChunkLoad(ServerLevel level, int chunkX, int chunkZ, ChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<ChunkAccess> onComplete) {
        level.chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static void scheduleTickingState(ServerLevel level, int chunkX, int chunkZ, FullChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<LevelChunk> onComplete) {
        level.chunkTaskScheduler.scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
    }

    public static List<ChunkHolder> getVisibleChunkHolders(ServerLevel level) {
        return level.chunkTaskScheduler.chunkHolderManager.getOldChunkHolders();
    }

    public static List<ChunkHolder> getUpdatingChunkHolders(ServerLevel level) {
        return level.chunkTaskScheduler.chunkHolderManager.getOldChunkHolders();
    }

    public static int getVisibleChunkHolderCount(ServerLevel level) {
        return level.chunkTaskScheduler.chunkHolderManager.size();
    }

    public static int getUpdatingChunkHolderCount(ServerLevel level) {
        return level.chunkTaskScheduler.chunkHolderManager.size();
    }

    public static boolean hasAnyChunkHolders(ServerLevel level) {
        return ChunkSystem.getUpdatingChunkHolderCount(level) != 0;
    }

    public static void onEntityPreAdd(ServerLevel level, Entity entity) {
    }

    public static void onChunkHolderCreate(ServerLevel level, ChunkHolder holder) {
        ChunkMap chunkMap = level.chunkSource.chunkMap;
        int len = chunkMap.regionManagers.size();
        for (int index = 0; index < len; ++index) {
            chunkMap.regionManagers.get(index).addChunk(holder.getPos().x, holder.getPos().z);
        }
    }

    public static void onChunkHolderDelete(ServerLevel level, ChunkHolder holder) {
        ChunkMap chunkMap = level.chunkSource.chunkMap;
        int len = chunkMap.regionManagers.size();
        for (int index = 0; index < len; ++index) {
            chunkMap.regionManagers.get(index).removeChunk(holder.getPos().x, holder.getPos().z);
        }
    }

    public static void onChunkBorder(LevelChunk chunk, ChunkHolder holder) {
        chunk.playerChunk = holder;
        chunk.chunkStatus = FullChunkStatus.FULL;
    }

    public static void onChunkNotBorder(LevelChunk chunk, ChunkHolder holder) {
        chunk.chunkStatus = FullChunkStatus.INACCESSIBLE;
    }

    public static void onChunkTicking(LevelChunk chunk, ChunkHolder holder) {
        chunk.level.getChunkSource().tickingChunks.add(chunk);
        chunk.chunkStatus = FullChunkStatus.BLOCK_TICKING;
        chunk.level.chunkSource.chunkMap.tickingGenerated.incrementAndGet();
    }

    public static void onChunkNotTicking(LevelChunk chunk, ChunkHolder holder) {
        chunk.level.getChunkSource().tickingChunks.remove(chunk);
        chunk.chunkStatus = FullChunkStatus.FULL;
    }

    public static void onChunkEntityTicking(LevelChunk chunk, ChunkHolder holder) {
        chunk.level.getChunkSource().entityTickingChunks.add(chunk);
        chunk.chunkStatus = FullChunkStatus.ENTITY_TICKING;
    }

    public static void onChunkNotEntityTicking(LevelChunk chunk, ChunkHolder holder) {
        chunk.level.getChunkSource().entityTickingChunks.remove(chunk);
        chunk.chunkStatus = FullChunkStatus.BLOCK_TICKING;
    }

    public static ChunkHolder getUnloadingChunkHolder(ServerLevel level, int chunkX, int chunkZ) {
        return level.chunkSource.chunkMap.getUnloadingChunkHolder(chunkX, chunkZ);
    }

    public static int getSendViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getAPISendViewDistance(player);
    }

    public static int getLoadViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getLoadViewDistance(player);
    }

    public static int getTickViewDistance(ServerPlayer player) {
        return RegionizedPlayerChunkLoader.getAPITickViewDistance(player);
    }

    private ChunkSystem() {
        throw new RuntimeException();
    }
}

