/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system;

import ca.spottedleaf.concurrentutil.collection.SRSWLinkedQueue;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import io.papermc.paper.chunk.system.scheduling.ChunkHolderManager;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.player.SingleUserAreaMap;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongHeapPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class RegionizedPlayerChunkLoader {
    private static final long[][] SEARCH_RADIUS_ITERATION_LIST = new long[67][];
    public static final TicketType<Long> REGION_PLAYER_TICKET;
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int TICK_TICKET_LEVEL = 31;
    public static final int GENERATED_TICKET_LEVEL;
    public static final int LOADED_TICKET_LEVEL;
    private final ServerLevel world;

    private static void expandQuadrants(CustomLongArray input, int size) {
        int len = input.size();
        long[] array = input.elements();
        int writeIndex = size - 1;
        for (int i = len - 1; i >= 0; --i) {
            int chunkZ;
            long key = array[i];
            int chunkX = CoordinateUtils.getChunkX(key);
            if ((chunkX | (chunkZ = CoordinateUtils.getChunkZ(key))) < 0 || i != 0 && chunkX == 0 && chunkZ == 0) {
                throw new IllegalStateException();
            }
            if (chunkZ != 0) {
                array[writeIndex--] = CoordinateUtils.getChunkKey(chunkX, -chunkZ);
            }
            if (chunkX != 0 && chunkZ != 0) {
                array[writeIndex--] = CoordinateUtils.getChunkKey(-chunkX, -chunkZ);
            }
            if (chunkX != 0) {
                array[writeIndex--] = CoordinateUtils.getChunkKey(-chunkX, chunkZ);
            }
            array[writeIndex--] = key;
        }
        input.forceSize(size);
        if (writeIndex != -1) {
            throw new IllegalStateException();
        }
    }

    private static long[] generateBFSOrder(int radius) {
        CustomLongArray[] byDistance = RegionizedPlayerChunkLoader.makeQ1BFS(radius);
        int len = byDistance.length;
        for (int i = 0; i < len; ++i) {
            CustomLongArray points = byDistance[i];
            int expectedSize = RegionizedPlayerChunkLoader.getDistanceSize(i, radius);
            CustomLongArray spread = RegionizedPlayerChunkLoader.spread(points, expectedSize);
            RegionizedPlayerChunkLoader.expandQuadrants(spread, expectedSize);
            byDistance[i] = spread;
        }
        CustomLongArray ret = new CustomLongArray((2 * radius + 1) * (2 * radius + 1));
        for (CustomLongArray dist : byDistance) {
            ret.addAll(dist);
        }
        return ret.elements();
    }

    public static int getAPITickViewDistance(Player player) {
        return RegionizedPlayerChunkLoader.getAPITickViewDistance(((CraftPlayer)player).getHandle());
    }

    public static int getAPITickViewDistance(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.level();
        PlayerChunkLoaderData data = player.chunkLoader;
        if (data == null) {
            return level.playerChunkLoader.getAPITickDistance();
        }
        return data.lastTickDistance;
    }

    public static int getAPIViewDistance(Player player) {
        return RegionizedPlayerChunkLoader.getAPIViewDistance(((CraftPlayer)player).getHandle());
    }

    public static int getAPIViewDistance(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.level();
        PlayerChunkLoaderData data = player.chunkLoader;
        if (data == null) {
            return level.playerChunkLoader.getAPIViewDistance();
        }
        return data.lastLoadDistance - 1;
    }

    public static int getLoadViewDistance(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.level();
        PlayerChunkLoaderData data = player.chunkLoader;
        if (data == null) {
            return level.playerChunkLoader.getAPIViewDistance();
        }
        return data.lastLoadDistance - 1;
    }

    public static int getAPISendViewDistance(Player player) {
        return RegionizedPlayerChunkLoader.getAPISendViewDistance(((CraftPlayer)player).getHandle());
    }

    public static int getAPISendViewDistance(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.level();
        PlayerChunkLoaderData data = player.chunkLoader;
        if (data == null) {
            return level.playerChunkLoader.getAPISendViewDistance();
        }
        return data.lastSendDistance;
    }

    public RegionizedPlayerChunkLoader(ServerLevel world) {
        this.world = world;
    }

    public void addPlayer(ServerPlayer player) {
        PlayerChunkLoaderData loader;
        TickThread.ensureTickThread(player, "Cannot add player to player chunk loader async");
        if (!player.isRealPlayer) {
            return;
        }
        if (player.chunkLoader != null) {
            throw new IllegalStateException("Player is already added to player chunk loader");
        }
        player.chunkLoader = loader = new PlayerChunkLoaderData(this.world, player);
        loader.add();
    }

    public void updatePlayer(ServerPlayer player) {
        PlayerChunkLoaderData loader = player.chunkLoader;
        if (loader != null) {
            loader.update();
        }
    }

    public void removePlayer(ServerPlayer player) {
        TickThread.ensureTickThread(player, "Cannot remove player from player chunk loader async");
        if (!player.isRealPlayer) {
            return;
        }
        PlayerChunkLoaderData loader = player.chunkLoader;
        if (loader == null) {
            return;
        }
        loader.remove();
        player.chunkLoader = null;
    }

    public void setSendDistance(int distance) {
        this.world.setSendViewDistance(distance);
    }

    public void setLoadDistance(int distance) {
        this.world.setLoadViewDistance(distance);
    }

    public void setTickDistance(int distance) {
        this.world.setTickViewDistance(distance);
    }

    public int getAPITickDistance() {
        ViewDistances distances = this.world.getViewDistances();
        int tickViewDistance = PlayerChunkLoaderData.getTickDistance(-1, distances.tickViewDistance);
        return tickViewDistance;
    }

    public int getAPIViewDistance() {
        ViewDistances distances = this.world.getViewDistances();
        int tickViewDistance = PlayerChunkLoaderData.getTickDistance(-1, distances.tickViewDistance);
        int loadDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, -1, distances.loadViewDistance);
        return loadDistance - 1;
    }

    public int getAPISendViewDistance() {
        ViewDistances distances = this.world.getViewDistances();
        int tickViewDistance = PlayerChunkLoaderData.getTickDistance(-1, distances.tickViewDistance);
        int loadDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, -1, distances.loadViewDistance);
        int sendViewDistance = PlayerChunkLoaderData.getSendViewDistance(loadDistance, -1, -1, distances.sendViewDistance);
        return sendViewDistance;
    }

    public boolean isChunkSent(ServerPlayer player, int chunkX, int chunkZ, boolean borderOnly) {
        return borderOnly ? this.isChunkSentBorderOnly(player, chunkX, chunkZ) : this.isChunkSent(player, chunkX, chunkZ);
    }

    public boolean isChunkSent(ServerPlayer player, int chunkX, int chunkZ) {
        PlayerChunkLoaderData loader = player.chunkLoader;
        if (loader == null) {
            return false;
        }
        return loader.sentChunks.contains(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    public boolean isChunkSentBorderOnly(ServerPlayer player, int chunkX, int chunkZ) {
        PlayerChunkLoaderData loader = player.chunkLoader;
        if (loader == null) {
            return false;
        }
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                if (loader.sentChunks.contains(CoordinateUtils.getChunkKey(dx + chunkX, dz + chunkZ))) continue;
                return true;
            }
        }
        return false;
    }

    public void tick() {
        TickThread.ensureTickThread("Cannot tick player chunk loader async");
        long currTime = System.nanoTime();
        for (ServerPlayer player : new ArrayList<ServerPlayer>(this.world.players())) {
            PlayerChunkLoaderData loader = player.chunkLoader;
            if (loader == null || loader.world != this.world) continue;
            loader.update();
            loader.updateQueues(currTime);
        }
    }

    private static int getDistanceSize(int radius, int max) {
        if (radius == 0) {
            return 1;
        }
        int diff = radius - max;
        if (diff <= 0) {
            return 4 * radius;
        }
        return 4 * (max - Math.max(0, diff - 1));
    }

    private static int getQ1DistanceSize(int radius, int max) {
        if (radius == 0) {
            return 1;
        }
        int diff = radius - max;
        if (diff <= 0) {
            return radius + 1;
        }
        return max - diff + 1;
    }

    private static CustomLongArray[] makeQ1BFS(int radius) {
        CustomLongArray[] ret = new CustomLongArray[2 * radius + 1];
        BasicFIFOLQueue queue = new BasicFIFOLQueue(Math.max(1, 4 * radius) + 1);
        LongOpenHashSet seen = new LongOpenHashSet((radius + 1) * (radius + 1));
        seen.add(CoordinateUtils.getChunkKey(0, 0));
        queue.addLast(CoordinateUtils.getChunkKey(0, 0));
        while (!queue.isEmpty()) {
            long chunk = queue.removeFirst();
            int chunkX = CoordinateUtils.getChunkX(chunk);
            int chunkZ = CoordinateUtils.getChunkZ(chunk);
            int index = Math.abs(chunkX) + Math.abs(chunkZ);
            CustomLongArray list = ret[index];
            if (list != null) {
                list.addUnchecked(chunk);
            } else {
                ret[index] = new CustomLongArray(RegionizedPlayerChunkLoader.getQ1DistanceSize(index, radius));
                ret[index].addUnchecked(chunk);
            }
            for (int i = 0; i < 4; ++i) {
                int signInv = -(i >>> 1);
                int axis = i & 1;
                int dx = (axis - 1 ^ signInv) - signInv;
                int dz = (-axis ^ signInv) - signInv;
                int neighbourX = chunkX + dx;
                int neighbourZ = chunkZ + dz;
                long neighbour = CoordinateUtils.getChunkKey(neighbourX, neighbourZ);
                if ((neighbourX | neighbourZ) < 0 || Math.max(Math.abs(neighbourX), Math.abs(neighbourZ)) > radius || !seen.add(neighbour)) continue;
                queue.addLast(neighbour);
            }
        }
        return ret;
    }

    private static CustomLongArray spread(CustomLongArray input, int size) {
        LongLinkedOpenHashSet notAdded = new LongLinkedOpenHashSet((LongCollection)input);
        CustomLongArray added = new CustomLongArray(size);
        while (!notAdded.isEmpty()) {
            if (added.isEmpty()) {
                added.addUnchecked(notAdded.removeLastLong());
                continue;
            }
            long maxChunk = -1L;
            int maxDist = 0;
            LongListIterator iterator = notAdded.iterator();
            while (iterator.hasNext()) {
                long chunkKey = iterator.nextLong();
                int chunkX = CoordinateUtils.getChunkX(chunkKey);
                int chunkZ = CoordinateUtils.getChunkZ(chunkKey);
                int minDist = Integer.MAX_VALUE;
                int len = added.size();
                long[] addedArr = added.elements();
                Objects.checkFromToIndex(0, len, addedArr.length);
                for (int i = 0; i < len; ++i) {
                    long addedKey = addedArr[i];
                    int addedX = CoordinateUtils.getChunkX(addedKey);
                    int addedZ = CoordinateUtils.getChunkZ(addedKey);
                    int dist = Math.max(Math.abs(addedX - chunkX), Math.abs(addedZ - chunkZ));
                    minDist = Math.min(dist, minDist);
                }
                if (minDist <= maxDist) continue;
                maxDist = minDist;
                maxChunk = chunkKey;
            }
            if (!notAdded.remove(maxChunk)) {
                throw new IllegalStateException();
            }
            added.addUnchecked(maxChunk);
        }
        return added;
    }

    static {
        for (int i = 0; i < SEARCH_RADIUS_ITERATION_LIST.length; ++i) {
            RegionizedPlayerChunkLoader.SEARCH_RADIUS_ITERATION_LIST[i] = RegionizedPlayerChunkLoader.generateBFSOrder(i);
        }
        REGION_PLAYER_TICKET = TicketType.create("region_player_ticket", Long::compareTo);
        GENERATED_TICKET_LEVEL = 33 + ChunkStatus.getDistance(ChunkStatus.FULL);
        LOADED_TICKET_LEVEL = 33 + ChunkStatus.getDistance(ChunkStatus.EMPTY);
    }

    private static class CustomLongArray
    extends LongArrayList {
        public CustomLongArray() {
        }

        public CustomLongArray(int expected) {
            super(expected);
        }

        public boolean addAll(CustomLongArray list) {
            this.addElements(this.size, list.a, 0, list.size);
            return list.size != 0;
        }

        public void addUnchecked(long value) {
            this.a[this.size++] = value;
        }

        public void forceSize(int to) {
            this.size = to;
        }

        public int hashCode() {
            long h = 1L;
            Objects.checkFromToIndex(0, this.size, this.a.length);
            for (int i = 0; i < this.size; ++i) {
                h = HashCommon.mix((long)(h + this.a[i]));
            }
            return (int)h;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomLongArray)) {
                return false;
            }
            CustomLongArray other = (CustomLongArray)((Object)o);
            return this.size == other.size && Arrays.equals(this.a, 0, this.size, other.a, 0, this.size);
        }
    }

    public static final class PlayerChunkLoaderData {
        private static final AtomicLong ID_GENERATOR = new AtomicLong();
        private final long id = ID_GENERATOR.incrementAndGet();
        private final Long idBoxed = this.id;
        private static final long MAX_RATE = 10000L;
        private final ServerPlayer player;
        private final ServerLevel world;
        private int lastChunkX = Integer.MIN_VALUE;
        private int lastChunkZ = Integer.MIN_VALUE;
        private int lastSendDistance = Integer.MIN_VALUE;
        private int lastLoadDistance = Integer.MIN_VALUE;
        private int lastTickDistance = Integer.MIN_VALUE;
        private int lastSentChunkCenterX = Integer.MIN_VALUE;
        private int lastSentChunkCenterZ = Integer.MIN_VALUE;
        private int lastSentChunkRadius = Integer.MIN_VALUE;
        private int lastSentSimulationDistance = Integer.MIN_VALUE;
        private boolean canGenerateChunks = true;
        private final ArrayDeque<ChunkHolderManager.TicketOperation<?, ?>> delayedTicketOps = new ArrayDeque();
        private final LongOpenHashSet sentChunks = new LongOpenHashSet();
        private static final byte CHUNK_TICKET_STAGE_NONE = 0;
        private static final byte CHUNK_TICKET_STAGE_LOADING = 1;
        private static final byte CHUNK_TICKET_STAGE_LOADED = 2;
        private static final byte CHUNK_TICKET_STAGE_GENERATING = 3;
        private static final byte CHUNK_TICKET_STAGE_GENERATED = 4;
        private static final byte CHUNK_TICKET_STAGE_TICK = 5;
        private static final int[] TICKET_STAGE_TO_LEVEL = new int[]{ChunkHolderManager.MAX_TICKET_LEVEL + 1, LOADED_TICKET_LEVEL, LOADED_TICKET_LEVEL, GENERATED_TICKET_LEVEL, GENERATED_TICKET_LEVEL, 31};
        private final Long2ByteOpenHashMap chunkTicketStage = new Long2ByteOpenHashMap();
        private final AllocatingRateLimiter chunkSendLimiter;
        private final AllocatingRateLimiter chunkLoadTicketLimiter;
        private final AllocatingRateLimiter chunkGenerateTicketLimiter;
        private final LongComparator CLOSEST_MANHATTAN_DIST;
        private final LongHeapPriorityQueue sendQueue;
        private final LongHeapPriorityQueue tickingQueue;
        private final LongHeapPriorityQueue generatingQueue;
        private final LongHeapPriorityQueue genQueue;
        private final LongHeapPriorityQueue loadingQueue;
        private final LongHeapPriorityQueue loadQueue;
        private volatile boolean removed;
        private final SingleUserAreaMap<PlayerChunkLoaderData> broadcastMap;
        private final SingleUserAreaMap<PlayerChunkLoaderData> loadTicketCleanup;
        private final SingleUserAreaMap<PlayerChunkLoaderData> tickMap;

        public PlayerChunkLoaderData(ServerLevel world, ServerPlayer player) {
            this.chunkTicketStage.defaultReturnValue((byte)0);
            this.chunkSendLimiter = new AllocatingRateLimiter();
            this.chunkLoadTicketLimiter = new AllocatingRateLimiter();
            this.chunkGenerateTicketLimiter = new AllocatingRateLimiter();
            this.CLOSEST_MANHATTAN_DIST = (c1, c2) -> {
                int c1x = CoordinateUtils.getChunkX(c1);
                int c1z = CoordinateUtils.getChunkZ(c1);
                int c2x = CoordinateUtils.getChunkX(c2);
                int c2z = CoordinateUtils.getChunkZ(c2);
                int centerX = this.lastChunkX;
                int centerZ = this.lastChunkZ;
                return Integer.compare(Math.abs(c1x - centerX) + Math.abs(c1z - centerZ), Math.abs(c2x - centerX) + Math.abs(c2z - centerZ));
            };
            this.sendQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.tickingQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.generatingQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.genQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.loadingQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.loadQueue = new LongHeapPriorityQueue(this.CLOSEST_MANHATTAN_DIST);
            this.broadcastMap = new SingleUserAreaMap<PlayerChunkLoaderData>(this, this){

                @Override
                protected void addCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                }

                @Override
                protected void removeCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                    parameter.sendUnloadChunk(chunkX, chunkZ);
                }
            };
            this.loadTicketCleanup = new SingleUserAreaMap<PlayerChunkLoaderData>(this, this){

                @Override
                protected void addCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                }

                @Override
                protected void removeCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                    long chunk = CoordinateUtils.getChunkKey(chunkX, chunkZ);
                    byte ticketStage = parameter.chunkTicketStage.remove(chunk);
                    int level = TICKET_STAGE_TO_LEVEL[ticketStage];
                    if (level > ChunkHolderManager.MAX_TICKET_LEVEL) {
                        return;
                    }
                    parameter.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(chunk, TicketType.UNKNOWN, level, new ChunkPos(chunkX, chunkZ), REGION_PLAYER_TICKET, level, parameter.idBoxed));
                }
            };
            this.tickMap = new SingleUserAreaMap<PlayerChunkLoaderData>(this, this){

                @Override
                protected void addCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                }

                @Override
                protected void removeCallback(PlayerChunkLoaderData parameter, int chunkX, int chunkZ) {
                    long chunk = CoordinateUtils.getChunkKey(chunkX, chunkZ);
                    if (!parameter.chunkTicketStage.replace(chunk, (byte)5, (byte)4)) {
                        return;
                    }
                    parameter.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(chunk, TicketType.UNKNOWN, 31, new ChunkPos(chunkX, chunkZ), REGION_PLAYER_TICKET, 31, parameter.idBoxed));
                    parameter.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addOp(chunk, REGION_PLAYER_TICKET, GENERATED_TICKET_LEVEL, parameter.idBoxed));
                }
            };
            this.world = world;
            this.player = player;
        }

        private void flushDelayedTicketOps() {
            if (this.delayedTicketOps.isEmpty()) {
                return;
            }
            this.world.chunkTaskScheduler.chunkHolderManager.performTicketUpdates(this.delayedTicketOps);
            this.delayedTicketOps.clear();
        }

        private void pushDelayedTicketOp(ChunkHolderManager.TicketOperation<?, ?> op) {
            this.delayedTicketOps.addLast(op);
        }

        private void sendChunk(int chunkX, int chunkZ) {
            if (this.sentChunks.add(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
                PlayerChunkSender.sendChunk(this.player.connection, this.world, this.world.getChunkIfLoaded(chunkX, chunkZ));
                return;
            }
            throw new IllegalStateException();
        }

        private void sendUnloadChunk(int chunkX, int chunkZ) {
            if (!this.sentChunks.remove(CoordinateUtils.getChunkKey(chunkX, chunkZ))) {
                return;
            }
            this.sendUnloadChunkRaw(chunkX, chunkZ);
        }

        private void sendUnloadChunkRaw(int chunkX, int chunkZ) {
            PlayerChunkSender.dropChunkStatic(this.player, new ChunkPos(chunkX, chunkZ));
        }

        private static boolean wantChunkLoaded(int centerX, int centerZ, int chunkX, int chunkZ, int sendRadius) {
            return ChunkTrackingView.isWithinDistance(centerX, centerZ, sendRadius, chunkX, chunkZ, true);
        }

        private static int getClientViewDistance(ServerPlayer player) {
            Integer vd = player.requestedViewDistance();
            return vd == null ? -1 : Math.max(0, vd);
        }

        private static int getTickDistance(int playerTickViewDistance, int worldTickViewDistance) {
            return playerTickViewDistance < 0 ? worldTickViewDistance : playerTickViewDistance;
        }

        private static int getLoadViewDistance(int tickViewDistance, int playerLoadViewDistance, int worldLoadViewDistance) {
            return Math.max(tickViewDistance + 1, playerLoadViewDistance < 0 ? worldLoadViewDistance : playerLoadViewDistance);
        }

        private static int getSendViewDistance(int loadViewDistance, int clientViewDistance, int playerSendViewDistance, int worldSendViewDistance) {
            return Math.min(loadViewDistance - 1, playerSendViewDistance < 0 ? (!GlobalConfiguration.get().chunkLoadingAdvanced.autoConfigSendDistance || clientViewDistance < 0 ? (worldSendViewDistance < 0 ? loadViewDistance - 1 : worldSendViewDistance) : clientViewDistance + 1) : playerSendViewDistance);
        }

        private Packet<?> updateClientChunkRadius(int radius) {
            this.lastSentChunkRadius = radius;
            return new ClientboundSetChunkCacheRadiusPacket(radius);
        }

        private Packet<?> updateClientSimulationDistance(int distance) {
            this.lastSentSimulationDistance = distance;
            return new ClientboundSetSimulationDistancePacket(distance);
        }

        private Packet<?> updateClientChunkCenter(int chunkX, int chunkZ) {
            this.lastSentChunkCenterX = chunkX;
            this.lastSentChunkCenterZ = chunkZ;
            return new ClientboundSetChunkCacheCenterPacket(chunkX, chunkZ);
        }

        private boolean canPlayerGenerateChunks() {
            return !this.player.isSpectator() || this.world.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
        }

        private double getMaxChunkLoadRate() {
            double configRate = GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkLoadRate;
            return configRate < 0.0 || configRate > 10000.0 ? 10000.0 : Math.max(1.0, configRate);
        }

        private double getMaxChunkGenRate() {
            double configRate = GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkGenerateRate;
            return configRate < 0.0 || configRate > 10000.0 ? 10000.0 : Math.max(1.0, configRate);
        }

        private double getMaxChunkSendRate() {
            double configRate = GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkSendRate;
            return configRate < 0.0 || configRate > 10000.0 ? 10000.0 : Math.max(1.0, configRate);
        }

        private long getMaxChunkLoads() {
            long radiusChunks = (2L * (long)this.lastLoadDistance + 1L) * (2L * (long)this.lastLoadDistance + 1L);
            long configLimit = GlobalConfiguration.get().chunkLoadingAdvanced.playerMaxConcurrentChunkLoads;
            if (configLimit == 0L) {
                configLimit = Math.max(5L, radiusChunks / 5L);
            } else if (configLimit < 0L) {
                configLimit = Integer.MAX_VALUE;
            }
            return configLimit -= (long)this.loadingQueue.size();
        }

        private long getMaxChunkGenerates() {
            long radiusChunks = (2L * (long)this.lastLoadDistance + 1L) * (2L * (long)this.lastLoadDistance + 1L);
            long configLimit = GlobalConfiguration.get().chunkLoadingAdvanced.playerMaxConcurrentChunkGenerates;
            if (configLimit == 0L) {
                configLimit = Math.max(5L, radiusChunks / 5L);
            } else if (configLimit < 0L) {
                configLimit = Integer.MAX_VALUE;
            }
            return configLimit -= (long)this.generatingQueue.size();
        }

        private boolean wantChunkSent(int chunkX, int chunkZ) {
            int dx = this.lastChunkX - chunkX;
            int dz = this.lastChunkZ - chunkZ;
            return Math.max(Math.abs(dx), Math.abs(dz)) <= this.lastSendDistance + 1 && PlayerChunkLoaderData.wantChunkLoaded(this.lastChunkX, this.lastChunkZ, chunkX, chunkZ, this.lastSendDistance);
        }

        private boolean wantChunkTicked(int chunkX, int chunkZ) {
            int dx = this.lastChunkX - chunkX;
            int dz = this.lastChunkZ - chunkZ;
            return Math.max(Math.abs(dx), Math.abs(dz)) <= this.lastTickDistance;
        }

        void updateQueues(long time) {
            int pendingSendZ;
            long pendingSend;
            int pendingSendX;
            LevelChunk chunk;
            byte prev;
            int pendingChunkZ;
            long pendingGenChunk;
            int pendingChunkX;
            LevelChunk pending;
            int pendingChunkZ2;
            long pendingLoadChunk;
            int pendingChunkX2;
            ChunkAccess pending2;
            TickThread.ensureTickThread(this.player, "Cannot tick player chunk loader async");
            if (this.removed) {
                throw new IllegalStateException("Ticking removed player chunk loader");
            }
            double loadRate = this.getMaxChunkLoadRate();
            double genRate = this.getMaxChunkGenRate();
            double sendRate = this.getMaxChunkSendRate();
            this.chunkLoadTicketLimiter.tickAllocation(time, loadRate, loadRate);
            this.chunkGenerateTicketLimiter.tickAllocation(time, genRate, genRate);
            this.chunkSendLimiter.tickAllocation(time, sendRate, sendRate);
            while (!this.loadingQueue.isEmpty() && (pending2 = this.world.chunkSource.getChunkAtImmediately(pendingChunkX2 = CoordinateUtils.getChunkX(pendingLoadChunk = this.loadingQueue.firstLong()), pendingChunkZ2 = CoordinateUtils.getChunkZ(pendingLoadChunk))) != null) {
                this.loadingQueue.dequeueLong();
                byte prev2 = this.chunkTicketStage.put(pendingLoadChunk, (byte)2);
                if (prev2 != 1) {
                    throw new IllegalStateException("Previous state should be 1, not " + prev2);
                }
                if (!this.canGenerateChunks && !this.isLoadedChunkGeneratable(pending2)) continue;
                this.genQueue.enqueue(pendingLoadChunk);
            }
            long maxLoads = Math.max(0L, Math.min(10000L, Math.min((long)this.loadQueue.size(), this.getMaxChunkLoads())));
            int maxLoadsThisTick = (int)this.chunkLoadTicketLimiter.takeAllocation(time, loadRate, maxLoads);
            if (maxLoadsThisTick > 0) {
                int i;
                LongArrayList chunks = new LongArrayList(maxLoadsThisTick);
                for (i = 0; i < maxLoadsThisTick; ++i) {
                    long chunk2 = this.loadQueue.dequeueLong();
                    byte prev3 = this.chunkTicketStage.put(chunk2, (byte)1);
                    if (prev3 != 0) {
                        throw new IllegalStateException("Previous state should be 0, not " + prev3);
                    }
                    this.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addOp(chunk2, REGION_PLAYER_TICKET, LOADED_TICKET_LEVEL, this.idBoxed));
                    chunks.add(chunk2);
                    this.loadingQueue.enqueue(chunk2);
                }
                this.flushDelayedTicketOps();
                this.world.chunkTaskScheduler.chunkHolderManager.processTicketUpdates();
                if (this.removed) {
                    return;
                }
                for (i = 0; i < maxLoadsThisTick; ++i) {
                    long queuedLoadChunk = chunks.getLong(i);
                    int queuedChunkX = CoordinateUtils.getChunkX(queuedLoadChunk);
                    int queuedChunkZ = CoordinateUtils.getChunkZ(queuedLoadChunk);
                    this.world.chunkTaskScheduler.scheduleChunkLoad(queuedChunkX, queuedChunkZ, ChunkStatus.EMPTY, false, PrioritisedExecutor.Priority.NORMAL, null);
                    if (!this.removed) continue;
                    return;
                }
            }
            while (!this.generatingQueue.isEmpty() && (pending = this.world.chunkSource.getChunkAtIfLoadedMainThreadNoCache(pendingChunkX = CoordinateUtils.getChunkX(pendingGenChunk = this.generatingQueue.firstLong()), pendingChunkZ = CoordinateUtils.getChunkZ(pendingGenChunk))) != null) {
                this.generatingQueue.dequeueLong();
                byte prev4 = this.chunkTicketStage.put(pendingGenChunk, (byte)4);
                if (prev4 != 3) {
                    throw new IllegalStateException("Previous state should be 3, not " + prev4);
                }
                if (this.wantChunkSent(pendingChunkX, pendingChunkZ)) {
                    this.sendQueue.enqueue(pendingGenChunk);
                }
                if (!this.wantChunkTicked(pendingChunkX, pendingChunkZ)) continue;
                this.tickingQueue.enqueue(pendingGenChunk);
            }
            long maxGens = Math.max(0L, Math.min(10000L, Math.min((long)this.genQueue.size(), this.getMaxChunkGenerates())));
            int maxGensThisTick = (int)this.chunkGenerateTicketLimiter.takeAllocation(time, genRate, maxGens);
            int ratedGensThisTick = 0;
            while (!this.genQueue.isEmpty()) {
                int chunkZ;
                long chunkKey = this.genQueue.firstLong();
                int chunkX = CoordinateUtils.getChunkX(chunkKey);
                ChunkAccess chunk3 = this.world.chunkSource.getChunkAtImmediately(chunkX, chunkZ = CoordinateUtils.getChunkZ(chunkKey));
                if (chunk3.getStatus() != ChunkStatus.FULL) {
                    if (ratedGensThisTick + 1 > maxGensThisTick) break;
                    ++ratedGensThisTick;
                }
                this.genQueue.dequeueLong();
                prev = this.chunkTicketStage.put(chunkKey, (byte)3);
                if (prev != 2) {
                    throw new IllegalStateException("Previous state should be 2, not " + prev);
                }
                this.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(chunkKey, REGION_PLAYER_TICKET, GENERATED_TICKET_LEVEL, this.idBoxed, REGION_PLAYER_TICKET, LOADED_TICKET_LEVEL, this.idBoxed));
                this.generatingQueue.enqueue(chunkKey);
            }
            block5: while (!this.tickingQueue.isEmpty()) {
                long pendingTicking = this.tickingQueue.firstLong();
                int pendingChunkX3 = CoordinateUtils.getChunkX(pendingTicking);
                int pendingChunkZ3 = CoordinateUtils.getChunkZ(pendingTicking);
                int tickingReq = 2;
                for (int dz = -2; dz <= 2; ++dz) {
                    for (int dx = -2; dx <= 2; ++dx) {
                        long neighbour;
                        byte stage;
                        if ((dx | dz) != 0 && (stage = this.chunkTicketStage.get(neighbour = CoordinateUtils.getChunkKey(dx + pendingChunkX3, dz + pendingChunkZ3))) != 4 && stage != 5) break block5;
                    }
                }
                this.tickingQueue.dequeueLong();
                this.pushDelayedTicketOp(ChunkHolderManager.TicketOperation.addAndRemove(pendingTicking, REGION_PLAYER_TICKET, 31, this.idBoxed, REGION_PLAYER_TICKET, GENERATED_TICKET_LEVEL, this.idBoxed));
                prev = this.chunkTicketStage.put(pendingTicking, (byte)5);
                if (prev == 4) continue;
                throw new IllegalStateException("Previous state should be 4, not " + prev);
            }
            long maxSends = Math.max(0L, Math.min(10000L, Integer.MAX_VALUE));
            int maxSendsThisTick = Math.min((int)this.chunkSendLimiter.takeAllocation(time, sendRate, maxSends), this.sendQueue.size());
            for (int i = 0; i < maxSendsThisTick && (chunk = this.world.chunkSource.getChunkAtIfLoadedMainThreadNoCache(pendingSendX = CoordinateUtils.getChunkX(pendingSend = this.sendQueue.firstLong()), pendingSendZ = CoordinateUtils.getChunkZ(pendingSend))).areNeighboursLoaded(1) && TickThread.isTickThreadFor(this.world, pendingSendX, pendingSendZ); ++i) {
                if (!chunk.isPostProcessingDone) {
                    chunk.postProcessGeneration();
                    if (this.removed || this.sendQueue.isEmpty() || this.sendQueue.firstLong() != pendingSend) {
                        return;
                    }
                }
                this.sendQueue.dequeueLong();
                this.sendChunk(pendingSendX, pendingSendZ);
                if (!this.removed) continue;
                return;
            }
            this.flushDelayedTicketOps();
        }

        void add() {
            TickThread.ensureTickThread(this.player, "Cannot add player asynchronously");
            if (this.removed) {
                throw new IllegalStateException("Adding removed player chunk loader");
            }
            ViewDistances playerDistances = this.player.getViewDistances();
            ViewDistances worldDistances = this.world.getViewDistances();
            int chunkX = this.player.chunkPosition().x;
            int chunkZ = this.player.chunkPosition().z;
            int tickViewDistance = PlayerChunkLoaderData.getTickDistance(playerDistances.tickViewDistance, worldDistances.tickViewDistance);
            int loadViewDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, playerDistances.loadViewDistance, worldDistances.loadViewDistance);
            int clientViewDistance = PlayerChunkLoaderData.getClientViewDistance(this.player);
            int sendViewDistance = PlayerChunkLoaderData.getSendViewDistance(loadViewDistance, clientViewDistance, playerDistances.sendViewDistance, worldDistances.sendViewDistance);
            this.player.connection.send(this.updateClientChunkRadius(sendViewDistance));
            this.player.connection.send(this.updateClientSimulationDistance(tickViewDistance));
            this.broadcastMap.add(chunkX, chunkZ, sendViewDistance + 1);
            this.loadTicketCleanup.add(chunkX, chunkZ, loadViewDistance + 1);
            this.tickMap.add(chunkX, chunkZ, tickViewDistance);
            this.player.connection.send(this.updateClientChunkCenter(chunkX, chunkZ));
            this.update();
        }

        private boolean isLoadedChunkGeneratable(int chunkX, int chunkZ) {
            return this.isLoadedChunkGeneratable(this.world.chunkSource.getChunkAtImmediately(chunkX, chunkZ));
        }

        private boolean isLoadedChunkGeneratable(ChunkAccess chunkAccess) {
            BelowZeroRetrogen belowZeroRetrogen;
            return chunkAccess != null && (chunkAccess.getStatus() == ChunkStatus.FULL || (belowZeroRetrogen = chunkAccess.getBelowZeroRetrogen()) != null && belowZeroRetrogen.targetStatus().isOrAfter(ChunkStatus.SPAWN));
        }

        void update() {
            long[] toIterate;
            TickThread.ensureTickThread(this.player, "Cannot update player asynchronously");
            if (this.removed) {
                throw new IllegalStateException("Updating removed player chunk loader");
            }
            ViewDistances playerDistances = this.player.getViewDistances();
            ViewDistances worldDistances = this.world.getViewDistances();
            int tickViewDistance = PlayerChunkLoaderData.getTickDistance(playerDistances.tickViewDistance, worldDistances.tickViewDistance);
            int loadViewDistance = PlayerChunkLoaderData.getLoadViewDistance(tickViewDistance, playerDistances.loadViewDistance, worldDistances.loadViewDistance);
            int clientViewDistance = PlayerChunkLoaderData.getClientViewDistance(this.player);
            int sendViewDistance = PlayerChunkLoaderData.getSendViewDistance(loadViewDistance, clientViewDistance, playerDistances.sendViewDistance, worldDistances.sendViewDistance);
            ChunkPos playerPos = this.player.chunkPosition();
            boolean canGenerateChunks = this.canPlayerGenerateChunks();
            int currentChunkX = playerPos.x;
            int currentChunkZ = playerPos.z;
            int prevChunkX = this.lastChunkX;
            int prevChunkZ = this.lastChunkZ;
            if (sendViewDistance == this.lastSendDistance && loadViewDistance == this.lastLoadDistance && tickViewDistance == this.lastTickDistance && prevChunkX == currentChunkX && prevChunkZ == currentChunkZ && this.canGenerateChunks == canGenerateChunks) {
                return;
            }
            this.broadcastMap.update(currentChunkX, currentChunkZ, sendViewDistance + 1);
            this.loadTicketCleanup.update(currentChunkX, currentChunkZ, loadViewDistance + 1);
            this.tickMap.update(currentChunkX, currentChunkZ, tickViewDistance);
            if (sendViewDistance > loadViewDistance || tickViewDistance > loadViewDistance) {
                throw new IllegalStateException();
            }
            if (this.lastSentChunkRadius != sendViewDistance) {
                this.player.connection.send(this.updateClientChunkRadius(sendViewDistance));
            }
            if (this.lastSentSimulationDistance != tickViewDistance) {
                this.player.connection.send(this.updateClientSimulationDistance(tickViewDistance));
            }
            this.sendQueue.clear();
            this.tickingQueue.clear();
            this.generatingQueue.clear();
            this.genQueue.clear();
            this.loadingQueue.clear();
            this.loadQueue.clear();
            this.lastChunkX = currentChunkX;
            this.lastChunkZ = currentChunkZ;
            this.lastSendDistance = sendViewDistance;
            this.lastLoadDistance = loadViewDistance;
            this.lastTickDistance = tickViewDistance;
            this.canGenerateChunks = canGenerateChunks;
            block8: for (long deltaChunk : toIterate = SEARCH_RADIUS_ITERATION_LIST[loadViewDistance + 1]) {
                boolean sentChunk;
                int dx = CoordinateUtils.getChunkX(deltaChunk);
                int dz = CoordinateUtils.getChunkZ(deltaChunk);
                int chunkX = dx + currentChunkX;
                int chunkZ = dz + currentChunkZ;
                long chunk = CoordinateUtils.getChunkKey(chunkX, chunkZ);
                int squareDistance = Math.max(Math.abs(dx), Math.abs(dz));
                int manhattanDistance = Math.abs(dx) + Math.abs(dz);
                boolean sendChunk = squareDistance <= sendViewDistance + 1 && PlayerChunkLoaderData.wantChunkLoaded(currentChunkX, currentChunkZ, chunkX, chunkZ, sendViewDistance);
                boolean bl = sentChunk = sendChunk ? this.sentChunks.contains(chunk) : this.sentChunks.remove(chunk);
                if (!sendChunk && sentChunk) {
                    this.sendUnloadChunkRaw(chunkX, chunkZ);
                }
                byte stage = this.chunkTicketStage.get(chunk);
                switch (stage) {
                    case 0: {
                        this.loadQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 1: {
                        this.loadingQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 2: {
                        if (!canGenerateChunks && !this.isLoadedChunkGeneratable(chunkX, chunkZ)) continue block8;
                        this.genQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 3: {
                        this.generatingQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 4: {
                        if (sendChunk && !sentChunk) {
                            this.sendQueue.enqueue(chunk);
                        }
                        if (squareDistance > tickViewDistance) continue block8;
                        this.tickingQueue.enqueue(chunk);
                        continue block8;
                    }
                    case 5: {
                        if (!sendChunk || sentChunk) continue block8;
                        this.sendQueue.enqueue(chunk);
                        continue block8;
                    }
                    default: {
                        throw new IllegalStateException("Unknown stage: " + stage);
                    }
                }
            }
            if (this.lastSentChunkCenterX != currentChunkX || this.lastSentChunkCenterZ != currentChunkZ) {
                this.player.connection.send(this.updateClientChunkCenter(currentChunkX, currentChunkZ));
            }
            this.flushDelayedTicketOps();
        }

        void remove() {
            TickThread.ensureTickThread(this.player, "Cannot add player asynchronously");
            if (this.removed) {
                throw new IllegalStateException("Removing removed player chunk loader");
            }
            this.removed = true;
            this.broadcastMap.remove();
            this.loadTicketCleanup.remove();
            this.tickMap.remove();
            this.sendQueue.clear();
            this.tickingQueue.clear();
            this.generatingQueue.clear();
            this.genQueue.clear();
            this.loadingQueue.clear();
            this.loadQueue.clear();
            this.flushDelayedTicketOps();
        }

        public LongOpenHashSet getSentChunksRaw() {
            return this.sentChunks;
        }
    }

    public record ViewDistances(int tickViewDistance, int loadViewDistance, int sendViewDistance) {
        public ViewDistances setTickViewDistance(int distance) {
            return new ViewDistances(distance, this.loadViewDistance, this.sendViewDistance);
        }

        public ViewDistances setLoadViewDistance(int distance) {
            return new ViewDistances(this.tickViewDistance, distance, this.sendViewDistance);
        }

        public ViewDistances setSendViewDistance(int distance) {
            return new ViewDistances(this.tickViewDistance, this.loadViewDistance, distance);
        }
    }

    private static final class BasicFIFOLQueue {
        private final long[] values;
        private int head;
        private int tail;

        public BasicFIFOLQueue(int cap) {
            if (cap <= 1) {
                throw new IllegalArgumentException();
            }
            this.values = new long[cap];
        }

        public boolean isEmpty() {
            return this.head == this.tail;
        }

        public long removeFirst() {
            long ret = this.values[this.head];
            if (this.head == this.tail) {
                throw new IllegalStateException();
            }
            ++this.head;
            if (this.head == this.values.length) {
                this.head = 0;
            }
            return ret;
        }

        public void addLast(long value) {
            this.values[this.tail++] = value;
            if (this.tail == this.head) {
                throw new IllegalStateException();
            }
            if (this.tail == this.values.length) {
                this.tail = 0;
            }
        }
    }

    static final class CountedSRSWLinkedQueue<E> {
        private final SRSWLinkedQueue<E> queue = new SRSWLinkedQueue();
        private volatile long countAdded;
        private volatile long countRemoved;
        private static final VarHandle COUNT_ADDED_HANDLE = ConcurrentUtil.getVarHandle(CountedSRSWLinkedQueue.class, "countAdded", Long.TYPE);
        private static final VarHandle COUNT_REMOVED_HANDLE = ConcurrentUtil.getVarHandle(CountedSRSWLinkedQueue.class, "countRemoved", Long.TYPE);

        CountedSRSWLinkedQueue() {
        }

        private long getCountAddedPlain() {
            return COUNT_ADDED_HANDLE.get(this);
        }

        private long getCountAddedAcquire() {
            return COUNT_ADDED_HANDLE.getAcquire(this);
        }

        private void setCountAddedRelease(long to) {
            COUNT_ADDED_HANDLE.setRelease(this, to);
        }

        private long getCountRemovedPlain() {
            return COUNT_REMOVED_HANDLE.get(this);
        }

        private long getCountRemovedAcquire() {
            return COUNT_REMOVED_HANDLE.getAcquire(this);
        }

        private void setCountRemovedRelease(long to) {
            COUNT_REMOVED_HANDLE.setRelease(this, to);
        }

        public void add(E element) {
            this.setCountAddedRelease(this.getCountAddedPlain() + 1L);
            this.queue.addLast(element);
        }

        public E poll() {
            E ret = this.queue.poll();
            if (ret != null) {
                this.setCountRemovedRelease(this.getCountRemovedPlain() + 1L);
            }
            return ret;
        }

        public long size() {
            long removed = this.getCountRemovedAcquire();
            long added = this.getCountAddedAcquire();
            return added - removed;
        }
    }

    private static final class AllocatingRateLimiter {
        private static final long MAX_GRANULARITY = TimeUnit.SECONDS.toNanos(1L);
        private double allocation;
        private long lastAllocationUpdate;
        private double takeCarry;
        private long lastTakeUpdate;

        private AllocatingRateLimiter() {
        }

        public void tickAllocation(long time, double rate, double maxAllocation) {
            long diff = Math.min(MAX_GRANULARITY, time - this.lastAllocationUpdate);
            this.lastAllocationUpdate = time;
            this.allocation = Math.min(maxAllocation - this.takeCarry, this.allocation + rate * ((double)diff * 1.0E-9));
        }

        public long takeAllocation(long time, double rate, long maxTake) {
            if (maxTake < 1L) {
                return 0L;
            }
            double ret = this.takeCarry;
            long diff = Math.min(MAX_GRANULARITY, time - this.lastTakeUpdate);
            this.lastTakeUpdate = time;
            double take = Math.min(Math.min((double)maxTake - this.takeCarry, this.allocation), rate * ((double)diff * 1.0E-9));
            this.allocation -= take;
            long retInteger = (long)Math.floor(ret += take);
            this.takeCarry = ret - (double)retInteger;
            return retInteger;
        }
    }
}

