/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.io;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.concurrentutil.executor.Cancellable;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedQueueExecutorThread;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedThreadedTaskQueue;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.TickThread;
import it.unimi.dsi.fastutil.HashCommon;
import java.io.IOException;
import java.lang.invoke.VarHandle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import org.leavesmc.leaves.region.AbstractRegionFile;
import org.slf4j.Logger;

public final class RegionFileIOThread
extends PrioritisedQueueExecutorThread {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    protected static final RegionFileType[] CACHED_REGIONFILE_TYPES = RegionFileType.values();
    private static final Object INIT_LOCK = new Object();
    static RegionFileIOThread[] threads;

    private ChunkDataController getControllerFor(ServerLevel world, RegionFileType type) {
        return switch (type.ordinal()) {
            case 0 -> world.chunkDataControllerNew;
            case 1 -> world.poiDataControllerNew;
            case 2 -> world.entityDataControllerNew;
            default -> throw new IllegalStateException("Unknown controller type " + String.valueOf((Object)type));
        };
    }

    static RegionFileIOThread selectThread(ServerLevel world, int chunkX, int chunkZ, RegionFileType type) {
        if (threads == null) {
            throw new IllegalStateException("Threads not initialised");
        }
        int regionX = chunkX >> 5;
        int regionZ = chunkZ >> 5;
        int typeOffset = type.ordinal();
        return threads[(System.identityHashCode(world) + regionX + regionZ + typeOffset) % threads.length];
    }

    public static void close(boolean wait) {
        int len = threads.length;
        for (int i = 0; i < len; ++i) {
            threads[i].close(false, true);
        }
        if (wait) {
            RegionFileIOThread.flush();
        }
    }

    public static long[] getExecutedTasks() {
        long[] ret = new long[threads.length];
        int len = threads.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = threads[i].getTotalTasksExecuted();
        }
        return ret;
    }

    public static long[] getTasksScheduled() {
        long[] ret = new long[threads.length];
        int len = threads.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = threads[i].getTotalTasksScheduled();
        }
        return ret;
    }

    public static void flush() {
        int len = threads.length;
        for (int i = 0; i < len; ++i) {
            threads[i].waitUntilAllExecuted();
        }
    }

    public static void partialFlush(int totalTasksRemaining) {
        long failures = 1L;
        while (true) {
            long[] executed = RegionFileIOThread.getExecutedTasks();
            long[] scheduled = RegionFileIOThread.getTasksScheduled();
            long sum = 0L;
            for (int i = 0; i < executed.length; ++i) {
                sum += scheduled[i] - executed[i];
            }
            if (sum <= (long)totalTasksRemaining) break;
            failures = ConcurrentUtil.linearLongBackoff(failures, 250000L, 5000000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(int threads) {
        Object object = INIT_LOCK;
        synchronized (object) {
            if (RegionFileIOThread.threads != null) {
                throw new IllegalStateException("Already initialised threads");
            }
            RegionFileIOThread.threads = new RegionFileIOThread[threads];
            for (int i = 0; i < threads; ++i) {
                RegionFileIOThread.threads[i] = new RegionFileIOThread(i);
                RegionFileIOThread.threads[i].start();
            }
        }
    }

    private RegionFileIOThread(int threadNumber) {
        super(new PrioritisedThreadedTaskQueue(), 1000000L);
        this.setName("RegionFile I/O Thread #" + threadNumber);
        this.setPriority(3);
        this.setUncaughtExceptionHandler((thread, thr) -> LOGGER.error("Uncaught exception thrown from I/O thread, report this! Thread: " + thread.getName(), thr));
    }

    public static boolean isRegionFileThread() {
        return Thread.currentThread() instanceof RegionFileIOThread;
    }

    public static PrioritisedExecutor.Priority getIOBlockingPriorityForCurrentThread() {
        if (TickThread.isTickThread()) {
            return PrioritisedExecutor.Priority.BLOCKING;
        }
        return PrioritisedExecutor.Priority.HIGHEST;
    }

    public static CompoundTag getPendingWrite(ServerLevel world, int chunkX, int chunkZ, RegionFileType type) {
        RegionFileIOThread thread = RegionFileIOThread.selectThread(world, chunkX, chunkZ, type);
        return thread.getPendingWriteInternal(world, chunkX, chunkZ, type);
    }

    CompoundTag getPendingWriteInternal(ServerLevel world, int chunkX, int chunkZ, RegionFileType type) {
        ChunkDataController taskController = this.getControllerFor(world, type);
        ChunkDataTask task = taskController.tasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (task == null) {
            return null;
        }
        CompoundTag ret = task.inProgressWrite;
        return ret == ChunkDataTask.NOTHING_TO_WRITE ? null : ret;
    }

    public static PrioritisedExecutor.Priority getPriority(ServerLevel world, int chunkX, int chunkZ, RegionFileType type) {
        RegionFileIOThread thread = RegionFileIOThread.selectThread(world, chunkX, chunkZ, type);
        return thread.getPriorityInternal(world, chunkX, chunkZ, type);
    }

    PrioritisedExecutor.Priority getPriorityInternal(ServerLevel world, int chunkX, int chunkZ, RegionFileType type) {
        ChunkDataController taskController = this.getControllerFor(world, type);
        ChunkDataTask task = taskController.tasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (task == null) {
            return PrioritisedExecutor.Priority.COMPLETING;
        }
        return task.prioritisedTask.getPriority();
    }

    public static void setPriority(ServerLevel world, int chunkX, int chunkZ, PrioritisedExecutor.Priority priority) {
        for (RegionFileType type : CACHED_REGIONFILE_TYPES) {
            RegionFileIOThread.setPriority(world, chunkX, chunkZ, type, priority);
        }
    }

    public static void setPriority(ServerLevel world, int chunkX, int chunkZ, RegionFileType type, PrioritisedExecutor.Priority priority) {
        RegionFileIOThread thread = RegionFileIOThread.selectThread(world, chunkX, chunkZ, type);
        thread.setPriorityInternal(world, chunkX, chunkZ, type, priority);
    }

    void setPriorityInternal(ServerLevel world, int chunkX, int chunkZ, RegionFileType type, PrioritisedExecutor.Priority priority) {
        ChunkDataController taskController = this.getControllerFor(world, type);
        ChunkDataTask task = taskController.tasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (task != null) {
            task.prioritisedTask.setPriority(priority);
        }
    }

    public static void raisePriority(ServerLevel world, int chunkX, int chunkZ, PrioritisedExecutor.Priority priority) {
        for (RegionFileType type : CACHED_REGIONFILE_TYPES) {
            RegionFileIOThread.raisePriority(world, chunkX, chunkZ, type, priority);
        }
    }

    public static void raisePriority(ServerLevel world, int chunkX, int chunkZ, RegionFileType type, PrioritisedExecutor.Priority priority) {
        RegionFileIOThread thread = RegionFileIOThread.selectThread(world, chunkX, chunkZ, type);
        thread.raisePriorityInternal(world, chunkX, chunkZ, type, priority);
    }

    void raisePriorityInternal(ServerLevel world, int chunkX, int chunkZ, RegionFileType type, PrioritisedExecutor.Priority priority) {
        ChunkDataController taskController = this.getControllerFor(world, type);
        ChunkDataTask task = taskController.tasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (task != null) {
            task.prioritisedTask.raisePriority(priority);
        }
    }

    public static void lowerPriority(ServerLevel world, int chunkX, int chunkZ, PrioritisedExecutor.Priority priority) {
        for (RegionFileType type : CACHED_REGIONFILE_TYPES) {
            RegionFileIOThread.lowerPriority(world, chunkX, chunkZ, type, priority);
        }
    }

    public static void lowerPriority(ServerLevel world, int chunkX, int chunkZ, RegionFileType type, PrioritisedExecutor.Priority priority) {
        RegionFileIOThread thread = RegionFileIOThread.selectThread(world, chunkX, chunkZ, type);
        thread.lowerPriorityInternal(world, chunkX, chunkZ, type, priority);
    }

    void lowerPriorityInternal(ServerLevel world, int chunkX, int chunkZ, RegionFileType type, PrioritisedExecutor.Priority priority) {
        ChunkDataController taskController = this.getControllerFor(world, type);
        ChunkDataTask task = taskController.tasks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (task != null) {
            task.prioritisedTask.lowerPriority(priority);
        }
    }

    public static void scheduleSave(ServerLevel world, int chunkX, int chunkZ, CompoundTag data, RegionFileType type) {
        RegionFileIOThread.scheduleSave(world, chunkX, chunkZ, data, type, PrioritisedExecutor.Priority.NORMAL);
    }

    public static void scheduleSave(ServerLevel world, int chunkX, int chunkZ, CompoundTag data, RegionFileType type, PrioritisedExecutor.Priority priority) {
        RegionFileIOThread thread = RegionFileIOThread.selectThread(world, chunkX, chunkZ, type);
        thread.scheduleSaveInternal(world, chunkX, chunkZ, data, type, priority);
    }

    void scheduleSaveInternal(ServerLevel world, int chunkX, int chunkZ, CompoundTag data, RegionFileType type, PrioritisedExecutor.Priority priority) {
        ChunkDataController taskController = this.getControllerFor(world, type);
        boolean[] created = new boolean[1];
        ChunkCoordinate key = new ChunkCoordinate(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        ChunkDataTask task = taskController.tasks.compute(key, (keyInMap, taskRunning) -> {
            if (taskRunning == null || taskRunning.failedWrite) {
                ChunkDataTask newTask = new ChunkDataTask(world, chunkX, chunkZ, taskController, this, priority);
                newTask.inProgressWrite = data;
                created[0] = true;
                return newTask;
            }
            taskRunning.inProgressWrite = data;
            return taskRunning;
        });
        if (created[0]) {
            task.prioritisedTask.queue();
        } else {
            task.prioritisedTask.raisePriority(priority);
        }
    }

    public static Cancellable loadAllChunkData(ServerLevel world, int chunkX, int chunkZ, Consumer<RegionFileData> onComplete, boolean intendingToBlock) {
        return RegionFileIOThread.loadAllChunkData(world, chunkX, chunkZ, onComplete, intendingToBlock, PrioritisedExecutor.Priority.NORMAL);
    }

    public static Cancellable loadAllChunkData(ServerLevel world, int chunkX, int chunkZ, Consumer<RegionFileData> onComplete, boolean intendingToBlock, PrioritisedExecutor.Priority priority) {
        return RegionFileIOThread.loadChunkData(world, chunkX, chunkZ, onComplete, intendingToBlock, priority, CACHED_REGIONFILE_TYPES);
    }

    public static Cancellable loadChunkData(ServerLevel world, int chunkX, int chunkZ, Consumer<RegionFileData> onComplete, boolean intendingToBlock, RegionFileType ... types) {
        return RegionFileIOThread.loadChunkData(world, chunkX, chunkZ, onComplete, intendingToBlock, PrioritisedExecutor.Priority.NORMAL, types);
    }

    public static Cancellable loadChunkData(ServerLevel world, int chunkX, int chunkZ, Consumer<RegionFileData> onComplete, boolean intendingToBlock, PrioritisedExecutor.Priority priority, RegionFileType ... types) {
        if (types == null) {
            throw new NullPointerException("Types cannot be null");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("Types cannot be empty");
        }
        RegionFileData ret = new RegionFileData();
        Cancellable[] reads = new CancellableRead[types.length];
        AtomicInteger completions = new AtomicInteger();
        int expectedCompletions = types.length;
        for (int i = 0; i < expectedCompletions; ++i) {
            RegionFileType type = types[i];
            reads[i] = RegionFileIOThread.loadDataAsync(world, chunkX, chunkZ, type, (data, throwable) -> {
                if (throwable != null) {
                    ret.setThrowable(type, (Throwable)throwable);
                } else {
                    ret.setData(type, (CompoundTag)data);
                }
                if (completions.incrementAndGet() == expectedCompletions) {
                    onComplete.accept(ret);
                }
            }, intendingToBlock, priority);
        }
        return new CancellableReads(reads);
    }

    public static Cancellable loadDataAsync(ServerLevel world, int chunkX, int chunkZ, RegionFileType type, BiConsumer<CompoundTag, Throwable> onComplete, boolean intendingToBlock) {
        return RegionFileIOThread.loadDataAsync(world, chunkX, chunkZ, type, onComplete, intendingToBlock, PrioritisedExecutor.Priority.NORMAL);
    }

    public static Cancellable loadDataAsync(ServerLevel world, int chunkX, int chunkZ, RegionFileType type, BiConsumer<CompoundTag, Throwable> onComplete, boolean intendingToBlock, PrioritisedExecutor.Priority priority) {
        RegionFileIOThread thread = RegionFileIOThread.selectThread(world, chunkX, chunkZ, type);
        return thread.loadDataAsyncInternal(world, chunkX, chunkZ, type, onComplete, intendingToBlock, priority);
    }

    Cancellable loadDataAsyncInternal(ServerLevel world, int chunkX, int chunkZ, RegionFileType type, BiConsumer<CompoundTag, Throwable> onComplete, boolean intendingToBlock, PrioritisedExecutor.Priority priority) {
        ChunkDataController taskController = this.getControllerFor(world, type);
        ImmediateCallbackCompletion callbackInfo = new ImmediateCallbackCompletion();
        ChunkCoordinate key = new ChunkCoordinate(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        BiFunction<ChunkCoordinate, ChunkDataTask, ChunkDataTask> compute = (keyInMap, running) -> {
            if (running == null) {
                ChunkDataTask newTask = new ChunkDataTask(world, chunkX, chunkZ, taskController, this, priority);
                newTask.inProgressRead = new InProgressRead();
                newTask.inProgressRead.waiters.add(onComplete);
                callbackInfo.tasksNeedsScheduling = true;
                return newTask;
            }
            CompoundTag pendingWrite = running.inProgressWrite;
            if (pendingWrite == ChunkDataTask.NOTHING_TO_WRITE) {
                if (!running.inProgressRead.addToWaiters(onComplete)) {
                    callbackInfo.data = running.inProgressRead.value;
                    callbackInfo.throwable = running.inProgressRead.throwable;
                    callbackInfo.completeNow = true;
                }
                return running;
            }
            callbackInfo.data = pendingWrite;
            callbackInfo.throwable = null;
            callbackInfo.completeNow = true;
            return running;
        };
        ChunkDataTask ret = taskController.tasks.compute(key, compute);
        if (callbackInfo.tasksNeedsScheduling) {
            ret.prioritisedTask.queue();
        } else if (callbackInfo.completeNow) {
            try {
                onComplete.accept(callbackInfo.data, callbackInfo.throwable);
            }
            catch (ThreadDeath thr) {
                throw thr;
            }
            catch (Throwable thr) {
                LOGGER.error("Callback " + ConcurrentUtil.genericToString(onComplete) + " synchronously failed to handle chunk data for task " + ret.toString(), thr);
            }
        } else {
            ret.prioritisedTask.raisePriority(priority);
        }
        return new CancellableRead(onComplete, ret);
    }

    public static CompoundTag loadData(ServerLevel world, int chunkX, int chunkZ, RegionFileType type, PrioritisedExecutor.Priority priority) throws IOException {
        CompletableFuture ret = new CompletableFuture();
        RegionFileIOThread.loadDataAsync(world, chunkX, chunkZ, type, (compound, thr) -> {
            if (thr != null) {
                ret.completeExceptionally((Throwable)thr);
            } else {
                ret.complete(compound);
            }
        }, true, priority);
        try {
            return (CompoundTag)ret.join();
        }
        catch (CompletionException ex) {
            throw new IOException(ex);
        }
    }

    public static enum RegionFileType {
        CHUNK_DATA,
        POI_DATA,
        ENTITY_DATA;

    }

    public static abstract class ChunkDataController {
        protected final ConcurrentHashMap<ChunkCoordinate, ChunkDataTask> tasks = new ConcurrentHashMap(8192, 0.1f);
        public final RegionFileType type;

        public ChunkDataController(RegionFileType type) {
            this.type = type;
        }

        public abstract RegionFileStorage getCache();

        public abstract void writeData(int var1, int var2, CompoundTag var3) throws IOException;

        public abstract CompoundTag readData(int var1, int var2) throws IOException;

        public boolean hasTasks() {
            return !this.tasks.isEmpty();
        }

        public boolean doesRegionFileNotExist(int chunkX, int chunkZ) {
            return this.getCache().doesRegionFileNotExistNoIO(new ChunkPos(chunkX, chunkZ));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T computeForRegionFile(int chunkX, int chunkZ, boolean existingOnly, Function<AbstractRegionFile, T> function) {
            AbstractRegionFile regionFile;
            RegionFileStorage cache;
            RegionFileStorage regionFileStorage = cache = this.getCache();
            synchronized (regionFileStorage) {
                try {
                    regionFile = cache.getRegionFile(new ChunkPos(chunkX, chunkZ), existingOnly, true);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                regionFileStorage = function.apply(regionFile);
                return (T)regionFileStorage;
            }
            finally {
                if (regionFile != null) {
                    regionFile.getFileLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T computeForRegionFileIfLoaded(int chunkX, int chunkZ, Function<AbstractRegionFile, T> function) {
            AbstractRegionFile regionFile;
            RegionFileStorage cache;
            RegionFileStorage regionFileStorage = cache = this.getCache();
            synchronized (regionFileStorage) {
                regionFile = cache.getRegionFileIfLoaded(new ChunkPos(chunkX, chunkZ));
                if (regionFile != null) {
                    regionFile.getFileLock().lock();
                }
            }
            try {
                regionFileStorage = function.apply(regionFile);
                return (T)regionFileStorage;
            }
            finally {
                if (regionFile != null) {
                    regionFile.getFileLock().unlock();
                }
            }
        }
    }

    static final class ChunkDataTask
    implements Runnable {
        protected static final CompoundTag NOTHING_TO_WRITE = new CompoundTag();
        private static final Logger LOGGER = LogUtils.getClassLogger();
        InProgressRead inProgressRead;
        volatile CompoundTag inProgressWrite = NOTHING_TO_WRITE;
        boolean failedWrite;
        final ServerLevel world;
        final int chunkX;
        final int chunkZ;
        final ChunkDataController taskController;
        final PrioritisedExecutor.PrioritisedTask prioritisedTask;

        public ChunkDataTask(ServerLevel world, int chunkX, int chunkZ, ChunkDataController taskController, PrioritisedExecutor executor, PrioritisedExecutor.Priority priority) {
            this.world = world;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.taskController = taskController;
            this.prioritisedTask = executor.createTask(this, priority);
        }

        public String toString() {
            return "Task for world: '" + this.world.getWorld().getName() + "' at (" + this.chunkX + "," + this.chunkZ + ") type: " + this.taskController.type.name() + ", hash: " + this.hashCode();
        }

        @Override
        public void run() {
            boolean[] done;
            CompoundTag write;
            ChunkDataTask inMap;
            InProgressRead read = this.inProgressRead;
            ChunkCoordinate chunkKey = new ChunkCoordinate(CoordinateUtils.getChunkKey(this.chunkX, this.chunkZ));
            if (read != null) {
                boolean[] canRead = new boolean[]{true};
                if (read.waiters.isEmpty() && (inMap = this.taskController.tasks.compute(chunkKey, (keyInMap, valueInMap) -> {
                    if (valueInMap == null) {
                        throw new IllegalStateException("Write completed concurrently, expected this task: " + this.toString() + ", report this!");
                    }
                    if (valueInMap != this) {
                        throw new IllegalStateException("Chunk task mismatch, expected this task: " + this.toString() + ", got: " + valueInMap.toString() + ", report this!");
                    }
                    if (!read.waiters.isEmpty()) {
                        return valueInMap;
                    }
                    canRead[0] = false;
                    return valueInMap.inProgressWrite == NOTHING_TO_WRITE ? null : valueInMap;
                })) == null) {
                    return;
                }
                if (canRead[0]) {
                    CompoundTag compound = null;
                    Throwable throwable = null;
                    try {
                        compound = this.taskController.readData(this.chunkX, this.chunkZ);
                    }
                    catch (ThreadDeath thr) {
                        throw thr;
                    }
                    catch (Throwable thr) {
                        throwable = thr;
                        LOGGER.error("Failed to read chunk data for task: " + this.toString(), thr);
                    }
                    read.complete(this, compound, throwable);
                }
            }
            if ((write = this.inProgressWrite) == NOTHING_TO_WRITE && (inMap = this.taskController.tasks.compute(chunkKey, (keyInMap, valueInMap) -> {
                if (valueInMap == null) {
                    throw new IllegalStateException("Write completed concurrently, expected this task: " + this.toString() + ", report this!");
                }
                if (valueInMap != this) {
                    throw new IllegalStateException("Chunk task mismatch, expected this task: " + this.toString() + ", got: " + valueInMap.toString() + ", report this!");
                }
                return valueInMap.inProgressWrite == NOTHING_TO_WRITE ? null : valueInMap;
            })) == null) {
                return;
            }
            do {
                CompoundTag dataWritten = write = this.inProgressWrite;
                boolean failedWrite = false;
                try {
                    this.taskController.writeData(this.chunkX, this.chunkZ, write);
                }
                catch (ThreadDeath thr) {
                    throw thr;
                }
                catch (Throwable thr) {
                    if (thr instanceof RegionFileStorage.RegionFileSizeException) {
                        int maxSize = 500;
                        LOGGER.error("Chunk at (" + this.chunkX + "," + this.chunkZ + ") in '" + this.world.getWorld().getName() + "' exceeds max size of 500MiB, it has been deleted from disk.");
                    }
                    failedWrite = thr instanceof IOException;
                    LOGGER.error("Failed to write chunk data for task: " + this.toString(), thr);
                }
                boolean finalFailWrite = failedWrite;
                done = new boolean[]{false};
                this.taskController.tasks.compute(chunkKey, (keyInMap, valueInMap) -> {
                    if (valueInMap == null) {
                        throw new IllegalStateException("Write completed concurrently, expected this task: " + this.toString() + ", report this!");
                    }
                    if (valueInMap != this) {
                        throw new IllegalStateException("Chunk task mismatch, expected this task: " + this.toString() + ", got: " + valueInMap.toString() + ", report this!");
                    }
                    if (valueInMap.inProgressWrite == dataWritten) {
                        valueInMap.failedWrite = finalFailWrite;
                        done[0] = true;
                        return finalFailWrite ? valueInMap : null;
                    }
                    return valueInMap;
                });
            } while (!done[0]);
        }
    }

    public static final class ChunkCoordinate
    implements Comparable<ChunkCoordinate> {
        public final long key;

        public ChunkCoordinate(long key) {
            this.key = key;
        }

        public int hashCode() {
            return (int)HashCommon.mix((long)this.key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ChunkCoordinate)) {
                return false;
            }
            ChunkCoordinate other = (ChunkCoordinate)obj;
            return this.key == other.key;
        }

        @Override
        public int compareTo(ChunkCoordinate other) {
            return Long.compare(this.key, other.key);
        }

        public String toString() {
            return new ChunkPos(this.key).toString();
        }
    }

    public static final class RegionFileData {
        private final boolean[] hasResult = new boolean[CACHED_REGIONFILE_TYPES.length];
        private final CompoundTag[] data = new CompoundTag[CACHED_REGIONFILE_TYPES.length];
        private final Throwable[] throwables = new Throwable[CACHED_REGIONFILE_TYPES.length];

        public void setData(RegionFileType type, CompoundTag data) {
            int index = type.ordinal();
            if (this.hasResult[index]) {
                throw new IllegalArgumentException("Result already exists for type " + String.valueOf((Object)type));
            }
            this.hasResult[index] = true;
            this.data[index] = data;
        }

        public void setThrowable(RegionFileType type, Throwable throwable) {
            int index = type.ordinal();
            if (this.hasResult[index]) {
                throw new IllegalArgumentException("Result already exists for type " + String.valueOf((Object)type));
            }
            this.hasResult[index] = true;
            this.throwables[index] = throwable;
        }

        public boolean hasResult(RegionFileType type) {
            return this.hasResult[type.ordinal()];
        }

        public CompoundTag getData(RegionFileType type) {
            int index = type.ordinal();
            if (!this.hasResult[index]) {
                throw new IllegalArgumentException("Result does not exist for type " + String.valueOf((Object)type));
            }
            return this.data[index];
        }

        public Throwable getThrowable(RegionFileType type) {
            int index = type.ordinal();
            if (!this.hasResult[index]) {
                throw new IllegalArgumentException("Result does not exist for type " + String.valueOf((Object)type));
            }
            return this.throwables[index];
        }
    }

    static final class CancellableRead
    implements Cancellable {
        private BiConsumer<CompoundTag, Throwable> callback;
        private ChunkDataTask task;

        CancellableRead(BiConsumer<CompoundTag, Throwable> callback, ChunkDataTask task) {
            this.callback = callback;
            this.task = task;
        }

        @Override
        public boolean cancel() {
            BiConsumer<CompoundTag, Throwable> callback = this.callback;
            ChunkDataTask task = this.task;
            if (callback == null || task == null) {
                return false;
            }
            this.callback = null;
            this.task = null;
            InProgressRead read = task.inProgressRead;
            return read != null && read.waiters.remove(callback);
        }
    }

    static final class CancellableReads
    implements Cancellable {
        private Cancellable[] reads;
        protected static final VarHandle READS_HANDLE = ConcurrentUtil.getVarHandle(CancellableReads.class, "reads", Cancellable[].class);

        CancellableReads(Cancellable[] reads) {
            this.reads = reads;
        }

        @Override
        public boolean cancel() {
            Cancellable[] reads = READS_HANDLE.getAndSet(this, null);
            if (reads == null) {
                return false;
            }
            boolean ret = false;
            for (Cancellable read : reads) {
                ret |= read.cancel();
            }
            return ret;
        }
    }

    private static final class ImmediateCallbackCompletion {
        public CompoundTag data;
        public Throwable throwable;
        public boolean completeNow;
        public boolean tasksNeedsScheduling;

        private ImmediateCallbackCompletion() {
        }
    }

    static final class InProgressRead {
        private static final Logger LOGGER = LogUtils.getClassLogger();
        CompoundTag value;
        Throwable throwable;
        final MultiThreadedQueue<BiConsumer<CompoundTag, Throwable>> waiters = new MultiThreadedQueue();

        InProgressRead() {
        }

        boolean addToWaiters(BiConsumer<CompoundTag, Throwable> callback) {
            return this.waiters.add(callback);
        }

        void complete(ChunkDataTask task, CompoundTag value, Throwable throwable) {
            BiConsumer<CompoundTag, Throwable> consumer;
            this.value = value;
            this.throwable = throwable;
            while ((consumer = this.waiters.pollOrBlockAdds()) != null) {
                try {
                    consumer.accept(value, throwable);
                }
                catch (ThreadDeath thr) {
                    throw thr;
                }
                catch (Throwable thr) {
                    LOGGER.error("Callback " + ConcurrentUtil.genericToString(consumer) + " failed to handle chunk data for task " + task.toString(), thr);
                }
            }
        }
    }
}

