/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import io.papermc.paper.chunk.system.light.LightQueue;
import io.papermc.paper.chunk.system.scheduling.ChunkProgressionTask;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.PriorityHolder;
import java.util.function.BooleanSupplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ChunkLightTask
extends ChunkProgressionTask {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ChunkAccess fromChunk;
    private final LightTaskPriorityHolder priorityHolder;

    public ChunkLightTask(ChunkTaskScheduler scheduler, ServerLevel world, int chunkX, int chunkZ, ChunkAccess chunk, PrioritisedExecutor.Priority priority) {
        super(scheduler, world, chunkX, chunkZ);
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.priorityHolder = new LightTaskPriorityHolder(priority, this);
        this.fromChunk = chunk;
    }

    @Override
    public boolean isScheduled() {
        return this.priorityHolder.isScheduled();
    }

    @Override
    public ChunkStatus getTargetStatus() {
        return ChunkStatus.LIGHT;
    }

    @Override
    public void schedule() {
        this.priorityHolder.schedule();
    }

    @Override
    public void cancel() {
        this.priorityHolder.cancel();
    }

    @Override
    public PrioritisedExecutor.Priority getPriority() {
        return this.priorityHolder.getPriority();
    }

    @Override
    public void lowerPriority(PrioritisedExecutor.Priority priority) {
        this.priorityHolder.raisePriority(priority);
    }

    @Override
    public void setPriority(PrioritisedExecutor.Priority priority) {
        this.priorityHolder.setPriority(priority);
    }

    @Override
    public void raisePriority(PrioritisedExecutor.Priority priority) {
        this.priorityHolder.raisePriority(priority);
    }

    private static final class LightTaskPriorityHolder
    extends PriorityHolder {
        protected final ChunkLightTask task;

        protected LightTaskPriorityHolder(PrioritisedExecutor.Priority priority, ChunkLightTask task) {
            super(priority);
            this.task = task;
        }

        @Override
        protected void cancelScheduled() {
            ChunkLightTask task = this.task;
            task.complete(null, null);
        }

        @Override
        protected PrioritisedExecutor.Priority getScheduledPriority() {
            ChunkLightTask task = this.task;
            return task.world.getChunkSource().getLightEngine().theLightEngine.lightQueue.getPriority(task.chunkX, task.chunkZ);
        }

        @Override
        protected void scheduleTask(PrioritisedExecutor.Priority priority) {
            ChunkLightTask task = this.task;
            StarLightInterface starLightInterface = task.world.getChunkSource().getLightEngine().theLightEngine;
            LightQueue lightQueue = starLightInterface.lightQueue;
            lightQueue.queueChunkLightTask(new ChunkPos(task.chunkX, task.chunkZ), new LightTask(starLightInterface, task), priority);
            lightQueue.setPriority(task.chunkX, task.chunkZ, priority);
        }

        @Override
        protected void lowerPriorityScheduled(PrioritisedExecutor.Priority priority) {
            ChunkLightTask task = this.task;
            StarLightInterface starLightInterface = task.world.getChunkSource().getLightEngine().theLightEngine;
            LightQueue lightQueue = starLightInterface.lightQueue;
            lightQueue.lowerPriority(task.chunkX, task.chunkZ, priority);
        }

        @Override
        protected void setPriorityScheduled(PrioritisedExecutor.Priority priority) {
            ChunkLightTask task = this.task;
            StarLightInterface starLightInterface = task.world.getChunkSource().getLightEngine().theLightEngine;
            LightQueue lightQueue = starLightInterface.lightQueue;
            lightQueue.setPriority(task.chunkX, task.chunkZ, priority);
        }

        @Override
        protected void raisePriorityScheduled(PrioritisedExecutor.Priority priority) {
            ChunkLightTask task = this.task;
            StarLightInterface starLightInterface = task.world.getChunkSource().getLightEngine().theLightEngine;
            LightQueue lightQueue = starLightInterface.lightQueue;
            lightQueue.raisePriority(task.chunkX, task.chunkZ, priority);
        }
    }

    private static final class LightTask
    implements BooleanSupplier {
        protected final StarLightInterface lightEngine;
        protected final ChunkLightTask task;

        public LightTask(StarLightInterface lightEngine, ChunkLightTask task) {
            this.lightEngine = lightEngine;
            this.task = task;
        }

        @Override
        public boolean getAsBoolean() {
            ChunkLightTask task = this.task;
            if (!task.priorityHolder.markExecuting()) {
                return false;
            }
            try {
                ProtoChunk chunk;
                Boolean[] emptySections = StarLightEngine.getEmptySectionsForChunk(task.fromChunk);
                if (task.fromChunk.isLightCorrect() && task.fromChunk.getStatus().isOrAfter(ChunkStatus.LIGHT)) {
                    this.lightEngine.forceLoadInChunk(task.fromChunk, emptySections);
                    this.lightEngine.checkChunkEdges(task.chunkX, task.chunkZ);
                } else {
                    task.fromChunk.setLightCorrect(false);
                    this.lightEngine.lightChunk(task.fromChunk, emptySections);
                    task.fromChunk.setLightCorrect(true);
                }
                ChunkAccess chunkAccess = task.fromChunk;
                if (chunkAccess instanceof ProtoChunk && (chunk = (ProtoChunk)chunkAccess).getStatus() == ChunkStatus.LIGHT.getParent()) {
                    chunk.setStatus(ChunkStatus.LIGHT);
                }
            }
            catch (Throwable thr) {
                if (!(thr instanceof ThreadDeath)) {
                    LOGGER.fatal("Failed to light chunk " + task.fromChunk.getPos().toString() + " in world '" + this.lightEngine.getWorld().getWorld().getName() + "'", thr);
                }
                task.complete(null, thr);
                if (thr instanceof ThreadDeath) {
                    throw (ThreadDeath)thr;
                }
                return true;
            }
            task.complete(task.fromChunk, null);
            return true;
        }
    }
}

