/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class ChunkQueue {
    public final int coordinateShift;
    private final AtomicLong orderGenerator = new AtomicLong();
    private final ConcurrentHashMap<Coordinate, UnloadSection> unloadSections = new ConcurrentHashMap();

    public ChunkQueue(int coordinateShift) {
        this.coordinateShift = coordinateShift;
    }

    public List<SectionToUnload> retrieveForAllRegions() {
        ArrayList<SectionToUnload> ret = new ArrayList<SectionToUnload>();
        for (Map.Entry<Coordinate, UnloadSection> entry : this.unloadSections.entrySet()) {
            Coordinate coord = entry.getKey();
            long key = coord.key;
            UnloadSection section = entry.getValue();
            int sectionX = Coordinate.x(key);
            int sectionZ = Coordinate.z(key);
            ret.add(new SectionToUnload(sectionX, sectionZ, coord, section.order, section.chunks.size()));
        }
        ret.sort((s1, s2) -> Long.compare(s1.order, s2.order));
        return ret;
    }

    public UnloadSection getSectionUnsynchronized(int sectionX, int sectionZ) {
        Coordinate coordinate = new Coordinate(Coordinate.key(sectionX, sectionZ));
        return this.unloadSections.get(coordinate);
    }

    public UnloadSection removeSection(int sectionX, int sectionZ) {
        Coordinate coordinate = new Coordinate(Coordinate.key(sectionX, sectionZ));
        return this.unloadSections.remove(coordinate);
    }

    public boolean addChunk(int chunkX, int chunkZ) {
        int shift = this.coordinateShift;
        int sectionX = chunkX >> shift;
        int sectionZ = chunkZ >> shift;
        Coordinate coordinate = new Coordinate(Coordinate.key(sectionX, sectionZ));
        long chunkKey = Coordinate.key(chunkX, chunkZ);
        UnloadSection section = this.unloadSections.get(coordinate);
        if (section == null) {
            section = new UnloadSection(this.orderGenerator.getAndIncrement());
            this.unloadSections.put(coordinate, section);
        }
        return section.chunks.add(chunkKey);
    }

    public boolean removeChunk(int chunkX, int chunkZ) {
        int shift = this.coordinateShift;
        int sectionX = chunkX >> shift;
        int sectionZ = chunkZ >> shift;
        Coordinate coordinate = new Coordinate(Coordinate.key(sectionX, sectionZ));
        long chunkKey = Coordinate.key(chunkX, chunkZ);
        UnloadSection section = this.unloadSections.get(coordinate);
        if (section == null) {
            return false;
        }
        if (!section.chunks.remove(chunkKey)) {
            return false;
        }
        if (section.chunks.isEmpty()) {
            this.unloadSections.remove(coordinate);
        }
        return true;
    }

    private static final class Coordinate
    implements Comparable<Coordinate> {
        public final long key;

        public Coordinate(long key) {
            this.key = key;
        }

        public Coordinate(int x, int z) {
            this.key = Coordinate.key(x, z);
        }

        public static long key(int x, int z) {
            return (long)z << 32 | (long)x & 0xFFFFFFFFL;
        }

        public static int x(long key) {
            return (int)key;
        }

        public static int z(long key) {
            return (int)(key >>> 32);
        }

        public int hashCode() {
            return (int)HashCommon.mix((long)this.key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Coordinate)) {
                return false;
            }
            Coordinate other = (Coordinate)obj;
            return this.key == other.key;
        }

        @Override
        public int compareTo(Coordinate other) {
            return Long.compare(this.key, other.key);
        }
    }

    public static final class UnloadSection {
        public final long order;
        public final LongLinkedOpenHashSet chunks = new LongLinkedOpenHashSet();

        public UnloadSection(long order) {
            this.order = order;
        }
    }

    public record SectionToUnload(int sectionX, int sectionZ, Coordinate coord, long order, int count) {
    }
}

