/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.scheduling.ChunkProgressionTask;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import org.slf4j.Logger;

public final class ChunkUpgradeGenericStatusTask
extends ChunkProgressionTask
implements Runnable {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    protected final ChunkAccess fromChunk;
    protected final ChunkStatus fromStatus;
    protected final ChunkStatus toStatus;
    protected final List<ChunkAccess> neighbours;
    protected final PrioritisedExecutor.PrioritisedTask generateTask;
    protected volatile boolean scheduled;
    protected static final VarHandle SCHEDULED_HANDLE = ConcurrentUtil.getVarHandle(ChunkUpgradeGenericStatusTask.class, "scheduled", Boolean.TYPE);

    public ChunkUpgradeGenericStatusTask(ChunkTaskScheduler scheduler, ServerLevel world, int chunkX, int chunkZ, ChunkAccess chunk, List<ChunkAccess> neighbours, ChunkStatus toStatus, PrioritisedExecutor.Priority priority) {
        super(scheduler, world, chunkX, chunkZ);
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.fromChunk = chunk;
        this.fromStatus = chunk.getStatus();
        this.toStatus = toStatus;
        this.neighbours = neighbours;
        this.generateTask = this.toStatus.isParallelCapable ? this.scheduler.parallelGenExecutor.createTask(this, priority) : this.scheduler.radiusAwareScheduler.createTask(chunkX, chunkZ, this.toStatus.writeRadius, this, priority);
    }

    @Override
    public ChunkStatus getTargetStatus() {
        return this.toStatus;
    }

    private boolean isEmptyTask() {
        boolean generation = !this.fromStatus.isOrAfter(this.toStatus);
        return generation && this.toStatus.isEmptyGenStatus() || !generation && this.toStatus.isEmptyLoadStatus();
    }

    @Override
    public void run() {
        ChunkAccess newChunk;
        CompletionStage<ChunkAccess> completeFuture;
        boolean generation;
        ChunkAccess chunk = this.fromChunk;
        ServerChunkCache serverChunkCache = this.world.chunkSource;
        ChunkMap chunkMap = serverChunkCache.chunkMap;
        boolean completing = false;
        WorldGenContext ctx = new WorldGenContext(this.world, chunkMap.generator, chunkMap.getWorldGenContext().structureManager(), serverChunkCache.getLightEngine());
        try {
            boolean bl = generation = !chunk.getStatus().isOrAfter(this.toStatus);
            if (generation) {
                if (this.toStatus.isEmptyGenStatus()) {
                    if (chunk instanceof ProtoChunk) {
                        ((ProtoChunk)chunk).setStatus(this.toStatus);
                    }
                    completing = true;
                    this.complete(chunk, null);
                    return;
                }
                completeFuture = this.toStatus.generate(ctx, Runnable::run, null, this.neighbours).whenComplete((either, throwable) -> {
                    if (either instanceof ProtoChunk) {
                        ProtoChunk proto = (ProtoChunk)either;
                        proto.setStatus(this.toStatus);
                    }
                });
            } else {
                if (this.toStatus.isEmptyLoadStatus()) {
                    completing = true;
                    this.complete(chunk, null);
                    return;
                }
                completeFuture = this.toStatus.load(ctx, null, chunk);
            }
        }
        catch (Throwable throwable2) {
            if (!completing) {
                this.complete(null, throwable2);
                if (throwable2 instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable2;
                }
                return;
            }
            this.scheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Target status", ChunkTaskScheduler.stringIfNull(this.toStatus), "From status", ChunkTaskScheduler.stringIfNull(this.fromStatus), "Generation task", this), throwable2);
            if (throwable2 instanceof ThreadDeath) {
                throw (ThreadDeath)throwable2;
            }
            LOGGER.error("Failed to complete status for chunk: status:" + String.valueOf(this.toStatus) + ", chunk: (" + this.chunkX + "," + this.chunkZ + "), world: " + this.world.getWorld().getName(), throwable2);
            return;
        }
        if (!((CompletableFuture)completeFuture).isDone() && !this.toStatus.warnedAboutNoImmediateComplete.getAndSet(true)) {
            LOGGER.warn("Future status not complete after scheduling: " + this.toStatus.toString() + ", generate: " + generation);
        }
        try {
            newChunk = (ChunkAccess)((CompletableFuture)completeFuture).join();
        }
        catch (Throwable throwable3) {
            this.complete(null, throwable3);
            if (throwable3 instanceof ThreadDeath) {
                throw (ThreadDeath)throwable3;
            }
            return;
        }
        if (newChunk == null) {
            this.complete(null, new IllegalStateException("Chunk for status: " + this.toStatus.toString() + ", generation: " + generation + " should not be null! Future: " + String.valueOf(completeFuture)).fillInStackTrace());
            return;
        }
        this.complete(newChunk, null);
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    public void schedule() {
        if (SCHEDULED_HANDLE.getAndSet(this, true)) {
            throw new IllegalStateException("Cannot double call schedule()");
        }
        if (this.isEmptyTask()) {
            if (this.generateTask.cancel()) {
                this.run();
            }
        } else {
            this.generateTask.queue();
        }
    }

    @Override
    public void cancel() {
        if (this.generateTask.cancel()) {
            this.complete(null, null);
        }
    }

    @Override
    public PrioritisedExecutor.Priority getPriority() {
        return this.generateTask.getPriority();
    }

    @Override
    public void lowerPriority(PrioritisedExecutor.Priority priority) {
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.generateTask.lowerPriority(priority);
    }

    @Override
    public void setPriority(PrioritisedExecutor.Priority priority) {
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.generateTask.setPriority(priority);
    }

    @Override
    public void raisePriority(PrioritisedExecutor.Priority priority) {
        if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
        }
        this.generateTask.raisePriority(priority);
    }
}

