/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import ca.spottedleaf.concurrentutil.completable.Completable;
import ca.spottedleaf.concurrentutil.executor.Cancellable;
import ca.spottedleaf.concurrentutil.executor.standard.DelayedPrioritisedTask;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import org.slf4j.Logger;

public abstract class GenericDataLoadTask<OnMain, FinalCompletion> {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    protected static final CompoundTag CANCELLED_DATA = new CompoundTag();
    protected final AtomicLong stageAndReferenceCount = new AtomicLong(0L);
    protected static final long STAGE_MASK = 0xFFFFFFFFL;
    protected static final long STAGE_CANCELLED = 0xFFFFFFFFL;
    protected static final long STAGE_NOT_STARTED = 0L;
    protected static final long STAGE_LOADING = 1L;
    protected static final long STAGE_PROCESSING = 2L;
    protected static final long STAGE_COMPLETED = 3L;
    protected final LoadDataFromDiskTask loadDataFromDiskTask;
    protected final PrioritisedExecutor.PrioritisedTask processOffMain;
    protected final PrioritisedExecutor.PrioritisedTask processOnMain;
    protected final ChunkTaskScheduler scheduler;
    protected final ServerLevel world;
    protected final int chunkX;
    protected final int chunkZ;
    protected final RegionFileIOThread.RegionFileType type;

    public GenericDataLoadTask(ChunkTaskScheduler scheduler, ServerLevel world, int chunkX, int chunkZ, RegionFileIOThread.RegionFileType type, PrioritisedExecutor.Priority priority) {
        ProcessOffMainTask offMainTask;
        ProcessOnMainTask mainTask;
        this.scheduler = scheduler;
        this.world = world;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.type = type;
        if (this.hasOnMain()) {
            mainTask = new ProcessOnMainTask();
            this.processOnMain = this.createOnMain(mainTask, priority);
        } else {
            mainTask = null;
            this.processOnMain = null;
        }
        if (this.hasOffMain()) {
            offMainTask = new ProcessOffMainTask(mainTask);
            this.processOffMain = this.createOffMain(offMainTask, priority);
        } else {
            offMainTask = null;
            this.processOffMain = null;
        }
        if (this.processOffMain == null && this.processOnMain == null) {
            throw new IllegalStateException("Illegal class implementation: " + this.getClass().getName() + ", should be able to schedule at least one task!");
        }
        this.loadDataFromDiskTask = new LoadDataFromDiskTask(world, chunkX, chunkZ, type, new DataLoadCallback(offMainTask, mainTask), priority);
    }

    protected abstract boolean hasOffMain();

    protected abstract boolean hasOnMain();

    protected abstract PrioritisedExecutor.PrioritisedTask createOffMain(Runnable var1, PrioritisedExecutor.Priority var2);

    protected abstract PrioritisedExecutor.PrioritisedTask createOnMain(Runnable var1, PrioritisedExecutor.Priority var2);

    protected abstract TaskResult<OnMain, Throwable> runOffMain(CompoundTag var1, Throwable var2);

    protected abstract TaskResult<FinalCompletion, Throwable> runOnMain(OnMain var1, Throwable var2);

    protected abstract void onComplete(TaskResult<FinalCompletion, Throwable> var1);

    protected abstract TaskResult<FinalCompletion, Throwable> completeOnMainOffMain(OnMain var1, Throwable var2);

    public String toString() {
        return "GenericDataLoadTask{class: " + this.getClass().getName() + ", world: " + this.world.getWorld().getName() + ", chunk: (" + this.chunkX + "," + this.chunkZ + "), hashcode: " + System.identityHashCode(this) + ", priority: " + String.valueOf((Object)this.getPriority()) + ", type: " + this.type.toString() + "}";
    }

    public PrioritisedExecutor.Priority getPriority() {
        if (this.processOnMain != null) {
            return this.processOnMain.getPriority();
        }
        return this.processOffMain.getPriority();
    }

    public void lowerPriority(PrioritisedExecutor.Priority priority) {
        if (this.processOffMain != null) {
            this.processOffMain.lowerPriority(priority);
        }
        if (this.processOnMain != null) {
            this.processOnMain.lowerPriority(priority);
        }
    }

    public void setPriority(PrioritisedExecutor.Priority priority) {
        this.loadDataFromDiskTask.raisePriority(priority);
        if (this.processOffMain != null) {
            this.processOffMain.setPriority(priority);
        }
        if (this.processOnMain != null) {
            this.processOnMain.setPriority(priority);
        }
    }

    public void raisePriority(PrioritisedExecutor.Priority priority) {
        this.loadDataFromDiskTask.raisePriority(priority);
        if (this.processOffMain != null) {
            this.processOffMain.raisePriority(priority);
        }
        if (this.processOnMain != null) {
            this.processOnMain.raisePriority(priority);
        }
    }

    public boolean schedule(boolean delay) {
        if (this.stageAndReferenceCount.get() != 0L || !this.stageAndReferenceCount.compareAndSet(0L, 0x100000001L)) {
            int failures = 0;
            long curr = this.stageAndReferenceCount.get();
            block0: while (true) {
                if ((curr & 0xFFFFFFFFL) == 0xFFFFFFFFL || (curr & 0xFFFFFFFFL) == 3L) {
                    return false;
                }
                if (curr == (curr = this.stageAndReferenceCount.compareAndExchange(curr, curr + 0x100000000L))) {
                    return false;
                }
                ++failures;
                int i = 0;
                while (true) {
                    if (i >= failures) continue block0;
                    ConcurrentUtil.backoff();
                    ++i;
                }
                break;
            }
        }
        if (!delay) {
            this.scheduleNow();
            return false;
        }
        return true;
    }

    public void scheduleNow() {
        this.loadDataFromDiskTask.schedule();
    }

    private boolean advanceStage(long expect, long to) {
        int failures = 0;
        long curr = this.stageAndReferenceCount.get();
        block0: while ((curr & 0xFFFFFFFFL) == expect) {
            long newVal = curr & 0xFFFFFFFF00000000L | to;
            if (curr == (curr = this.stageAndReferenceCount.compareAndExchange(curr, newVal))) {
                return true;
            }
            ++failures;
            int i = 0;
            while (true) {
                if (i >= failures) continue block0;
                ConcurrentUtil.backoff();
                ++i;
            }
            break;
        }
        return false;
    }

    public boolean cancel() {
        int failures = 0;
        long curr = this.stageAndReferenceCount.get();
        block0: while ((curr & 0xFFFFFFFFL) != 3L && (curr & 0xFFFFFFFFL) != 0xFFFFFFFFL) {
            if ((curr & 0xFFFFFFFFL) == 0L || (curr & 0xFFFFFFFF00000000L) == 0x100000000L) {
                newVal = 0xFFFFFFFFL;
                if (curr == (curr = this.stageAndReferenceCount.compareAndExchange(curr, 0xFFFFFFFFL))) {
                    this.loadDataFromDiskTask.cancel();
                    if (this.processOffMain != null) {
                        this.processOffMain.cancel();
                    }
                    if (this.processOnMain != null) {
                        this.processOnMain.cancel();
                    }
                    this.onComplete(null);
                    return true;
                }
            } else {
                if ((curr & 0xFFFFFFFF00000000L) == 0L) {
                    throw new IllegalStateException("Reference count cannot be zero here");
                }
                newVal = curr - 0x100000000L;
                if (curr == (curr = this.stageAndReferenceCount.compareAndExchange(curr, newVal))) {
                    return false;
                }
            }
            ++failures;
            int i = 0;
            while (true) {
                if (i >= failures) continue block0;
                ConcurrentUtil.backoff();
                ++i;
            }
            break;
        }
        return false;
    }

    protected final class ProcessOnMainTask
    implements Runnable {
        protected OnMain data;
        protected Throwable throwable;

        protected ProcessOnMainTask() {
        }

        @Override
        public void run() {
            if (!GenericDataLoadTask.this.advanceStage(2L, 3L)) {
                return;
            }
            TaskResult result = GenericDataLoadTask.this.runOnMain(this.data, this.throwable);
            GenericDataLoadTask.this.onComplete(result);
        }
    }

    protected final class ProcessOffMainTask
    implements Runnable {
        protected CompoundTag data;
        protected Throwable throwable;
        protected final ProcessOnMainTask schedule;

        public ProcessOffMainTask(ProcessOnMainTask schedule) {
            this.schedule = schedule;
        }

        @Override
        public void run() {
            if (!GenericDataLoadTask.this.advanceStage(1L, this.schedule == null ? 3L : 2L)) {
                return;
            }
            TaskResult newData = GenericDataLoadTask.this.runOffMain(this.data, this.throwable);
            if (GenericDataLoadTask.this.stageAndReferenceCount.get() == 0xFFFFFFFFL) {
                return;
            }
            if (this.schedule != null) {
                TaskResult syncComplete = GenericDataLoadTask.this.completeOnMainOffMain(newData.left, (Throwable)newData.right);
                if (syncComplete != null) {
                    if (GenericDataLoadTask.this.advanceStage(2L, 3L)) {
                        GenericDataLoadTask.this.onComplete(syncComplete);
                    }
                    return;
                }
                this.schedule.data = newData.left;
                this.schedule.throwable = (Throwable)newData.right;
                GenericDataLoadTask.this.processOnMain.queue();
            } else {
                GenericDataLoadTask.this.onComplete(newData);
            }
        }
    }

    public static final class LoadDataFromDiskTask {
        protected volatile int priority;
        protected static final VarHandle PRIORITY_HANDLE = ConcurrentUtil.getVarHandle(LoadDataFromDiskTask.class, "priority", Integer.TYPE);
        protected static final int PRIORITY_EXECUTED = Integer.MIN_VALUE;
        protected static final int PRIORITY_LOAD_SCHEDULED = 0x40000000;
        protected static final int PRIORITY_UNLOAD_SCHEDULED = 0x20000000;
        protected static final int PRIORITY_FLAGS = -65536;
        private final ServerLevel world;
        private final int chunkX;
        private final int chunkZ;
        private final RegionFileIOThread.RegionFileType type;
        private Cancellable dataLoadTask;
        private Cancellable dataUnloadCancellable;
        private DelayedPrioritisedTask dataUnloadTask;
        private final BiConsumer<CompoundTag, Throwable> onComplete;
        private final AtomicBoolean scheduled = new AtomicBoolean();

        protected final int getPriorityVolatile() {
            return PRIORITY_HANDLE.getVolatile(this);
        }

        protected final int compareAndExchangePriorityVolatile(int expect, int update) {
            return PRIORITY_HANDLE.compareAndExchange(this, expect, update);
        }

        protected final int getAndOrPriorityVolatile(int val) {
            return PRIORITY_HANDLE.getAndBitwiseOr(this, val);
        }

        protected final void setPriorityPlain(int val) {
            PRIORITY_HANDLE.set(this, val);
        }

        public LoadDataFromDiskTask(ServerLevel world, int chunkX, int chunkZ, RegionFileIOThread.RegionFileType type, BiConsumer<CompoundTag, Throwable> onComplete, PrioritisedExecutor.Priority priority) {
            if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
                throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
            }
            this.world = world;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.type = type;
            this.onComplete = onComplete;
            this.setPriorityPlain(priority.priority);
        }

        private void complete(CompoundTag data, Throwable throwable) {
            block2: {
                try {
                    this.onComplete.accept(data, throwable);
                }
                catch (Throwable thr2) {
                    this.world.chunkTaskScheduler.unrecoverableChunkSystemFailure(this.chunkX, this.chunkZ, Map.of("Completed throwable", ChunkTaskScheduler.stringIfNull(throwable), "Regionfile type", ChunkTaskScheduler.stringIfNull((Object)this.type)), thr2);
                    if (!(thr2 instanceof ThreadDeath)) break block2;
                    throw (ThreadDeath)thr2;
                }
            }
        }

        protected boolean markExecuting() {
            return (this.getAndOrPriorityVolatile(Integer.MIN_VALUE) & Integer.MIN_VALUE) == 0;
        }

        protected boolean isMarkedExecuted() {
            return (this.getPriorityVolatile() & Integer.MIN_VALUE) != 0;
        }

        public void lowerPriority(PrioritisedExecutor.Priority priority) {
            if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
                throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
            }
            int failures = 0;
            int curr = this.getPriorityVolatile();
            block0: while ((curr & Integer.MIN_VALUE) == 0) {
                if ((curr & 0x40000000) != 0) {
                    RegionFileIOThread.lowerPriority(this.world, this.chunkX, this.chunkZ, this.type, priority);
                    return;
                }
                if ((curr & 0x20000000) != 0 && this.dataUnloadTask != null) {
                    this.dataUnloadTask.lowerPriority(priority);
                }
                if (!priority.isHigherPriority(curr & 0xFFFF)) {
                    return;
                }
                if (curr == (curr = this.compareAndExchangePriorityVolatile(curr, priority.priority | curr & 0xFFFF0000))) {
                    return;
                }
                ++failures;
                int i = 0;
                while (true) {
                    if (i >= failures) continue block0;
                    ConcurrentUtil.backoff();
                    ++i;
                }
                break;
            }
            return;
        }

        public void setPriority(PrioritisedExecutor.Priority priority) {
            if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
                throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
            }
            int failures = 0;
            int curr = this.getPriorityVolatile();
            block0: while ((curr & Integer.MIN_VALUE) == 0) {
                if ((curr & 0x40000000) != 0) {
                    RegionFileIOThread.setPriority(this.world, this.chunkX, this.chunkZ, this.type, priority);
                    return;
                }
                if ((curr & 0x20000000) != 0 && this.dataUnloadTask != null) {
                    this.dataUnloadTask.setPriority(priority);
                }
                if (curr == (curr = this.compareAndExchangePriorityVolatile(curr, priority.priority | curr & 0xFFFF0000))) {
                    return;
                }
                ++failures;
                int i = 0;
                while (true) {
                    if (i >= failures) continue block0;
                    ConcurrentUtil.backoff();
                    ++i;
                }
                break;
            }
            return;
        }

        public void raisePriority(PrioritisedExecutor.Priority priority) {
            if (!PrioritisedExecutor.Priority.isValidPriority(priority)) {
                throw new IllegalArgumentException("Invalid priority " + String.valueOf((Object)priority));
            }
            int failures = 0;
            int curr = this.getPriorityVolatile();
            block0: while ((curr & Integer.MIN_VALUE) == 0) {
                if ((curr & 0x40000000) != 0) {
                    RegionFileIOThread.raisePriority(this.world, this.chunkX, this.chunkZ, this.type, priority);
                    return;
                }
                if ((curr & 0x20000000) != 0 && this.dataUnloadTask != null) {
                    this.dataUnloadTask.raisePriority(priority);
                }
                if (!priority.isLowerPriority(curr & 0xFFFF)) {
                    return;
                }
                if (curr == (curr = this.compareAndExchangePriorityVolatile(curr, priority.priority | curr & 0xFFFF0000))) {
                    return;
                }
                ++failures;
                int i = 0;
                while (true) {
                    if (i >= failures) continue block0;
                    ConcurrentUtil.backoff();
                    ++i;
                }
                break;
            }
            return;
        }

        public void cancel() {
            if ((this.getAndOrPriorityVolatile(Integer.MIN_VALUE) & Integer.MIN_VALUE) != 0) {
                return;
            }
            if (this.dataUnloadCancellable != null) {
                this.dataUnloadCancellable.cancel();
            }
            if (this.dataLoadTask != null) {
                this.dataLoadTask.cancel();
            }
            this.complete(CANCELLED_DATA, null);
        }

        public void schedule() {
            if (this.scheduled.getAndSet(true)) {
                throw new IllegalStateException("schedule() called twice");
            }
            int priority = this.getPriorityVolatile();
            if ((priority & Integer.MIN_VALUE) != 0) {
                return;
            }
            BiConsumer<CompoundTag, Throwable> consumer = (data, thr) -> {
                if (this.markExecuting()) {
                    this.complete((CompoundTag)data, (Throwable)thr);
                }
            };
            PrioritisedExecutor.Priority initialPriority = PrioritisedExecutor.Priority.getPriority(priority);
            boolean scheduledUnload = false;
            NewChunkHolder holder = this.world.chunkTaskScheduler.chunkHolderManager.getChunkHolder(this.chunkX, this.chunkZ);
            if (holder != null) {
                Completable<CompoundTag> unloadCompletable;
                BiConsumer<CompoundTag, Throwable> unloadConsumer = (data, thr) -> {
                    if (data != null) {
                        consumer.accept((CompoundTag)data, (Throwable)null);
                    } else {
                        this.schedule(false, consumer, PrioritisedExecutor.Priority.getPriority(this.getPriorityVolatile() & 0xFFFF));
                    }
                };
                Cancellable unloadCancellable = null;
                CompoundTag syncComplete = null;
                NewChunkHolder.UnloadTask unloadTask = holder.getUnloadTask(this.type);
                Completable<CompoundTag> completable = unloadCompletable = unloadTask == null ? null : unloadTask.completable();
                if (unloadCompletable != null && (unloadCancellable = unloadCompletable.addAsynchronousWaiter(unloadConsumer)) == null) {
                    syncComplete = unloadCompletable.getResult();
                }
                if (syncComplete != null) {
                    consumer.accept(syncComplete, null);
                    return;
                }
                if (unloadCancellable != null) {
                    scheduledUnload = true;
                    this.dataUnloadCancellable = unloadCancellable;
                    this.dataUnloadTask = unloadTask.task();
                }
            }
            this.schedule(scheduledUnload, consumer, initialPriority);
        }

        private void schedule(boolean scheduledUnload, BiConsumer<CompoundTag, Throwable> consumer, PrioritisedExecutor.Priority initialPriority) {
            int priority = this.getPriorityVolatile();
            if ((priority & Integer.MIN_VALUE) != 0) {
                return;
            }
            if (!scheduledUnload) {
                this.dataLoadTask = RegionFileIOThread.loadDataAsync(this.world, this.chunkX, this.chunkZ, this.type, consumer, initialPriority.isHigherPriority(PrioritisedExecutor.Priority.NORMAL), initialPriority);
            }
            int failures = 0;
            block0: while (priority != (priority = this.compareAndExchangePriorityVolatile(priority, priority | (scheduledUnload ? 0x20000000 : 0x40000000)))) {
                if ((priority & Integer.MIN_VALUE) != 0) {
                    if (this.dataUnloadCancellable != null) {
                        this.dataUnloadCancellable.cancel();
                    }
                    if (this.dataLoadTask != null) {
                        this.dataLoadTask.cancel();
                    }
                    return;
                }
                if (scheduledUnload) {
                    if (this.dataUnloadTask != null) {
                        this.dataUnloadTask.setPriority(PrioritisedExecutor.Priority.getPriority(priority & 0xFFFF));
                    }
                } else {
                    RegionFileIOThread.setPriority(this.world, this.chunkX, this.chunkZ, this.type, PrioritisedExecutor.Priority.getPriority(priority & 0xFFFF));
                }
                ++failures;
                int i = 0;
                while (true) {
                    if (i >= failures) continue block0;
                    ConcurrentUtil.backoff();
                    ++i;
                }
                break;
            }
            return;
        }
    }

    protected final class DataLoadCallback
    implements BiConsumer<CompoundTag, Throwable> {
        protected final ProcessOffMainTask offMainTask;
        protected final ProcessOnMainTask onMainTask;

        public DataLoadCallback(ProcessOffMainTask offMainTask, ProcessOnMainTask onMainTask) {
            this.offMainTask = offMainTask;
            this.onMainTask = onMainTask;
        }

        @Override
        public void accept(CompoundTag compoundTag, Throwable throwable) {
            if (GenericDataLoadTask.this.stageAndReferenceCount.get() == 0xFFFFFFFFL) {
                return;
            }
            try {
                if (compoundTag == CANCELLED_DATA) {
                    LOGGER.error("Data callback says cancelled, but stage does not?");
                    return;
                }
                if (GenericDataLoadTask.this.processOffMain != null) {
                    this.offMainTask.data = compoundTag;
                    this.offMainTask.throwable = throwable;
                    GenericDataLoadTask.this.processOffMain.queue();
                    return;
                }
                this.onMainTask.data = compoundTag;
                this.onMainTask.throwable = throwable;
                GenericDataLoadTask.this.processOnMain.queue();
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable thr2) {
                LOGGER.error("Failed I/O callback for task: " + GenericDataLoadTask.this.toString(), thr2);
                GenericDataLoadTask.this.scheduler.unrecoverableChunkSystemFailure(GenericDataLoadTask.this.chunkX, GenericDataLoadTask.this.chunkZ, Map.of("Callback throwable", ChunkTaskScheduler.stringIfNull(throwable)), thr2);
            }
        }
    }

    public record TaskResult<L, R>(L left, R right) {
    }
}

