/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.brigadier.bukkit;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.minecraft.commands.CommandSource;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.server.TabCompleteEvent;

public class BukkitCommandNode
extends LiteralCommandNode<CommandSourceStack> {
    private final Command command;

    private BukkitCommandNode(String literal, Command command, BukkitBrigCommand bukkitBrigCommand) {
        super(literal, (com.mojang.brigadier.Command)bukkitBrigCommand, source -> {
            if (source instanceof net.minecraft.commands.CommandSourceStack) {
                net.minecraft.commands.CommandSourceStack commandSourceStack = (net.minecraft.commands.CommandSourceStack)source;
                if (commandSourceStack.source == CommandSource.NULL) {
                    return true;
                }
            }
            return command.testPermissionSilent(source.getSender());
        }, null, null, false);
        this.command = command;
    }

    public static BukkitCommandNode of(String name, Command command) {
        BukkitBrigCommand bukkitBrigCommand = new BukkitBrigCommand(command, name);
        BukkitCommandNode commandNode = new BukkitCommandNode(name, command, bukkitBrigCommand);
        commandNode.addChild((CommandNode)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)new BukkitBrigSuggestionProvider(command, name)).executes((com.mojang.brigadier.Command)bukkitBrigCommand)).build());
        return commandNode;
    }

    public Command getBukkitCommand() {
        return this.command;
    }

    public static class BukkitBrigCommand
    implements com.mojang.brigadier.Command<CommandSourceStack> {
        private final Command command;
        private final String literal;

        BukkitBrigCommand(Command command, String literal) {
            this.command = command;
            this.literal = literal;
        }

        public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            String content = context.getRange().get(context.getInput());
            String[] args = StringUtils.split((String)content, (char)' ');
            this.command.execute(sender, this.literal, Arrays.copyOfRange(args, 1, args.length));
            return 1;
        }
    }

    static class BukkitBrigSuggestionProvider
    implements SuggestionProvider<CommandSourceStack> {
        private final Command command;
        private final String literal;

        BukkitBrigSuggestionProvider(Command command, String literal) {
            this.command = command;
            this.literal = literal;
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            String[] args = builder.getRemaining().split(" ", -1);
            List results = null;
            Location pos = ((CommandSourceStack)context.getSource()).getLocation();
            try {
                results = this.command.tabComplete(sender, this.literal, args, pos.clone());
            }
            catch (CommandException ex) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "An internal error occurred while attempting to tab-complete this command");
                Bukkit.getServer().getLogger().log(Level.SEVERE, "Exception when " + sender.getName() + " attempted to tab complete " + builder.getRemaining(), ex);
            }
            if (sender instanceof Player) {
                Player player = (Player)sender;
                TabCompleteEvent tabEvent = new TabCompleteEvent((CommandSender)player, builder.getInput(), results != null ? results : new ArrayList(), true, pos);
                results = !tabEvent.callEvent() ? null : tabEvent.getCompletions();
            }
            if (results == null) {
                return builder.buildFuture();
            }
            builder = builder.createOffset(builder.getInput().lastIndexOf(32) + 1);
            for (String s : results) {
                builder.suggest(s);
            }
            return builder.buildFuture();
        }
    }
}

