/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.Table;
import com.mojang.logging.LogUtils;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import io.papermc.paper.configuration.ConfigurationLoaders;
import io.papermc.paper.configuration.ConfigurationPart;
import io.papermc.paper.configuration.Configurations;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.NestedSetting;
import io.papermc.paper.configuration.RemovedConfigurations;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.legacy.RequiresSpigotInitialization;
import io.papermc.paper.configuration.mapping.InnerClassFieldDiscoverer;
import io.papermc.paper.configuration.serializer.ComponentSerializer;
import io.papermc.paper.configuration.serializer.EnumValueSerializer;
import io.papermc.paper.configuration.serializer.NbtPathSerializer;
import io.papermc.paper.configuration.serializer.PacketClassSerializer;
import io.papermc.paper.configuration.serializer.StringRepresentableSerializer;
import io.papermc.paper.configuration.serializer.collections.FastutilMapSerializer;
import io.papermc.paper.configuration.serializer.collections.MapSerializer;
import io.papermc.paper.configuration.serializer.collections.TableSerializer;
import io.papermc.paper.configuration.serializer.registry.RegistryHolderSerializer;
import io.papermc.paper.configuration.serializer.registry.RegistryValueSerializer;
import io.papermc.paper.configuration.transformation.Transformations;
import io.papermc.paper.configuration.transformation.global.LegacyPaperConfig;
import io.papermc.paper.configuration.transformation.global.versioned.V29_LogIPs;
import io.papermc.paper.configuration.transformation.world.FeatureSeedsGeneration;
import io.papermc.paper.configuration.transformation.world.LegacyPaperWorldConfig;
import io.papermc.paper.configuration.transformation.world.versioned.V29_ZeroWorldHeight;
import io.papermc.paper.configuration.transformation.world.versioned.V30_RenameFilterNbtFromSpawnEgg;
import io.papermc.paper.configuration.transformation.world.versioned.V31_SpawnLoadedRangeToGameRule;
import io.papermc.paper.configuration.type.BooleanOrDefault;
import io.papermc.paper.configuration.type.Duration;
import io.papermc.paper.configuration.type.DurationOrDisabled;
import io.papermc.paper.configuration.type.EngineMode;
import io.papermc.paper.configuration.type.fallback.FallbackValueSerializer;
import io.papermc.paper.configuration.type.number.DoubleOr;
import io.papermc.paper.configuration.type.number.IntOr;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.apache.commons.lang3.RandomStringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.leavesmc.leaves.util.McTechnicalModeHelper;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.objectmapping.meta.NodeResolver;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class PaperConfigurations
extends Configurations<GlobalConfiguration, WorldConfiguration> {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    static final String GLOBAL_CONFIG_FILE_NAME = "paper-global.yml";
    static final String WORLD_DEFAULTS_CONFIG_FILE_NAME = "paper-world-defaults.yml";
    static final String WORLD_CONFIG_FILE_NAME = "paper-world.yml";
    public static final String CONFIG_DIR = "config";
    private static final String BACKUP_DIR = "legacy-backup";
    private static final String GLOBAL_HEADER = String.format("This is the global configuration file for Paper.\nAs you can see, there's a lot to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\n\nIf you need help with the configuration or have any questions related to Paper,\njoin us in our Discord or check the docs page.\n\nThe world configuration options have been moved inside\ntheir respective world folder. The files are named %s\n\nDocs: https://docs.papermc.io/\nDiscord: https://discord.gg/papermc\nWebsite: https://papermc.io/", "paper-world.yml");
    private static final String WORLD_DEFAULTS_HEADER = "This is the world defaults configuration file for Paper.\nAs you can see, there's a lot to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\n\nIf you need help with the configuration or have any questions related to Paper,\njoin us in our Discord or check the docs page.\n\nConfiguration options here apply to all worlds, unless you specify overrides inside\nthe world-specific config file inside each world folder.\n\nDocs: https://docs.papermc.io/\nDiscord: https://discord.gg/papermc\nWebsite: https://papermc.io/";
    private static final Function<Configurations.ContextMap, String> WORLD_HEADER = map -> String.format("This is a world configuration file for Paper.\nThis file may start empty but can be filled with settings to override ones in the %s/%s\n\nWorld: %s (%s)", CONFIG_DIR, WORLD_DEFAULTS_CONFIG_FILE_NAME, map.require(Configurations.WORLD_NAME), map.require(Configurations.WORLD_KEY));
    private static final String MOVED_NOTICE = "The global and world default configuration files have moved to %s\nand the world-specific configuration file has been moved inside\nthe respective world folder.\n\nSee https://docs.papermc.io/paper/configuration for more information.\n";
    @VisibleForTesting
    public static final Supplier<SpigotWorldConfig> SPIGOT_WORLD_DEFAULTS = Suppliers.memoize(() -> new SpigotWorldConfig(RandomStringUtils.randomAlphabetic((int)255)){

        @Override
        public void init() {
            SpigotConfig.readConfig(SpigotWorldConfig.class, this);
        }
    });
    public static final Configurations.ContextKey<Supplier<SpigotWorldConfig>> SPIGOT_WORLD_CONFIG_CONTEXT_KEY = new Configurations.ContextKey<Supplier<SpigotWorldConfig>>(new TypeToken<Supplier<SpigotWorldConfig>>(){}, "spigot world config");
    private static final List<Transformations.DefaultsAware> DEFAULT_AWARE_TRANSFORMATIONS = List.of(FeatureSeedsGeneration::apply);

    public PaperConfigurations(Path globalFolder) {
        super(globalFolder, GlobalConfiguration.class, WorldConfiguration.class, GLOBAL_CONFIG_FILE_NAME, WORLD_DEFAULTS_CONFIG_FILE_NAME, WORLD_CONFIG_FILE_NAME);
    }

    @Override
    protected int globalConfigVersion() {
        return 29;
    }

    @Override
    protected int worldConfigVersion() {
        return 31;
    }

    @Override
    protected YamlConfigurationLoader.Builder createLoaderBuilder() {
        return (YamlConfigurationLoader.Builder)super.createLoaderBuilder().defaultOptions(PaperConfigurations::defaultOptions);
    }

    private static ConfigurationOptions defaultOptions(ConfigurationOptions options) {
        return options.serializers(builder -> builder.register(MapSerializer.TYPE, (TypeSerializer)new MapSerializer(false)).register((ScalarSerializer)new EnumValueSerializer()).register((ScalarSerializer)new ComponentSerializer()));
    }

    @Override
    protected ObjectMapper.Factory.Builder createGlobalObjectMapperFactoryBuilder() {
        return PaperConfigurations.defaultGlobalFactoryBuilder(super.createGlobalObjectMapperFactoryBuilder());
    }

    private static ObjectMapper.Factory.Builder defaultGlobalFactoryBuilder(ObjectMapper.Factory.Builder builder) {
        return builder.addDiscoverer(InnerClassFieldDiscoverer.globalConfig());
    }

    @Override
    protected YamlConfigurationLoader.Builder createGlobalLoaderBuilder() {
        return (YamlConfigurationLoader.Builder)super.createGlobalLoaderBuilder().defaultOptions(PaperConfigurations::defaultGlobalOptions);
    }

    private static ConfigurationOptions defaultGlobalOptions(ConfigurationOptions options) {
        return options.header(GLOBAL_HEADER).serializers(builder -> builder.register((ScalarSerializer)new PacketClassSerializer()).register(IntOr.Default.SERIALIZER));
    }

    @Override
    public GlobalConfiguration initializeGlobalConfiguration(RegistryAccess registryAccess) throws ConfigurateException {
        GlobalConfiguration configuration = (GlobalConfiguration)super.initializeGlobalConfiguration(registryAccess);
        GlobalConfiguration.set(configuration);
        return configuration;
    }

    @Override
    protected Configurations.ContextMap.Builder createDefaultContextMap(RegistryAccess registryAccess) {
        return super.createDefaultContextMap(registryAccess).put(SPIGOT_WORLD_CONFIG_CONTEXT_KEY, SPIGOT_WORLD_DEFAULTS);
    }

    @Override
    protected ObjectMapper.Factory.Builder createWorldObjectMapperFactoryBuilder(Configurations.ContextMap contextMap) {
        return super.createWorldObjectMapperFactoryBuilder(contextMap).addNodeResolver((NodeResolver.Factory)new RequiresSpigotInitialization.Factory(contextMap.require(SPIGOT_WORLD_CONFIG_CONTEXT_KEY).get())).addNodeResolver((NodeResolver.Factory)new NestedSetting.Factory()).addDiscoverer(InnerClassFieldDiscoverer.worldConfig(PaperConfigurations.createWorldConfigInstance(contextMap)));
    }

    private static WorldConfiguration createWorldConfigInstance(Configurations.ContextMap contextMap) {
        return new WorldConfiguration(contextMap.require(SPIGOT_WORLD_CONFIG_CONTEXT_KEY).get(), contextMap.require(Configurations.WORLD_KEY));
    }

    @Override
    protected YamlConfigurationLoader.Builder createWorldConfigLoaderBuilder(Configurations.ContextMap contextMap) {
        RegistryAccess access = contextMap.require(Configurations.REGISTRY_ACCESS);
        return (YamlConfigurationLoader.Builder)super.createWorldConfigLoaderBuilder(contextMap).defaultOptions(options -> options.header(contextMap.require(Configurations.WORLD_NAME).equals("__world_defaults__") ? WORLD_DEFAULTS_HEADER : WORLD_HEADER.apply(contextMap)).serializers(serializers -> serializers.register(new TypeToken<Reference2IntMap<?>>(this){}, new FastutilMapSerializer.SomethingToPrimitive<Reference2IntMap>(Reference2IntOpenHashMap::new, Integer.TYPE)).register(new TypeToken<Reference2LongMap<?>>(this){}, new FastutilMapSerializer.SomethingToPrimitive<Reference2LongMap>(Reference2LongOpenHashMap::new, Long.TYPE)).register(new TypeToken<Table<?, ?, ?>>(this){}, (TypeSerializer)new TableSerializer()).register(StringRepresentableSerializer::isValidFor, (TypeSerializer)new StringRepresentableSerializer()).register(IntOr.Default.SERIALIZER).register(IntOr.Disabled.SERIALIZER).register(DoubleOr.Default.SERIALIZER).register(BooleanOrDefault.SERIALIZER).register((ScalarSerializer)Duration.SERIALIZER).register(DurationOrDisabled.SERIALIZER).register(EngineMode.SERIALIZER).register((ScalarSerializer)NbtPathSerializer.SERIALIZER).register((ScalarSerializer)FallbackValueSerializer.create(contextMap.require(SPIGOT_WORLD_CONFIG_CONTEXT_KEY).get(), MinecraftServer::getServer)).register(new RegistryValueSerializer(new TypeToken<EntityType<?>>(this){}, access, Registries.ENTITY_TYPE, true)).register(new RegistryValueSerializer<Item>(Item.class, access, Registries.ITEM, true)).register(new RegistryValueSerializer<Block>(Block.class, access, Registries.BLOCK, true)).register(new RegistryHolderSerializer(new TypeToken<ConfiguredFeature<?, ?>>(this){}, access, Registries.CONFIGURED_FEATURE, false))));
    }

    @Override
    protected void applyWorldConfigTransformations(Configurations.ContextMap contextMap, ConfigurationNode node, @Nullable ConfigurationNode defaultsNode) throws ConfigurateException {
        ConfigurationTransformation.Builder builder = ConfigurationTransformation.builder();
        for (NodePath path : RemovedConfigurations.REMOVED_WORLD_PATHS) {
            builder.addAction(path, TransformAction.remove());
        }
        builder.build().apply(node);
        ConfigurationTransformation.VersionedBuilder versionedBuilder = Transformations.versionedBuilder();
        V29_ZeroWorldHeight.apply(versionedBuilder);
        V30_RenameFilterNbtFromSpawnEgg.apply(versionedBuilder);
        V31_SpawnLoadedRangeToGameRule.apply(versionedBuilder, contextMap, defaultsNode);
        versionedBuilder.build().apply(node);
    }

    @Override
    protected void applyGlobalConfigTransformations(ConfigurationNode node) throws ConfigurateException {
        ConfigurationTransformation.Builder builder = ConfigurationTransformation.builder();
        for (NodePath path : RemovedConfigurations.REMOVED_GLOBAL_PATHS) {
            builder.addAction(path, TransformAction.remove());
        }
        builder.build().apply(node);
        ConfigurationTransformation.VersionedBuilder versionedBuilder = Transformations.versionedBuilder();
        V29_LogIPs.apply(versionedBuilder);
        versionedBuilder.build().apply(node);
    }

    @Override
    protected void applyDefaultsAwareWorldConfigTransformations(Configurations.ContextMap contextMap, ConfigurationNode worldNode, ConfigurationNode defaultsNode) throws ConfigurateException {
        ConfigurationTransformation.Builder builder = ConfigurationTransformation.builder();
        DEFAULT_AWARE_TRANSFORMATIONS.forEach(transform -> transform.apply(builder, contextMap, defaultsNode));
        builder.build().apply(worldNode);
    }

    @Override
    public WorldConfiguration createWorldConfig(Configurations.ContextMap contextMap) {
        String levelName = contextMap.require(Configurations.WORLD_NAME);
        try {
            return (WorldConfiguration)super.createWorldConfig(contextMap);
        }
        catch (IOException exception) {
            throw new RuntimeException("Could not create world config for " + levelName, exception);
        }
    }

    @Override
    protected boolean isConfigType(Type type) {
        return ConfigurationPart.class.isAssignableFrom(GenericTypeReflector.erase((Type)type));
    }

    public void reloadConfigs(MinecraftServer server) {
        try {
            this.initializeGlobalConfiguration(PaperConfigurations.reloader(this.globalConfigClass, GlobalConfiguration.get()));
            this.initializeWorldDefaultsConfiguration(server.registryAccess());
            for (ServerLevel level : server.getAllLevels()) {
                this.createWorldConfig(PaperConfigurations.createWorldContextMap(level), PaperConfigurations.reloader(this.worldConfigClass, level.paperConfig()));
            }
            McTechnicalModeHelper.doMcTechnicalModeIf();
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not reload paper configuration files", ex);
        }
    }

    private static Configurations.ContextMap createWorldContextMap(ServerLevel level) {
        return PaperConfigurations.createWorldContextMap(level.convertable.levelDirectory.path(), level.serverLevelData.getLevelName(), level.dimension().location(), level.spigotConfig, level.registryAccess(), level.getGameRules());
    }

    public static Configurations.ContextMap createWorldContextMap(Path dir, String levelName, ResourceLocation worldKey, SpigotWorldConfig spigotConfig, RegistryAccess registryAccess, GameRules gameRules) {
        return Configurations.ContextMap.builder().put(Configurations.WORLD_DIRECTORY, dir).put(Configurations.WORLD_NAME, levelName).put(Configurations.WORLD_KEY, worldKey).put(SPIGOT_WORLD_CONFIG_CONTEXT_KEY, Suppliers.ofInstance((Object)spigotConfig)).put(Configurations.REGISTRY_ACCESS, registryAccess).put(Configurations.GAME_RULES, gameRules).build();
    }

    public static PaperConfigurations setup(Path legacyConfig, Path configDir, Path worldFolder, File spigotConfig) throws Exception {
        Path legacy;
        Path path = legacy = Files.isSymbolicLink(legacyConfig) ? Files.readSymbolicLink(legacyConfig) : legacyConfig;
        if (PaperConfigurations.needsConverting(legacyConfig)) {
            String legacyFileName = legacyConfig.getFileName().toString();
            try {
                Path replacementFile;
                if (Files.exists(configDir, new LinkOption[0]) && !Files.isDirectory(configDir, new LinkOption[0])) {
                    throw new RuntimeException("Paper needs to create a '" + String.valueOf(configDir.toAbsolutePath()) + "' folder. You already have a non-directory named '" + String.valueOf(configDir.toAbsolutePath()) + "'. Please remove it and restart the server.");
                }
                Path backupDir = configDir.resolve(BACKUP_DIR);
                if (Files.exists(backupDir, new LinkOption[0]) && !Files.isDirectory(backupDir, new LinkOption[0])) {
                    throw new RuntimeException("Paper needs to create a 'legacy-backup' directory in the '" + String.valueOf(configDir.toAbsolutePath()) + "' folder. You already have a non-directory named 'legacy-backup'. Please remove it and restart the server.");
                }
                PaperConfigurations.createDirectoriesSymlinkAware(backupDir);
                String backupFileName = legacyFileName + ".old";
                Path legacyConfigBackup = backupDir.resolve(backupFileName);
                if (Files.exists(legacyConfigBackup, new LinkOption[0]) && !Files.isRegularFile(legacyConfigBackup, new LinkOption[0])) {
                    throw new RuntimeException("Paper needs to create a '" + backupFileName + "' file in the '" + String.valueOf(backupDir.toAbsolutePath()) + "' folder. You already have a non-file named '" + backupFileName + "'. Please remove it and restart the server.");
                }
                Files.move(legacyConfig.toRealPath(new LinkOption[0]), legacyConfigBackup, StandardCopyOption.REPLACE_EXISTING);
                if (Files.isSymbolicLink(legacyConfig)) {
                    Files.delete(legacyConfig);
                }
                if (Files.notExists(replacementFile = legacy.resolveSibling(legacyFileName + "-README.txt"), new LinkOption[0])) {
                    Files.createFile(replacementFile, new FileAttribute[0]);
                    Files.writeString(replacementFile, (CharSequence)String.format(MOVED_NOTICE, configDir.toAbsolutePath()), new OpenOption[0]);
                }
                PaperConfigurations.convert(legacyConfigBackup, configDir, worldFolder, spigotConfig);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not convert '" + legacyFileName + "' to the new configuration format", ex);
            }
        }
        try {
            PaperConfigurations.createDirectoriesSymlinkAware(configDir);
            return new PaperConfigurations(configDir);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not setup PaperConfigurations", ex);
        }
    }

    private static void convert(Path legacyConfig, Path configDir, Path worldFolder, File spigotConfig) throws Exception {
        PaperConfigurations.createDirectoriesSymlinkAware(configDir);
        YamlConfigurationLoader legacyLoader = ConfigurationLoaders.naturallySortedWithoutHeader(legacyConfig);
        YamlConfigurationLoader globalLoader = ConfigurationLoaders.naturallySortedWithoutHeader(configDir.resolve(GLOBAL_CONFIG_FILE_NAME));
        YamlConfigurationLoader worldDefaultsLoader = ConfigurationLoaders.naturallySortedWithoutHeader(configDir.resolve(WORLD_DEFAULTS_CONFIG_FILE_NAME));
        ConfigurationNode legacy = legacyLoader.load();
        Preconditions.checkState((!legacy.virtual() ? 1 : 0) != 0, (Object)"can't be virtual");
        int version = legacy.node(new Object[]{"config-version"}).getInt();
        ConfigurationNode legacyWorldSettings = legacy.node(new Object[]{"world-settings"}).copy();
        Preconditions.checkState((!legacyWorldSettings.virtual() ? 1 : 0) != 0, (Object)"can't be virtual");
        legacy.removeChild((Object)"world-settings");
        YamlConfiguration spigotConfiguration = PaperConfigurations.loadLegacyConfigFile(spigotConfig);
        LegacyPaperConfig.transformation(spigotConfiguration).apply(legacy);
        spigotConfiguration.save(spigotConfig);
        legacy.mergeFrom(legacy.node(new Object[]{"settings"}));
        legacy.removeChild((Object)"settings");
        LegacyPaperConfig.toNewFormat().apply(legacy);
        globalLoader.save(legacy);
        ConfigurationNode worldDefaults = legacyWorldSettings.node(new Object[]{"default"}).copy();
        Preconditions.checkState((!worldDefaults.virtual() ? 1 : 0) != 0);
        worldDefaults.node(new Object[]{"config-version"}).raw((Object)version);
        legacyWorldSettings.removeChild((Object)"default");
        LegacyPaperWorldConfig.transformation().apply(worldDefaults);
        LegacyPaperWorldConfig.toNewFormat().apply(worldDefaults);
        worldDefaultsLoader.save(worldDefaults);
        legacyWorldSettings.childrenMap().forEach((world, legacyWorldNode) -> {
            try {
                legacyWorldNode.node(new Object[]{"config-version"}).raw((Object)version);
                LegacyPaperWorldConfig.transformation().apply(legacyWorldNode);
                LegacyPaperWorldConfig.toNewFormat().apply(legacyWorldNode);
                ConfigurationLoaders.naturallySortedWithoutHeader(worldFolder.resolve(world.toString()).resolve(WORLD_CONFIG_FILE_NAME)).save(legacyWorldNode);
            }
            catch (ConfigurateException ex) {
                ex.printStackTrace();
            }
        });
    }

    private static boolean needsConverting(Path legacyConfig) {
        return Files.exists(legacyConfig, new LinkOption[0]) && Files.isRegularFile(legacyConfig, new LinkOption[0]);
    }

    @Deprecated
    public YamlConfiguration createLegacyObject(MinecraftServer server) {
        YamlConfiguration global = YamlConfiguration.loadConfiguration((File)this.globalFolder.resolve(this.globalConfigFileName).toFile());
        ConfigurationSection worlds = global.createSection("__________WORLDS__________");
        worlds.set("__defaults__", (Object)YamlConfiguration.loadConfiguration((File)this.globalFolder.resolve(this.defaultWorldConfigFileName).toFile()));
        for (ServerLevel level : server.getAllLevels()) {
            worlds.set(level.getWorld().getName(), (Object)YamlConfiguration.loadConfiguration((File)this.getWorldConfigFile(level).toFile()));
        }
        return global;
    }

    @Deprecated
    public static YamlConfiguration loadLegacyConfigFile(File configFile) throws Exception {
        YamlConfiguration config = new YamlConfiguration();
        if (configFile.exists()) {
            try {
                config.load(configFile);
            }
            catch (Exception ex) {
                throw new Exception("Failed to load configuration file: " + configFile.getName(), ex);
            }
        }
        return config;
    }

    @VisibleForTesting
    static ConfigurationNode createForTesting() {
        ObjectMapper.Factory factory = PaperConfigurations.defaultGlobalFactoryBuilder(ObjectMapper.factoryBuilder()).build();
        ConfigurationOptions options = PaperConfigurations.defaultGlobalOptions(PaperConfigurations.defaultOptions(ConfigurationOptions.defaults())).serializers(builder -> builder.register(type -> ConfigurationPart.class.isAssignableFrom(GenericTypeReflector.erase((Type)type)), factory.asTypeSerializer()));
        return BasicConfigurationNode.root((ConfigurationOptions)options);
    }

    static void createDirectoriesSymlinkAware(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }
}

