/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.transformation.world;

import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.transformation.Transformations;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import org.bukkit.Material;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public final class LegacyPaperWorldConfig {
    private LegacyPaperWorldConfig() {
    }

    public static ConfigurationTransformation transformation() {
        return ConfigurationTransformation.chain((ConfigurationTransformation[])new ConfigurationTransformation[]{LegacyPaperWorldConfig.versioned(), LegacyPaperWorldConfig.notVersioned()});
    }

    private static ConfigurationTransformation.Versioned versioned() {
        return ConfigurationTransformation.versionedBuilder().versionKey(new Object[]{"config-version"}).addVersion(13, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"enable-old-tnt-cannon-behaviors"}), TransformAction.rename((Object)"prevent-tnt-from-moving-in-water")).build()).addVersion(16, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"use-chunk-inhabited-timer"}), (path, value) -> {
            if (!value.getBoolean(true)) {
                value.raw((Object)0);
            } else {
                value.raw((Object)-1);
            }
            Object[] newPath = path.array();
            newPath[newPath.length - 1] = "fixed-chunk-inhabited-time";
            return newPath;
        }).build()).addVersion(18, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"nether-ceiling-void-damage"}), (path, value) -> {
            if (value.getBoolean(false)) {
                value.raw((Object)128);
            } else {
                value.raw((Object)0);
            }
            Object[] newPath = path.array();
            newPath[newPath.length - 1] = "nether-ceiling-void-damage-height";
            return newPath;
        }).build()).addVersion(19, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"anti-xray", "hidden-blocks"}), (path, value) -> {
            @Nullable List hiddenBlocks = value.getList(String.class);
            if (hiddenBlocks != null) {
                hiddenBlocks.remove("lit_redstone_ore");
            }
            return null;
        }).addAction(NodePath.path((Object[])new Object[]{"anti-xray", "replacement-blocks"}), (path, value) -> {
            int index;
            @Nullable List replacementBlocks = value.getList(String.class);
            if (replacementBlocks != null && (index = replacementBlocks.indexOf("planks")) != -1) {
                replacementBlocks.set(index, "oak_planks");
            }
            value.raw((Object)replacementBlocks);
            return null;
        }).build()).addVersion(20, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"baby-zombie-movement-speed"}), TransformAction.rename((Object)"baby-zombie-movement-modifier")).build()).addVersion(22, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"per-player-mob-spawns"}), (path, value) -> {
            value.raw((Object)true);
            return null;
        }).build()).addVersion(24, new ConfigurationTransformation[]{ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"spawn-limits", "monsters"}), TransformAction.rename((Object)"monster")).addAction(NodePath.path((Object[])new Object[]{"spawn-limits", "animals"}), TransformAction.rename((Object)"creature")).addAction(NodePath.path((Object[])new Object[]{"spawn-limits", "water-animals"}), TransformAction.rename((Object)"water_creature")).addAction(NodePath.path((Object[])new Object[]{"spawn-limits", "water-ambient"}), TransformAction.rename((Object)"water_ambient")).build(), ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"despawn-ranges"}), (path, value) -> {
            int softDistance = value.node(new Object[]{"soft"}).getInt(32);
            int hardDistance = value.node(new Object[]{"hard"}).getInt(128);
            value.node(new Object[]{"soft"}).raw(null);
            value.node(new Object[]{"hard"}).raw(null);
            for (MobCategory category : MobCategory.values()) {
                if (softDistance != 32) {
                    value.node(new Object[]{category.getName(), "soft"}).raw((Object)softDistance);
                }
                if (hardDistance == 128) continue;
                value.node(new Object[]{category.getName(), "hard"}).raw((Object)hardDistance);
            }
            return null;
        }).build()}).addVersion(26, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"alt-item-despawn-rate", "items", ConfigurationTransformation.WILDCARD_OBJECT}), (path, value) -> {
            String itemName = path.get(path.size() - 1).toString();
            Optional<Holder.Reference<Item>> item = BuiltInRegistries.ITEM.getHolder(ResourceKey.create(Registries.ITEM, new ResourceLocation(itemName.toLowerCase(Locale.ROOT))));
            if (item.isEmpty()) {
                itemName = Material.valueOf((String)itemName).getKey().getKey();
            }
            Object[] newPath = path.array();
            newPath[newPath.length - 1] = itemName;
            return newPath;
        }).build()).addVersion(27, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"use-faster-eigencraft-redstone"}), (path, value) -> {
            WorldConfiguration.Misc.RedstoneImplementation redstoneImplementation = value.getBoolean(false) ? WorldConfiguration.Misc.RedstoneImplementation.EIGENCRAFT : WorldConfiguration.Misc.RedstoneImplementation.VANILLA;
            value.set((Object)redstoneImplementation);
            Object[] newPath = path.array();
            newPath[newPath.length - 1] = "redstone-implementation";
            return newPath;
        }).build()).build();
    }

    private static ConfigurationTransformation notVersioned() {
        return ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"treasure-maps-return-already-discovered"}), (path, value) -> {
            boolean prevValue = value.getBoolean(false);
            value.node(new Object[]{"villager-trade"}).set((Object)prevValue);
            value.node(new Object[]{"loot-tables"}).set((Object)prevValue);
            return path.with(path.size() - 1, (Object)"treasure-maps-find-already-discovered").array();
        }).addAction(NodePath.path((Object[])new Object[]{"alt-item-despawn-rate", "items"}), (path, value) -> {
            if (value.isMap()) {
                HashMap rebuild = new HashMap();
                value.childrenMap().forEach((key, node) -> {
                    Material bukkitMat;
                    String itemName = key.toString();
                    Optional<Holder.Reference<Item>> itemHolder = BuiltInRegistries.ITEM.getHolder(ResourceKey.create(Registries.ITEM, new ResourceLocation(itemName.toLowerCase(Locale.ROOT))));
                    String item = itemHolder.isEmpty() ? ((bukkitMat = Material.matchMaterial((String)itemName)) != null ? bukkitMat.getKey().getKey() : null) : itemHolder.get().unwrapKey().orElseThrow().location().getPath();
                    if (item != null) {
                        rebuild.put(item, node.getInt());
                    }
                });
                value.set(rebuild);
            }
            return null;
        }).build();
    }

    public static ConfigurationTransformation toNewFormat() {
        return ConfigurationTransformation.chain((ConfigurationTransformation[])new ConfigurationTransformation[]{ConfigurationTransformation.versionedBuilder().versionKey(new Object[]{"config-version"}).addVersion(28, LegacyPaperWorldConfig.newFormatTransformation()).build(), ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"config-version"}), TransformAction.rename((Object)"_version")).build()});
    }

    private static ConfigurationTransformation newFormatTransformation() {
        ConfigurationTransformation.Builder builder = ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"verbose"}), TransformAction.remove());
        Transformations.moveFromRoot(builder, "anti-xray", "anticheat");
        Transformations.moveFromRootAndRename(builder, "armor-stands-do-collision-entity-lookups", "do-collision-entity-lookups", "entities", "armor-stands");
        Transformations.moveFromRootAndRename(builder, "armor-stands-tick", "tick", "entities", "armor-stands");
        Transformations.moveFromRoot(builder, "auto-save-interval", "chunks");
        Transformations.moveFromRoot(builder, "delay-chunk-unloads-by", "chunks");
        Transformations.moveFromRoot(builder, "entity-per-chunk-save-limit", "chunks");
        Transformations.moveFromRoot(builder, "fixed-chunk-inhabited-time", "chunks");
        Transformations.moveFromRoot(builder, "max-auto-save-chunks-per-tick", "chunks");
        Transformations.moveFromRoot(builder, "prevent-moving-into-unloaded-chunks", "chunks");
        Transformations.moveFromRoot(builder, "entities-target-with-follow-range", "entities");
        Transformations.moveFromRoot(builder, "mob-effects", "entities");
        Transformations.moveFromRoot(builder, "filter-nbt-data-from-spawn-eggs-and-related", "entities", "spawning");
        LegacyPaperWorldConfig.moveFromGameMechanics(builder, "disable-mob-spawner-spawn-egg-transformation", "entities", "spawning");
        Transformations.moveFromRoot(builder, "per-player-mob-spawns", "entities", "spawning");
        LegacyPaperWorldConfig.moveFromGameMechanics(builder, "scan-for-legacy-ender-dragon", "entities", "spawning");
        Transformations.moveFromRoot(builder, "spawn-limits", "entities", "spawning");
        Transformations.moveFromRoot(builder, "despawn-ranges", "entities", "spawning");
        Transformations.moveFromRoot(builder, "wateranimal-spawn-height", "entities", "spawning");
        builder.addAction(NodePath.path((Object[])new Object[]{"slime-spawn-height", "swamp-biome"}), TransformAction.rename((Object)"surface-biome"));
        Transformations.moveFromRoot(builder, "slime-spawn-height", "entities", "spawning");
        Transformations.moveFromRoot(builder, "wandering-trader", "entities", "spawning");
        Transformations.moveFromRoot(builder, "all-chunks-are-slime-chunks", "entities", "spawning");
        Transformations.moveFromRoot(builder, "skeleton-horse-thunder-spawn-chance", "entities", "spawning");
        Transformations.moveFromRoot(builder, "iron-golems-can-spawn-in-air", "entities", "spawning");
        Transformations.moveFromRoot(builder, "alt-item-despawn-rate", "entities", "spawning");
        Transformations.moveFromRoot(builder, "count-all-mobs-for-spawning", "entities", "spawning");
        Transformations.moveFromRoot(builder, "creative-arrow-despawn-rate", "entities", "spawning");
        Transformations.moveFromRoot(builder, "non-player-arrow-despawn-rate", "entities", "spawning");
        Transformations.moveFromRoot(builder, "monster-spawn-max-light-level", "entities", "spawning");
        Transformations.moveFromRootAndRename(builder, "duplicate-uuid-saferegen-delete-range", "safe-regen-delete-range", "entities", "spawning", "duplicate-uuid");
        Transformations.moveFromRoot(builder, "baby-zombie-movement-modifier", "entities", "behavior");
        Transformations.moveFromRoot(builder, "disable-creeper-lingering-effect", "entities", "behavior");
        Transformations.moveFromRoot(builder, "door-breaking-difficulty", "entities", "behavior");
        LegacyPaperWorldConfig.moveFromGameMechanics(builder, "disable-chest-cat-detection", "entities", "behavior");
        LegacyPaperWorldConfig.moveFromGameMechanics(builder, "disable-player-crits", "entities", "behavior");
        Transformations.moveFromRoot(builder, "experience-merge-max-value", "entities", "behavior");
        Transformations.moveFromRoot(builder, "mobs-can-always-pick-up-loot", "entities", "behavior");
        LegacyPaperWorldConfig.moveFromGameMechanics(builder, "nerf-pigmen-from-nether-portals", "entities", "behavior");
        Transformations.moveFromRoot(builder, "parrots-are-unaffected-by-player-movement", "entities", "behavior");
        Transformations.moveFromRoot(builder, "phantoms-do-not-spawn-on-creative-players", "entities", "behavior");
        Transformations.moveFromRoot(builder, "phantoms-only-attack-insomniacs", "entities", "behavior");
        Transformations.moveFromRoot(builder, "piglins-guard-chests", "entities", "behavior");
        Transformations.moveFromRoot(builder, "spawner-nerfed-mobs-should-jump", "entities", "behavior");
        Transformations.moveFromRoot(builder, "zombie-villager-infection-chance", "entities", "behavior");
        Transformations.moveFromRoot(builder, "zombies-target-turtle-eggs", "entities", "behavior");
        Transformations.moveFromRoot(builder, "ender-dragons-death-always-places-dragon-egg", "entities", "behavior");
        LegacyPaperWorldConfig.moveFromGameMechanicsAndRename(builder, "disable-pillager-patrols", "disable", "game-mechanics", "pillager-patrols");
        LegacyPaperWorldConfig.moveFromGameMechanics(builder, "pillager-patrols", "entities", "behavior");
        Transformations.moveFromRoot(builder, "should-remove-dragon", "entities", "behavior");
        Transformations.moveFromRootAndRename(builder, "map-item-frame-cursor-limit", "item-frame-cursor-limit", "maps");
        Transformations.moveFromRootAndRename(builder, "map-item-frame-cursor-update-interval", "item-frame-cursor-update-interval", "maps");
        Transformations.moveFromRootAndRename(builder, "mob-spawner-tick-rate", "mob-spawner", "tick-rates");
        Transformations.moveFromRootAndRename(builder, "container-update-tick-rate", "container-update", "tick-rates");
        Transformations.moveFromRootAndRename(builder, "grass-spread-tick-rate", "grass-spread", "tick-rates");
        Transformations.moveFromRoot(builder, "allow-non-player-entities-on-scoreboards", "scoreboards");
        Transformations.moveFromRoot(builder, "use-vanilla-world-scoreboard-name-coloring", "scoreboards");
        Transformations.moveFromRoot(builder, "disable-thunder", "environment");
        Transformations.moveFromRoot(builder, "disable-ice-and-snow", "environment");
        Transformations.moveFromRoot(builder, "optimize-explosions", "environment");
        Transformations.moveFromRoot(builder, "disable-explosion-knockback", "environment");
        Transformations.moveFromRoot(builder, "frosted-ice", "environment");
        Transformations.moveFromRoot(builder, "disable-teleportation-suffocation-check", "environment");
        Transformations.moveFromRoot(builder, "portal-create-radius", "environment");
        Transformations.moveFromRoot(builder, "portal-search-radius", "environment");
        Transformations.moveFromRoot(builder, "portal-search-vanilla-dimension-scaling", "environment");
        Transformations.moveFromRootAndRename(builder, "enable-treasure-maps", "enabled", "environment", "treasure-maps");
        Transformations.moveFromRootAndRename(builder, "treasure-maps-find-already-discovered", "find-already-discovered", "environment", "treasure-maps");
        Transformations.moveFromRoot(builder, "water-over-lava-flow-speed", "environment");
        Transformations.moveFromRoot(builder, "nether-ceiling-void-damage-height", "environment");
        Transformations.moveFromRoot(builder, "keep-spawn-loaded", "spawn");
        Transformations.moveFromRoot(builder, "keep-spawn-loaded-range", "spawn");
        Transformations.moveFromRoot(builder, "allow-using-signs-inside-spawn-protection", "spawn");
        Transformations.moveFromRoot(builder, "max-entity-collisions", "collisions");
        Transformations.moveFromRoot(builder, "allow-vehicle-collisions", "collisions");
        Transformations.moveFromRoot(builder, "fix-climbing-bypassing-cramming-rule", "collisions");
        Transformations.moveFromRoot(builder, "only-players-collide", "collisions");
        Transformations.moveFromRoot(builder, "allow-player-cramming-damage", "collisions");
        Transformations.moveFromRoot(builder, "falling-block-height-nerf", "fixes");
        Transformations.moveFromRoot(builder, "fix-items-merging-through-walls", "fixes");
        Transformations.moveFromRoot(builder, "prevent-tnt-from-moving-in-water", "fixes");
        Transformations.moveFromRoot(builder, "remove-corrupt-tile-entities", "fixes");
        Transformations.moveFromRoot(builder, "split-overstacked-loot", "fixes");
        Transformations.moveFromRoot(builder, "tnt-entity-height-nerf", "fixes");
        Transformations.moveFromRoot(builder, "fix-wither-targeting-bug", "fixes");
        LegacyPaperWorldConfig.moveFromGameMechanics(builder, "disable-unloaded-chunk-enderpearl-exploit", "fixes");
        LegacyPaperWorldConfig.moveFromGameMechanics(builder, "fix-curing-zombie-villager-discount-exploit", "fixes");
        builder.addAction(NodePath.path((Object[])new Object[]{"fishing-time-range", "MaximumTicks"}), TransformAction.rename((Object)"maximum"));
        builder.addAction(NodePath.path((Object[])new Object[]{"fishing-time-range", "MinimumTicks"}), TransformAction.rename((Object)"minimum"));
        builder.addAction(NodePath.path((Object[])new Object[]{"generator-settings", "flat-bedrock"}), (path, value) -> new Object[]{"environment", "generate-flat-bedrock"});
        builder.addAction(NodePath.path((Object[])new Object[]{"generator-settings"}), TransformAction.remove());
        builder.addAction(NodePath.path((Object[])new Object[]{"game-mechanics", ConfigurationTransformation.WILDCARD_OBJECT}), (path, value) -> new Object[]{"misc", path.array()[1]});
        builder.addAction(NodePath.path((Object[])new Object[]{"game-mechanics"}), TransformAction.remove());
        builder.addAction(NodePath.path((Object[])new Object[]{"feature-seeds", ConfigurationTransformation.WILDCARD_OBJECT}), (path, value) -> {
            String key = path.array()[path.size() - 1].toString();
            if (!key.equals("generate-random-seeds-for-all")) {
                return new Object[]{"feature-seeds", "features", key};
            }
            return null;
        });
        builder.addAction(NodePath.path((Object[])new Object[]{"duplicate-uuid-resolver"}), (path, value) -> {
            WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode duplicateUUIDMode = switch ((String)value.require(String.class)) {
                case "regen", "regenerate", "saferegen", "saferegenerate" -> WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN;
                case "remove", "delete" -> WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.DELETE;
                case "silent", "nothing" -> WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.NOTHING;
                default -> WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.WARN;
            };
            value.set((Object)duplicateUUIDMode);
            return new Object[]{"entities", "spawning", "duplicate-uuid", "mode"};
        });
        builder.addAction(NodePath.path((Object[])new Object[]{"redstone-implementation"}), (path, value) -> {
            if (((String)value.require(String.class)).equalsIgnoreCase("alternate-current")) {
                value.set((Object)"alternate_current");
            }
            return new Object[]{"misc", "redstone-implementation"};
        });
        LegacyPaperWorldConfig.moveToMisc(builder, "light-queue-size");
        LegacyPaperWorldConfig.moveToMisc(builder, "update-pathfinding-on-block-update");
        LegacyPaperWorldConfig.moveToMisc(builder, "show-sign-click-command-failure-msgs-to-player");
        LegacyPaperWorldConfig.moveToMisc(builder, "max-leash-distance");
        return builder.build();
    }

    private static void moveToMisc(ConfigurationTransformation.Builder builder, String ... key) {
        Transformations.moveFromRootAndRename(builder, NodePath.path((Object[])key), key[key.length - 1], "misc");
    }

    private static void moveFromGameMechanics(ConfigurationTransformation.Builder builder, String key, String ... parents) {
        LegacyPaperWorldConfig.moveFromGameMechanicsAndRename(builder, key, key, parents);
    }

    private static void moveFromGameMechanicsAndRename(ConfigurationTransformation.Builder builder, String oldKey, String newKey, String ... parents) {
        Transformations.moveFromRootAndRename(builder, NodePath.path((Object[])new Object[]{"game-mechanics", oldKey}), newKey, parents);
    }
}

