/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.dependency;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.PluginProvider;
import io.papermc.paper.plugin.provider.entrypoint.DependencyContext;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class MetaDependencyTree
implements DependencyContext {
    protected final MutableGraph<String> graph;
    protected final Set<String> dependencies = new HashSet<String>();

    public MetaDependencyTree() {
        this((MutableGraph<String>)GraphBuilder.directed().build());
    }

    public MetaDependencyTree(MutableGraph<String> graph) {
        this.graph = graph;
    }

    public void add(PluginMeta configuration) {
        String identifier = configuration.getName();
        this.registerDependencies(identifier, configuration);
        this.graph.addNode((Object)identifier);
        for (String provides : configuration.getProvidedPlugins()) {
            this.graph.putEdge((Object)identifier, (Object)provides);
            this.dependencies.add(provides);
        }
        this.dependencies.add(identifier);
    }

    protected abstract void registerDependencies(String var1, PluginMeta var2);

    public void remove(PluginMeta configuration) {
        String identifier = configuration.getName();
        this.unregisterDependencies(identifier, configuration);
        this.graph.removeNode((Object)identifier);
        for (String provides : configuration.getProvidedPlugins()) {
            this.graph.removeEdge((Object)identifier, (Object)provides);
            this.dependencies.remove(provides);
        }
        this.dependencies.remove(identifier);
    }

    protected abstract void unregisterDependencies(String var1, PluginMeta var2);

    public boolean isTransitiveDependency(@NotNull PluginMeta plugin, @NotNull PluginMeta depend) {
        String pluginIdentifier = plugin.getName();
        if (this.graph.nodes().contains(pluginIdentifier)) {
            Set reachableNodes = Graphs.reachableNodes(this.graph, (Object)pluginIdentifier);
            if (reachableNodes.contains(depend.getName())) {
                return true;
            }
            for (String provided : depend.getProvidedPlugins()) {
                if (!reachableNodes.contains(provided)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDependency(@NotNull String pluginIdentifier) {
        return this.dependencies.contains(pluginIdentifier);
    }

    public void addDirectDependency(String dependency) {
        this.dependencies.add(dependency);
    }

    public String toString() {
        return "SimpleDependencyTree{graph=" + String.valueOf(this.graph) + "}";
    }

    public MutableGraph<String> getGraph() {
        return this.graph;
    }

    public void add(PluginProvider<?> provider) {
        this.add(provider.getMeta());
    }

    public void remove(PluginProvider<?> provider) {
        this.remove(provider.getMeta());
    }
}

