/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.source;

import com.mojang.logging.LogUtils;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.entrypoint.EntrypointHandler;
import io.papermc.paper.plugin.provider.source.FileProviderSource;
import io.papermc.paper.plugin.provider.source.ProviderSource;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class PluginFlagProviderSource
implements ProviderSource<List<Path>, List<Path>> {
    public static final PluginFlagProviderSource INSTANCE = new PluginFlagProviderSource();
    private static final FileProviderSource FILE_PROVIDER_SOURCE = new FileProviderSource(arg_0 -> PluginFlagProviderSource.lambda$static$0("File '%s' specified through 'add-plugin' argument", arg_0), false);
    private static final Logger LOGGER = LogUtils.getClassLogger();

    @Override
    public List<Path> prepareContext(List<Path> context) {
        ArrayList<Path> files = new ArrayList<Path>();
        for (Path path : context) {
            try {
                files.add(FILE_PROVIDER_SOURCE.prepareContext(path));
            }
            catch (Exception e) {
                LOGGER.error("Error preparing plugin context: " + e.getMessage(), (Throwable)e);
            }
        }
        if (PluginInitializerManager.instance().pluginRemapper != null && !files.isEmpty()) {
            return PluginInitializerManager.instance().pluginRemapper.rewriteExtraPlugins(files);
        }
        return files;
    }

    @Override
    public void registerProviders(EntrypointHandler entrypointHandler, List<Path> context) {
        for (Path path : context) {
            try {
                FILE_PROVIDER_SOURCE.registerProviders(entrypointHandler, path);
            }
            catch (Exception e) {
                LOGGER.error("Error loading plugin: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
        return "File '%s' specified through 'add-plugin' argument".formatted(xva$0);
    }
}

