/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.google.common.hash.HashCode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public final class Hashing {
    private Hashing() {
    }

    public static String sha256(InputStream stream) {
        String string;
        block8: {
            InputStream inputStream = stream;
            try {
                string = com.google.common.hash.Hashing.sha256().hashBytes(IOUtils.toByteArray((InputStream)stream)).toString().toUpperCase(Locale.ROOT);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to take hash of InputStream", ex);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static String sha256(Path file) {
        HashCode hash;
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("'" + String.valueOf(file) + "' is not a regular file!");
        }
        try {
            hash = com.google.common.io.Files.asByteSource((File)file.toFile()).hash(com.google.common.hash.Hashing.sha256());
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to take hash of file '" + String.valueOf(file) + "'", ex);
        }
        return hash.toString().toUpperCase(Locale.ROOT);
    }
}

