/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TickThread
extends Thread {
    public static final boolean STRICT_THREAD_CHECKS = Boolean.getBoolean("paper.strict-thread-checks");
    public final int id;
    private static final AtomicInteger ID_GENERATOR;

    @Deprecated
    public static void softEnsureTickThread(String reason) {
        if (!STRICT_THREAD_CHECKS) {
            return;
        }
        TickThread.ensureTickThread(reason);
    }

    @Deprecated
    public static void ensureTickThread(String reason) {
        if (!TickThread.isTickThread()) {
            MinecraftServer.LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(ServerLevel world, BlockPos pos, String reason) {
        if (!TickThread.isTickThreadFor(world, pos)) {
            MinecraftServer.LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(ServerLevel world, ChunkPos pos, String reason) {
        if (!TickThread.isTickThreadFor(world, pos)) {
            MinecraftServer.LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(ServerLevel world, int chunkX, int chunkZ, String reason) {
        if (!TickThread.isTickThreadFor(world, chunkX, chunkZ)) {
            MinecraftServer.LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(Entity entity, String reason) {
        if (!TickThread.isTickThreadFor(entity)) {
            MinecraftServer.LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(ServerLevel world, AABB aabb, String reason) {
        if (!TickThread.isTickThreadFor(world, aabb)) {
            MinecraftServer.LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(ServerLevel world, double blockX, double blockZ, String reason) {
        if (!TickThread.isTickThreadFor(world, blockX, blockZ)) {
            MinecraftServer.LOGGER.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public TickThread(String name) {
        this((Runnable)null, name);
    }

    public TickThread(Runnable run, String name) {
        this(run, name, ID_GENERATOR.incrementAndGet());
    }

    private TickThread(Runnable run, String name, int id) {
        super(run, name);
        this.id = id;
    }

    public static TickThread getCurrentTickThread() {
        return (TickThread)Thread.currentThread();
    }

    public static boolean isTickThread() {
        return Thread.currentThread() instanceof TickThread;
    }

    public static boolean isShutdownThread() {
        return false;
    }

    public static boolean isTickThreadFor(ServerLevel world, BlockPos pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(ServerLevel world, ChunkPos pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(ServerLevel world, Vec3 pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(ServerLevel world, int chunkX, int chunkZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(ServerLevel world, AABB aabb) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(ServerLevel world, double blockX, double blockZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(ServerLevel world, Vec3 position, Vec3 deltaMovement, int buffer) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(ServerLevel world, int fromChunkX, int fromChunkZ, int toChunkX, int toChunkZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(ServerLevel world, int chunkX, int chunkZ, int radius) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Entity entity) {
        return TickThread.isTickThread();
    }

    static {
        if (STRICT_THREAD_CHECKS) {
            MinecraftServer.LOGGER.warn("Strict thread checks enabled - performance may suffer");
        }
        ID_GENERATOR = new AtomicInteger();
    }
}

