/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public interface CollectionContentsPredicate<T, P extends Predicate<T>>
extends Predicate<Iterable<T>> {
    public List<P> unpack();

    public static <T, P extends Predicate<T>> Codec<CollectionContentsPredicate<T, P>> codec(Codec<P> predicateCodec) {
        return predicateCodec.listOf().xmap(CollectionContentsPredicate::of, CollectionContentsPredicate::unpack);
    }

    @SafeVarargs
    public static <T, P extends Predicate<T>> CollectionContentsPredicate<T, P> of(P ... predicates) {
        return CollectionContentsPredicate.of(List.of(predicates));
    }

    public static <T, P extends Predicate<T>> CollectionContentsPredicate<T, P> of(List<P> predicates) {
        return switch (predicates.size()) {
            case 0 -> new Zero();
            case 1 -> new Single((Predicate)predicates.getFirst());
            default -> new Multiple(predicates);
        };
    }

    public static class Zero<T, P extends Predicate<T>>
    implements CollectionContentsPredicate<T, P> {
        @Override
        @Override
        public boolean test(Iterable<T> iterable) {
            return true;
        }

        @Override
        @Override
        public List<P> unpack() {
            return List.of();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Iterable)object);
        }
    }

    public record Single<T, P extends Predicate<T>>(P test) implements CollectionContentsPredicate<T, P>
    {
        @Override
        @Override
        public boolean test(Iterable<T> iterable) {
            for (T object : iterable) {
                if (!this.test.test(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Override
        public List<P> unpack() {
            return List.of(this.test);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Iterable)object);
        }
    }

    public record Multiple<T, P extends Predicate<T>>(List<P> tests) implements CollectionContentsPredicate<T, P>
    {
        @Override
        @Override
        public boolean test(Iterable<T> iterable) {
            ArrayList<P> list = new ArrayList<P>(this.tests);
            for (Object object : iterable) {
                list.removeIf(predicate -> predicate.test(object));
                if (!list.isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        @Override
        public List<P> unpack() {
            return this.tests;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Iterable)object);
        }
    }
}

