/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.loot.LootContext;
import org.leavesmc.leaves.bot.ServerBot;

public abstract class SimpleCriterionTrigger<T extends SimpleInstance>
implements CriterionTrigger<T> {
    @Override
    public final void addPlayerListener(PlayerAdvancements manager, CriterionTrigger.Listener<T> conditions) {
        manager.criterionData.computeIfAbsent(this, managerx -> Sets.newHashSet()).add(conditions);
    }

    @Override
    public final void removePlayerListener(PlayerAdvancements manager, CriterionTrigger.Listener<T> conditions) {
        Set<CriterionTrigger.Listener<?>> set = manager.criterionData.get(this);
        if (set != null) {
            set.remove(conditions);
            if (set.isEmpty()) {
                manager.criterionData.remove(this);
            }
        }
    }

    @Override
    public final void removePlayerListeners(PlayerAdvancements tracker) {
        tracker.criterionData.remove(this);
    }

    protected void trigger(ServerPlayer player, Predicate<T> predicate) {
        if (player instanceof ServerBot) {
            return;
        }
        PlayerAdvancements playerAdvancements = player.getAdvancements();
        Set<CriterionTrigger.Listener<?>> set = playerAdvancements.criterionData.get(this);
        if (set != null && !set.isEmpty()) {
            LootContext lootContext = null;
            List list = null;
            for (CriterionTrigger.Listener<?> listener : set) {
                Optional<ContextAwarePredicate> optional;
                SimpleInstance simpleInstance = (SimpleInstance)listener.trigger();
                if (!predicate.test(simpleInstance) || !(optional = simpleInstance.player()).isEmpty() && !optional.get().matches(lootContext = lootContext == null ? EntityPredicate.createContext(player, player) : lootContext)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener<Object> listener2 : list) {
                    listener2.run(playerAdvancements);
                }
            }
        }
    }

    public static interface SimpleInstance
    extends CriterionTriggerInstance {
        @Override
        default public void validate(CriterionValidator validator) {
            validator.validateEntity(this.player(), ".player");
        }

        public Optional<ContextAwarePredicate> player();
    }
}

