/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

public record WrappedMinMaxBounds(@Nullable Float min, @Nullable Float max) {
    public static final WrappedMinMaxBounds ANY = new WrappedMinMaxBounds(null, null);
    public static final SimpleCommandExceptionType ERROR_INTS_ONLY = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.ints"));

    public static WrappedMinMaxBounds exactly(float value) {
        return new WrappedMinMaxBounds(Float.valueOf(value), Float.valueOf(value));
    }

    public static WrappedMinMaxBounds between(float min, float max) {
        return new WrappedMinMaxBounds(Float.valueOf(min), Float.valueOf(max));
    }

    public static WrappedMinMaxBounds atLeast(float value) {
        return new WrappedMinMaxBounds(Float.valueOf(value), null);
    }

    public static WrappedMinMaxBounds atMost(float value) {
        return new WrappedMinMaxBounds(null, Float.valueOf(value));
    }

    public boolean matches(float value) {
        if (this.min != null && this.max != null && this.min.floatValue() > this.max.floatValue() && this.min.floatValue() > value && this.max.floatValue() < value) {
            return false;
        }
        if (this.min != null && this.min.floatValue() > value) {
            return false;
        }
        return this.max == null || !(this.max.floatValue() < value);
    }

    public boolean matchesSqr(double value) {
        if (this.min != null && this.max != null && this.min.floatValue() > this.max.floatValue() && (double)(this.min.floatValue() * this.min.floatValue()) > value && (double)(this.max.floatValue() * this.max.floatValue()) < value) {
            return false;
        }
        if (this.min != null && (double)(this.min.floatValue() * this.min.floatValue()) > value) {
            return false;
        }
        return this.max == null || !((double)(this.max.floatValue() * this.max.floatValue()) < value);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        if (this.min != null && this.max != null && this.min.equals(this.max)) {
            return new JsonPrimitive((Number)this.min);
        }
        JsonObject jsonObject = new JsonObject();
        if (this.min != null) {
            jsonObject.addProperty("min", (Number)this.min);
        }
        if (this.max != null) {
            jsonObject.addProperty("max", (Number)this.min);
        }
        return jsonObject;
    }

    public static WrappedMinMaxBounds fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        if (GsonHelper.isNumberValue(json)) {
            float f = GsonHelper.convertToFloat(json, "value");
            return new WrappedMinMaxBounds(Float.valueOf(f), Float.valueOf(f));
        }
        JsonObject jsonObject = GsonHelper.convertToJsonObject(json, "value");
        Float float_ = jsonObject.has("min") ? Float.valueOf(GsonHelper.getAsFloat(jsonObject, "min")) : null;
        Float float2 = jsonObject.has("max") ? Float.valueOf(GsonHelper.getAsFloat(jsonObject, "max")) : null;
        return new WrappedMinMaxBounds(float_, float2);
    }

    public static WrappedMinMaxBounds fromReader(StringReader reader, boolean allowFloats) throws CommandSyntaxException {
        return WrappedMinMaxBounds.fromReader(reader, allowFloats, value -> value);
    }

    public static WrappedMinMaxBounds fromReader(StringReader reader, boolean allowFloats, Function<Float, Float> transform) throws CommandSyntaxException {
        Float float3;
        if (!reader.canRead()) {
            throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)reader);
        }
        int i = reader.getCursor();
        Float float_ = WrappedMinMaxBounds.optionallyFormat(WrappedMinMaxBounds.readNumber(reader, allowFloats), transform);
        if (reader.canRead(2) && reader.peek() == '.' && reader.peek(1) == '.') {
            reader.skip();
            reader.skip();
            Float float2 = WrappedMinMaxBounds.optionallyFormat(WrappedMinMaxBounds.readNumber(reader, allowFloats), transform);
            if (float_ == null && float2 == null) {
                reader.setCursor(i);
                throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)reader);
            }
        } else {
            if (!allowFloats && reader.canRead() && reader.peek() == '.') {
                reader.setCursor(i);
                throw ERROR_INTS_ONLY.createWithContext((ImmutableStringReader)reader);
            }
            float3 = float_;
        }
        if (float_ == null && float3 == null) {
            reader.setCursor(i);
            throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)reader);
        }
        return new WrappedMinMaxBounds(float_, float3);
    }

    @Nullable
    private static Float readNumber(StringReader reader, boolean allowFloats) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && WrappedMinMaxBounds.isAllowedNumber(reader, allowFloats)) {
            reader.skip();
        }
        String string = reader.getString().substring(i, reader.getCursor());
        if (string.isEmpty()) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            if (allowFloats) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidDouble().createWithContext((ImmutableStringReader)reader, (Object)string);
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)reader, (Object)string);
        }
    }

    private static boolean isAllowedNumber(StringReader reader, boolean allowFloats) {
        char c = reader.peek();
        if (c >= '0' && c <= '9' || c == '-') {
            return true;
        }
        if (allowFloats && c == '.') {
            return !reader.canRead(2) || reader.peek(1) != '.';
        }
        return false;
    }

    @Nullable
    private static Float optionallyFormat(@Nullable Float value, Function<Float, Float> function) {
        return value == null ? null : function.apply(value);
    }
}

