/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;

public class SwizzleArgument
implements ArgumentType<EnumSet<Direction.Axis>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("xyz", "x");
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("arguments.swizzle.invalid"));

    public static SwizzleArgument swizzle() {
        return new SwizzleArgument();
    }

    public static EnumSet<Direction.Axis> getSwizzle(CommandContext<CommandSourceStack> context, String name) {
        return (EnumSet)context.getArgument(name, EnumSet.class);
    }

    /*
     * WARNING - void declaration
     */
    public EnumSet<Direction.Axis> parse(StringReader stringReader) throws CommandSyntaxException {
        EnumSet<Direction.Axis> enumSet = EnumSet.noneOf(Direction.Axis.class);
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            void axis4;
            char c = stringReader.read();
            switch (c) {
                case 'x': {
                    Direction.Axis axis = Direction.Axis.X;
                    break;
                }
                case 'y': {
                    Direction.Axis axis2 = Direction.Axis.Y;
                    break;
                }
                case 'z': {
                    Direction.Axis axis3 = Direction.Axis.Z;
                    break;
                }
                default: {
                    throw ERROR_INVALID.createWithContext((ImmutableStringReader)stringReader);
                }
            }
            if (enumSet.contains(axis4)) {
                throw ERROR_INVALID.createWithContext((ImmutableStringReader)stringReader);
            }
            enumSet.add((Direction.Axis)axis4);
        }
        return enumSet;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

