/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.ResourceLocationParseRule;
import net.minecraft.util.parsing.packrat.commands.ResourceLookupRule;
import net.minecraft.util.parsing.packrat.commands.StringReaderTerms;
import net.minecraft.util.parsing.packrat.commands.TagParseRule;

public class ComponentPredicateParser {
    public static <T, C, P> Grammar<List<T>> createGrammar(Context<T, C, P> callbacks) {
        Atom atom = Atom.of("top");
        Atom atom2 = Atom.of("type");
        Atom atom3 = Atom.of("any_type");
        Atom atom4 = Atom.of("element_type");
        Atom atom5 = Atom.of("tag_type");
        Atom atom6 = Atom.of("conditions");
        Atom atom7 = Atom.of("alternatives");
        Atom atom8 = Atom.of("term");
        Atom atom9 = Atom.of("negation");
        Atom atom10 = Atom.of("test");
        Atom atom11 = Atom.of("component_type");
        Atom atom12 = Atom.of("predicate_type");
        Atom<ResourceLocation> atom13 = Atom.of("id");
        Atom atom14 = Atom.of("tag");
        Dictionary<StringReader> dictionary = new Dictionary<StringReader>();
        dictionary.put(atom, Term.alternative(Term.sequence(Term.named(atom2), StringReaderTerms.character('['), Term.cut(), Term.optional(Term.named(atom6)), StringReaderTerms.character(']')), Term.named(atom2)), results -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            ((Optional)results.getOrThrow(atom2)).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            List list = (List)results.get(atom6);
            if (list != null) {
                builder.addAll((Iterable)list);
            }
            return builder.build();
        });
        dictionary.put(atom2, Term.alternative(Term.named(atom4), Term.sequence(StringReaderTerms.character('#'), Term.cut(), Term.named(atom5)), Term.named(atom3)), results -> Optional.ofNullable(results.getAny(atom4, atom5)));
        dictionary.put(atom3, StringReaderTerms.character('*'), results -> Unit.INSTANCE);
        dictionary.put(atom4, new ElementLookupRule<T, C, P>(atom13, callbacks));
        dictionary.put(atom5, new TagLookupRule<T, C, P>(atom13, callbacks));
        dictionary.put(atom6, Term.sequence(Term.named(atom7), Term.optional(Term.sequence(StringReaderTerms.character(','), Term.named(atom6)))), results -> {
            Object object = callbacks.anyOf((List)results.getOrThrow(atom7));
            return Optional.ofNullable((List)results.get(atom6)).map(predicates -> Util.copyAndAdd(object, predicates)).orElse(List.of(object));
        });
        dictionary.put(atom7, Term.sequence(Term.named(atom8), Term.optional(Term.sequence(StringReaderTerms.character('|'), Term.named(atom7)))), results -> {
            Object object = results.getOrThrow(atom8);
            return Optional.ofNullable((List)results.get(atom7)).map(predicates -> Util.copyAndAdd(object, predicates)).orElse(List.of(object));
        });
        dictionary.put(atom8, Term.alternative(Term.named(atom10), Term.sequence(StringReaderTerms.character('!'), Term.named(atom9))), results -> results.getAnyOrThrow(atom10, atom9));
        dictionary.put(atom9, Term.named(atom10), results -> callbacks.negate(results.getOrThrow(atom10)));
        dictionary.put(atom10, Term.alternative(Term.sequence(Term.named(atom11), StringReaderTerms.character('='), Term.cut(), Term.named(atom14)), Term.sequence(Term.named(atom12), StringReaderTerms.character('~'), Term.cut(), Term.named(atom14)), Term.named(atom11)), (state, results) -> {
            Object object = results.get(atom12);
            try {
                if (object != null) {
                    Tag tag = (Tag)results.getOrThrow(atom14);
                    return Optional.of(callbacks.createPredicateTest((ImmutableStringReader)state.input(), object, tag));
                }
                Object object2 = results.getOrThrow(atom11);
                Tag tag2 = (Tag)results.get(atom14);
                return Optional.of(tag2 != null ? callbacks.createComponentTest((ImmutableStringReader)state.input(), object2, tag2) : callbacks.createComponentTest((ImmutableStringReader)state.input(), object2));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                state.errorCollector().store(state.mark(), commandSyntaxException);
                return Optional.empty();
            }
        });
        dictionary.put(atom11, new ComponentLookupRule<T, C, P>(atom13, callbacks));
        dictionary.put(atom12, new PredicateLookupRule<T, C, P>(atom13, callbacks));
        dictionary.put(atom14, TagParseRule.INSTANCE);
        dictionary.put(atom13, ResourceLocationParseRule.INSTANCE);
        return new Grammar<List<T>>(dictionary, atom);
    }

    static class ElementLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, T> {
        ElementLookupRule(Atom<ResourceLocation> symbol, Context<T, C, P> callbacks) {
            super(symbol, callbacks);
        }

        @Override
        @Override
        protected T validateElement(ImmutableStringReader reader, ResourceLocation id) throws Exception {
            return ((Context)this.context).forElementType(reader, id);
        }

        @Override
        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listElementTypes();
        }
    }

    public static interface Context<T, C, P> {
        public T forElementType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listElementTypes();

        public T forTagType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listTagTypes();

        public C lookupComponentType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listComponentTypes();

        public T createComponentTest(ImmutableStringReader var1, C var2, Tag var3) throws CommandSyntaxException;

        public T createComponentTest(ImmutableStringReader var1, C var2);

        public P lookupPredicateType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listPredicateTypes();

        public T createPredicateTest(ImmutableStringReader var1, P var2, Tag var3) throws CommandSyntaxException;

        public T negate(T var1);

        public T anyOf(List<T> var1);
    }

    static class TagLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, T> {
        TagLookupRule(Atom<ResourceLocation> symbol, Context<T, C, P> callbacks) {
            super(symbol, callbacks);
        }

        @Override
        @Override
        protected T validateElement(ImmutableStringReader reader, ResourceLocation id) throws Exception {
            return ((Context)this.context).forTagType(reader, id);
        }

        @Override
        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listTagTypes();
        }
    }

    static class ComponentLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, C> {
        ComponentLookupRule(Atom<ResourceLocation> symbol, Context<T, C, P> callbacks) {
            super(symbol, callbacks);
        }

        @Override
        @Override
        protected C validateElement(ImmutableStringReader reader, ResourceLocation id) throws Exception {
            return ((Context)this.context).lookupComponentType(reader, id);
        }

        @Override
        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listComponentTypes();
        }
    }

    static class PredicateLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, P> {
        PredicateLookupRule(Atom<ResourceLocation> symbol, Context<T, C, P> callbacks) {
            super(symbol, callbacks);
        }

        @Override
        @Override
        protected P validateElement(ImmutableStringReader reader, ResourceLocation id) throws Exception {
            return ((Context)this.context).lookupPredicateType(reader, id);
        }

        @Override
        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listPredicateTypes();
        }
    }
}

