/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemInput {
    private static final Dynamic2CommandExceptionType ERROR_STACK_TOO_BIG = new Dynamic2CommandExceptionType((item, maxCount) -> Component.translatableEscape("arguments.item.overstacked", item, maxCount));
    private final Holder<Item> item;
    private final DataComponentMap components;
    @Nullable
    private final DataComponentPatch patch;

    public ItemInput(Holder<Item> item, DataComponentMap components) {
        this(item, components, null);
    }

    public ItemInput(Holder<Item> item, DataComponentMap components, @Nullable DataComponentPatch patch) {
        this.patch = patch;
        this.item = item;
        this.components = components;
    }

    public Item getItem() {
        return this.item.value();
    }

    public ItemStack createItemStack(int amount, boolean checkOverstack) throws CommandSyntaxException {
        ItemStack itemStack = new ItemStack(this.item, amount);
        if (this.patch != null) {
            itemStack.applyComponents(this.patch);
        } else {
            itemStack.applyComponents(this.components);
        }
        if (checkOverstack && amount > itemStack.getMaxStackSize()) {
            throw ERROR_STACK_TOO_BIG.create((Object)this.getItemName(), (Object)itemStack.getMaxStackSize());
        }
        return itemStack;
    }

    public String serialize(HolderLookup.Provider registries) {
        StringBuilder stringBuilder = new StringBuilder(this.getItemName());
        String string = this.serializeComponents(registries);
        if (!string.isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(string);
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private String serializeComponents(HolderLookup.Provider registries) {
        RegistryOps<Tag> dynamicOps = registries.createSerializationContext(NbtOps.INSTANCE);
        return this.components.stream().flatMap(component -> {
            DataComponentType dataComponentType = component.type();
            ResourceLocation resourceLocation = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(dataComponentType);
            Optional optional = component.encodeValue(dynamicOps).result();
            return resourceLocation != null && !optional.isEmpty() ? Stream.of(resourceLocation.toString() + "=" + String.valueOf(optional.get())) : Stream.empty();
        }).collect(Collectors.joining(String.valueOf(',')));
    }

    private String getItemName() {
        return this.item.unwrapKey().map(ResourceKey::location).orElseGet(() -> "unknown[" + String.valueOf(this.item) + "]").toString();
    }
}

