/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution.tasks;

import java.util.List;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.CommandQueueEntry;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.execution.tasks.ContinuationTask;
import net.minecraft.commands.functions.InstantiatedFunction;

public class CallFunction<T extends ExecutionCommandSource<T>>
implements UnboundEntryAction<T> {
    private final InstantiatedFunction<T> function;
    private final CommandResultCallback resultCallback;
    private final boolean returnParentFrame;

    public CallFunction(InstantiatedFunction<T> function, CommandResultCallback returnValueConsumer, boolean propagateReturn) {
        this.function = function;
        this.resultCallback = returnValueConsumer;
        this.returnParentFrame = propagateReturn;
    }

    @Override
    @Override
    public void execute(T executionCommandSource, ExecutionContext<T> executionContext, Frame frame2) {
        executionContext.incrementCost();
        List<UnboundEntryAction<T>> list = this.function.entries();
        TraceCallbacks traceCallbacks = executionContext.tracer();
        if (traceCallbacks != null) {
            traceCallbacks.onCall(frame2.depth(), this.function.id(), this.function.entries().size());
        }
        int i = frame2.depth() + 1;
        Frame.FrameControl frameControl = this.returnParentFrame ? frame2.frameControl() : executionContext.frameControlForDepth(i);
        Frame frame22 = new Frame(i, this.resultCallback, frameControl);
        ContinuationTask.schedule(executionContext, frame22, list, (frame, action) -> new CommandQueueEntry<ExecutionCommandSource>(frame, action.bind(executionCommandSource)));
    }

    @Override
    public /* synthetic */ void execute(Object source, ExecutionContext context, Frame frame) {
        this.execute((ExecutionCommandSource)source, context, frame);
    }
}

