/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public interface DataComponentMap
extends Iterable<TypedDataComponent<?>> {
    public static final DataComponentMap EMPTY = new DataComponentMap(){

        @Override
        @Nullable
        @Override
        public <T> T get(DataComponentType<? extends T> type) {
            return null;
        }

        @Override
        @Override
        public Set<DataComponentType<?>> keySet() {
            return Set.of();
        }

        @Override
        @Override
        public Iterator<TypedDataComponent<?>> iterator() {
            return Collections.emptyIterator();
        }
    };
    public static final Codec<DataComponentMap> CODEC = DataComponentType.VALUE_MAP_CODEC.flatComapMap(Builder::buildFromMapTrusted, components -> {
        int i = components.size();
        if (i == 0) {
            return DataResult.success((Object)Reference2ObjectMaps.emptyMap());
        }
        Reference2ObjectArrayMap reference2ObjectMap = new Reference2ObjectArrayMap(i);
        for (TypedDataComponent<?> typedDataComponent : components) {
            if (typedDataComponent.type().isTransient()) continue;
            reference2ObjectMap.put(typedDataComponent.type(), typedDataComponent.value());
        }
        return DataResult.success((Object)reference2ObjectMap);
    });

    public static DataComponentMap composite(final DataComponentMap base, final DataComponentMap overrides) {
        return new DataComponentMap(){

            @Override
            @Nullable
            @Override
            public <T> T get(DataComponentType<? extends T> type) {
                T object = overrides.get(type);
                if (object != null) {
                    return object;
                }
                return base.get(type);
            }

            @Override
            @Override
            public Set<DataComponentType<?>> keySet() {
                return Sets.union(base.keySet(), overrides.keySet());
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public <T> T get(DataComponentType<? extends T> var1);

    public Set<DataComponentType<?>> keySet();

    default public boolean has(DataComponentType<?> type) {
        return this.get(type) != null;
    }

    default public <T> T getOrDefault(DataComponentType<? extends T> type, T fallback) {
        T object = this.get(type);
        return object != null ? object : fallback;
    }

    @Nullable
    default public <T> TypedDataComponent<T> getTyped(DataComponentType<T> type) {
        T object = this.get(type);
        return object != null ? new TypedDataComponent<T>(type, object) : null;
    }

    @Override
    @Override
    default public Iterator<TypedDataComponent<?>> iterator() {
        return Iterators.transform(this.keySet().iterator(), type -> Objects.requireNonNull(this.getTyped((DataComponentType)type)));
    }

    default public Stream<TypedDataComponent<?>> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.size(), 1345), false);
    }

    default public int size() {
        return this.keySet().size();
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public DataComponentMap filter(final Predicate<DataComponentType<?>> predicate) {
        return new DataComponentMap(){

            @Override
            @Nullable
            @Override
            public <T> T get(DataComponentType<? extends T> type) {
                return predicate.test(type) ? (T)DataComponentMap.this.get(type) : null;
            }

            @Override
            @Override
            public Set<DataComponentType<?>> keySet() {
                return Sets.filter(DataComponentMap.this.keySet(), predicate::test);
            }
        };
    }

    public static class Builder {
        private final Reference2ObjectMap<DataComponentType<?>, Object> map = new Reference2ObjectArrayMap();

        Builder() {
        }

        public <T> Builder set(DataComponentType<T> type, @Nullable T value) {
            this.setUnchecked(type, value);
            return this;
        }

        <T> void setUnchecked(DataComponentType<T> type, @Nullable Object value) {
            if (value != null) {
                this.map.put(type, value);
            } else {
                this.map.remove(type);
            }
        }

        public Builder addAll(DataComponentMap componentSet) {
            for (TypedDataComponent<?> typedDataComponent : componentSet) {
                this.map.put(typedDataComponent.type(), typedDataComponent.value());
            }
            return this;
        }

        public DataComponentMap build() {
            return Builder.buildFromMapTrusted(this.map);
        }

        private static DataComponentMap buildFromMapTrusted(Map<DataComponentType<?>, Object> components) {
            if (components.isEmpty()) {
                return EMPTY;
            }
            if (components.size() < 8) {
                return new SimpleMap((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectArrayMap(components));
            }
            return new SimpleMap((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectOpenHashMap(components));
        }

        record SimpleMap(Reference2ObjectMap<DataComponentType<?>, Object> map) implements DataComponentMap
        {
            @Override
            @Nullable
            @Override
            public <T> T get(DataComponentType<? extends T> type) {
                return (T)this.map.get(type);
            }

            @Override
            @Override
            public boolean has(DataComponentType<?> type) {
                return this.map.containsKey(type);
            }

            @Override
            @Override
            public Set<DataComponentType<?>> keySet() {
                return this.map.keySet();
            }

            @Override
            @Override
            public Iterator<TypedDataComponent<?>> iterator() {
                return Iterators.transform((Iterator)Reference2ObjectMaps.fastIterator(this.map), TypedDataComponent::fromEntryUnchecked);
            }

            @Override
            @Override
            public int size() {
                return this.map.size();
            }

            @Override
            @Override
            public String toString() {
                return this.map.toString();
            }
        }
    }
}

