/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class DataComponentPredicate
implements Predicate<DataComponentMap> {
    public static final Codec<DataComponentPredicate> CODEC = DataComponentType.VALUE_MAP_CODEC.xmap(map -> new DataComponentPredicate(map.entrySet().stream().map(TypedDataComponent::fromEntryUnchecked).collect(Collectors.toList())), predicate -> predicate.expectedComponents.stream().filter(typedDataComponent -> !typedDataComponent.type().isTransient()).collect(Collectors.toMap(TypedDataComponent::type, TypedDataComponent::value)));
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPredicate> STREAM_CODEC = TypedDataComponent.STREAM_CODEC.apply(ByteBufCodecs.list()).map(DataComponentPredicate::new, predicate -> predicate.expectedComponents);
    public static final DataComponentPredicate EMPTY = new DataComponentPredicate(List.of());
    private final List<TypedDataComponent<?>> expectedComponents;

    DataComponentPredicate(List<TypedDataComponent<?>> components) {
        this.expectedComponents = components;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DataComponentPredicate allOf(DataComponentMap components) {
        return new DataComponentPredicate((List<TypedDataComponent<?>>)ImmutableList.copyOf((Iterable)components));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DataComponentPredicate)) return false;
        DataComponentPredicate dataComponentPredicate = (DataComponentPredicate)object;
        if (!this.expectedComponents.equals(dataComponentPredicate.expectedComponents)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.expectedComponents.hashCode();
    }

    @Override
    public String toString() {
        return this.expectedComponents.toString();
    }

    @Override
    @Override
    public boolean test(DataComponentMap dataComponentMap) {
        for (TypedDataComponent<?> typedDataComponent : this.expectedComponents) {
            Object object = dataComponentMap.get(typedDataComponent.type());
            if (Objects.equals(typedDataComponent.value(), object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean test(DataComponentHolder holder) {
        return this.test(holder.getComponents());
    }

    public boolean alwaysMatches() {
        return this.expectedComponents.isEmpty();
    }

    public DataComponentPatch asPatch() {
        DataComponentPatch.Builder builder = DataComponentPatch.builder();
        for (TypedDataComponent<?> typedDataComponent : this.expectedComponents) {
            builder.set(typedDataComponent);
        }
        return builder.build();
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((DataComponentMap)object);
    }

    public static class Builder {
        private final List<TypedDataComponent<?>> expectedComponents = new ArrayList();

        Builder() {
        }

        public <T> Builder expect(DataComponentType<? super T> type, T value) {
            for (TypedDataComponent<?> typedDataComponent : this.expectedComponents) {
                if (typedDataComponent.type() != type) continue;
                throw new IllegalArgumentException("Predicate already has component of type: '" + String.valueOf(type) + "'");
            }
            this.expectedComponents.add(new TypedDataComponent<T>(type, value));
            return this;
        }

        public DataComponentPredicate build() {
            return new DataComponentPredicate(List.copyOf(this.expectedComponents));
        }
    }
}

