/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.BoatDispenseItemBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.phys.AABB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.DummyGeneratorAccess;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public interface DispenseItemBehavior {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DispenseItemBehavior NOOP = (sourceblock, itemstack) -> itemstack;

    public net.minecraft.world.item.ItemStack dispense(BlockSource var1, net.minecraft.world.item.ItemStack var2);

    public static void bootStrap() {
        DispenserBlock.registerProjectileBehavior(Items.ARROW);
        DispenserBlock.registerProjectileBehavior(Items.TIPPED_ARROW);
        DispenserBlock.registerProjectileBehavior(Items.SPECTRAL_ARROW);
        DispenserBlock.registerProjectileBehavior(Items.EGG);
        DispenserBlock.registerProjectileBehavior(Items.SNOWBALL);
        DispenserBlock.registerProjectileBehavior(Items.EXPERIENCE_BOTTLE);
        DispenserBlock.registerProjectileBehavior(Items.SPLASH_POTION);
        DispenserBlock.registerProjectileBehavior(Items.LINGERING_POTION);
        DispenserBlock.registerProjectileBehavior(Items.FIREWORK_ROCKET);
        DispenserBlock.registerProjectileBehavior(Items.FIRE_CHARGE);
        DispenserBlock.registerProjectileBehavior(Items.WIND_CHARGE);
        DefaultDispenseItemBehavior dispensebehavioritem = new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                Direction enumdirection = pointer.state().getValue(DispenserBlock.FACING);
                EntityType<?> entitytypes = ((SpawnEggItem)stack.getItem()).getType(stack);
                ServerLevel worldserver = pointer.level();
                net.minecraft.world.item.ItemStack itemstack1 = stack.copyWithCount(1);
                CraftBlock block = CraftBlock.at(worldserver, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                    itemstack1 = CraftItemStack.unwrap(event.getItem());
                    entitytypes = ((SpawnEggItem)itemstack1.getItem()).getType(itemstack1);
                }
                try {
                    entitytypes.spawn(pointer.level(), itemstack1, (Player)null, pointer.pos().relative(enumdirection), MobSpawnType.DISPENSER, enumdirection != Direction.UP, false);
                }
                catch (Exception exception) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)pointer.pos(), (Object)exception);
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
                if (shrink) {
                    stack.shrink(1);
                }
                pointer.level().gameEvent((Entity)null, GameEvent.ENTITY_PLACE, pointer.pos());
                return stack;
            }
        };
        for (SpawnEggItem itemmonsteregg : SpawnEggItem.eggs()) {
            DispenserBlock.registerBehavior(itemmonsteregg, dispensebehavioritem);
        }
        DispenserBlock.registerBehavior(Items.ARMOR_STAND, new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack newStack;
                Consumer<ArmorStand> consumer;
                ArmorStand entityarmorstand2;
                Direction enumdirection = pointer.state().getValue(DispenserBlock.FACING);
                BlockPos blockposition = pointer.pos().relative(enumdirection);
                ServerLevel worldserver = pointer.level();
                net.minecraft.world.item.ItemStack itemstack1 = stack.copyWithCount(1);
                CraftBlock block = CraftBlock.at(worldserver, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                if ((entityarmorstand2 = EntityType.ARMOR_STAND.spawn(worldserver, consumer = EntityType.appendDefaultStackConfig(entityarmorstand -> entityarmorstand.setYRot(enumdirection.toYRot()), worldserver, newStack = CraftItemStack.unwrap(event.getItem()), null), blockposition, MobSpawnType.DISPENSER, false, false)) != null && shrink) {
                    stack.shrink(1);
                }
                return stack;
            }
        });
        DispenserBlock.registerBehavior(Items.SADDLE, new OptionalDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPos blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
                List<net.minecraft.world.entity.LivingEntity> list = pointer.level().getEntitiesOfClass(net.minecraft.world.entity.LivingEntity.class, new AABB(blockposition), entityliving -> {
                    if (!(entityliving instanceof Saddleable)) {
                        return false;
                    }
                    Saddleable isaddleable = (Saddleable)((Object)entityliving);
                    return !isaddleable.isSaddled() && isaddleable.isSaddleable();
                });
                if (!list.isEmpty()) {
                    net.minecraft.world.item.ItemStack itemstack1 = stack.copyWithCount(1);
                    ServerLevel world = pointer.level();
                    CraftBlock block = CraftBlock.at(world, pointer.pos());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                    BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)list.get(0).getBukkitEntity()));
                    if (!DispenserBlock.eventFired) {
                        world.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    boolean shrink = true;
                    if (!event.getItem().equals((Object)craftItem)) {
                        shrink = false;
                        net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                        DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
                        if (idispensebehavior != NOOP && idispensebehavior != this) {
                            idispensebehavior.dispense(pointer, eventStack);
                            return stack;
                        }
                    }
                    ((Saddleable)((Object)list.get(0))).equipSaddle(SoundSource.BLOCKS, CraftItemStack.asNMSCopy(event.getItem()));
                    if (shrink) {
                        stack.shrink(1);
                    }
                    this.setSuccess(true);
                    return stack;
                }
                return super.execute(pointer, stack);
            }
        });
        OptionalDispenseItemBehavior dispensebehaviormaybe = new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                AbstractHorse entityhorseabstract2;
                BlockPos blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
                List<AbstractHorse> list = pointer.level().getEntitiesOfClass(AbstractHorse.class, new AABB(blockposition), entityhorseabstract -> entityhorseabstract.isAlive() && entityhorseabstract.canWearBodyArmor());
                Iterator<AbstractHorse> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    return super.execute(pointer, stack);
                } while (!(entityhorseabstract2 = iterator1.next()).isBodyArmorItem(stack) || entityhorseabstract2.isWearingBodyArmor() || !entityhorseabstract2.isTamed());
                net.minecraft.world.item.ItemStack itemstack1 = stack.copyWithCount(1);
                ServerLevel world = pointer.level();
                CraftBlock block = CraftBlock.at(world, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorseabstract2.getBukkitEntity()));
                if (!DispenserBlock.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                if (shrink) {
                    stack.shrink(1);
                }
                entityhorseabstract2.setBodyArmorItem(CraftItemStack.asNMSCopy(event.getItem()));
                this.setSuccess(true);
                return stack;
            }
        };
        DispenserBlock.registerBehavior(Items.LEATHER_HORSE_ARMOR, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.IRON_HORSE_ARMOR, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.GOLDEN_HORSE_ARMOR, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.DIAMOND_HORSE_ARMOR, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.WHITE_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.ORANGE_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.CYAN_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.BLUE_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.BROWN_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.BLACK_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.GRAY_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.GREEN_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.LIGHT_BLUE_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.LIGHT_GRAY_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.LIME_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.MAGENTA_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.PINK_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.PURPLE_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.RED_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.YELLOW_CARPET, dispensebehaviormaybe);
        DispenserBlock.registerBehavior(Items.CHEST, new OptionalDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                AbstractChestedHorse entityhorsechestedabstract2;
                BlockPos blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
                List<AbstractChestedHorse> list = pointer.level().getEntitiesOfClass(AbstractChestedHorse.class, new AABB(blockposition), entityhorsechestedabstract -> entityhorsechestedabstract.isAlive() && !entityhorsechestedabstract.hasChest());
                Iterator<AbstractChestedHorse> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    return super.execute(pointer, stack);
                } while (!(entityhorsechestedabstract2 = iterator1.next()).isTamed());
                net.minecraft.world.item.ItemStack itemstack1 = stack.copyWithCount(1);
                ServerLevel world = pointer.level();
                CraftBlock block = CraftBlock.at(world, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorsechestedabstract2.getBukkitEntity()));
                if (!DispenserBlock.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                entityhorsechestedabstract2.getSlot(499).set(CraftItemStack.asNMSCopy(event.getItem()));
                if (shrink) {
                    stack.shrink(1);
                }
                this.setSuccess(true);
                return stack;
            }
        });
        DispenserBlock.registerBehavior(Items.OAK_BOAT, new BoatDispenseItemBehavior(Boat.Type.OAK));
        DispenserBlock.registerBehavior(Items.SPRUCE_BOAT, new BoatDispenseItemBehavior(Boat.Type.SPRUCE));
        DispenserBlock.registerBehavior(Items.BIRCH_BOAT, new BoatDispenseItemBehavior(Boat.Type.BIRCH));
        DispenserBlock.registerBehavior(Items.JUNGLE_BOAT, new BoatDispenseItemBehavior(Boat.Type.JUNGLE));
        DispenserBlock.registerBehavior(Items.DARK_OAK_BOAT, new BoatDispenseItemBehavior(Boat.Type.DARK_OAK));
        DispenserBlock.registerBehavior(Items.ACACIA_BOAT, new BoatDispenseItemBehavior(Boat.Type.ACACIA));
        DispenserBlock.registerBehavior(Items.CHERRY_BOAT, new BoatDispenseItemBehavior(Boat.Type.CHERRY));
        DispenserBlock.registerBehavior(Items.MANGROVE_BOAT, new BoatDispenseItemBehavior(Boat.Type.MANGROVE));
        DispenserBlock.registerBehavior(Items.BAMBOO_RAFT, new BoatDispenseItemBehavior(Boat.Type.BAMBOO));
        DispenserBlock.registerBehavior(Items.OAK_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.OAK, true));
        DispenserBlock.registerBehavior(Items.SPRUCE_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.SPRUCE, true));
        DispenserBlock.registerBehavior(Items.BIRCH_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.BIRCH, true));
        DispenserBlock.registerBehavior(Items.JUNGLE_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.JUNGLE, true));
        DispenserBlock.registerBehavior(Items.DARK_OAK_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.DARK_OAK, true));
        DispenserBlock.registerBehavior(Items.ACACIA_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.ACACIA, true));
        DispenserBlock.registerBehavior(Items.CHERRY_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.CHERRY, true));
        DispenserBlock.registerBehavior(Items.MANGROVE_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.MANGROVE, true));
        DispenserBlock.registerBehavior(Items.BAMBOO_CHEST_RAFT, new BoatDispenseItemBehavior(Boat.Type.BAMBOO, true));
        DefaultDispenseItemBehavior dispensebehavioritem1 = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            /*
             * Unable to fully structure code
             */
            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                dispensiblecontaineritem = (DispensibleContainerItem)stack.getItem();
                blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
                worldserver = pointer.level();
                x = blockposition.getX();
                y = blockposition.getY();
                z = blockposition.getZ();
                iblockdata = worldserver.getBlockState(blockposition);
                dispensedItem = stack;
                v0 = willEmptyContentsSolidBucketItem = dispensiblecontaineritem instanceof SolidBucketItem != false && worldserver.isInWorldBounds(blockposition) != false && iblockdata.isAir() != false;
                if (!(dispensiblecontaineritem instanceof BucketItem)) ** GOTO lbl-1000
                bucketItem = (BucketItem)dispensiblecontaineritem;
                if (bucketItem.content instanceof FlowingFluid && (iblockdata.isAir() || iblockdata.canBeReplaced(bucketItem.content) || (var15_13 = iblockdata.getBlock()) instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)var15_13).canPlaceLiquid(null, worldserver, blockposition, iblockdata, bucketItem.content))) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = willEmptyBucketItem = false;
                }
                if (willEmptyContentsSolidBucketItem || willEmptyBucketItem) {
                    block = CraftBlock.at(worldserver, pointer.pos());
                    craftItem = CraftItemStack.asCraftMirror(stack.copyWithCount(1));
                    event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(x, y, z));
                    if (!DispenserBlock.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != DispenseItemBehavior.NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                    dispensedItem = CraftItemStack.unwrap(event.getItem());
                    dispensiblecontaineritem = (DispensibleContainerItem)dispensedItem.getItem();
                }
                if (dispensiblecontaineritem.emptyContents(null, worldserver, blockposition, null)) {
                    dispensiblecontaineritem.checkExtraContent(null, worldserver, dispensedItem, blockposition);
                    item = Items.BUCKET;
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        stack = new net.minecraft.world.item.ItemStack(item);
                    } else if (pointer.blockEntity().addItem(new net.minecraft.world.item.ItemStack(item)) < 0) {
                        this.defaultDispenseItemBehavior.dispense(pointer, new net.minecraft.world.item.ItemStack(item));
                    }
                    return stack;
                }
                return this.defaultDispenseItemBehavior.dispense(pointer, stack);
            }
        };
        DispenserBlock.registerBehavior(Items.LAVA_BUCKET, dispensebehavioritem1);
        DispenserBlock.registerBehavior(Items.WATER_BUCKET, dispensebehavioritem1);
        DispenserBlock.registerBehavior(Items.POWDER_SNOW_BUCKET, dispensebehavioritem1);
        DispenserBlock.registerBehavior(Items.SALMON_BUCKET, dispensebehavioritem1);
        DispenserBlock.registerBehavior(Items.COD_BUCKET, dispensebehavioritem1);
        DispenserBlock.registerBehavior(Items.PUFFERFISH_BUCKET, dispensebehavioritem1);
        DispenserBlock.registerBehavior(Items.TROPICAL_FISH_BUCKET, dispensebehavioritem1);
        DispenserBlock.registerBehavior(Items.AXOLOTL_BUCKET, dispensebehavioritem1);
        DispenserBlock.registerBehavior(Items.TADPOLE_BUCKET, dispensebehavioritem1);
        DispenserBlock.registerBehavior(Items.BUCKET, new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPos blockposition;
                ServerLevel worldserver = pointer.level();
                net.minecraft.world.level.block.state.BlockState iblockdata = worldserver.getBlockState(blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING)));
                Block block = iblockdata.getBlock();
                if (block instanceof BucketPickup) {
                    net.minecraft.world.item.ItemStack eventStack;
                    DispenseItemBehavior idispensebehavior;
                    BucketPickup ifluidsource = (BucketPickup)((Object)block);
                    net.minecraft.world.item.ItemStack itemstack1 = ifluidsource.pickupBlock(null, DummyGeneratorAccess.INSTANCE, blockposition, iblockdata);
                    if (itemstack1.isEmpty()) {
                        return super.execute(pointer, stack);
                    }
                    worldserver.gameEvent((Entity)null, GameEvent.FLUID_PICKUP, blockposition);
                    Item item = itemstack1.getItem();
                    CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.pos());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.copyWithCount(1));
                    BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                    if (!DispenserBlock.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return stack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                    itemstack1 = ifluidsource.pickupBlock(null, worldserver, blockposition, iblockdata);
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        return new net.minecraft.world.item.ItemStack(item);
                    }
                    if (pointer.blockEntity().addItem(new net.minecraft.world.item.ItemStack(item)) < 0) {
                        this.defaultDispenseItemBehavior.dispense(pointer, new net.minecraft.world.item.ItemStack(item));
                    }
                    return stack;
                }
                return super.execute(pointer, stack);
            }
        });
        DispenserBlock.registerBehavior(Items.FLINT_AND_STEEL, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                ServerLevel worldserver = pointer.level();
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                this.setSuccess(true);
                Direction enumdirection = pointer.state().getValue(DispenserBlock.FACING);
                BlockPos blockposition = pointer.pos().relative(enumdirection);
                net.minecraft.world.level.block.state.BlockState iblockdata = worldserver.getBlockState(blockposition);
                if (BaseFireBlock.canBePlacedAt(worldserver, blockposition, enumdirection)) {
                    if (!CraftEventFactory.callBlockIgniteEvent((Level)worldserver, blockposition, pointer.pos()).isCancelled()) {
                        worldserver.setBlockAndUpdate(blockposition, BaseFireBlock.getState(worldserver, blockposition));
                        worldserver.gameEvent((Entity)null, GameEvent.BLOCK_PLACE, blockposition);
                    }
                } else if (!(CampfireBlock.canLight(iblockdata) || CandleBlock.canLight(iblockdata) || CandleCakeBlock.canLight(iblockdata))) {
                    if (iblockdata.getBlock() instanceof TntBlock && CraftEventFactory.callTNTPrimeEvent(worldserver, blockposition, TNTPrimeEvent.PrimeCause.DISPENSER, null, pointer.pos())) {
                        TntBlock.explode(worldserver, blockposition);
                        worldserver.removeBlock(blockposition, false);
                    } else {
                        this.setSuccess(false);
                    }
                } else {
                    worldserver.setBlockAndUpdate(blockposition, (net.minecraft.world.level.block.state.BlockState)iblockdata.setValue(BlockStateProperties.LIT, true));
                    worldserver.gameEvent((Entity)null, GameEvent.BLOCK_CHANGE, blockposition);
                }
                if (this.isSuccess()) {
                    stack.hurtAndBreak(1, worldserver.getRandom(), null, () -> stack.setCount(0));
                }
                return stack;
            }
        });
        DispenserBlock.registerBehavior(Items.BONE_MEAL, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                this.setSuccess(true);
                ServerLevel worldserver = pointer.level();
                BlockPos blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
                CraftBlock block = CraftBlock.at(worldserver, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.copyWithCount(1));
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                worldserver.captureTreeGeneration = true;
                if (!BoneMealItem.growCrop(stack, worldserver, blockposition) && !BoneMealItem.growWaterPlant(stack, worldserver, blockposition, null)) {
                    this.setSuccess(false);
                } else if (!worldserver.isClientSide) {
                    worldserver.levelEvent(1505, blockposition, 15);
                }
                worldserver.captureTreeGeneration = false;
                if (worldserver.capturedBlockStates.size() > 0) {
                    TreeType treeType = SaplingBlock.treeType;
                    SaplingBlock.treeType = null;
                    Location location = CraftLocation.toBukkit(blockposition, (World)worldserver.getWorld());
                    ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(worldserver.capturedBlockStates.values());
                    worldserver.capturedBlockStates.clear();
                    StructureGrowEvent structureEvent = null;
                    if (treeType != null) {
                        structureEvent = new StructureGrowEvent(location, treeType, false, null, blocks);
                        Bukkit.getPluginManager().callEvent((Event)structureEvent);
                    }
                    BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent(location.getBlock(), null, blocks);
                    fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
                    Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
                    if (!fertilizeEvent.isCancelled()) {
                        for (BlockState blockState : blocks) {
                            blockState.update(true);
                            worldserver.checkCapturedTreeStateForObserverNotify(blockposition, (CraftBlockState)blockState);
                        }
                    }
                }
                return stack;
            }
        });
        DispenserBlock.registerBehavior(Blocks.TNT, new DefaultDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                ServerLevel worldserver = pointer.level();
                BlockPos blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
                net.minecraft.world.item.ItemStack itemstack1 = stack.copyWithCount(1);
                CraftBlock block = CraftBlock.at(worldserver, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector((double)blockposition.getX() + 0.5, (double)blockposition.getY(), (double)blockposition.getZ() + 0.5));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                boolean shrink = true;
                if (!event.getItem().equals((Object)craftItem)) {
                    shrink = false;
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(pointer, eventStack);
                        return stack;
                    }
                }
                PrimedTnt entitytntprimed = new PrimedTnt(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), null);
                worldserver.addFreshEntity(entitytntprimed);
                worldserver.playSound(null, entitytntprimed.getX(), entitytntprimed.getY(), entitytntprimed.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldserver.gameEvent((Entity)null, GameEvent.ENTITY_PLACE, blockposition);
                if (shrink) {
                    stack.shrink(1);
                }
                return stack;
            }
        });
        OptionalDispenseItemBehavior dispensebehaviormaybe1 = new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                this.setSuccess(ArmorItem.dispenseArmor(pointer, stack, this));
                return stack;
            }
        };
        DispenserBlock.registerBehavior(Items.CREEPER_HEAD, dispensebehaviormaybe1);
        DispenserBlock.registerBehavior(Items.ZOMBIE_HEAD, dispensebehaviormaybe1);
        DispenserBlock.registerBehavior(Items.DRAGON_HEAD, dispensebehaviormaybe1);
        DispenserBlock.registerBehavior(Items.SKELETON_SKULL, dispensebehaviormaybe1);
        DispenserBlock.registerBehavior(Items.PIGLIN_HEAD, dispensebehaviormaybe1);
        DispenserBlock.registerBehavior(Items.PLAYER_HEAD, dispensebehaviormaybe1);
        DispenserBlock.registerBehavior(Items.WITHER_SKELETON_SKULL, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                ServerLevel worldserver = pointer.level();
                Direction enumdirection = pointer.state().getValue(DispenserBlock.FACING);
                BlockPos blockposition = pointer.pos().relative(enumdirection);
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.copyWithCount(1));
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (worldserver.isEmptyBlock(blockposition) && WitherSkullBlock.canSpawnMob(worldserver, blockposition, stack)) {
                    worldserver.setBlock(blockposition, (net.minecraft.world.level.block.state.BlockState)Blocks.WITHER_SKELETON_SKULL.defaultBlockState().setValue(SkullBlock.ROTATION, RotationSegment.convertToSegment(enumdirection)), 3);
                    worldserver.gameEvent((Entity)null, GameEvent.BLOCK_PLACE, blockposition);
                    BlockEntity tileentity = worldserver.getBlockEntity(blockposition);
                    if (tileentity instanceof SkullBlockEntity) {
                        WitherSkullBlock.checkSpawn(worldserver, blockposition, (SkullBlockEntity)tileentity);
                    }
                    stack.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ArmorItem.dispenseArmor(pointer, stack, this));
                }
                return stack;
            }
        });
        DispenserBlock.registerBehavior(Blocks.CARVED_PUMPKIN, new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                ServerLevel worldserver = pointer.level();
                BlockPos blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
                CarvedPumpkinBlock blockpumpkincarved = (CarvedPumpkinBlock)Blocks.CARVED_PUMPKIN;
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.copyWithCount(1));
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (worldserver.isEmptyBlock(blockposition) && blockpumpkincarved.canSpawnGolem(worldserver, blockposition)) {
                    if (!worldserver.isClientSide) {
                        worldserver.setBlock(blockposition, blockpumpkincarved.defaultBlockState(), 3);
                        worldserver.gameEvent((Entity)null, GameEvent.BLOCK_PLACE, blockposition);
                    }
                    stack.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ArmorItem.dispenseArmor(pointer, stack, this));
                }
                return stack;
            }
        });
        DispenserBlock.registerBehavior(Blocks.SHULKER_BOX.asItem(), new ShulkerBoxDispenseBehavior());
        for (DyeColor enumcolor : DyeColor.values()) {
            DispenserBlock.registerBehavior(ShulkerBoxBlock.getBlockByColor(enumcolor).asItem(), new ShulkerBoxDispenseBehavior());
        }
        DispenserBlock.registerBehavior(Items.GLASS_BOTTLE.asItem(), new OptionalDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            private net.minecraft.world.item.ItemStack takeLiquid(BlockSource pointer, net.minecraft.world.item.ItemStack oldStack, net.minecraft.world.item.ItemStack newStack) {
                oldStack.shrink(1);
                if (oldStack.isEmpty()) {
                    pointer.level().gameEvent((Entity)null, GameEvent.FLUID_PICKUP, pointer.pos());
                    return newStack.copy();
                }
                if (pointer.blockEntity().addItem(newStack.copy()) < 0) {
                    this.defaultDispenseItemBehavior.dispense(pointer, newStack.copy());
                }
                return oldStack;
            }

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                this.setSuccess(false);
                ServerLevel worldserver = pointer.level();
                BlockPos blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
                net.minecraft.world.level.block.state.BlockState iblockdata = worldserver.getBlockState(blockposition);
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(stack.copyWithCount(1));
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                if (iblockdata.is(BlockTags.BEEHIVES, blockbase_blockdata -> blockbase_blockdata.hasProperty(BeehiveBlock.HONEY_LEVEL) && blockbase_blockdata.getBlock() instanceof BeehiveBlock) && iblockdata.getValue(BeehiveBlock.HONEY_LEVEL) >= 5) {
                    ((BeehiveBlock)iblockdata.getBlock()).releaseBeesAndResetHoneyLevel(worldserver, iblockdata, blockposition, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                    this.setSuccess(true);
                    return this.takeLiquid(pointer, stack, new net.minecraft.world.item.ItemStack(Items.HONEY_BOTTLE));
                }
                if (worldserver.getFluidState(blockposition).is(FluidTags.WATER)) {
                    this.setSuccess(true);
                    return this.takeLiquid(pointer, stack, PotionContents.createItemStack(Items.POTION, Potions.WATER));
                }
                return super.execute(pointer, stack);
            }
        });
        DispenserBlock.registerBehavior(Items.GLOWSTONE, new OptionalDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                Direction enumdirection = pointer.state().getValue(DispenserBlock.FACING);
                BlockPos blockposition = pointer.pos().relative(enumdirection);
                ServerLevel worldserver = pointer.level();
                net.minecraft.world.level.block.state.BlockState iblockdata = worldserver.getBlockState(blockposition);
                this.setSuccess(true);
                if (iblockdata.is(Blocks.RESPAWN_ANCHOR)) {
                    if (iblockdata.getValue(RespawnAnchorBlock.CHARGE) != 4) {
                        net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(pointer, blockposition, stack, this);
                        if (result != null) {
                            this.setSuccess(false);
                            return result;
                        }
                        RespawnAnchorBlock.charge(null, worldserver, blockposition, iblockdata);
                        stack.shrink(1);
                    } else {
                        this.setSuccess(false);
                    }
                    return stack;
                }
                return super.execute(pointer, stack);
            }
        });
        DispenserBlock.registerBehavior(Items.SHEARS.asItem(), new ShearsDispenseItemBehavior());
        DispenserBlock.registerBehavior(Items.BRUSH.asItem(), new OptionalDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                Armadillo armadillo;
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                BlockPos blockposition;
                ServerLevel worldserver = pointer.level();
                List<Entity> list = worldserver.getEntitiesOfClass(Armadillo.class, new AABB(blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS);
                if (list.isEmpty()) {
                    this.setSuccess(false);
                    return stack;
                }
                net.minecraft.world.item.ItemStack itemstack1 = stack;
                ServerLevel world = pointer.level();
                CraftBlock block = CraftBlock.at(world, pointer.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)((Armadillo)list.get(0)).getBukkitEntity()));
                if (!DispenserBlock.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return stack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != ArmorItem.DISPENSE_ITEM_BEHAVIOR) {
                    idispensebehavior.dispense(pointer, eventStack);
                    return stack;
                }
                Iterator<Entity> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    this.setSuccess(false);
                    return stack;
                } while (!(armadillo = (Armadillo)iterator1.next()).brushOffScute());
                stack.hurtAndBreak(16, worldserver.getRandom(), null, () -> {
                    stack.shrink(1);
                    stack.setDamageValue(0);
                });
                return stack;
            }
        });
        DispenserBlock.registerBehavior(Items.HONEYCOMB, new OptionalDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                BlockPos blockposition = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
                ServerLevel worldserver = pointer.level();
                net.minecraft.world.level.block.state.BlockState iblockdata = worldserver.getBlockState(blockposition);
                Optional<net.minecraft.world.level.block.state.BlockState> optional = HoneycombItem.getWaxed(iblockdata);
                if (optional.isPresent()) {
                    net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(pointer, blockposition, stack, this);
                    if (result != null) {
                        this.setSuccess(false);
                        return result;
                    }
                    worldserver.setBlockAndUpdate(blockposition, optional.get());
                    worldserver.levelEvent(3003, blockposition, 0);
                    stack.shrink(1);
                    this.setSuccess(true);
                    return stack;
                }
                return super.execute(pointer, stack);
            }
        });
        DispenserBlock.registerBehavior(Items.POTION, new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Override
            public net.minecraft.world.item.ItemStack execute(BlockSource pointer, net.minecraft.world.item.ItemStack stack) {
                PotionContents potioncontents = stack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
                if (!potioncontents.is(Potions.WATER)) {
                    return this.defaultDispenseItemBehavior.dispense(pointer, stack);
                }
                ServerLevel worldserver = pointer.level();
                BlockPos blockposition = pointer.pos();
                BlockPos blockposition1 = pointer.pos().relative(pointer.state().getValue(DispenserBlock.FACING));
                if (!worldserver.getBlockState(blockposition1).is(BlockTags.CONVERTABLE_TO_MUD)) {
                    return this.defaultDispenseItemBehavior.dispense(pointer, stack);
                }
                net.minecraft.world.item.ItemStack result = CraftEventFactory.handleBlockDispenseEvent(pointer, blockposition1, stack, this);
                if (result != null) {
                    return result;
                }
                if (!worldserver.isClientSide) {
                    for (int k = 0; k < 5; ++k) {
                        worldserver.sendParticles(ParticleTypes.SPLASH, (double)blockposition.getX() + worldserver.random.nextDouble(), blockposition.getY() + 1, (double)blockposition.getZ() + worldserver.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    }
                }
                worldserver.playSound((Player)null, blockposition, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldserver.gameEvent((Entity)null, GameEvent.FLUID_PLACE, blockposition);
                worldserver.setBlockAndUpdate(blockposition1, Blocks.MUD.defaultBlockState());
                return new net.minecraft.world.item.ItemStack(Items.GLASS_BOTTLE);
            }
        });
    }
}

