/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes.packs;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.ArmorDyeRecipe;
import net.minecraft.world.item.crafting.BannerDuplicateRecipe;
import net.minecraft.world.item.crafting.BookCloningRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.DecoratedPotRecipe;
import net.minecraft.world.item.crafting.FireworkRocketRecipe;
import net.minecraft.world.item.crafting.FireworkStarFadeRecipe;
import net.minecraft.world.item.crafting.FireworkStarRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.MapCloningRecipe;
import net.minecraft.world.item.crafting.MapExtendingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RepairItemRecipe;
import net.minecraft.world.item.crafting.ShieldDecorationRecipe;
import net.minecraft.world.item.crafting.ShulkerBoxColoring;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.SuspiciousStewRecipe;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class VanillaRecipeProvider
extends RecipeProvider {
    private static final ImmutableList<ItemLike> COAL_SMELTABLES = ImmutableList.of((Object)Items.COAL_ORE, (Object)Items.DEEPSLATE_COAL_ORE);
    private static final ImmutableList<ItemLike> IRON_SMELTABLES = ImmutableList.of((Object)Items.IRON_ORE, (Object)Items.DEEPSLATE_IRON_ORE, (Object)Items.RAW_IRON);
    private static final ImmutableList<ItemLike> COPPER_SMELTABLES = ImmutableList.of((Object)Items.COPPER_ORE, (Object)Items.DEEPSLATE_COPPER_ORE, (Object)Items.RAW_COPPER);
    private static final ImmutableList<ItemLike> GOLD_SMELTABLES = ImmutableList.of((Object)Items.GOLD_ORE, (Object)Items.DEEPSLATE_GOLD_ORE, (Object)Items.NETHER_GOLD_ORE, (Object)Items.RAW_GOLD);
    private static final ImmutableList<ItemLike> DIAMOND_SMELTABLES = ImmutableList.of((Object)Items.DIAMOND_ORE, (Object)Items.DEEPSLATE_DIAMOND_ORE);
    private static final ImmutableList<ItemLike> LAPIS_SMELTABLES = ImmutableList.of((Object)Items.LAPIS_ORE, (Object)Items.DEEPSLATE_LAPIS_ORE);
    private static final ImmutableList<ItemLike> REDSTONE_SMELTABLES = ImmutableList.of((Object)Items.REDSTONE_ORE, (Object)Items.DEEPSLATE_REDSTONE_ORE);
    private static final ImmutableList<ItemLike> EMERALD_SMELTABLES = ImmutableList.of((Object)Items.EMERALD_ORE, (Object)Items.DEEPSLATE_EMERALD_ORE);

    public VanillaRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookupFuture) {
        super(output, registryLookupFuture);
    }

    @Override
    @Override
    public CompletableFuture<?> run(CachedOutput writer, HolderLookup.Provider registryLookup) {
        return CompletableFuture.allOf(super.run(writer, registryLookup), this.buildAdvancement(writer, registryLookup, Advancement.Builder.recipeAdvancement().addCriterion("impossible", CriteriaTriggers.IMPOSSIBLE.createCriterion(new ImpossibleTrigger.TriggerInstance())).build(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT)));
    }

    @Override
    @Override
    protected void buildRecipes(RecipeOutput exporter) {
        VanillaRecipeProvider.generateForEnabledBlockFamilies(exporter, FeatureFlagSet.of(FeatureFlags.VANILLA));
        VanillaRecipeProvider.planksFromLog(exporter, Blocks.ACACIA_PLANKS, ItemTags.ACACIA_LOGS, 4);
        VanillaRecipeProvider.planksFromLogs(exporter, Blocks.BIRCH_PLANKS, ItemTags.BIRCH_LOGS, 4);
        VanillaRecipeProvider.planksFromLogs(exporter, Blocks.CRIMSON_PLANKS, ItemTags.CRIMSON_STEMS, 4);
        VanillaRecipeProvider.planksFromLog(exporter, Blocks.DARK_OAK_PLANKS, ItemTags.DARK_OAK_LOGS, 4);
        VanillaRecipeProvider.planksFromLogs(exporter, Blocks.JUNGLE_PLANKS, ItemTags.JUNGLE_LOGS, 4);
        VanillaRecipeProvider.planksFromLogs(exporter, Blocks.OAK_PLANKS, ItemTags.OAK_LOGS, 4);
        VanillaRecipeProvider.planksFromLogs(exporter, Blocks.SPRUCE_PLANKS, ItemTags.SPRUCE_LOGS, 4);
        VanillaRecipeProvider.planksFromLogs(exporter, Blocks.WARPED_PLANKS, ItemTags.WARPED_STEMS, 4);
        VanillaRecipeProvider.planksFromLogs(exporter, Blocks.MANGROVE_PLANKS, ItemTags.MANGROVE_LOGS, 4);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.ACACIA_WOOD, Blocks.ACACIA_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.BIRCH_WOOD, Blocks.BIRCH_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.DARK_OAK_WOOD, Blocks.DARK_OAK_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.JUNGLE_WOOD, Blocks.JUNGLE_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.OAK_WOOD, Blocks.OAK_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.SPRUCE_WOOD, Blocks.SPRUCE_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.CRIMSON_HYPHAE, Blocks.CRIMSON_STEM);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.WARPED_HYPHAE, Blocks.WARPED_STEM);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.MANGROVE_WOOD, Blocks.MANGROVE_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.STRIPPED_ACACIA_WOOD, Blocks.STRIPPED_ACACIA_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.STRIPPED_BIRCH_WOOD, Blocks.STRIPPED_BIRCH_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.STRIPPED_DARK_OAK_WOOD, Blocks.STRIPPED_DARK_OAK_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.STRIPPED_JUNGLE_WOOD, Blocks.STRIPPED_JUNGLE_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.STRIPPED_OAK_WOOD, Blocks.STRIPPED_OAK_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.STRIPPED_SPRUCE_WOOD, Blocks.STRIPPED_SPRUCE_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.STRIPPED_CRIMSON_HYPHAE, Blocks.STRIPPED_CRIMSON_STEM);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.STRIPPED_WARPED_HYPHAE, Blocks.STRIPPED_WARPED_STEM);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.STRIPPED_MANGROVE_WOOD, Blocks.STRIPPED_MANGROVE_LOG);
        VanillaRecipeProvider.woodenBoat(exporter, Items.ACACIA_BOAT, Blocks.ACACIA_PLANKS);
        VanillaRecipeProvider.woodenBoat(exporter, Items.BIRCH_BOAT, Blocks.BIRCH_PLANKS);
        VanillaRecipeProvider.woodenBoat(exporter, Items.DARK_OAK_BOAT, Blocks.DARK_OAK_PLANKS);
        VanillaRecipeProvider.woodenBoat(exporter, Items.JUNGLE_BOAT, Blocks.JUNGLE_PLANKS);
        VanillaRecipeProvider.woodenBoat(exporter, Items.OAK_BOAT, Blocks.OAK_PLANKS);
        VanillaRecipeProvider.woodenBoat(exporter, Items.SPRUCE_BOAT, Blocks.SPRUCE_PLANKS);
        VanillaRecipeProvider.woodenBoat(exporter, Items.MANGROVE_BOAT, Blocks.MANGROVE_PLANKS);
        List<Item> list = List.of(Items.BLACK_DYE, Items.BLUE_DYE, Items.BROWN_DYE, Items.CYAN_DYE, Items.GRAY_DYE, Items.GREEN_DYE, Items.LIGHT_BLUE_DYE, Items.LIGHT_GRAY_DYE, Items.LIME_DYE, Items.MAGENTA_DYE, Items.ORANGE_DYE, Items.PINK_DYE, Items.PURPLE_DYE, Items.RED_DYE, Items.YELLOW_DYE, Items.WHITE_DYE);
        List<Item> list2 = List.of(Items.BLACK_WOOL, Items.BLUE_WOOL, Items.BROWN_WOOL, Items.CYAN_WOOL, Items.GRAY_WOOL, Items.GREEN_WOOL, Items.LIGHT_BLUE_WOOL, Items.LIGHT_GRAY_WOOL, Items.LIME_WOOL, Items.MAGENTA_WOOL, Items.ORANGE_WOOL, Items.PINK_WOOL, Items.PURPLE_WOOL, Items.RED_WOOL, Items.YELLOW_WOOL, Items.WHITE_WOOL);
        List<Item> list3 = List.of(Items.BLACK_BED, Items.BLUE_BED, Items.BROWN_BED, Items.CYAN_BED, Items.GRAY_BED, Items.GREEN_BED, Items.LIGHT_BLUE_BED, Items.LIGHT_GRAY_BED, Items.LIME_BED, Items.MAGENTA_BED, Items.ORANGE_BED, Items.PINK_BED, Items.PURPLE_BED, Items.RED_BED, Items.YELLOW_BED, Items.WHITE_BED);
        List<Item> list4 = List.of(Items.BLACK_CARPET, Items.BLUE_CARPET, Items.BROWN_CARPET, Items.CYAN_CARPET, Items.GRAY_CARPET, Items.GREEN_CARPET, Items.LIGHT_BLUE_CARPET, Items.LIGHT_GRAY_CARPET, Items.LIME_CARPET, Items.MAGENTA_CARPET, Items.ORANGE_CARPET, Items.PINK_CARPET, Items.PURPLE_CARPET, Items.RED_CARPET, Items.YELLOW_CARPET, Items.WHITE_CARPET);
        VanillaRecipeProvider.colorBlockWithDye(exporter, list, list2, "wool");
        VanillaRecipeProvider.colorBlockWithDye(exporter, list, list3, "bed");
        VanillaRecipeProvider.colorBlockWithDye(exporter, list, list4, "carpet");
        VanillaRecipeProvider.carpet(exporter, Blocks.BLACK_CARPET, Blocks.BLACK_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.BLACK_BED, Blocks.BLACK_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.BLACK_BANNER, Blocks.BLACK_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.BLUE_CARPET, Blocks.BLUE_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.BLUE_BED, Blocks.BLUE_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.BLUE_BANNER, Blocks.BLUE_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.BROWN_CARPET, Blocks.BROWN_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.BROWN_BED, Blocks.BROWN_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.BROWN_BANNER, Blocks.BROWN_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.CYAN_CARPET, Blocks.CYAN_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.CYAN_BED, Blocks.CYAN_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.CYAN_BANNER, Blocks.CYAN_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.GRAY_CARPET, Blocks.GRAY_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.GRAY_BED, Blocks.GRAY_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.GRAY_BANNER, Blocks.GRAY_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.GREEN_CARPET, Blocks.GREEN_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.GREEN_BED, Blocks.GREEN_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.GREEN_BANNER, Blocks.GREEN_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.LIGHT_BLUE_CARPET, Blocks.LIGHT_BLUE_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.LIGHT_BLUE_BED, Blocks.LIGHT_BLUE_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.LIGHT_BLUE_BANNER, Blocks.LIGHT_BLUE_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.LIGHT_GRAY_CARPET, Blocks.LIGHT_GRAY_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.LIGHT_GRAY_BED, Blocks.LIGHT_GRAY_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.LIGHT_GRAY_BANNER, Blocks.LIGHT_GRAY_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.LIME_CARPET, Blocks.LIME_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.LIME_BED, Blocks.LIME_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.LIME_BANNER, Blocks.LIME_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.MAGENTA_CARPET, Blocks.MAGENTA_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.MAGENTA_BED, Blocks.MAGENTA_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.MAGENTA_BANNER, Blocks.MAGENTA_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.ORANGE_CARPET, Blocks.ORANGE_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.ORANGE_BED, Blocks.ORANGE_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.ORANGE_BANNER, Blocks.ORANGE_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.PINK_CARPET, Blocks.PINK_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.PINK_BED, Blocks.PINK_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.PINK_BANNER, Blocks.PINK_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.PURPLE_CARPET, Blocks.PURPLE_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.PURPLE_BED, Blocks.PURPLE_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.PURPLE_BANNER, Blocks.PURPLE_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.RED_CARPET, Blocks.RED_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.RED_BED, Blocks.RED_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.RED_BANNER, Blocks.RED_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.WHITE_CARPET, Blocks.WHITE_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.WHITE_BED, Blocks.WHITE_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.WHITE_BANNER, Blocks.WHITE_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.YELLOW_CARPET, Blocks.YELLOW_WOOL);
        VanillaRecipeProvider.bedFromPlanksAndWool(exporter, Items.YELLOW_BED, Blocks.YELLOW_WOOL);
        VanillaRecipeProvider.banner(exporter, Items.YELLOW_BANNER, Blocks.YELLOW_WOOL);
        VanillaRecipeProvider.carpet(exporter, Blocks.MOSS_CARPET, Blocks.MOSS_BLOCK);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.BLACK_STAINED_GLASS, Items.BLACK_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.BLACK_STAINED_GLASS_PANE, Blocks.BLACK_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.BLACK_STAINED_GLASS_PANE, Items.BLACK_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.BLUE_STAINED_GLASS, Items.BLUE_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.BLUE_STAINED_GLASS_PANE, Blocks.BLUE_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.BLUE_STAINED_GLASS_PANE, Items.BLUE_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.BROWN_STAINED_GLASS, Items.BROWN_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.BROWN_STAINED_GLASS_PANE, Blocks.BROWN_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.BROWN_STAINED_GLASS_PANE, Items.BROWN_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.CYAN_STAINED_GLASS, Items.CYAN_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.CYAN_STAINED_GLASS_PANE, Blocks.CYAN_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.CYAN_STAINED_GLASS_PANE, Items.CYAN_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.GRAY_STAINED_GLASS, Items.GRAY_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.GRAY_STAINED_GLASS_PANE, Blocks.GRAY_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.GRAY_STAINED_GLASS_PANE, Items.GRAY_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.GREEN_STAINED_GLASS, Items.GREEN_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.GREEN_STAINED_GLASS_PANE, Blocks.GREEN_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.GREEN_STAINED_GLASS_PANE, Items.GREEN_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.LIGHT_BLUE_STAINED_GLASS, Items.LIGHT_BLUE_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.LIGHT_BLUE_STAINED_GLASS_PANE, Blocks.LIGHT_BLUE_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.LIGHT_BLUE_STAINED_GLASS_PANE, Items.LIGHT_BLUE_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.LIGHT_GRAY_STAINED_GLASS, Items.LIGHT_GRAY_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.LIGHT_GRAY_STAINED_GLASS_PANE, Blocks.LIGHT_GRAY_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.LIGHT_GRAY_STAINED_GLASS_PANE, Items.LIGHT_GRAY_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.LIME_STAINED_GLASS, Items.LIME_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.LIME_STAINED_GLASS_PANE, Blocks.LIME_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.LIME_STAINED_GLASS_PANE, Items.LIME_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.MAGENTA_STAINED_GLASS, Items.MAGENTA_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.MAGENTA_STAINED_GLASS_PANE, Blocks.MAGENTA_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.MAGENTA_STAINED_GLASS_PANE, Items.MAGENTA_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.ORANGE_STAINED_GLASS, Items.ORANGE_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.ORANGE_STAINED_GLASS_PANE, Blocks.ORANGE_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.ORANGE_STAINED_GLASS_PANE, Items.ORANGE_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.PINK_STAINED_GLASS, Items.PINK_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.PINK_STAINED_GLASS_PANE, Blocks.PINK_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.PINK_STAINED_GLASS_PANE, Items.PINK_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.PURPLE_STAINED_GLASS, Items.PURPLE_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.PURPLE_STAINED_GLASS_PANE, Blocks.PURPLE_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.PURPLE_STAINED_GLASS_PANE, Items.PURPLE_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.RED_STAINED_GLASS, Items.RED_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.RED_STAINED_GLASS_PANE, Blocks.RED_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.RED_STAINED_GLASS_PANE, Items.RED_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.WHITE_STAINED_GLASS, Items.WHITE_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.WHITE_STAINED_GLASS_PANE, Blocks.WHITE_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.WHITE_STAINED_GLASS_PANE, Items.WHITE_DYE);
        VanillaRecipeProvider.stainedGlassFromGlassAndDye(exporter, Blocks.YELLOW_STAINED_GLASS, Items.YELLOW_DYE);
        VanillaRecipeProvider.stainedGlassPaneFromStainedGlass(exporter, Blocks.YELLOW_STAINED_GLASS_PANE, Blocks.YELLOW_STAINED_GLASS);
        VanillaRecipeProvider.stainedGlassPaneFromGlassPaneAndDye(exporter, Blocks.YELLOW_STAINED_GLASS_PANE, Items.YELLOW_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.BLACK_TERRACOTTA, Items.BLACK_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.BLUE_TERRACOTTA, Items.BLUE_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.BROWN_TERRACOTTA, Items.BROWN_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.CYAN_TERRACOTTA, Items.CYAN_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.GRAY_TERRACOTTA, Items.GRAY_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.GREEN_TERRACOTTA, Items.GREEN_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.LIGHT_BLUE_TERRACOTTA, Items.LIGHT_BLUE_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.LIGHT_GRAY_TERRACOTTA, Items.LIGHT_GRAY_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.LIME_TERRACOTTA, Items.LIME_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.MAGENTA_TERRACOTTA, Items.MAGENTA_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.ORANGE_TERRACOTTA, Items.ORANGE_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.PINK_TERRACOTTA, Items.PINK_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.PURPLE_TERRACOTTA, Items.PURPLE_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.RED_TERRACOTTA, Items.RED_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.WHITE_TERRACOTTA, Items.WHITE_DYE);
        VanillaRecipeProvider.coloredTerracottaFromTerracottaAndDye(exporter, Blocks.YELLOW_TERRACOTTA, Items.YELLOW_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.BLACK_CONCRETE_POWDER, Items.BLACK_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.BLUE_CONCRETE_POWDER, Items.BLUE_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.BROWN_CONCRETE_POWDER, Items.BROWN_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.CYAN_CONCRETE_POWDER, Items.CYAN_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.GRAY_CONCRETE_POWDER, Items.GRAY_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.GREEN_CONCRETE_POWDER, Items.GREEN_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.LIGHT_BLUE_CONCRETE_POWDER, Items.LIGHT_BLUE_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.LIGHT_GRAY_CONCRETE_POWDER, Items.LIGHT_GRAY_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.LIME_CONCRETE_POWDER, Items.LIME_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.MAGENTA_CONCRETE_POWDER, Items.MAGENTA_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.ORANGE_CONCRETE_POWDER, Items.ORANGE_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.PINK_CONCRETE_POWDER, Items.PINK_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.PURPLE_CONCRETE_POWDER, Items.PURPLE_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.RED_CONCRETE_POWDER, Items.RED_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.WHITE_CONCRETE_POWDER, Items.WHITE_DYE);
        VanillaRecipeProvider.concretePowder(exporter, Blocks.YELLOW_CONCRETE_POWDER, Items.YELLOW_DYE);
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Items.CANDLE).define(Character.valueOf('S'), Items.STRING).define(Character.valueOf('H'), Items.HONEYCOMB).pattern("S").pattern("H").unlockedBy("has_string", (Criterion)VanillaRecipeProvider.has(Items.STRING))).unlockedBy("has_honeycomb", (Criterion)VanillaRecipeProvider.has(Items.HONEYCOMB)).save(exporter);
        VanillaRecipeProvider.candle(exporter, Blocks.BLACK_CANDLE, Items.BLACK_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.BLUE_CANDLE, Items.BLUE_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.BROWN_CANDLE, Items.BROWN_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.CYAN_CANDLE, Items.CYAN_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.GRAY_CANDLE, Items.GRAY_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.GREEN_CANDLE, Items.GREEN_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.LIGHT_BLUE_CANDLE, Items.LIGHT_BLUE_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.LIGHT_GRAY_CANDLE, Items.LIGHT_GRAY_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.LIME_CANDLE, Items.LIME_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.MAGENTA_CANDLE, Items.MAGENTA_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.ORANGE_CANDLE, Items.ORANGE_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.PINK_CANDLE, Items.PINK_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.PURPLE_CANDLE, Items.PURPLE_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.RED_CANDLE, Items.RED_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.WHITE_CANDLE, Items.WHITE_DYE);
        VanillaRecipeProvider.candle(exporter, Blocks.YELLOW_CANDLE, Items.YELLOW_DYE);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.PACKED_MUD, 1).requires(Blocks.MUD).requires(Items.WHEAT).unlockedBy("has_mud", (Criterion)VanillaRecipeProvider.has(Blocks.MUD)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.MUD_BRICKS, 4).define(Character.valueOf('#'), Blocks.PACKED_MUD).pattern("##").pattern("##").unlockedBy("has_packed_mud", (Criterion)VanillaRecipeProvider.has(Blocks.PACKED_MUD)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.MUDDY_MANGROVE_ROOTS, 1).requires(Blocks.MUD).requires(Items.MANGROVE_ROOTS).unlockedBy("has_mangrove_roots", (Criterion)VanillaRecipeProvider.has(Blocks.MANGROVE_ROOTS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TRANSPORTATION, Blocks.ACTIVATOR_RAIL, 6).define(Character.valueOf('#'), Blocks.REDSTONE_TORCH).define(Character.valueOf('S'), Items.STICK).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("XSX").pattern("X#X").pattern("XSX").unlockedBy("has_rail", (Criterion)VanillaRecipeProvider.has(Blocks.RAIL)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.ANDESITE, 2).requires(Blocks.DIORITE).requires(Blocks.COBBLESTONE).unlockedBy("has_stone", (Criterion)VanillaRecipeProvider.has(Blocks.DIORITE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.ANVIL).define(Character.valueOf('I'), Blocks.IRON_BLOCK).define(Character.valueOf('i'), Items.IRON_INGOT).pattern("III").pattern(" i ").pattern("iii").unlockedBy("has_iron_block", (Criterion)VanillaRecipeProvider.has(Blocks.IRON_BLOCK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Items.ARMOR_STAND).define(Character.valueOf('/'), Items.STICK).define(Character.valueOf('_'), Blocks.SMOOTH_STONE_SLAB).pattern("///").pattern(" / ").pattern("/_/").unlockedBy("has_stone_slab", (Criterion)VanillaRecipeProvider.has(Blocks.SMOOTH_STONE_SLAB)).save(exporter);
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.ARROW, 4).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.FLINT).define(Character.valueOf('Y'), Items.FEATHER).pattern("X").pattern("#").pattern("Y").unlockedBy("has_feather", (Criterion)VanillaRecipeProvider.has(Items.FEATHER))).unlockedBy("has_flint", (Criterion)VanillaRecipeProvider.has(Items.FLINT)).save(exporter);
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.BARREL, 1).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).pattern("PSP").pattern("P P").pattern("PSP").unlockedBy("has_planks", (Criterion)VanillaRecipeProvider.has(ItemTags.PLANKS))).unlockedBy("has_wood_slab", (Criterion)VanillaRecipeProvider.has(ItemTags.WOODEN_SLABS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, Blocks.BEACON).define(Character.valueOf('S'), Items.NETHER_STAR).define(Character.valueOf('G'), Blocks.GLASS).define(Character.valueOf('O'), Blocks.OBSIDIAN).pattern("GGG").pattern("GSG").pattern("OOO").unlockedBy("has_nether_star", (Criterion)VanillaRecipeProvider.has(Items.NETHER_STAR)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.BEEHIVE).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('H'), Items.HONEYCOMB).pattern("PPP").pattern("HHH").pattern("PPP").unlockedBy("has_honeycomb", (Criterion)VanillaRecipeProvider.has(Items.HONEYCOMB)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.FOOD, Items.BEETROOT_SOUP).requires(Items.BOWL).requires(Items.BEETROOT, 6).unlockedBy("has_beetroot", (Criterion)VanillaRecipeProvider.has(Items.BEETROOT)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.BLACK_DYE).requires(Items.INK_SAC).group("black_dye").unlockedBy("has_ink_sac", (Criterion)VanillaRecipeProvider.has(Items.INK_SAC)).save(exporter);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.BLACK_DYE, Blocks.WITHER_ROSE, "black_dye");
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BREWING, Items.BLAZE_POWDER, 2).requires(Items.BLAZE_ROD).unlockedBy("has_blaze_rod", (Criterion)VanillaRecipeProvider.has(Items.BLAZE_ROD)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.BLUE_DYE).requires(Items.LAPIS_LAZULI).group("blue_dye").unlockedBy("has_lapis_lazuli", (Criterion)VanillaRecipeProvider.has(Items.LAPIS_LAZULI)).save(exporter);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.BLUE_DYE, Blocks.CORNFLOWER, "blue_dye");
        VanillaRecipeProvider.threeByThreePacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.BLUE_ICE, Blocks.PACKED_ICE);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.BONE_MEAL, 3).requires(Items.BONE).group("bonemeal").unlockedBy("has_bone", (Criterion)VanillaRecipeProvider.has(Items.BONE)).save(exporter);
        VanillaRecipeProvider.nineBlockStorageRecipesRecipesWithCustomUnpacking(exporter, RecipeCategory.MISC, Items.BONE_MEAL, RecipeCategory.BUILDING_BLOCKS, Items.BONE_BLOCK, "bone_meal_from_bone_block", "bonemeal");
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.BOOK).requires(Items.PAPER, 3).requires(Items.LEATHER).unlockedBy("has_paper", (Criterion)VanillaRecipeProvider.has(Items.PAPER)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.BOOKSHELF).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), Items.BOOK).pattern("###").pattern("XXX").pattern("###").unlockedBy("has_book", (Criterion)VanillaRecipeProvider.has(Items.BOOK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.BOW).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.STRING).pattern(" #X").pattern("# X").pattern(" #X").unlockedBy("has_string", (Criterion)VanillaRecipeProvider.has(Items.STRING)).save(exporter);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.MISC, Items.BOWL, 4).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("# #").pattern(" # ").unlockedBy("has_brown_mushroom", (Criterion)VanillaRecipeProvider.has(Blocks.BROWN_MUSHROOM))).unlockedBy("has_red_mushroom", (Criterion)VanillaRecipeProvider.has(Blocks.RED_MUSHROOM))).unlockedBy("has_mushroom_stew", (Criterion)VanillaRecipeProvider.has(Items.MUSHROOM_STEW)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.FOOD, Items.BREAD).define(Character.valueOf('#'), Items.WHEAT).pattern("###").unlockedBy("has_wheat", (Criterion)VanillaRecipeProvider.has(Items.WHEAT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BREWING, Blocks.BREWING_STAND).define(Character.valueOf('B'), Items.BLAZE_ROD).define(Character.valueOf('#'), ItemTags.STONE_CRAFTING_MATERIALS).pattern(" B ").pattern("###").unlockedBy("has_blaze_rod", (Criterion)VanillaRecipeProvider.has(Items.BLAZE_ROD)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.BRICKS).define(Character.valueOf('#'), Items.BRICK).pattern("##").pattern("##").unlockedBy("has_brick", (Criterion)VanillaRecipeProvider.has(Items.BRICK)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.BROWN_DYE).requires(Items.COCOA_BEANS).group("brown_dye").unlockedBy("has_cocoa_beans", (Criterion)VanillaRecipeProvider.has(Items.COCOA_BEANS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, Items.BUCKET).define(Character.valueOf('#'), Items.IRON_INGOT).pattern("# #").pattern(" # ").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.FOOD, Blocks.CAKE).define(Character.valueOf('A'), Items.MILK_BUCKET).define(Character.valueOf('B'), Items.SUGAR).define(Character.valueOf('C'), Items.WHEAT).define(Character.valueOf('E'), Items.EGG).pattern("AAA").pattern("BEB").pattern("CCC").unlockedBy("has_egg", (Criterion)VanillaRecipeProvider.has(Items.EGG)).save(exporter);
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.CAMPFIRE).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('S'), Items.STICK).define(Character.valueOf('C'), ItemTags.COALS).pattern(" S ").pattern("SCS").pattern("LLL").unlockedBy("has_stick", (Criterion)VanillaRecipeProvider.has(Items.STICK))).unlockedBy("has_coal", (Criterion)VanillaRecipeProvider.has(ItemTags.COALS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TRANSPORTATION, Items.CARROT_ON_A_STICK).define(Character.valueOf('#'), Items.FISHING_ROD).define(Character.valueOf('X'), Items.CARROT).pattern("# ").pattern(" X").unlockedBy("has_carrot", (Criterion)VanillaRecipeProvider.has(Items.CARROT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TRANSPORTATION, Items.WARPED_FUNGUS_ON_A_STICK).define(Character.valueOf('#'), Items.FISHING_ROD).define(Character.valueOf('X'), Items.WARPED_FUNGUS).pattern("# ").pattern(" X").unlockedBy("has_warped_fungus", (Criterion)VanillaRecipeProvider.has(Items.WARPED_FUNGUS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BREWING, Blocks.CAULDRON).define(Character.valueOf('#'), Items.IRON_INGOT).pattern("# #").pattern("# #").pattern("###").unlockedBy("has_water_bucket", (Criterion)VanillaRecipeProvider.has(Items.WATER_BUCKET)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.COMPOSTER).define(Character.valueOf('#'), ItemTags.WOODEN_SLABS).pattern("# #").pattern("# #").pattern("###").unlockedBy("has_wood_slab", (Criterion)VanillaRecipeProvider.has(ItemTags.WOODEN_SLABS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.CHEST).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("###").pattern("# #").pattern("###").unlockedBy("has_lots_of_items", (Criterion)CriteriaTriggers.INVENTORY_CHANGED.createCriterion(new InventoryChangeTrigger.TriggerInstance(Optional.empty(), new InventoryChangeTrigger.TriggerInstance.Slots(MinMaxBounds.Ints.atLeast(10), MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY), List.of()))).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.TRANSPORTATION, Items.CHEST_MINECART).requires(Blocks.CHEST).requires(Items.MINECART).unlockedBy("has_minecart", (Criterion)VanillaRecipeProvider.has(Items.MINECART)).save(exporter);
        VanillaRecipeProvider.chestBoat(exporter, Items.ACACIA_CHEST_BOAT, Items.ACACIA_BOAT);
        VanillaRecipeProvider.chestBoat(exporter, Items.BIRCH_CHEST_BOAT, Items.BIRCH_BOAT);
        VanillaRecipeProvider.chestBoat(exporter, Items.DARK_OAK_CHEST_BOAT, Items.DARK_OAK_BOAT);
        VanillaRecipeProvider.chestBoat(exporter, Items.JUNGLE_CHEST_BOAT, Items.JUNGLE_BOAT);
        VanillaRecipeProvider.chestBoat(exporter, Items.OAK_CHEST_BOAT, Items.OAK_BOAT);
        VanillaRecipeProvider.chestBoat(exporter, Items.SPRUCE_CHEST_BOAT, Items.SPRUCE_BOAT);
        VanillaRecipeProvider.chestBoat(exporter, Items.MANGROVE_CHEST_BOAT, Items.MANGROVE_BOAT);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)VanillaRecipeProvider.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_QUARTZ_BLOCK, Ingredient.of(Blocks.QUARTZ_SLAB)).unlockedBy("has_chiseled_quartz_block", (Criterion)VanillaRecipeProvider.has(Blocks.CHISELED_QUARTZ_BLOCK))).unlockedBy("has_quartz_block", (Criterion)VanillaRecipeProvider.has(Blocks.QUARTZ_BLOCK))).unlockedBy("has_quartz_pillar", (Criterion)VanillaRecipeProvider.has(Blocks.QUARTZ_PILLAR)).save(exporter);
        VanillaRecipeProvider.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_STONE_BRICKS, Ingredient.of(Blocks.STONE_BRICK_SLAB)).unlockedBy("has_tag", (Criterion)VanillaRecipeProvider.has(ItemTags.STONE_BRICKS)).save(exporter);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CLAY, Items.CLAY_BALL);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.CLOCK).define(Character.valueOf('#'), Items.GOLD_INGOT).define(Character.valueOf('X'), Items.REDSTONE).pattern(" # ").pattern("#X#").pattern(" # ").unlockedBy("has_redstone", (Criterion)VanillaRecipeProvider.has(Items.REDSTONE)).save(exporter);
        VanillaRecipeProvider.nineBlockStorageRecipes(exporter, RecipeCategory.MISC, Items.COAL, RecipeCategory.BUILDING_BLOCKS, Items.COAL_BLOCK);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.COARSE_DIRT, 4).define(Character.valueOf('D'), Blocks.DIRT).define(Character.valueOf('G'), Blocks.GRAVEL).pattern("DG").pattern("GD").unlockedBy("has_gravel", (Criterion)VanillaRecipeProvider.has(Blocks.GRAVEL)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.COMPARATOR).define(Character.valueOf('#'), Blocks.REDSTONE_TORCH).define(Character.valueOf('X'), Items.QUARTZ).define(Character.valueOf('I'), Blocks.STONE).pattern(" # ").pattern("#X#").pattern("III").unlockedBy("has_quartz", (Criterion)VanillaRecipeProvider.has(Items.QUARTZ)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.COMPASS).define(Character.valueOf('#'), Items.IRON_INGOT).define(Character.valueOf('X'), Items.REDSTONE).pattern(" # ").pattern("#X#").pattern(" # ").unlockedBy("has_redstone", (Criterion)VanillaRecipeProvider.has(Items.REDSTONE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.FOOD, Items.COOKIE, 8).define(Character.valueOf('#'), Items.WHEAT).define(Character.valueOf('X'), Items.COCOA_BEANS).pattern("#X#").unlockedBy("has_cocoa", (Criterion)VanillaRecipeProvider.has(Items.COCOA_BEANS)).save(exporter);
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.CRAFTING_TABLE).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("##").pattern("##").unlockedBy("unlock_right_away", (Criterion)PlayerTrigger.TriggerInstance.tick())).showNotification(false).save(exporter);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.CROSSBOW).define(Character.valueOf('~'), Items.STRING).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('&'), Items.IRON_INGOT).define(Character.valueOf('$'), Blocks.TRIPWIRE_HOOK).pattern("#&#").pattern("~$~").pattern(" # ").unlockedBy("has_string", (Criterion)VanillaRecipeProvider.has(Items.STRING))).unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT))).unlockedBy("has_tripwire_hook", (Criterion)VanillaRecipeProvider.has(Blocks.TRIPWIRE_HOOK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.LOOM).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), Items.STRING).pattern("@@").pattern("##").unlockedBy("has_string", (Criterion)VanillaRecipeProvider.has(Items.STRING)).save(exporter);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)VanillaRecipeProvider.chiseledBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_RED_SANDSTONE, Ingredient.of(Blocks.RED_SANDSTONE_SLAB)).unlockedBy("has_red_sandstone", (Criterion)VanillaRecipeProvider.has(Blocks.RED_SANDSTONE))).unlockedBy("has_chiseled_red_sandstone", (Criterion)VanillaRecipeProvider.has(Blocks.CHISELED_RED_SANDSTONE))).unlockedBy("has_cut_red_sandstone", (Criterion)VanillaRecipeProvider.has(Blocks.CUT_RED_SANDSTONE)).save(exporter);
        VanillaRecipeProvider.chiseled(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_SANDSTONE, Blocks.SANDSTONE_SLAB);
        VanillaRecipeProvider.nineBlockStorageRecipesRecipesWithCustomUnpacking(exporter, RecipeCategory.MISC, Items.COPPER_INGOT, RecipeCategory.BUILDING_BLOCKS, Items.COPPER_BLOCK, VanillaRecipeProvider.getSimpleRecipeName(Items.COPPER_INGOT), VanillaRecipeProvider.getItemName(Items.COPPER_INGOT));
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.COPPER_INGOT, 9).requires(Blocks.WAXED_COPPER_BLOCK).group(VanillaRecipeProvider.getItemName(Items.COPPER_INGOT)).unlockedBy(VanillaRecipeProvider.getHasName(Blocks.WAXED_COPPER_BLOCK), (Criterion)VanillaRecipeProvider.has(Blocks.WAXED_COPPER_BLOCK)).save(exporter, VanillaRecipeProvider.getConversionRecipeName(Items.COPPER_INGOT, Blocks.WAXED_COPPER_BLOCK));
        VanillaRecipeProvider.waxRecipes(exporter, FeatureFlagSet.of(FeatureFlags.VANILLA));
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.CYAN_DYE, 2).requires(Items.BLUE_DYE).requires(Items.GREEN_DYE).group("cyan_dye").unlockedBy("has_green_dye", (Criterion)VanillaRecipeProvider.has(Items.GREEN_DYE))).unlockedBy("has_blue_dye", (Criterion)VanillaRecipeProvider.has(Items.BLUE_DYE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.DARK_PRISMARINE).define(Character.valueOf('S'), Items.PRISMARINE_SHARD).define(Character.valueOf('I'), Items.BLACK_DYE).pattern("SSS").pattern("SIS").pattern("SSS").unlockedBy("has_prismarine_shard", (Criterion)VanillaRecipeProvider.has(Items.PRISMARINE_SHARD)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.DAYLIGHT_DETECTOR).define(Character.valueOf('Q'), Items.QUARTZ).define(Character.valueOf('G'), Blocks.GLASS).define(Character.valueOf('W'), Ingredient.of(ItemTags.WOODEN_SLABS)).pattern("GGG").pattern("QQQ").pattern("WWW").unlockedBy("has_quartz", (Criterion)VanillaRecipeProvider.has(Items.QUARTZ)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICKS, 4).define(Character.valueOf('S'), Blocks.POLISHED_DEEPSLATE).pattern("SS").pattern("SS").unlockedBy("has_polished_deepslate", (Criterion)VanillaRecipeProvider.has(Blocks.POLISHED_DEEPSLATE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILES, 4).define(Character.valueOf('S'), Blocks.DEEPSLATE_BRICKS).pattern("SS").pattern("SS").unlockedBy("has_deepslate_bricks", (Criterion)VanillaRecipeProvider.has(Blocks.DEEPSLATE_BRICKS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TRANSPORTATION, Blocks.DETECTOR_RAIL, 6).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Blocks.STONE_PRESSURE_PLATE).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("X X").pattern("X#X").pattern("XRX").unlockedBy("has_rail", (Criterion)VanillaRecipeProvider.has(Blocks.RAIL)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.DIAMOND_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.DIAMOND).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_diamond", (Criterion)VanillaRecipeProvider.has(Items.DIAMOND)).save(exporter);
        VanillaRecipeProvider.nineBlockStorageRecipes(exporter, RecipeCategory.MISC, Items.DIAMOND, RecipeCategory.BUILDING_BLOCKS, Items.DIAMOND_BLOCK);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.DIAMOND_BOOTS).define(Character.valueOf('X'), Items.DIAMOND).pattern("X X").pattern("X X").unlockedBy("has_diamond", (Criterion)VanillaRecipeProvider.has(Items.DIAMOND)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.DIAMOND_CHESTPLATE).define(Character.valueOf('X'), Items.DIAMOND).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_diamond", (Criterion)VanillaRecipeProvider.has(Items.DIAMOND)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.DIAMOND_HELMET).define(Character.valueOf('X'), Items.DIAMOND).pattern("XXX").pattern("X X").unlockedBy("has_diamond", (Criterion)VanillaRecipeProvider.has(Items.DIAMOND)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.DIAMOND_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.DIAMOND).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_diamond", (Criterion)VanillaRecipeProvider.has(Items.DIAMOND)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.DIAMOND_LEGGINGS).define(Character.valueOf('X'), Items.DIAMOND).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_diamond", (Criterion)VanillaRecipeProvider.has(Items.DIAMOND)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.DIAMOND_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.DIAMOND).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_diamond", (Criterion)VanillaRecipeProvider.has(Items.DIAMOND)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.DIAMOND_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.DIAMOND).pattern("X").pattern("#").pattern("#").unlockedBy("has_diamond", (Criterion)VanillaRecipeProvider.has(Items.DIAMOND)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.DIAMOND_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.DIAMOND).pattern("X").pattern("X").pattern("#").unlockedBy("has_diamond", (Criterion)VanillaRecipeProvider.has(Items.DIAMOND)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.DIORITE, 2).define(Character.valueOf('Q'), Items.QUARTZ).define(Character.valueOf('C'), Blocks.COBBLESTONE).pattern("CQ").pattern("QC").unlockedBy("has_quartz", (Criterion)VanillaRecipeProvider.has(Items.QUARTZ)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.DISPENSER).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Blocks.COBBLESTONE).define(Character.valueOf('X'), Items.BOW).pattern("###").pattern("#X#").pattern("#R#").unlockedBy("has_bow", (Criterion)VanillaRecipeProvider.has(Items.BOW)).save(exporter);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DRIPSTONE_BLOCK, Items.POINTED_DRIPSTONE);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.DROPPER).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Blocks.COBBLESTONE).pattern("###").pattern("# #").pattern("#R#").unlockedBy("has_redstone", (Criterion)VanillaRecipeProvider.has(Items.REDSTONE)).save(exporter);
        VanillaRecipeProvider.nineBlockStorageRecipes(exporter, RecipeCategory.MISC, Items.EMERALD, RecipeCategory.BUILDING_BLOCKS, Items.EMERALD_BLOCK);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.ENCHANTING_TABLE).define(Character.valueOf('B'), Items.BOOK).define(Character.valueOf('#'), Blocks.OBSIDIAN).define(Character.valueOf('D'), Items.DIAMOND).pattern(" B ").pattern("D#D").pattern("###").unlockedBy("has_obsidian", (Criterion)VanillaRecipeProvider.has(Blocks.OBSIDIAN)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.ENDER_CHEST).define(Character.valueOf('#'), Blocks.OBSIDIAN).define(Character.valueOf('E'), Items.ENDER_EYE).pattern("###").pattern("#E#").pattern("###").unlockedBy("has_ender_eye", (Criterion)VanillaRecipeProvider.has(Items.ENDER_EYE)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.ENDER_EYE).requires(Items.ENDER_PEARL).requires(Items.BLAZE_POWDER).unlockedBy("has_blaze_powder", (Criterion)VanillaRecipeProvider.has(Items.BLAZE_POWDER)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICKS, 4).define(Character.valueOf('#'), Blocks.END_STONE).pattern("##").pattern("##").unlockedBy("has_end_stone", (Criterion)VanillaRecipeProvider.has(Blocks.END_STONE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Items.END_CRYSTAL).define(Character.valueOf('T'), Items.GHAST_TEAR).define(Character.valueOf('E'), Items.ENDER_EYE).define(Character.valueOf('G'), Blocks.GLASS).pattern("GGG").pattern("GEG").pattern("GTG").unlockedBy("has_ender_eye", (Criterion)VanillaRecipeProvider.has(Items.ENDER_EYE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.END_ROD, 4).define(Character.valueOf('#'), Items.POPPED_CHORUS_FRUIT).define(Character.valueOf('/'), Items.BLAZE_ROD).pattern("/").pattern("#").unlockedBy("has_chorus_fruit_popped", (Criterion)VanillaRecipeProvider.has(Items.POPPED_CHORUS_FRUIT)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BREWING, Items.FERMENTED_SPIDER_EYE).requires(Items.SPIDER_EYE).requires(Blocks.BROWN_MUSHROOM).requires(Items.SUGAR).unlockedBy("has_spider_eye", (Criterion)VanillaRecipeProvider.has(Items.SPIDER_EYE)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.FIRE_CHARGE, 3).requires(Items.GUNPOWDER).requires(Items.BLAZE_POWDER).requires(Ingredient.of(Items.COAL, Items.CHARCOAL)).unlockedBy("has_blaze_powder", (Criterion)VanillaRecipeProvider.has(Items.BLAZE_POWDER)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.FIREWORK_ROCKET, 3).requires(Items.GUNPOWDER).requires(Items.PAPER).unlockedBy("has_gunpowder", (Criterion)VanillaRecipeProvider.has(Items.GUNPOWDER)).save(exporter, "firework_rocket_simple");
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.FISHING_ROD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.STRING).pattern("  #").pattern(" #X").pattern("# X").unlockedBy("has_string", (Criterion)VanillaRecipeProvider.has(Items.STRING)).save(exporter);
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.TOOLS, Items.FLINT_AND_STEEL).requires(Items.IRON_INGOT).requires(Items.FLINT).unlockedBy("has_flint", (Criterion)VanillaRecipeProvider.has(Items.FLINT))).unlockedBy("has_obsidian", (Criterion)VanillaRecipeProvider.has(Blocks.OBSIDIAN)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.FLOWER_POT).define(Character.valueOf('#'), Items.BRICK).pattern("# #").pattern(" # ").unlockedBy("has_brick", (Criterion)VanillaRecipeProvider.has(Items.BRICK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.FURNACE).define(Character.valueOf('#'), ItemTags.STONE_CRAFTING_MATERIALS).pattern("###").pattern("# #").pattern("###").unlockedBy("has_cobblestone", (Criterion)VanillaRecipeProvider.has(ItemTags.STONE_CRAFTING_MATERIALS)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.TRANSPORTATION, Items.FURNACE_MINECART).requires(Blocks.FURNACE).requires(Items.MINECART).unlockedBy("has_minecart", (Criterion)VanillaRecipeProvider.has(Items.MINECART)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BREWING, Items.GLASS_BOTTLE, 3).define(Character.valueOf('#'), Blocks.GLASS).pattern("# #").pattern(" # ").unlockedBy("has_glass", (Criterion)VanillaRecipeProvider.has(Blocks.GLASS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.GLASS_PANE, 16).define(Character.valueOf('#'), Blocks.GLASS).pattern("###").pattern("###").unlockedBy("has_glass", (Criterion)VanillaRecipeProvider.has(Blocks.GLASS)).save(exporter);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.GLOWSTONE, Items.GLOWSTONE_DUST);
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.DECORATIONS, Items.GLOW_ITEM_FRAME).requires(Items.ITEM_FRAME).requires(Items.GLOW_INK_SAC).unlockedBy("has_item_frame", (Criterion)VanillaRecipeProvider.has(Items.ITEM_FRAME))).unlockedBy("has_glow_ink_sac", (Criterion)VanillaRecipeProvider.has(Items.GLOW_INK_SAC)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.FOOD, Items.GOLDEN_APPLE).define(Character.valueOf('#'), Items.GOLD_INGOT).define(Character.valueOf('X'), Items.APPLE).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_gold_ingot", (Criterion)VanillaRecipeProvider.has(Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.GOLDEN_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_gold_ingot", (Criterion)VanillaRecipeProvider.has(Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.GOLDEN_BOOTS).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("X X").pattern("X X").unlockedBy("has_gold_ingot", (Criterion)VanillaRecipeProvider.has(Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BREWING, Items.GOLDEN_CARROT).define(Character.valueOf('#'), Items.GOLD_NUGGET).define(Character.valueOf('X'), Items.CARROT).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_gold_nugget", (Criterion)VanillaRecipeProvider.has(Items.GOLD_NUGGET)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.GOLDEN_CHESTPLATE).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_gold_ingot", (Criterion)VanillaRecipeProvider.has(Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.GOLDEN_HELMET).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("XXX").pattern("X X").unlockedBy("has_gold_ingot", (Criterion)VanillaRecipeProvider.has(Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.GOLDEN_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_gold_ingot", (Criterion)VanillaRecipeProvider.has(Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.GOLDEN_LEGGINGS).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_gold_ingot", (Criterion)VanillaRecipeProvider.has(Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.GOLDEN_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_gold_ingot", (Criterion)VanillaRecipeProvider.has(Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TRANSPORTATION, Blocks.POWERED_RAIL, 6).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("X X").pattern("X#X").pattern("XRX").unlockedBy("has_rail", (Criterion)VanillaRecipeProvider.has(Blocks.RAIL)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.GOLDEN_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("X").pattern("#").pattern("#").unlockedBy("has_gold_ingot", (Criterion)VanillaRecipeProvider.has(Items.GOLD_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.GOLDEN_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.GOLD_INGOT).pattern("X").pattern("X").pattern("#").unlockedBy("has_gold_ingot", (Criterion)VanillaRecipeProvider.has(Items.GOLD_INGOT)).save(exporter);
        VanillaRecipeProvider.nineBlockStorageRecipesRecipesWithCustomUnpacking(exporter, RecipeCategory.MISC, Items.GOLD_INGOT, RecipeCategory.BUILDING_BLOCKS, Items.GOLD_BLOCK, "gold_ingot_from_gold_block", "gold_ingot");
        VanillaRecipeProvider.nineBlockStorageRecipesWithCustomPacking(exporter, RecipeCategory.MISC, Items.GOLD_NUGGET, RecipeCategory.MISC, Items.GOLD_INGOT, "gold_ingot_from_nuggets", "gold_ingot");
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.GRANITE).requires(Blocks.DIORITE).requires(Items.QUARTZ).unlockedBy("has_quartz", (Criterion)VanillaRecipeProvider.has(Items.QUARTZ)).save(exporter);
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.GRAY_DYE, 2).requires(Items.BLACK_DYE).requires(Items.WHITE_DYE).unlockedBy("has_white_dye", (Criterion)VanillaRecipeProvider.has(Items.WHITE_DYE))).unlockedBy("has_black_dye", (Criterion)VanillaRecipeProvider.has(Items.BLACK_DYE)).save(exporter);
        VanillaRecipeProvider.threeByThreePacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.HAY_BLOCK, Items.WHEAT);
        VanillaRecipeProvider.pressurePlate(exporter, Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE, Items.IRON_INGOT);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.FOOD, Items.HONEY_BOTTLE, 4).requires(Items.HONEY_BLOCK).requires(Items.GLASS_BOTTLE, 4).unlockedBy("has_honey_block", (Criterion)VanillaRecipeProvider.has(Blocks.HONEY_BLOCK)).save(exporter);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.REDSTONE, Blocks.HONEY_BLOCK, Items.HONEY_BOTTLE);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.DECORATIONS, Blocks.HONEYCOMB_BLOCK, Items.HONEYCOMB);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.HOPPER).define(Character.valueOf('C'), Blocks.CHEST).define(Character.valueOf('I'), Items.IRON_INGOT).pattern("I I").pattern("ICI").pattern(" I ").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.TRANSPORTATION, Items.HOPPER_MINECART).requires(Blocks.HOPPER).requires(Items.MINECART).unlockedBy("has_minecart", (Criterion)VanillaRecipeProvider.has(Items.MINECART)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.IRON_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.IRON_BARS, 16).define(Character.valueOf('#'), Items.IRON_INGOT).pattern("###").pattern("###").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.IRON_BOOTS).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("X X").pattern("X X").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.IRON_CHESTPLATE).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        VanillaRecipeProvider.doorBuilder(Blocks.IRON_DOOR, Ingredient.of(Items.IRON_INGOT)).unlockedBy(VanillaRecipeProvider.getHasName(Items.IRON_INGOT), VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.IRON_HELMET).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("XXX").pattern("X X").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.IRON_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        VanillaRecipeProvider.nineBlockStorageRecipesRecipesWithCustomUnpacking(exporter, RecipeCategory.MISC, Items.IRON_INGOT, RecipeCategory.BUILDING_BLOCKS, Items.IRON_BLOCK, "iron_ingot_from_iron_block", "iron_ingot");
        VanillaRecipeProvider.nineBlockStorageRecipesWithCustomPacking(exporter, RecipeCategory.MISC, Items.IRON_NUGGET, RecipeCategory.MISC, Items.IRON_INGOT, "iron_ingot_from_nuggets", "iron_ingot");
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.IRON_LEGGINGS).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.IRON_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.IRON_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("X").pattern("#").pattern("#").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.IRON_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("X").pattern("X").pattern("#").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.REDSTONE, Blocks.IRON_TRAPDOOR, Items.IRON_INGOT);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Items.ITEM_FRAME).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.LEATHER).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_leather", (Criterion)VanillaRecipeProvider.has(Items.LEATHER)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.JUKEBOX).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), Items.DIAMOND).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_diamond", (Criterion)VanillaRecipeProvider.has(Items.DIAMOND)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.LADDER, 3).define(Character.valueOf('#'), Items.STICK).pattern("# #").pattern("###").pattern("# #").unlockedBy("has_stick", (Criterion)VanillaRecipeProvider.has(Items.STICK)).save(exporter);
        VanillaRecipeProvider.nineBlockStorageRecipes(exporter, RecipeCategory.MISC, Items.LAPIS_LAZULI, RecipeCategory.BUILDING_BLOCKS, Items.LAPIS_BLOCK);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.LEAD, 2).define(Character.valueOf('~'), Items.STRING).define(Character.valueOf('O'), Items.SLIME_BALL).pattern("~~ ").pattern("~O ").pattern("  ~").unlockedBy("has_slime_ball", (Criterion)VanillaRecipeProvider.has(Items.SLIME_BALL)).save(exporter);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.MISC, Items.LEATHER, Items.RABBIT_HIDE);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.LEATHER_BOOTS).define(Character.valueOf('X'), Items.LEATHER).pattern("X X").pattern("X X").unlockedBy("has_leather", (Criterion)VanillaRecipeProvider.has(Items.LEATHER)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.LEATHER_CHESTPLATE).define(Character.valueOf('X'), Items.LEATHER).pattern("X X").pattern("XXX").pattern("XXX").unlockedBy("has_leather", (Criterion)VanillaRecipeProvider.has(Items.LEATHER)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.LEATHER_HELMET).define(Character.valueOf('X'), Items.LEATHER).pattern("XXX").pattern("X X").unlockedBy("has_leather", (Criterion)VanillaRecipeProvider.has(Items.LEATHER)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.LEATHER_LEGGINGS).define(Character.valueOf('X'), Items.LEATHER).pattern("XXX").pattern("X X").pattern("X X").unlockedBy("has_leather", (Criterion)VanillaRecipeProvider.has(Items.LEATHER)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, Items.LEATHER_HORSE_ARMOR).define(Character.valueOf('X'), Items.LEATHER).pattern("X X").pattern("XXX").pattern("X X").unlockedBy("has_leather", (Criterion)VanillaRecipeProvider.has(Items.LEATHER)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.LECTERN).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('B'), Blocks.BOOKSHELF).pattern("SSS").pattern(" B ").pattern(" S ").unlockedBy("has_book", (Criterion)VanillaRecipeProvider.has(Items.BOOK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.LEVER).define(Character.valueOf('#'), Blocks.COBBLESTONE).define(Character.valueOf('X'), Items.STICK).pattern("X").pattern("#").unlockedBy("has_cobblestone", (Criterion)VanillaRecipeProvider.has(Blocks.COBBLESTONE)).save(exporter);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.LIGHT_BLUE_DYE, Blocks.BLUE_ORCHID, "light_blue_dye");
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.LIGHT_BLUE_DYE, 2).requires(Items.BLUE_DYE).requires(Items.WHITE_DYE).group("light_blue_dye").unlockedBy("has_blue_dye", (Criterion)VanillaRecipeProvider.has(Items.BLUE_DYE))).unlockedBy("has_white_dye", (Criterion)VanillaRecipeProvider.has(Items.WHITE_DYE)).save(exporter, "light_blue_dye_from_blue_white_dye");
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.LIGHT_GRAY_DYE, Blocks.AZURE_BLUET, "light_gray_dye");
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.LIGHT_GRAY_DYE, 2).requires(Items.GRAY_DYE).requires(Items.WHITE_DYE).group("light_gray_dye").unlockedBy("has_gray_dye", (Criterion)VanillaRecipeProvider.has(Items.GRAY_DYE))).unlockedBy("has_white_dye", (Criterion)VanillaRecipeProvider.has(Items.WHITE_DYE)).save(exporter, "light_gray_dye_from_gray_white_dye");
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.LIGHT_GRAY_DYE, 3).requires(Items.BLACK_DYE).requires(Items.WHITE_DYE, 2).group("light_gray_dye").unlockedBy("has_white_dye", (Criterion)VanillaRecipeProvider.has(Items.WHITE_DYE))).unlockedBy("has_black_dye", (Criterion)VanillaRecipeProvider.has(Items.BLACK_DYE)).save(exporter, "light_gray_dye_from_black_white_dye");
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.LIGHT_GRAY_DYE, Blocks.OXEYE_DAISY, "light_gray_dye");
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.LIGHT_GRAY_DYE, Blocks.WHITE_TULIP, "light_gray_dye");
        VanillaRecipeProvider.pressurePlate(exporter, Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE, Items.GOLD_INGOT);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.LIGHTNING_ROD).define(Character.valueOf('#'), Items.COPPER_INGOT).pattern("#").pattern("#").pattern("#").unlockedBy("has_copper_ingot", (Criterion)VanillaRecipeProvider.has(Items.COPPER_INGOT)).save(exporter);
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.LIME_DYE, 2).requires(Items.GREEN_DYE).requires(Items.WHITE_DYE).unlockedBy("has_green_dye", (Criterion)VanillaRecipeProvider.has(Items.GREEN_DYE))).unlockedBy("has_white_dye", (Criterion)VanillaRecipeProvider.has(Items.WHITE_DYE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.JACK_O_LANTERN).define(Character.valueOf('A'), Blocks.CARVED_PUMPKIN).define(Character.valueOf('B'), Blocks.TORCH).pattern("A").pattern("B").unlockedBy("has_carved_pumpkin", (Criterion)VanillaRecipeProvider.has(Blocks.CARVED_PUMPKIN)).save(exporter);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.MAGENTA_DYE, Blocks.ALLIUM, "magenta_dye");
        ((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.MAGENTA_DYE, 4).requires(Items.BLUE_DYE).requires(Items.RED_DYE, 2).requires(Items.WHITE_DYE).group("magenta_dye").unlockedBy("has_blue_dye", (Criterion)VanillaRecipeProvider.has(Items.BLUE_DYE))).unlockedBy("has_rose_red", (Criterion)VanillaRecipeProvider.has(Items.RED_DYE))).unlockedBy("has_white_dye", (Criterion)VanillaRecipeProvider.has(Items.WHITE_DYE)).save(exporter, "magenta_dye_from_blue_red_white_dye");
        ((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.MAGENTA_DYE, 3).requires(Items.BLUE_DYE).requires(Items.RED_DYE).requires(Items.PINK_DYE).group("magenta_dye").unlockedBy("has_pink_dye", (Criterion)VanillaRecipeProvider.has(Items.PINK_DYE))).unlockedBy("has_blue_dye", (Criterion)VanillaRecipeProvider.has(Items.BLUE_DYE))).unlockedBy("has_red_dye", (Criterion)VanillaRecipeProvider.has(Items.RED_DYE)).save(exporter, "magenta_dye_from_blue_red_pink");
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.MAGENTA_DYE, Blocks.LILAC, "magenta_dye", 2);
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.MAGENTA_DYE, 2).requires(Items.PURPLE_DYE).requires(Items.PINK_DYE).group("magenta_dye").unlockedBy("has_pink_dye", (Criterion)VanillaRecipeProvider.has(Items.PINK_DYE))).unlockedBy("has_purple_dye", (Criterion)VanillaRecipeProvider.has(Items.PURPLE_DYE)).save(exporter, "magenta_dye_from_purple_and_pink");
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.MAGMA_BLOCK, Items.MAGMA_CREAM);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BREWING, Items.MAGMA_CREAM).requires(Items.BLAZE_POWDER).requires(Items.SLIME_BALL).unlockedBy("has_blaze_powder", (Criterion)VanillaRecipeProvider.has(Items.BLAZE_POWDER)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, Items.MAP).define(Character.valueOf('#'), Items.PAPER).define(Character.valueOf('X'), Items.COMPASS).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_compass", (Criterion)VanillaRecipeProvider.has(Items.COMPASS)).save(exporter);
        VanillaRecipeProvider.threeByThreePacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.MELON, Items.MELON_SLICE, "has_melon");
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.MELON_SEEDS).requires(Items.MELON_SLICE).unlockedBy("has_melon", (Criterion)VanillaRecipeProvider.has(Items.MELON_SLICE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TRANSPORTATION, Items.MINECART).define(Character.valueOf('#'), Items.IRON_INGOT).pattern("# #").pattern("###").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_COBBLESTONE).requires(Blocks.COBBLESTONE).requires(Blocks.VINE).group("mossy_cobblestone").unlockedBy("has_vine", (Criterion)VanillaRecipeProvider.has(Blocks.VINE)).save(exporter, VanillaRecipeProvider.getConversionRecipeName(Blocks.MOSSY_COBBLESTONE, Blocks.VINE));
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_STONE_BRICKS).requires(Blocks.STONE_BRICKS).requires(Blocks.VINE).group("mossy_stone_bricks").unlockedBy("has_vine", (Criterion)VanillaRecipeProvider.has(Blocks.VINE)).save(exporter, VanillaRecipeProvider.getConversionRecipeName(Blocks.MOSSY_STONE_BRICKS, Blocks.VINE));
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_COBBLESTONE).requires(Blocks.COBBLESTONE).requires(Blocks.MOSS_BLOCK).group("mossy_cobblestone").unlockedBy("has_moss_block", (Criterion)VanillaRecipeProvider.has(Blocks.MOSS_BLOCK)).save(exporter, VanillaRecipeProvider.getConversionRecipeName(Blocks.MOSSY_COBBLESTONE, Blocks.MOSS_BLOCK));
        ShapelessRecipeBuilder.shapeless(RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_STONE_BRICKS).requires(Blocks.STONE_BRICKS).requires(Blocks.MOSS_BLOCK).group("mossy_stone_bricks").unlockedBy("has_moss_block", (Criterion)VanillaRecipeProvider.has(Blocks.MOSS_BLOCK)).save(exporter, VanillaRecipeProvider.getConversionRecipeName(Blocks.MOSSY_STONE_BRICKS, Blocks.MOSS_BLOCK));
        ((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.FOOD, Items.MUSHROOM_STEW).requires(Blocks.BROWN_MUSHROOM).requires(Blocks.RED_MUSHROOM).requires(Items.BOWL).unlockedBy("has_mushroom_stew", (Criterion)VanillaRecipeProvider.has(Items.MUSHROOM_STEW))).unlockedBy("has_bowl", (Criterion)VanillaRecipeProvider.has(Items.BOWL))).unlockedBy("has_brown_mushroom", (Criterion)VanillaRecipeProvider.has(Blocks.BROWN_MUSHROOM))).unlockedBy("has_red_mushroom", (Criterion)VanillaRecipeProvider.has(Blocks.RED_MUSHROOM)).save(exporter);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.NETHER_BRICKS, Items.NETHER_BRICK);
        VanillaRecipeProvider.threeByThreePacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.NETHER_WART_BLOCK, Items.NETHER_WART);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.NOTE_BLOCK).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), Items.REDSTONE).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_redstone", (Criterion)VanillaRecipeProvider.has(Items.REDSTONE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.OBSERVER).define(Character.valueOf('Q'), Items.QUARTZ).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Blocks.COBBLESTONE).pattern("###").pattern("RRQ").pattern("###").unlockedBy("has_quartz", (Criterion)VanillaRecipeProvider.has(Items.QUARTZ)).save(exporter);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.ORANGE_DYE, Blocks.ORANGE_TULIP, "orange_dye");
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.ORANGE_DYE, 2).requires(Items.RED_DYE).requires(Items.YELLOW_DYE).group("orange_dye").unlockedBy("has_red_dye", (Criterion)VanillaRecipeProvider.has(Items.RED_DYE))).unlockedBy("has_yellow_dye", (Criterion)VanillaRecipeProvider.has(Items.YELLOW_DYE)).save(exporter, "orange_dye_from_red_yellow");
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Items.PAINTING).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Ingredient.of(ItemTags.WOOL)).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_wool", (Criterion)VanillaRecipeProvider.has(ItemTags.WOOL)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, Items.PAPER, 3).define(Character.valueOf('#'), Blocks.SUGAR_CANE).pattern("###").unlockedBy("has_reeds", (Criterion)VanillaRecipeProvider.has(Blocks.SUGAR_CANE)).save(exporter);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_PILLAR, 2).define(Character.valueOf('#'), Blocks.QUARTZ_BLOCK).pattern("#").pattern("#").unlockedBy("has_chiseled_quartz_block", (Criterion)VanillaRecipeProvider.has(Blocks.CHISELED_QUARTZ_BLOCK))).unlockedBy("has_quartz_block", (Criterion)VanillaRecipeProvider.has(Blocks.QUARTZ_BLOCK))).unlockedBy("has_quartz_pillar", (Criterion)VanillaRecipeProvider.has(Blocks.QUARTZ_PILLAR)).save(exporter);
        VanillaRecipeProvider.threeByThreePacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.PACKED_ICE, Blocks.ICE);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.PINK_DYE, Blocks.PEONY, "pink_dye", 2);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.PINK_DYE, Blocks.PINK_TULIP, "pink_dye");
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.PINK_DYE, 2).requires(Items.RED_DYE).requires(Items.WHITE_DYE).group("pink_dye").unlockedBy("has_white_dye", (Criterion)VanillaRecipeProvider.has(Items.WHITE_DYE))).unlockedBy("has_red_dye", (Criterion)VanillaRecipeProvider.has(Items.RED_DYE)).save(exporter, "pink_dye_from_red_white_dye");
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.PISTON).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('#'), Blocks.COBBLESTONE).define(Character.valueOf('T'), ItemTags.PLANKS).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("TTT").pattern("#X#").pattern("#R#").unlockedBy("has_redstone", (Criterion)VanillaRecipeProvider.has(Items.REDSTONE)).save(exporter);
        VanillaRecipeProvider.polished(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BASALT, Blocks.BASALT);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE, Items.PRISMARINE_SHARD);
        VanillaRecipeProvider.threeByThreePacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE_BRICKS, Items.PRISMARINE_SHARD);
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.FOOD, Items.PUMPKIN_PIE).requires(Blocks.PUMPKIN).requires(Items.SUGAR).requires(Items.EGG).unlockedBy("has_carved_pumpkin", (Criterion)VanillaRecipeProvider.has(Blocks.CARVED_PUMPKIN))).unlockedBy("has_pumpkin", (Criterion)VanillaRecipeProvider.has(Blocks.PUMPKIN)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.PUMPKIN_SEEDS, 4).requires(Blocks.PUMPKIN).unlockedBy("has_pumpkin", (Criterion)VanillaRecipeProvider.has(Blocks.PUMPKIN)).save(exporter);
        ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.PURPLE_DYE, 2).requires(Items.BLUE_DYE).requires(Items.RED_DYE).unlockedBy("has_blue_dye", (Criterion)VanillaRecipeProvider.has(Items.BLUE_DYE))).unlockedBy("has_red_dye", (Criterion)VanillaRecipeProvider.has(Items.RED_DYE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.SHULKER_BOX).define(Character.valueOf('#'), Blocks.CHEST).define(Character.valueOf('-'), Items.SHULKER_SHELL).pattern("-").pattern("#").pattern("-").unlockedBy("has_shulker_shell", (Criterion)VanillaRecipeProvider.has(Items.SHULKER_SHELL)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_BLOCK, 4).define(Character.valueOf('F'), Items.POPPED_CHORUS_FRUIT).pattern("FF").pattern("FF").unlockedBy("has_chorus_fruit_popped", (Criterion)VanillaRecipeProvider.has(Items.POPPED_CHORUS_FRUIT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_PILLAR).define(Character.valueOf('#'), Blocks.PURPUR_SLAB).pattern("#").pattern("#").unlockedBy("has_purpur_block", (Criterion)VanillaRecipeProvider.has(Blocks.PURPUR_BLOCK)).save(exporter);
        VanillaRecipeProvider.slabBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_SLAB, Ingredient.of(Blocks.PURPUR_BLOCK, Blocks.PURPUR_PILLAR)).unlockedBy("has_purpur_block", VanillaRecipeProvider.has(Blocks.PURPUR_BLOCK)).save(exporter);
        VanillaRecipeProvider.stairBuilder(Blocks.PURPUR_STAIRS, Ingredient.of(Blocks.PURPUR_BLOCK, Blocks.PURPUR_PILLAR)).unlockedBy("has_purpur_block", VanillaRecipeProvider.has(Blocks.PURPUR_BLOCK)).save(exporter);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_BLOCK, Items.QUARTZ);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_BRICKS, 4).define(Character.valueOf('#'), Blocks.QUARTZ_BLOCK).pattern("##").pattern("##").unlockedBy("has_quartz_block", (Criterion)VanillaRecipeProvider.has(Blocks.QUARTZ_BLOCK)).save(exporter);
        VanillaRecipeProvider.slabBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_SLAB, Ingredient.of(Blocks.CHISELED_QUARTZ_BLOCK, Blocks.QUARTZ_BLOCK, Blocks.QUARTZ_PILLAR)).unlockedBy("has_chiseled_quartz_block", VanillaRecipeProvider.has(Blocks.CHISELED_QUARTZ_BLOCK)).unlockedBy("has_quartz_block", VanillaRecipeProvider.has(Blocks.QUARTZ_BLOCK)).unlockedBy("has_quartz_pillar", VanillaRecipeProvider.has(Blocks.QUARTZ_PILLAR)).save(exporter);
        VanillaRecipeProvider.stairBuilder(Blocks.QUARTZ_STAIRS, Ingredient.of(Blocks.CHISELED_QUARTZ_BLOCK, Blocks.QUARTZ_BLOCK, Blocks.QUARTZ_PILLAR)).unlockedBy("has_chiseled_quartz_block", VanillaRecipeProvider.has(Blocks.CHISELED_QUARTZ_BLOCK)).unlockedBy("has_quartz_block", VanillaRecipeProvider.has(Blocks.QUARTZ_BLOCK)).unlockedBy("has_quartz_pillar", VanillaRecipeProvider.has(Blocks.QUARTZ_PILLAR)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.FOOD, Items.RABBIT_STEW).requires(Items.BAKED_POTATO).requires(Items.COOKED_RABBIT).requires(Items.BOWL).requires(Items.CARROT).requires(Blocks.BROWN_MUSHROOM).group("rabbit_stew").unlockedBy("has_cooked_rabbit", (Criterion)VanillaRecipeProvider.has(Items.COOKED_RABBIT)).save(exporter, VanillaRecipeProvider.getConversionRecipeName(Items.RABBIT_STEW, Items.BROWN_MUSHROOM));
        ShapelessRecipeBuilder.shapeless(RecipeCategory.FOOD, Items.RABBIT_STEW).requires(Items.BAKED_POTATO).requires(Items.COOKED_RABBIT).requires(Items.BOWL).requires(Items.CARROT).requires(Blocks.RED_MUSHROOM).group("rabbit_stew").unlockedBy("has_cooked_rabbit", (Criterion)VanillaRecipeProvider.has(Items.COOKED_RABBIT)).save(exporter, VanillaRecipeProvider.getConversionRecipeName(Items.RABBIT_STEW, Items.RED_MUSHROOM));
        ShapedRecipeBuilder.shaped(RecipeCategory.TRANSPORTATION, Blocks.RAIL, 16).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.IRON_INGOT).pattern("X X").pattern("X#X").pattern("X X").unlockedBy("has_minecart", (Criterion)VanillaRecipeProvider.has(Items.MINECART)).save(exporter);
        VanillaRecipeProvider.nineBlockStorageRecipes(exporter, RecipeCategory.REDSTONE, Items.REDSTONE, RecipeCategory.REDSTONE, Items.REDSTONE_BLOCK);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.REDSTONE_LAMP).define(Character.valueOf('R'), Items.REDSTONE).define(Character.valueOf('G'), Blocks.GLOWSTONE).pattern(" R ").pattern("RGR").pattern(" R ").unlockedBy("has_glowstone", (Criterion)VanillaRecipeProvider.has(Blocks.GLOWSTONE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.REDSTONE_TORCH).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Items.REDSTONE).pattern("X").pattern("#").unlockedBy("has_redstone", (Criterion)VanillaRecipeProvider.has(Items.REDSTONE)).save(exporter);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.RED_DYE, Items.BEETROOT, "red_dye");
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.RED_DYE, Blocks.POPPY, "red_dye");
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.RED_DYE, Blocks.ROSE_BUSH, "red_dye", 2);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.RED_DYE).requires(Blocks.RED_TULIP).group("red_dye").unlockedBy("has_red_flower", (Criterion)VanillaRecipeProvider.has(Blocks.RED_TULIP)).save(exporter, "red_dye_from_tulip");
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.RED_NETHER_BRICKS).define(Character.valueOf('W'), Items.NETHER_WART).define(Character.valueOf('N'), Items.NETHER_BRICK).pattern("NW").pattern("WN").unlockedBy("has_nether_wart", (Criterion)VanillaRecipeProvider.has(Items.NETHER_WART)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.RED_SANDSTONE).define(Character.valueOf('#'), Blocks.RED_SAND).pattern("##").pattern("##").unlockedBy("has_sand", (Criterion)VanillaRecipeProvider.has(Blocks.RED_SAND)).save(exporter);
        VanillaRecipeProvider.slabBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.RED_SANDSTONE_SLAB, Ingredient.of(Blocks.RED_SANDSTONE, Blocks.CHISELED_RED_SANDSTONE)).unlockedBy("has_red_sandstone", VanillaRecipeProvider.has(Blocks.RED_SANDSTONE)).unlockedBy("has_chiseled_red_sandstone", VanillaRecipeProvider.has(Blocks.CHISELED_RED_SANDSTONE)).save(exporter);
        VanillaRecipeProvider.stairBuilder(Blocks.RED_SANDSTONE_STAIRS, Ingredient.of(Blocks.RED_SANDSTONE, Blocks.CHISELED_RED_SANDSTONE, Blocks.CUT_RED_SANDSTONE)).unlockedBy("has_red_sandstone", VanillaRecipeProvider.has(Blocks.RED_SANDSTONE)).unlockedBy("has_chiseled_red_sandstone", VanillaRecipeProvider.has(Blocks.CHISELED_RED_SANDSTONE)).unlockedBy("has_cut_red_sandstone", VanillaRecipeProvider.has(Blocks.CUT_RED_SANDSTONE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.REPEATER).define(Character.valueOf('#'), Blocks.REDSTONE_TORCH).define(Character.valueOf('X'), Items.REDSTONE).define(Character.valueOf('I'), Blocks.STONE).pattern("#X#").pattern("III").unlockedBy("has_redstone_torch", (Criterion)VanillaRecipeProvider.has(Blocks.REDSTONE_TORCH)).save(exporter);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SANDSTONE, Blocks.SAND);
        VanillaRecipeProvider.slabBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.SANDSTONE_SLAB, Ingredient.of(Blocks.SANDSTONE, Blocks.CHISELED_SANDSTONE)).unlockedBy("has_sandstone", VanillaRecipeProvider.has(Blocks.SANDSTONE)).unlockedBy("has_chiseled_sandstone", VanillaRecipeProvider.has(Blocks.CHISELED_SANDSTONE)).save(exporter);
        VanillaRecipeProvider.stairBuilder(Blocks.SANDSTONE_STAIRS, Ingredient.of(Blocks.SANDSTONE, Blocks.CHISELED_SANDSTONE, Blocks.CUT_SANDSTONE)).unlockedBy("has_sandstone", VanillaRecipeProvider.has(Blocks.SANDSTONE)).unlockedBy("has_chiseled_sandstone", VanillaRecipeProvider.has(Blocks.CHISELED_SANDSTONE)).unlockedBy("has_cut_sandstone", VanillaRecipeProvider.has(Blocks.CUT_SANDSTONE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.SEA_LANTERN).define(Character.valueOf('S'), Items.PRISMARINE_SHARD).define(Character.valueOf('C'), Items.PRISMARINE_CRYSTALS).pattern("SCS").pattern("CCC").pattern("SCS").unlockedBy("has_prismarine_crystals", (Criterion)VanillaRecipeProvider.has(Items.PRISMARINE_CRYSTALS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.SHEARS).define(Character.valueOf('#'), Items.IRON_INGOT).pattern(" #").pattern("# ").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.SHIELD).define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('o'), Items.IRON_INGOT).pattern("WoW").pattern("WWW").pattern(" W ").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        VanillaRecipeProvider.nineBlockStorageRecipes(exporter, RecipeCategory.MISC, Items.SLIME_BALL, RecipeCategory.REDSTONE, Items.SLIME_BLOCK);
        VanillaRecipeProvider.cut(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_RED_SANDSTONE, Blocks.RED_SANDSTONE);
        VanillaRecipeProvider.cut(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_SANDSTONE, Blocks.SANDSTONE);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SNOW_BLOCK, Items.SNOWBALL);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.SNOW, 6).define(Character.valueOf('#'), Blocks.SNOW_BLOCK).pattern("###").unlockedBy("has_snowball", (Criterion)VanillaRecipeProvider.has(Items.SNOWBALL)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.SOUL_CAMPFIRE).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('S'), Items.STICK).define(Character.valueOf('#'), ItemTags.SOUL_FIRE_BASE_BLOCKS).pattern(" S ").pattern("S#S").pattern("LLL").unlockedBy("has_soul_sand", (Criterion)VanillaRecipeProvider.has(ItemTags.SOUL_FIRE_BASE_BLOCKS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BREWING, Items.GLISTERING_MELON_SLICE).define(Character.valueOf('#'), Items.GOLD_NUGGET).define(Character.valueOf('X'), Items.MELON_SLICE).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_melon", (Criterion)VanillaRecipeProvider.has(Items.MELON_SLICE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.SPECTRAL_ARROW, 2).define(Character.valueOf('#'), Items.GLOWSTONE_DUST).define(Character.valueOf('X'), Items.ARROW).pattern(" # ").pattern("#X#").pattern(" # ").unlockedBy("has_glowstone_dust", (Criterion)VanillaRecipeProvider.has(Items.GLOWSTONE_DUST)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.SPYGLASS).define(Character.valueOf('#'), Items.AMETHYST_SHARD).define(Character.valueOf('X'), Items.COPPER_INGOT).pattern(" # ").pattern(" X ").pattern(" X ").unlockedBy("has_amethyst_shard", (Criterion)VanillaRecipeProvider.has(Items.AMETHYST_SHARD)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, Items.STICK, 4).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("#").pattern("#").group("sticks").unlockedBy("has_planks", (Criterion)VanillaRecipeProvider.has(ItemTags.PLANKS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.MISC, Items.STICK, 1).define(Character.valueOf('#'), Blocks.BAMBOO).pattern("#").pattern("#").group("sticks").unlockedBy("has_bamboo", (Criterion)VanillaRecipeProvider.has(Blocks.BAMBOO)).save(exporter, "stick_from_bamboo_item");
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.STICKY_PISTON).define(Character.valueOf('P'), Blocks.PISTON).define(Character.valueOf('S'), Items.SLIME_BALL).pattern("S").pattern("P").unlockedBy("has_slime_ball", (Criterion)VanillaRecipeProvider.has(Items.SLIME_BALL)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICKS, 4).define(Character.valueOf('#'), Blocks.STONE).pattern("##").pattern("##").unlockedBy("has_stone", (Criterion)VanillaRecipeProvider.has(Blocks.STONE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.STONE_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_cobblestone", (Criterion)VanillaRecipeProvider.has(ItemTags.STONE_TOOL_MATERIALS)).save(exporter);
        VanillaRecipeProvider.slabBuilder(RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICK_SLAB, Ingredient.of(Blocks.STONE_BRICKS)).unlockedBy("has_stone_bricks", VanillaRecipeProvider.has(ItemTags.STONE_BRICKS)).save(exporter);
        VanillaRecipeProvider.stairBuilder(Blocks.STONE_BRICK_STAIRS, Ingredient.of(Blocks.STONE_BRICKS)).unlockedBy("has_stone_bricks", VanillaRecipeProvider.has(ItemTags.STONE_BRICKS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.STONE_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_cobblestone", (Criterion)VanillaRecipeProvider.has(ItemTags.STONE_TOOL_MATERIALS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.STONE_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_cobblestone", (Criterion)VanillaRecipeProvider.has(ItemTags.STONE_TOOL_MATERIALS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.STONE_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("X").pattern("#").pattern("#").unlockedBy("has_cobblestone", (Criterion)VanillaRecipeProvider.has(ItemTags.STONE_TOOL_MATERIALS)).save(exporter);
        VanillaRecipeProvider.slab(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_STONE_SLAB, Blocks.SMOOTH_STONE);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.STONE_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).pattern("X").pattern("X").pattern("#").unlockedBy("has_cobblestone", (Criterion)VanillaRecipeProvider.has(ItemTags.STONE_TOOL_MATERIALS)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.WHITE_WOOL).define(Character.valueOf('#'), Items.STRING).pattern("##").pattern("##").unlockedBy("has_string", (Criterion)VanillaRecipeProvider.has(Items.STRING)).save(exporter, VanillaRecipeProvider.getConversionRecipeName(Blocks.WHITE_WOOL, Items.STRING));
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.SUGAR, Blocks.SUGAR_CANE, "sugar");
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.SUGAR, 3).requires(Items.HONEY_BOTTLE).group("sugar").unlockedBy("has_honey_bottle", (Criterion)VanillaRecipeProvider.has(Items.HONEY_BOTTLE)).save(exporter, VanillaRecipeProvider.getConversionRecipeName(Items.SUGAR, Items.HONEY_BOTTLE));
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.TARGET).define(Character.valueOf('H'), Items.HAY_BLOCK).define(Character.valueOf('R'), Items.REDSTONE).pattern(" R ").pattern("RHR").pattern(" R ").unlockedBy("has_redstone", (Criterion)VanillaRecipeProvider.has(Items.REDSTONE))).unlockedBy("has_hay_block", (Criterion)VanillaRecipeProvider.has(Blocks.HAY_BLOCK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.TNT).define(Character.valueOf('#'), Ingredient.of(Blocks.SAND, Blocks.RED_SAND)).define(Character.valueOf('X'), Items.GUNPOWDER).pattern("X#X").pattern("#X#").pattern("X#X").unlockedBy("has_gunpowder", (Criterion)VanillaRecipeProvider.has(Items.GUNPOWDER)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.TRANSPORTATION, Items.TNT_MINECART).requires(Blocks.TNT).requires(Items.MINECART).unlockedBy("has_minecart", (Criterion)VanillaRecipeProvider.has(Items.MINECART)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.TORCH, 4).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), Ingredient.of(Items.COAL, Items.CHARCOAL)).pattern("X").pattern("#").unlockedBy("has_stone_pickaxe", (Criterion)VanillaRecipeProvider.has(Items.STONE_PICKAXE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.SOUL_TORCH, 4).define(Character.valueOf('X'), Ingredient.of(Items.COAL, Items.CHARCOAL)).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('S'), ItemTags.SOUL_FIRE_BASE_BLOCKS).pattern("X").pattern("#").pattern("S").unlockedBy("has_soul_sand", (Criterion)VanillaRecipeProvider.has(ItemTags.SOUL_FIRE_BASE_BLOCKS)).save(exporter);
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.LANTERN).define(Character.valueOf('#'), Items.TORCH).define(Character.valueOf('X'), Items.IRON_NUGGET).pattern("XXX").pattern("X#X").pattern("XXX").unlockedBy("has_iron_nugget", (Criterion)VanillaRecipeProvider.has(Items.IRON_NUGGET))).unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.SOUL_LANTERN).define(Character.valueOf('#'), Items.SOUL_TORCH).define(Character.valueOf('X'), Items.IRON_NUGGET).pattern("XXX").pattern("X#X").pattern("XXX").unlockedBy("has_soul_torch", (Criterion)VanillaRecipeProvider.has(Items.SOUL_TORCH)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.REDSTONE, Blocks.TRAPPED_CHEST).requires(Blocks.CHEST).requires(Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", (Criterion)VanillaRecipeProvider.has(Blocks.TRIPWIRE_HOOK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Blocks.TRIPWIRE_HOOK, 2).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('S'), Items.STICK).define(Character.valueOf('I'), Items.IRON_INGOT).pattern("I").pattern("S").pattern("#").unlockedBy("has_string", (Criterion)VanillaRecipeProvider.has(Items.STRING)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.TURTLE_HELMET).define(Character.valueOf('X'), Items.TURTLE_SCUTE).pattern("XXX").pattern("X X").unlockedBy("has_turtle_scute", (Criterion)VanillaRecipeProvider.has(Items.TURTLE_SCUTE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.WOLF_ARMOR).define(Character.valueOf('X'), Items.ARMADILLO_SCUTE).pattern("X  ").pattern("XXX").pattern("X X").unlockedBy("has_armadillo_scute", (Criterion)VanillaRecipeProvider.has(Items.ARMADILLO_SCUTE)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.WHEAT, 9).requires(Blocks.HAY_BLOCK).unlockedBy("has_hay_block", (Criterion)VanillaRecipeProvider.has(Blocks.HAY_BLOCK)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.WHITE_DYE).requires(Items.BONE_MEAL).group("white_dye").unlockedBy("has_bone_meal", (Criterion)VanillaRecipeProvider.has(Items.BONE_MEAL)).save(exporter);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.WHITE_DYE, Blocks.LILY_OF_THE_VALLEY, "white_dye");
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.WOODEN_AXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).pattern("XX").pattern("X#").pattern(" #").unlockedBy("has_stick", (Criterion)VanillaRecipeProvider.has(Items.STICK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.WOODEN_HOE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).pattern("XX").pattern(" #").pattern(" #").unlockedBy("has_stick", (Criterion)VanillaRecipeProvider.has(Items.STICK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.WOODEN_PICKAXE).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).pattern("XXX").pattern(" # ").pattern(" # ").unlockedBy("has_stick", (Criterion)VanillaRecipeProvider.has(Items.STICK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.WOODEN_SHOVEL).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).pattern("X").pattern("#").pattern("#").unlockedBy("has_stick", (Criterion)VanillaRecipeProvider.has(Items.STICK)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.COMBAT, Items.WOODEN_SWORD).define(Character.valueOf('#'), Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).pattern("X").pattern("X").pattern("#").unlockedBy("has_stick", (Criterion)VanillaRecipeProvider.has(Items.STICK)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.WRITABLE_BOOK).requires(Items.BOOK).requires(Items.INK_SAC).requires(Items.FEATHER).unlockedBy("has_book", (Criterion)VanillaRecipeProvider.has(Items.BOOK)).save(exporter);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.YELLOW_DYE, Blocks.DANDELION, "yellow_dye");
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.YELLOW_DYE, Blocks.SUNFLOWER, "yellow_dye", 2);
        VanillaRecipeProvider.nineBlockStorageRecipes(exporter, RecipeCategory.FOOD, Items.DRIED_KELP, RecipeCategory.BUILDING_BLOCKS, Items.DRIED_KELP_BLOCK);
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.MISC, Blocks.CONDUIT).define(Character.valueOf('#'), Items.NAUTILUS_SHELL).define(Character.valueOf('X'), Items.HEART_OF_THE_SEA).pattern("###").pattern("#X#").pattern("###").unlockedBy("has_nautilus_core", (Criterion)VanillaRecipeProvider.has(Items.HEART_OF_THE_SEA))).unlockedBy("has_nautilus_shell", (Criterion)VanillaRecipeProvider.has(Items.NAUTILUS_SHELL)).save(exporter);
        VanillaRecipeProvider.wall(exporter, RecipeCategory.DECORATIONS, Blocks.RED_SANDSTONE_WALL, Blocks.RED_SANDSTONE);
        VanillaRecipeProvider.wall(exporter, RecipeCategory.DECORATIONS, Blocks.STONE_BRICK_WALL, Blocks.STONE_BRICKS);
        VanillaRecipeProvider.wall(exporter, RecipeCategory.DECORATIONS, Blocks.SANDSTONE_WALL, Blocks.SANDSTONE);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.CREEPER_BANNER_PATTERN).requires(Items.PAPER).requires(Items.CREEPER_HEAD).unlockedBy("has_creeper_head", (Criterion)VanillaRecipeProvider.has(Items.CREEPER_HEAD)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.SKULL_BANNER_PATTERN).requires(Items.PAPER).requires(Items.WITHER_SKELETON_SKULL).unlockedBy("has_wither_skeleton_skull", (Criterion)VanillaRecipeProvider.has(Items.WITHER_SKELETON_SKULL)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.FLOWER_BANNER_PATTERN).requires(Items.PAPER).requires(Blocks.OXEYE_DAISY).unlockedBy("has_oxeye_daisy", (Criterion)VanillaRecipeProvider.has(Blocks.OXEYE_DAISY)).save(exporter);
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.MOJANG_BANNER_PATTERN).requires(Items.PAPER).requires(Items.ENCHANTED_GOLDEN_APPLE).unlockedBy("has_enchanted_golden_apple", (Criterion)VanillaRecipeProvider.has(Items.ENCHANTED_GOLDEN_APPLE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.SCAFFOLDING, 6).define(Character.valueOf('~'), Items.STRING).define(Character.valueOf('I'), Blocks.BAMBOO).pattern("I~I").pattern("I I").pattern("I I").unlockedBy("has_bamboo", (Criterion)VanillaRecipeProvider.has(Blocks.BAMBOO)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.GRINDSTONE).define(Character.valueOf('I'), Items.STICK).define(Character.valueOf('-'), Blocks.STONE_SLAB).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("I-I").pattern("# #").unlockedBy("has_stone_slab", (Criterion)VanillaRecipeProvider.has(Blocks.STONE_SLAB)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.BLAST_FURNACE).define(Character.valueOf('#'), Blocks.SMOOTH_STONE).define(Character.valueOf('X'), Blocks.FURNACE).define(Character.valueOf('I'), Items.IRON_INGOT).pattern("III").pattern("IXI").pattern("###").unlockedBy("has_smooth_stone", (Criterion)VanillaRecipeProvider.has(Blocks.SMOOTH_STONE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.SMOKER).define(Character.valueOf('#'), ItemTags.LOGS).define(Character.valueOf('X'), Blocks.FURNACE).pattern(" # ").pattern("#X#").pattern(" # ").unlockedBy("has_furnace", (Criterion)VanillaRecipeProvider.has(Blocks.FURNACE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.CARTOGRAPHY_TABLE).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), Items.PAPER).pattern("@@").pattern("##").pattern("##").unlockedBy("has_paper", (Criterion)VanillaRecipeProvider.has(Items.PAPER)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.SMITHING_TABLE).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), Items.IRON_INGOT).pattern("@@").pattern("##").pattern("##").unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.FLETCHING_TABLE).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('@'), Items.FLINT).pattern("@@").pattern("##").pattern("##").unlockedBy("has_flint", (Criterion)VanillaRecipeProvider.has(Items.FLINT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.STONECUTTER).define(Character.valueOf('I'), Items.IRON_INGOT).define(Character.valueOf('#'), Blocks.STONE).pattern(" I ").pattern("###").unlockedBy("has_stone", (Criterion)VanillaRecipeProvider.has(Blocks.STONE)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.LODESTONE).define(Character.valueOf('S'), Items.CHISELED_STONE_BRICKS).define(Character.valueOf('#'), Items.NETHERITE_INGOT).pattern("SSS").pattern("S#S").pattern("SSS").unlockedBy("has_netherite_ingot", (Criterion)VanillaRecipeProvider.has(Items.NETHERITE_INGOT)).save(exporter);
        VanillaRecipeProvider.nineBlockStorageRecipesRecipesWithCustomUnpacking(exporter, RecipeCategory.MISC, Items.NETHERITE_INGOT, RecipeCategory.BUILDING_BLOCKS, Items.NETHERITE_BLOCK, "netherite_ingot_from_netherite_block", "netherite_ingot");
        ShapelessRecipeBuilder.shapeless(RecipeCategory.MISC, Items.NETHERITE_INGOT).requires(Items.NETHERITE_SCRAP, 4).requires(Items.GOLD_INGOT, 4).group("netherite_ingot").unlockedBy("has_netherite_scrap", (Criterion)VanillaRecipeProvider.has(Items.NETHERITE_SCRAP)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.RESPAWN_ANCHOR).define(Character.valueOf('O'), Blocks.CRYING_OBSIDIAN).define(Character.valueOf('G'), Blocks.GLOWSTONE).pattern("OOO").pattern("GGG").pattern("OOO").unlockedBy("has_obsidian", (Criterion)VanillaRecipeProvider.has(Blocks.CRYING_OBSIDIAN)).save(exporter);
        ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Blocks.CHAIN).define(Character.valueOf('I'), Items.IRON_INGOT).define(Character.valueOf('N'), Items.IRON_NUGGET).pattern("N").pattern("I").pattern("N").unlockedBy("has_iron_nugget", (Criterion)VanillaRecipeProvider.has(Items.IRON_NUGGET))).unlockedBy("has_iron_ingot", (Criterion)VanillaRecipeProvider.has(Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.TINTED_GLASS, 2).define(Character.valueOf('G'), Blocks.GLASS).define(Character.valueOf('S'), Items.AMETHYST_SHARD).pattern(" S ").pattern("SGS").pattern(" S ").unlockedBy("has_amethyst_shard", (Criterion)VanillaRecipeProvider.has(Items.AMETHYST_SHARD)).save(exporter);
        VanillaRecipeProvider.twoByTwoPacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.AMETHYST_BLOCK, Items.AMETHYST_SHARD);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.RECOVERY_COMPASS).define(Character.valueOf('C'), Items.COMPASS).define(Character.valueOf('S'), Items.ECHO_SHARD).pattern("SSS").pattern("SCS").pattern("SSS").unlockedBy("has_echo_shard", (Criterion)VanillaRecipeProvider.has(Items.ECHO_SHARD)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.REDSTONE, Items.CALIBRATED_SCULK_SENSOR).define(Character.valueOf('#'), Items.AMETHYST_SHARD).define(Character.valueOf('X'), Items.SCULK_SENSOR).pattern(" # ").pattern("#X#").unlockedBy("has_amethyst_shard", (Criterion)VanillaRecipeProvider.has(Items.AMETHYST_SHARD)).save(exporter);
        VanillaRecipeProvider.threeByThreePacker(exporter, RecipeCategory.MISC, Items.MUSIC_DISC_5, Items.DISC_FRAGMENT_5);
        SpecialRecipeBuilder.special(ArmorDyeRecipe::new).save(exporter, "armor_dye");
        SpecialRecipeBuilder.special(BannerDuplicateRecipe::new).save(exporter, "banner_duplicate");
        SpecialRecipeBuilder.special(BookCloningRecipe::new).save(exporter, "book_cloning");
        SpecialRecipeBuilder.special(FireworkRocketRecipe::new).save(exporter, "firework_rocket");
        SpecialRecipeBuilder.special(FireworkStarRecipe::new).save(exporter, "firework_star");
        SpecialRecipeBuilder.special(FireworkStarFadeRecipe::new).save(exporter, "firework_star_fade");
        SpecialRecipeBuilder.special(MapCloningRecipe::new).save(exporter, "map_cloning");
        SpecialRecipeBuilder.special(MapExtendingRecipe::new).save(exporter, "map_extending");
        SpecialRecipeBuilder.special(RepairItemRecipe::new).save(exporter, "repair_item");
        SpecialRecipeBuilder.special(ShieldDecorationRecipe::new).save(exporter, "shield_decoration");
        SpecialRecipeBuilder.special(ShulkerBoxColoring::new).save(exporter, "shulker_box_coloring");
        SpecialRecipeBuilder.special(TippedArrowRecipe::new).save(exporter, "tipped_arrow");
        SpecialRecipeBuilder.special(SuspiciousStewRecipe::new).save(exporter, "suspicious_stew");
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.POTATO), RecipeCategory.FOOD, Items.BAKED_POTATO, 0.35f, 200).unlockedBy("has_potato", (Criterion)VanillaRecipeProvider.has(Items.POTATO)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.CLAY_BALL), RecipeCategory.MISC, Items.BRICK, 0.3f, 200).unlockedBy("has_clay_ball", (Criterion)VanillaRecipeProvider.has(Items.CLAY_BALL)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(ItemTags.LOGS_THAT_BURN), RecipeCategory.MISC, Items.CHARCOAL, 0.15f, 200).unlockedBy("has_log", (Criterion)VanillaRecipeProvider.has(ItemTags.LOGS_THAT_BURN)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.CHORUS_FRUIT), RecipeCategory.MISC, Items.POPPED_CHORUS_FRUIT, 0.1f, 200).unlockedBy("has_chorus_fruit", (Criterion)VanillaRecipeProvider.has(Items.CHORUS_FRUIT)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.BEEF), RecipeCategory.FOOD, Items.COOKED_BEEF, 0.35f, 200).unlockedBy("has_beef", (Criterion)VanillaRecipeProvider.has(Items.BEEF)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.CHICKEN), RecipeCategory.FOOD, Items.COOKED_CHICKEN, 0.35f, 200).unlockedBy("has_chicken", (Criterion)VanillaRecipeProvider.has(Items.CHICKEN)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.COD), RecipeCategory.FOOD, Items.COOKED_COD, 0.35f, 200).unlockedBy("has_cod", (Criterion)VanillaRecipeProvider.has(Items.COD)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.KELP), RecipeCategory.FOOD, Items.DRIED_KELP, 0.1f, 200).unlockedBy("has_kelp", (Criterion)VanillaRecipeProvider.has(Blocks.KELP)).save(exporter, VanillaRecipeProvider.getSmeltingRecipeName(Items.DRIED_KELP));
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.SALMON), RecipeCategory.FOOD, Items.COOKED_SALMON, 0.35f, 200).unlockedBy("has_salmon", (Criterion)VanillaRecipeProvider.has(Items.SALMON)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.MUTTON), RecipeCategory.FOOD, Items.COOKED_MUTTON, 0.35f, 200).unlockedBy("has_mutton", (Criterion)VanillaRecipeProvider.has(Items.MUTTON)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.PORKCHOP), RecipeCategory.FOOD, Items.COOKED_PORKCHOP, 0.35f, 200).unlockedBy("has_porkchop", (Criterion)VanillaRecipeProvider.has(Items.PORKCHOP)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.RABBIT), RecipeCategory.FOOD, Items.COOKED_RABBIT, 0.35f, 200).unlockedBy("has_rabbit", (Criterion)VanillaRecipeProvider.has(Items.RABBIT)).save(exporter);
        VanillaRecipeProvider.oreSmelting(exporter, COAL_SMELTABLES, RecipeCategory.MISC, Items.COAL, 0.1f, 200, "coal");
        VanillaRecipeProvider.oreSmelting(exporter, IRON_SMELTABLES, RecipeCategory.MISC, Items.IRON_INGOT, 0.7f, 200, "iron_ingot");
        VanillaRecipeProvider.oreSmelting(exporter, COPPER_SMELTABLES, RecipeCategory.MISC, Items.COPPER_INGOT, 0.7f, 200, "copper_ingot");
        VanillaRecipeProvider.oreSmelting(exporter, GOLD_SMELTABLES, RecipeCategory.MISC, Items.GOLD_INGOT, 1.0f, 200, "gold_ingot");
        VanillaRecipeProvider.oreSmelting(exporter, DIAMOND_SMELTABLES, RecipeCategory.MISC, Items.DIAMOND, 1.0f, 200, "diamond");
        VanillaRecipeProvider.oreSmelting(exporter, LAPIS_SMELTABLES, RecipeCategory.MISC, Items.LAPIS_LAZULI, 0.2f, 200, "lapis_lazuli");
        VanillaRecipeProvider.oreSmelting(exporter, REDSTONE_SMELTABLES, RecipeCategory.REDSTONE, Items.REDSTONE, 0.7f, 200, "redstone");
        VanillaRecipeProvider.oreSmelting(exporter, EMERALD_SMELTABLES, RecipeCategory.MISC, Items.EMERALD, 1.0f, 200, "emerald");
        VanillaRecipeProvider.nineBlockStorageRecipes(exporter, RecipeCategory.MISC, Items.RAW_IRON, RecipeCategory.BUILDING_BLOCKS, Items.RAW_IRON_BLOCK);
        VanillaRecipeProvider.nineBlockStorageRecipes(exporter, RecipeCategory.MISC, Items.RAW_COPPER, RecipeCategory.BUILDING_BLOCKS, Items.RAW_COPPER_BLOCK);
        VanillaRecipeProvider.nineBlockStorageRecipes(exporter, RecipeCategory.MISC, Items.RAW_GOLD, RecipeCategory.BUILDING_BLOCKS, Items.RAW_GOLD_BLOCK);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(ItemTags.SMELTS_TO_GLASS), RecipeCategory.BUILDING_BLOCKS, Blocks.GLASS.asItem(), 0.1f, 200).unlockedBy("has_smelts_to_glass", (Criterion)VanillaRecipeProvider.has(ItemTags.SMELTS_TO_GLASS)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.SEA_PICKLE), RecipeCategory.MISC, Items.LIME_DYE, 0.1f, 200).unlockedBy("has_sea_pickle", (Criterion)VanillaRecipeProvider.has(Blocks.SEA_PICKLE)).save(exporter, VanillaRecipeProvider.getSmeltingRecipeName(Items.LIME_DYE));
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.CACTUS.asItem()), RecipeCategory.MISC, Items.GREEN_DYE, 1.0f, 200).unlockedBy("has_cactus", (Criterion)VanillaRecipeProvider.has(Blocks.CACTUS)).save(exporter);
        ((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.GOLDEN_PICKAXE, Items.GOLDEN_SHOVEL, Items.GOLDEN_AXE, Items.GOLDEN_HOE, Items.GOLDEN_SWORD, Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS, Items.GOLDEN_HORSE_ARMOR), RecipeCategory.MISC, Items.GOLD_NUGGET, 0.1f, 200).unlockedBy("has_golden_pickaxe", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_PICKAXE))).unlockedBy("has_golden_shovel", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_SHOVEL))).unlockedBy("has_golden_axe", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_AXE))).unlockedBy("has_golden_hoe", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_HOE))).unlockedBy("has_golden_sword", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_SWORD))).unlockedBy("has_golden_helmet", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_HELMET))).unlockedBy("has_golden_chestplate", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_CHESTPLATE))).unlockedBy("has_golden_leggings", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_LEGGINGS))).unlockedBy("has_golden_boots", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_BOOTS))).unlockedBy("has_golden_horse_armor", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_HORSE_ARMOR)).save(exporter, VanillaRecipeProvider.getSmeltingRecipeName(Items.GOLD_NUGGET));
        ((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.smelting(Ingredient.of(Items.IRON_PICKAXE, Items.IRON_SHOVEL, Items.IRON_AXE, Items.IRON_HOE, Items.IRON_SWORD, Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS, Items.IRON_HORSE_ARMOR, Items.CHAINMAIL_HELMET, Items.CHAINMAIL_CHESTPLATE, Items.CHAINMAIL_LEGGINGS, Items.CHAINMAIL_BOOTS), RecipeCategory.MISC, Items.IRON_NUGGET, 0.1f, 200).unlockedBy("has_iron_pickaxe", (Criterion)VanillaRecipeProvider.has(Items.IRON_PICKAXE))).unlockedBy("has_iron_shovel", (Criterion)VanillaRecipeProvider.has(Items.IRON_SHOVEL))).unlockedBy("has_iron_axe", (Criterion)VanillaRecipeProvider.has(Items.IRON_AXE))).unlockedBy("has_iron_hoe", (Criterion)VanillaRecipeProvider.has(Items.IRON_HOE))).unlockedBy("has_iron_sword", (Criterion)VanillaRecipeProvider.has(Items.IRON_SWORD))).unlockedBy("has_iron_helmet", (Criterion)VanillaRecipeProvider.has(Items.IRON_HELMET))).unlockedBy("has_iron_chestplate", (Criterion)VanillaRecipeProvider.has(Items.IRON_CHESTPLATE))).unlockedBy("has_iron_leggings", (Criterion)VanillaRecipeProvider.has(Items.IRON_LEGGINGS))).unlockedBy("has_iron_boots", (Criterion)VanillaRecipeProvider.has(Items.IRON_BOOTS))).unlockedBy("has_iron_horse_armor", (Criterion)VanillaRecipeProvider.has(Items.IRON_HORSE_ARMOR))).unlockedBy("has_chainmail_helmet", (Criterion)VanillaRecipeProvider.has(Items.CHAINMAIL_HELMET))).unlockedBy("has_chainmail_chestplate", (Criterion)VanillaRecipeProvider.has(Items.CHAINMAIL_CHESTPLATE))).unlockedBy("has_chainmail_leggings", (Criterion)VanillaRecipeProvider.has(Items.CHAINMAIL_LEGGINGS))).unlockedBy("has_chainmail_boots", (Criterion)VanillaRecipeProvider.has(Items.CHAINMAIL_BOOTS)).save(exporter, VanillaRecipeProvider.getSmeltingRecipeName(Items.IRON_NUGGET));
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.CLAY), RecipeCategory.BUILDING_BLOCKS, Blocks.TERRACOTTA.asItem(), 0.35f, 200).unlockedBy("has_clay_block", (Criterion)VanillaRecipeProvider.has(Blocks.CLAY)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.NETHERRACK), RecipeCategory.MISC, Items.NETHER_BRICK, 0.1f, 200).unlockedBy("has_netherrack", (Criterion)VanillaRecipeProvider.has(Blocks.NETHERRACK)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.NETHER_QUARTZ_ORE), RecipeCategory.MISC, Items.QUARTZ, 0.2f, 200).unlockedBy("has_nether_quartz_ore", (Criterion)VanillaRecipeProvider.has(Blocks.NETHER_QUARTZ_ORE)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.WET_SPONGE), RecipeCategory.BUILDING_BLOCKS, Blocks.SPONGE.asItem(), 0.15f, 200).unlockedBy("has_wet_sponge", (Criterion)VanillaRecipeProvider.has(Blocks.WET_SPONGE)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.COBBLESTONE), RecipeCategory.BUILDING_BLOCKS, Blocks.STONE.asItem(), 0.1f, 200).unlockedBy("has_cobblestone", (Criterion)VanillaRecipeProvider.has(Blocks.COBBLESTONE)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.STONE), RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_STONE.asItem(), 0.1f, 200).unlockedBy("has_stone", (Criterion)VanillaRecipeProvider.has(Blocks.STONE)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.SANDSTONE), RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_SANDSTONE.asItem(), 0.1f, 200).unlockedBy("has_sandstone", (Criterion)VanillaRecipeProvider.has(Blocks.SANDSTONE)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.RED_SANDSTONE), RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_RED_SANDSTONE.asItem(), 0.1f, 200).unlockedBy("has_red_sandstone", (Criterion)VanillaRecipeProvider.has(Blocks.RED_SANDSTONE)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.QUARTZ_BLOCK), RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_QUARTZ.asItem(), 0.1f, 200).unlockedBy("has_quartz_block", (Criterion)VanillaRecipeProvider.has(Blocks.QUARTZ_BLOCK)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.STONE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.CRACKED_STONE_BRICKS.asItem(), 0.1f, 200).unlockedBy("has_stone_bricks", (Criterion)VanillaRecipeProvider.has(Blocks.STONE_BRICKS)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.BLACK_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.BLACK_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_black_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.BLACK_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.BLUE_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.BLUE_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_blue_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.BLUE_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.BROWN_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.BROWN_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_brown_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.BROWN_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.CYAN_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.CYAN_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_cyan_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.CYAN_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.GRAY_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.GRAY_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_gray_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.GRAY_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.GREEN_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.GREEN_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_green_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.GREEN_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.LIGHT_BLUE_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_light_blue_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.LIGHT_BLUE_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.LIGHT_GRAY_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_light_gray_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.LIGHT_GRAY_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.LIME_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.LIME_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_lime_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.LIME_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.MAGENTA_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.MAGENTA_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_magenta_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.MAGENTA_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.ORANGE_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.ORANGE_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_orange_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.ORANGE_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.PINK_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.PINK_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_pink_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.PINK_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.PURPLE_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.PURPLE_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_purple_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.PURPLE_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.RED_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.RED_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_red_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.RED_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.WHITE_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.WHITE_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_white_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.WHITE_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.YELLOW_TERRACOTTA), RecipeCategory.DECORATIONS, Blocks.YELLOW_GLAZED_TERRACOTTA.asItem(), 0.1f, 200).unlockedBy("has_yellow_terracotta", (Criterion)VanillaRecipeProvider.has(Blocks.YELLOW_TERRACOTTA)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.ANCIENT_DEBRIS), RecipeCategory.MISC, Items.NETHERITE_SCRAP, 2.0f, 200).unlockedBy("has_ancient_debris", (Criterion)VanillaRecipeProvider.has(Blocks.ANCIENT_DEBRIS)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.BASALT), RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_BASALT, 0.1f, 200).unlockedBy("has_basalt", (Criterion)VanillaRecipeProvider.has(Blocks.BASALT)).save(exporter);
        SimpleCookingRecipeBuilder.smelting(Ingredient.of(Blocks.COBBLED_DEEPSLATE), RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE, 0.1f, 200).unlockedBy("has_cobbled_deepslate", (Criterion)VanillaRecipeProvider.has(Blocks.COBBLED_DEEPSLATE)).save(exporter);
        VanillaRecipeProvider.oreBlasting(exporter, COAL_SMELTABLES, RecipeCategory.MISC, Items.COAL, 0.1f, 100, "coal");
        VanillaRecipeProvider.oreBlasting(exporter, IRON_SMELTABLES, RecipeCategory.MISC, Items.IRON_INGOT, 0.7f, 100, "iron_ingot");
        VanillaRecipeProvider.oreBlasting(exporter, COPPER_SMELTABLES, RecipeCategory.MISC, Items.COPPER_INGOT, 0.7f, 100, "copper_ingot");
        VanillaRecipeProvider.oreBlasting(exporter, GOLD_SMELTABLES, RecipeCategory.MISC, Items.GOLD_INGOT, 1.0f, 100, "gold_ingot");
        VanillaRecipeProvider.oreBlasting(exporter, DIAMOND_SMELTABLES, RecipeCategory.MISC, Items.DIAMOND, 1.0f, 100, "diamond");
        VanillaRecipeProvider.oreBlasting(exporter, LAPIS_SMELTABLES, RecipeCategory.MISC, Items.LAPIS_LAZULI, 0.2f, 100, "lapis_lazuli");
        VanillaRecipeProvider.oreBlasting(exporter, REDSTONE_SMELTABLES, RecipeCategory.REDSTONE, Items.REDSTONE, 0.7f, 100, "redstone");
        VanillaRecipeProvider.oreBlasting(exporter, EMERALD_SMELTABLES, RecipeCategory.MISC, Items.EMERALD, 1.0f, 100, "emerald");
        SimpleCookingRecipeBuilder.blasting(Ingredient.of(Blocks.NETHER_QUARTZ_ORE), RecipeCategory.MISC, Items.QUARTZ, 0.2f, 100).unlockedBy("has_nether_quartz_ore", (Criterion)VanillaRecipeProvider.has(Blocks.NETHER_QUARTZ_ORE)).save(exporter, VanillaRecipeProvider.getBlastingRecipeName(Items.QUARTZ));
        ((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.blasting(Ingredient.of(Items.GOLDEN_PICKAXE, Items.GOLDEN_SHOVEL, Items.GOLDEN_AXE, Items.GOLDEN_HOE, Items.GOLDEN_SWORD, Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS, Items.GOLDEN_HORSE_ARMOR), RecipeCategory.MISC, Items.GOLD_NUGGET, 0.1f, 100).unlockedBy("has_golden_pickaxe", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_PICKAXE))).unlockedBy("has_golden_shovel", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_SHOVEL))).unlockedBy("has_golden_axe", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_AXE))).unlockedBy("has_golden_hoe", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_HOE))).unlockedBy("has_golden_sword", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_SWORD))).unlockedBy("has_golden_helmet", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_HELMET))).unlockedBy("has_golden_chestplate", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_CHESTPLATE))).unlockedBy("has_golden_leggings", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_LEGGINGS))).unlockedBy("has_golden_boots", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_BOOTS))).unlockedBy("has_golden_horse_armor", (Criterion)VanillaRecipeProvider.has(Items.GOLDEN_HORSE_ARMOR)).save(exporter, VanillaRecipeProvider.getBlastingRecipeName(Items.GOLD_NUGGET));
        ((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.blasting(Ingredient.of(Items.IRON_PICKAXE, Items.IRON_SHOVEL, Items.IRON_AXE, Items.IRON_HOE, Items.IRON_SWORD, Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS, Items.IRON_HORSE_ARMOR, Items.CHAINMAIL_HELMET, Items.CHAINMAIL_CHESTPLATE, Items.CHAINMAIL_LEGGINGS, Items.CHAINMAIL_BOOTS), RecipeCategory.MISC, Items.IRON_NUGGET, 0.1f, 100).unlockedBy("has_iron_pickaxe", (Criterion)VanillaRecipeProvider.has(Items.IRON_PICKAXE))).unlockedBy("has_iron_shovel", (Criterion)VanillaRecipeProvider.has(Items.IRON_SHOVEL))).unlockedBy("has_iron_axe", (Criterion)VanillaRecipeProvider.has(Items.IRON_AXE))).unlockedBy("has_iron_hoe", (Criterion)VanillaRecipeProvider.has(Items.IRON_HOE))).unlockedBy("has_iron_sword", (Criterion)VanillaRecipeProvider.has(Items.IRON_SWORD))).unlockedBy("has_iron_helmet", (Criterion)VanillaRecipeProvider.has(Items.IRON_HELMET))).unlockedBy("has_iron_chestplate", (Criterion)VanillaRecipeProvider.has(Items.IRON_CHESTPLATE))).unlockedBy("has_iron_leggings", (Criterion)VanillaRecipeProvider.has(Items.IRON_LEGGINGS))).unlockedBy("has_iron_boots", (Criterion)VanillaRecipeProvider.has(Items.IRON_BOOTS))).unlockedBy("has_iron_horse_armor", (Criterion)VanillaRecipeProvider.has(Items.IRON_HORSE_ARMOR))).unlockedBy("has_chainmail_helmet", (Criterion)VanillaRecipeProvider.has(Items.CHAINMAIL_HELMET))).unlockedBy("has_chainmail_chestplate", (Criterion)VanillaRecipeProvider.has(Items.CHAINMAIL_CHESTPLATE))).unlockedBy("has_chainmail_leggings", (Criterion)VanillaRecipeProvider.has(Items.CHAINMAIL_LEGGINGS))).unlockedBy("has_chainmail_boots", (Criterion)VanillaRecipeProvider.has(Items.CHAINMAIL_BOOTS)).save(exporter, VanillaRecipeProvider.getBlastingRecipeName(Items.IRON_NUGGET));
        SimpleCookingRecipeBuilder.blasting(Ingredient.of(Blocks.ANCIENT_DEBRIS), RecipeCategory.MISC, Items.NETHERITE_SCRAP, 2.0f, 100).unlockedBy("has_ancient_debris", (Criterion)VanillaRecipeProvider.has(Blocks.ANCIENT_DEBRIS)).save(exporter, VanillaRecipeProvider.getBlastingRecipeName(Items.NETHERITE_SCRAP));
        VanillaRecipeProvider.cookRecipes(exporter, "smoking", RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new, 100);
        VanillaRecipeProvider.cookRecipes(exporter, "campfire_cooking", RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new, 600);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_SLAB, Blocks.STONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_STAIRS, Blocks.STONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICKS, Blocks.STONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICK_SLAB, Blocks.STONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICK_STAIRS, Blocks.STONE);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.STONE), RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_STONE_BRICKS).unlockedBy("has_stone", (Criterion)VanillaRecipeProvider.has(Blocks.STONE)).save(exporter, "chiseled_stone_bricks_stone_from_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.STONE), RecipeCategory.DECORATIONS, Blocks.STONE_BRICK_WALL).unlockedBy("has_stone", (Criterion)VanillaRecipeProvider.has(Blocks.STONE)).save(exporter, "stone_brick_walls_from_stone_stonecutting");
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_SANDSTONE, Blocks.SANDSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SANDSTONE_SLAB, Blocks.SANDSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_SANDSTONE_SLAB, Blocks.SANDSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_SANDSTONE_SLAB, Blocks.CUT_SANDSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SANDSTONE_STAIRS, Blocks.SANDSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.SANDSTONE_WALL, Blocks.SANDSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_SANDSTONE, Blocks.SANDSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_RED_SANDSTONE, Blocks.RED_SANDSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.RED_SANDSTONE_SLAB, Blocks.RED_SANDSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_RED_SANDSTONE_SLAB, Blocks.RED_SANDSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_RED_SANDSTONE_SLAB, Blocks.CUT_RED_SANDSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.RED_SANDSTONE_STAIRS, Blocks.RED_SANDSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.RED_SANDSTONE_WALL, Blocks.RED_SANDSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_RED_SANDSTONE, Blocks.RED_SANDSTONE);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.QUARTZ_BLOCK), RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_SLAB, 2).unlockedBy("has_quartz_block", (Criterion)VanillaRecipeProvider.has(Blocks.QUARTZ_BLOCK)).save(exporter, "quartz_slab_from_stonecutting");
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_STAIRS, Blocks.QUARTZ_BLOCK);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_PILLAR, Blocks.QUARTZ_BLOCK);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_QUARTZ_BLOCK, Blocks.QUARTZ_BLOCK);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.QUARTZ_BRICKS, Blocks.QUARTZ_BLOCK);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.COBBLESTONE_STAIRS, Blocks.COBBLESTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.COBBLESTONE_SLAB, Blocks.COBBLESTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.COBBLESTONE_WALL, Blocks.COBBLESTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICK_SLAB, Blocks.STONE_BRICKS, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.STONE_BRICK_STAIRS, Blocks.STONE_BRICKS);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.STONE_BRICKS), RecipeCategory.DECORATIONS, Blocks.STONE_BRICK_WALL).unlockedBy("has_stone_bricks", (Criterion)VanillaRecipeProvider.has(Blocks.STONE_BRICKS)).save(exporter, "stone_brick_wall_from_stone_bricks_stonecutting");
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_STONE_BRICKS, Blocks.STONE_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.BRICK_SLAB, Blocks.BRICKS, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.BRICK_STAIRS, Blocks.BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.BRICK_WALL, Blocks.BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.MUD_BRICK_SLAB, Blocks.MUD_BRICKS, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.MUD_BRICK_STAIRS, Blocks.MUD_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.MUD_BRICK_WALL, Blocks.MUD_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.NETHER_BRICK_SLAB, Blocks.NETHER_BRICKS, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.NETHER_BRICK_STAIRS, Blocks.NETHER_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.NETHER_BRICK_WALL, Blocks.NETHER_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_NETHER_BRICKS, Blocks.NETHER_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.RED_NETHER_BRICK_SLAB, Blocks.RED_NETHER_BRICKS, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.RED_NETHER_BRICK_STAIRS, Blocks.RED_NETHER_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.RED_NETHER_BRICK_WALL, Blocks.RED_NETHER_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_SLAB, Blocks.PURPUR_BLOCK, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_STAIRS, Blocks.PURPUR_BLOCK);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.PURPUR_PILLAR, Blocks.PURPUR_BLOCK);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE_SLAB, Blocks.PRISMARINE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE_STAIRS, Blocks.PRISMARINE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.PRISMARINE_WALL, Blocks.PRISMARINE);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.PRISMARINE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE_BRICK_SLAB, 2).unlockedBy("has_prismarine_brick", (Criterion)VanillaRecipeProvider.has(Blocks.PRISMARINE_BRICKS)).save(exporter, "prismarine_brick_slab_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.PRISMARINE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.PRISMARINE_BRICK_STAIRS).unlockedBy("has_prismarine_brick", (Criterion)VanillaRecipeProvider.has(Blocks.PRISMARINE_BRICKS)).save(exporter, "prismarine_brick_stairs_from_prismarine_stonecutting");
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DARK_PRISMARINE_SLAB, Blocks.DARK_PRISMARINE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DARK_PRISMARINE_STAIRS, Blocks.DARK_PRISMARINE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.ANDESITE_SLAB, Blocks.ANDESITE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.ANDESITE_STAIRS, Blocks.ANDESITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.ANDESITE_WALL, Blocks.ANDESITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_ANDESITE, Blocks.ANDESITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_ANDESITE_SLAB, Blocks.ANDESITE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_ANDESITE_STAIRS, Blocks.ANDESITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_ANDESITE_SLAB, Blocks.POLISHED_ANDESITE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_ANDESITE_STAIRS, Blocks.POLISHED_ANDESITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BASALT, Blocks.BASALT);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.GRANITE_SLAB, Blocks.GRANITE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.GRANITE_STAIRS, Blocks.GRANITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.GRANITE_WALL, Blocks.GRANITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_GRANITE, Blocks.GRANITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_GRANITE_SLAB, Blocks.GRANITE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_GRANITE_STAIRS, Blocks.GRANITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_GRANITE_SLAB, Blocks.POLISHED_GRANITE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_GRANITE_STAIRS, Blocks.POLISHED_GRANITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DIORITE_SLAB, Blocks.DIORITE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DIORITE_STAIRS, Blocks.DIORITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.DIORITE_WALL, Blocks.DIORITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DIORITE, Blocks.DIORITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DIORITE_SLAB, Blocks.DIORITE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DIORITE_STAIRS, Blocks.DIORITE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DIORITE_SLAB, Blocks.POLISHED_DIORITE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DIORITE_STAIRS, Blocks.POLISHED_DIORITE);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.MOSSY_STONE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_STONE_BRICK_SLAB, 2).unlockedBy("has_mossy_stone_bricks", (Criterion)VanillaRecipeProvider.has(Blocks.MOSSY_STONE_BRICKS)).save(exporter, "mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.MOSSY_STONE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_STONE_BRICK_STAIRS).unlockedBy("has_mossy_stone_bricks", (Criterion)VanillaRecipeProvider.has(Blocks.MOSSY_STONE_BRICKS)).save(exporter, "mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.MOSSY_STONE_BRICKS), RecipeCategory.DECORATIONS, Blocks.MOSSY_STONE_BRICK_WALL).unlockedBy("has_mossy_stone_bricks", (Criterion)VanillaRecipeProvider.has(Blocks.MOSSY_STONE_BRICKS)).save(exporter, "mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting");
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_COBBLESTONE_SLAB, Blocks.MOSSY_COBBLESTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.MOSSY_COBBLESTONE_STAIRS, Blocks.MOSSY_COBBLESTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.MOSSY_COBBLESTONE_WALL, Blocks.MOSSY_COBBLESTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_SANDSTONE_SLAB, Blocks.SMOOTH_SANDSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_SANDSTONE_STAIRS, Blocks.SMOOTH_SANDSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_RED_SANDSTONE_SLAB, Blocks.SMOOTH_RED_SANDSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_RED_SANDSTONE_STAIRS, Blocks.SMOOTH_RED_SANDSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_QUARTZ_SLAB, Blocks.SMOOTH_QUARTZ, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_QUARTZ_STAIRS, Blocks.SMOOTH_QUARTZ);
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.END_STONE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICK_SLAB, 2).unlockedBy("has_end_stone_brick", (Criterion)VanillaRecipeProvider.has(Blocks.END_STONE_BRICKS)).save(exporter, "end_stone_brick_slab_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.END_STONE_BRICKS), RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICK_STAIRS).unlockedBy("has_end_stone_brick", (Criterion)VanillaRecipeProvider.has(Blocks.END_STONE_BRICKS)).save(exporter, "end_stone_brick_stairs_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.stonecutting(Ingredient.of(Blocks.END_STONE_BRICKS), RecipeCategory.DECORATIONS, Blocks.END_STONE_BRICK_WALL).unlockedBy("has_end_stone_brick", (Criterion)VanillaRecipeProvider.has(Blocks.END_STONE_BRICKS)).save(exporter, "end_stone_brick_wall_from_end_stone_brick_stonecutting");
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICKS, Blocks.END_STONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICK_SLAB, Blocks.END_STONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.END_STONE_BRICK_STAIRS, Blocks.END_STONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.END_STONE_BRICK_WALL, Blocks.END_STONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.SMOOTH_STONE_SLAB, Blocks.SMOOTH_STONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.BLACKSTONE_SLAB, Blocks.BLACKSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.BLACKSTONE_STAIRS, Blocks.BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.BLACKSTONE_WALL, Blocks.BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE, Blocks.BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.POLISHED_BLACKSTONE_WALL, Blocks.BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_SLAB, Blocks.BLACKSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_STAIRS, Blocks.BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_POLISHED_BLACKSTONE, Blocks.BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICKS, Blocks.BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_SLAB, Blocks.BLACKSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS, Blocks.BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.POLISHED_BLACKSTONE_BRICK_WALL, Blocks.BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_SLAB, Blocks.POLISHED_BLACKSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_STAIRS, Blocks.POLISHED_BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICKS, Blocks.POLISHED_BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.POLISHED_BLACKSTONE_WALL, Blocks.POLISHED_BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_SLAB, Blocks.POLISHED_BLACKSTONE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS, Blocks.POLISHED_BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.POLISHED_BLACKSTONE_BRICK_WALL, Blocks.POLISHED_BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_POLISHED_BLACKSTONE, Blocks.POLISHED_BLACKSTONE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_SLAB, Blocks.POLISHED_BLACKSTONE_BRICKS, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS, Blocks.POLISHED_BLACKSTONE_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.POLISHED_BLACKSTONE_BRICK_WALL, Blocks.POLISHED_BLACKSTONE_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_COPPER_SLAB, Blocks.CUT_COPPER, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_COPPER_STAIRS, Blocks.CUT_COPPER);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CUT_COPPER_SLAB, Blocks.EXPOSED_CUT_COPPER, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CUT_COPPER_STAIRS, Blocks.EXPOSED_CUT_COPPER);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CUT_COPPER_SLAB, Blocks.WEATHERED_CUT_COPPER, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CUT_COPPER_STAIRS, Blocks.WEATHERED_CUT_COPPER);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CUT_COPPER_SLAB, Blocks.OXIDIZED_CUT_COPPER, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CUT_COPPER_STAIRS, Blocks.OXIDIZED_CUT_COPPER);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CUT_COPPER_SLAB, Blocks.WAXED_CUT_COPPER, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CUT_COPPER_STAIRS, Blocks.WAXED_CUT_COPPER);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CUT_COPPER_SLAB, Blocks.WAXED_EXPOSED_CUT_COPPER, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CUT_COPPER_STAIRS, Blocks.WAXED_EXPOSED_CUT_COPPER);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CUT_COPPER_SLAB, Blocks.WAXED_WEATHERED_CUT_COPPER, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CUT_COPPER_STAIRS, Blocks.WAXED_WEATHERED_CUT_COPPER);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CUT_COPPER_SLAB, Blocks.WAXED_OXIDIZED_CUT_COPPER, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS, Blocks.WAXED_OXIDIZED_CUT_COPPER);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_COPPER, Blocks.COPPER_BLOCK, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_COPPER_STAIRS, Blocks.COPPER_BLOCK, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CUT_COPPER_SLAB, Blocks.COPPER_BLOCK, 8);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CUT_COPPER, Blocks.EXPOSED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CUT_COPPER_STAIRS, Blocks.EXPOSED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.EXPOSED_CUT_COPPER_SLAB, Blocks.EXPOSED_COPPER, 8);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CUT_COPPER, Blocks.WEATHERED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CUT_COPPER_STAIRS, Blocks.WEATHERED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WEATHERED_CUT_COPPER_SLAB, Blocks.WEATHERED_COPPER, 8);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CUT_COPPER, Blocks.OXIDIZED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CUT_COPPER_STAIRS, Blocks.OXIDIZED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.OXIDIZED_CUT_COPPER_SLAB, Blocks.OXIDIZED_COPPER, 8);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CUT_COPPER, Blocks.WAXED_COPPER_BLOCK, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CUT_COPPER_STAIRS, Blocks.WAXED_COPPER_BLOCK, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_CUT_COPPER_SLAB, Blocks.WAXED_COPPER_BLOCK, 8);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CUT_COPPER, Blocks.WAXED_EXPOSED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CUT_COPPER_STAIRS, Blocks.WAXED_EXPOSED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_EXPOSED_CUT_COPPER_SLAB, Blocks.WAXED_EXPOSED_COPPER, 8);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CUT_COPPER, Blocks.WAXED_WEATHERED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CUT_COPPER_STAIRS, Blocks.WAXED_WEATHERED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_WEATHERED_CUT_COPPER_SLAB, Blocks.WAXED_WEATHERED_COPPER, 8);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CUT_COPPER, Blocks.WAXED_OXIDIZED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS, Blocks.WAXED_OXIDIZED_COPPER, 4);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.WAXED_OXIDIZED_CUT_COPPER_SLAB, Blocks.WAXED_OXIDIZED_COPPER, 8);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.COBBLED_DEEPSLATE_SLAB, Blocks.COBBLED_DEEPSLATE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.COBBLED_DEEPSLATE_STAIRS, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.COBBLED_DEEPSLATE_WALL, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_DEEPSLATE, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DEEPSLATE, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DEEPSLATE_SLAB, Blocks.COBBLED_DEEPSLATE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DEEPSLATE_STAIRS, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.POLISHED_DEEPSLATE_WALL, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICKS, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_SLAB, Blocks.COBBLED_DEEPSLATE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_STAIRS, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_BRICK_WALL, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILES, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_SLAB, Blocks.COBBLED_DEEPSLATE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_STAIRS, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_TILE_WALL, Blocks.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DEEPSLATE_SLAB, Blocks.POLISHED_DEEPSLATE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.POLISHED_DEEPSLATE_STAIRS, Blocks.POLISHED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.POLISHED_DEEPSLATE_WALL, Blocks.POLISHED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICKS, Blocks.POLISHED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_SLAB, Blocks.POLISHED_DEEPSLATE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_STAIRS, Blocks.POLISHED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_BRICK_WALL, Blocks.POLISHED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILES, Blocks.POLISHED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_SLAB, Blocks.POLISHED_DEEPSLATE, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_STAIRS, Blocks.POLISHED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_TILE_WALL, Blocks.POLISHED_DEEPSLATE);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_SLAB, Blocks.DEEPSLATE_BRICKS, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_BRICK_STAIRS, Blocks.DEEPSLATE_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_BRICK_WALL, Blocks.DEEPSLATE_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILES, Blocks.DEEPSLATE_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_SLAB, Blocks.DEEPSLATE_BRICKS, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_STAIRS, Blocks.DEEPSLATE_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_TILE_WALL, Blocks.DEEPSLATE_BRICKS);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_SLAB, Blocks.DEEPSLATE_TILES, 2);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.DEEPSLATE_TILE_STAIRS, Blocks.DEEPSLATE_TILES);
        VanillaRecipeProvider.stonecutterResultFromBase(exporter, RecipeCategory.DECORATIONS, Blocks.DEEPSLATE_TILE_WALL, Blocks.DEEPSLATE_TILES);
        VanillaRecipeProvider.smithingTrims().forEach(template -> VanillaRecipeProvider.trimSmithing(exporter, template.template(), template.id()));
        VanillaRecipeProvider.netheriteSmithing(exporter, Items.DIAMOND_CHESTPLATE, RecipeCategory.COMBAT, Items.NETHERITE_CHESTPLATE);
        VanillaRecipeProvider.netheriteSmithing(exporter, Items.DIAMOND_LEGGINGS, RecipeCategory.COMBAT, Items.NETHERITE_LEGGINGS);
        VanillaRecipeProvider.netheriteSmithing(exporter, Items.DIAMOND_HELMET, RecipeCategory.COMBAT, Items.NETHERITE_HELMET);
        VanillaRecipeProvider.netheriteSmithing(exporter, Items.DIAMOND_BOOTS, RecipeCategory.COMBAT, Items.NETHERITE_BOOTS);
        VanillaRecipeProvider.netheriteSmithing(exporter, Items.DIAMOND_SWORD, RecipeCategory.COMBAT, Items.NETHERITE_SWORD);
        VanillaRecipeProvider.netheriteSmithing(exporter, Items.DIAMOND_AXE, RecipeCategory.TOOLS, Items.NETHERITE_AXE);
        VanillaRecipeProvider.netheriteSmithing(exporter, Items.DIAMOND_PICKAXE, RecipeCategory.TOOLS, Items.NETHERITE_PICKAXE);
        VanillaRecipeProvider.netheriteSmithing(exporter, Items.DIAMOND_HOE, RecipeCategory.TOOLS, Items.NETHERITE_HOE);
        VanillaRecipeProvider.netheriteSmithing(exporter, Items.DIAMOND_SHOVEL, RecipeCategory.TOOLS, Items.NETHERITE_SHOVEL);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE, Items.NETHERRACK);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, Items.COBBLESTONE);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SANDSTONE);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE, Items.COBBLESTONE);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE, Items.MOSSY_COBBLESTONE);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, Items.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.END_STONE);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, Items.COBBLESTONE);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.PRISMARINE);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, Items.BLACKSTONE);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, Items.NETHERRACK);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.PURPUR_BLOCK);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.COBBLED_DEEPSLATE);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.TERRACOTTA);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.TERRACOTTA);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.TERRACOTTA);
        VanillaRecipeProvider.copySmithingTemplate(exporter, (ItemLike)Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, Items.TERRACOTTA);
        VanillaRecipeProvider.threeByThreePacker(exporter, RecipeCategory.BUILDING_BLOCKS, Blocks.BAMBOO_BLOCK, Items.BAMBOO);
        VanillaRecipeProvider.planksFromLogs(exporter, Blocks.BAMBOO_PLANKS, ItemTags.BAMBOO_BLOCKS, 2);
        VanillaRecipeProvider.mosaicBuilder(exporter, RecipeCategory.DECORATIONS, Blocks.BAMBOO_MOSAIC, Blocks.BAMBOO_SLAB);
        VanillaRecipeProvider.woodenBoat(exporter, Items.BAMBOO_RAFT, Blocks.BAMBOO_PLANKS);
        VanillaRecipeProvider.chestBoat(exporter, Items.BAMBOO_CHEST_RAFT, Items.BAMBOO_RAFT);
        VanillaRecipeProvider.hangingSign(exporter, Items.OAK_HANGING_SIGN, Blocks.STRIPPED_OAK_LOG);
        VanillaRecipeProvider.hangingSign(exporter, Items.SPRUCE_HANGING_SIGN, Blocks.STRIPPED_SPRUCE_LOG);
        VanillaRecipeProvider.hangingSign(exporter, Items.BIRCH_HANGING_SIGN, Blocks.STRIPPED_BIRCH_LOG);
        VanillaRecipeProvider.hangingSign(exporter, Items.JUNGLE_HANGING_SIGN, Blocks.STRIPPED_JUNGLE_LOG);
        VanillaRecipeProvider.hangingSign(exporter, Items.ACACIA_HANGING_SIGN, Blocks.STRIPPED_ACACIA_LOG);
        VanillaRecipeProvider.hangingSign(exporter, Items.CHERRY_HANGING_SIGN, Blocks.STRIPPED_CHERRY_LOG);
        VanillaRecipeProvider.hangingSign(exporter, Items.DARK_OAK_HANGING_SIGN, Blocks.STRIPPED_DARK_OAK_LOG);
        VanillaRecipeProvider.hangingSign(exporter, Items.MANGROVE_HANGING_SIGN, Blocks.STRIPPED_MANGROVE_LOG);
        VanillaRecipeProvider.hangingSign(exporter, Items.BAMBOO_HANGING_SIGN, Items.STRIPPED_BAMBOO_BLOCK);
        VanillaRecipeProvider.hangingSign(exporter, Items.CRIMSON_HANGING_SIGN, Blocks.STRIPPED_CRIMSON_STEM);
        VanillaRecipeProvider.hangingSign(exporter, Items.WARPED_HANGING_SIGN, Blocks.STRIPPED_WARPED_STEM);
        ShapedRecipeBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, Blocks.CHISELED_BOOKSHELF).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), ItemTags.WOODEN_SLABS).pattern("###").pattern("XXX").pattern("###").unlockedBy("has_book", (Criterion)VanillaRecipeProvider.has(Items.BOOK)).save(exporter);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.ORANGE_DYE, Blocks.TORCHFLOWER, "orange_dye");
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.CYAN_DYE, Blocks.PITCHER_PLANT, "cyan_dye", 2);
        VanillaRecipeProvider.planksFromLog(exporter, Blocks.CHERRY_PLANKS, ItemTags.CHERRY_LOGS, 4);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.CHERRY_WOOD, Blocks.CHERRY_LOG);
        VanillaRecipeProvider.woodFromLogs(exporter, Blocks.STRIPPED_CHERRY_WOOD, Blocks.STRIPPED_CHERRY_LOG);
        VanillaRecipeProvider.woodenBoat(exporter, Items.CHERRY_BOAT, Blocks.CHERRY_PLANKS);
        VanillaRecipeProvider.chestBoat(exporter, Items.CHERRY_CHEST_BOAT, Items.CHERRY_BOAT);
        VanillaRecipeProvider.oneToOneConversionRecipe(exporter, Items.PINK_DYE, Items.PINK_PETALS, "pink_dye", 1);
        ShapedRecipeBuilder.shaped(RecipeCategory.TOOLS, Items.BRUSH).define(Character.valueOf('X'), Items.FEATHER).define(Character.valueOf('#'), Items.COPPER_INGOT).define(Character.valueOf('I'), Items.STICK).pattern("X").pattern("#").pattern("I").unlockedBy("has_copper_ingot", (Criterion)VanillaRecipeProvider.has(Items.COPPER_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped(RecipeCategory.DECORATIONS, Items.DECORATED_POT).define(Character.valueOf('#'), Items.BRICK).pattern(" # ").pattern("# #").pattern(" # ").unlockedBy("has_brick", (Criterion)VanillaRecipeProvider.has(ItemTags.DECORATED_POT_INGREDIENTS)).save(exporter, "decorated_pot_simple");
        SpecialRecipeBuilder.special(DecoratedPotRecipe::new).save(exporter, "decorated_pot");
    }

    public static Stream<TrimTemplate> smithingTrims() {
        return Stream.of(Items.COAST_ARMOR_TRIM_SMITHING_TEMPLATE, Items.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.EYE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, Items.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.RIB_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE, Items.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE, Items.VEX_ARMOR_TRIM_SMITHING_TEMPLATE, Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE, Items.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE, Items.WILD_ARMOR_TRIM_SMITHING_TEMPLATE).map(template -> new TrimTemplate((Item)template, new ResourceLocation(VanillaRecipeProvider.getItemName(template) + "_smithing_trim")));
    }

    public record TrimTemplate(Item template, ResourceLocation id) {
    }
}

