/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.UpdateOneTwentyOneProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBindings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class TrialChambersStructurePools {
    public static final ResourceKey<StructureTemplatePool> START = Pools.createKey("trial_chambers/chamber/end");
    public static final ResourceKey<StructureTemplatePool> HALLWAY_FALLBACK = Pools.createKey("trial_chambers/hallway/fallback");
    public static final ResourceKey<StructureTemplatePool> CHAMBER_CAP_FALLBACK = Pools.createKey("trial_chambers/chamber/entrance_cap");
    public static final List<PoolAliasBinding> ALIAS_BINDINGS = ImmutableList.builder().add((Object)PoolAliasBinding.randomGroup(SimpleWeightedRandomList.builder().add(List.of(PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/ranged"), TrialChambersStructurePools.spawner("ranged/skeleton")), PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/slow_ranged"), TrialChambersStructurePools.spawner("slow_ranged/skeleton")))).add(List.of(PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/ranged"), TrialChambersStructurePools.spawner("ranged/stray")), PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/slow_ranged"), TrialChambersStructurePools.spawner("slow_ranged/stray")))).add(List.of(PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/ranged"), TrialChambersStructurePools.spawner("ranged/poison_skeleton")), PoolAliasBinding.direct(TrialChambersStructurePools.spawner("contents/slow_ranged"), TrialChambersStructurePools.spawner("slow_ranged/poison_skeleton")))).build())).add((Object)PoolAliasBinding.random(TrialChambersStructurePools.spawner("contents/melee"), SimpleWeightedRandomList.builder().add(TrialChambersStructurePools.spawner("melee/zombie")).add(TrialChambersStructurePools.spawner("melee/husk")).add(TrialChambersStructurePools.spawner("melee/slime")).build())).add((Object)PoolAliasBinding.random(TrialChambersStructurePools.spawner("contents/small_melee"), SimpleWeightedRandomList.builder().add(TrialChambersStructurePools.spawner("small_melee/spider")).add(TrialChambersStructurePools.spawner("small_melee/cave_spider")).add(TrialChambersStructurePools.spawner("small_melee/silverfish")).add(TrialChambersStructurePools.spawner("small_melee/baby_zombie")).build())).build();

    public static String spawner(String path) {
        return "trial_chambers/spawner/" + path;
    }

    public static void bootstrap(BootstrapContext<StructureTemplatePool> poolRegisterable) {
        HolderGetter<StructureTemplatePool> holderGetter = poolRegisterable.lookup(Registries.TEMPLATE_POOL);
        Holder.Reference<StructureTemplatePool> holder = holderGetter.getOrThrow(Pools.EMPTY);
        Holder.Reference<StructureTemplatePool> holder2 = holderGetter.getOrThrow(HALLWAY_FALLBACK);
        Holder.Reference<StructureTemplatePool> holder3 = holderGetter.getOrThrow(CHAMBER_CAP_FALLBACK);
        HolderGetter<StructureProcessorList> holderGetter2 = poolRegisterable.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference<StructureProcessorList> holder4 = holderGetter2.getOrThrow(UpdateOneTwentyOneProcessorLists.TRIAL_CHAMBERS_COPPER_BULB_DEGRADATION);
        poolRegisterable.register(START, new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/corridor/end_1", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/end_2", holder4), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/chamber/entrance_cap", new StructureTemplatePool(holder3, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/entrance_cap", holder4), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/chambers/end", new StructureTemplatePool(holder2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/chamber_1", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted", holder4), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/corridor", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/corridor/second_plate"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/intersection/intersection_1", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/intersection/intersection_2", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/intersection/intersection_3", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/first_plate"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium_1", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/entrance_1", holder4), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/chamber/addon", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/full_stacked_walkway"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/full_stacked_walkway_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/full_corner_column"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/full_column_ranged_spawner", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/middle_column_ranged_spawner", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/grate_bridge"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/hanging_platform"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/short_grate_platform"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/short_platform"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/lower_staircase_down"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/lower_walkway_platform"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/walkway_extension"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/side_walkway"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/closed_side_walkway"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/middle_walkway"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/10x15_rise"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/10x15_stacked_pathway"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/10x15_pathway_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/platform_with_space"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/stairs_with_space"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/stairs_with_space_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/c3_side_walkway_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/c3_side_walkway_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/walkway_with_bridge_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/corner_room_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/addon/c1_breeze"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/chamber/assembly", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/full_column"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_1"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_2"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_3"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_4"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_5"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/cover_6"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/platform_1"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/spawner_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/spawner_trap_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/hanging_1"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/hanging_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/hanging_3"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/hanging_4"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/left_staircase_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/left_staircase_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/left_staircase_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/right_staircase_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/right_staircase_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly/right_staircase_3"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/chamber/eruption", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/center_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/breeze_slice_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/slice_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/slice_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/slice_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/quadrant_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/quadrant_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/quadrant_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/quadrant_4"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption/quadrant_5"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/chamber/slanted", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/center"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/hallway_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/hallway_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/hallway_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/hallway_4"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/hallway_5"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_4"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/ramp_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/ramp_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/ramp_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/ramp_4"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/ominous_upper_arm_1"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/chamber/pedestal", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/center_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/slice_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/slice_2"), (Object)3), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/slice_3"), (Object)3), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/slice_4"), (Object)3), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/slice_5"), (Object)3), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/ominous_slice_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/quadrant_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/quadrant_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal/quadrant_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted/quadrant_4"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/corridor/slices", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_1", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_2", holder4), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_3", holder4), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_4", holder4), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_5", holder4), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_6", holder4), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_7", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/straight_8", holder4), (Object)2)), StructureTemplatePool.Projection.RIGID));
        poolRegisterable.register(HALLWAY_FALLBACK, new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble_chamber"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble_thin"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble_chamber_thin"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/hallway", new StructureTemplatePool(holder2, List.of(Pair.of(StructurePoolElement.single("trial_chambers/hallway/corridor_connector_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/upper_hallway_connector", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/lower_hallway_connector", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/chamber/chamber_1", holder4), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/chamber_2", holder4), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/chamber_4", holder4), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/chamber_8", holder4), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/assembly", holder4), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/eruption", holder4), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/slanted", holder4), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/chamber/pedestal", holder4), (Object)150), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble_chamber", holder4), (Object)10), Pair.of(StructurePoolElement.single("trial_chambers/hallway/rubble_chamber_thin", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/cache_1", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/left_corner", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/right_corner", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/corner_staircase", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/corner_staircase_down", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/long_straight_staircase", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/long_straight_staircase_down", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/straight", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/straight_staircase", holder4), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/hallway/straight_staircase_down", holder4), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/corridors/addon/lower", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.empty(), (Object)8), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/staircase"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/wall"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/ladder_to_middle"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/arrow_dispenser"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/bridge_lower"), (Object)2)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/corridors/addon/middle", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.empty(), (Object)8), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/open_walkway"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/walled_walkway"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/corridors/addon/middle_upper", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.empty(), (Object)6), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/open_walkway_upper"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/chandelier_upper"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/decoration_upper"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/head_upper"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/addon/reward_upper"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/atrium", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/bogged_relief"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/breeze_relief"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/spiral_relief"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/spider_relief"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/grand_staircase_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/grand_staircase_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/corridor/atrium/grand_staircase_3"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/decor", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.empty(), (Object)22), Pair.of(StructurePoolElement.single("trial_chambers/decor/empty_pot"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/decor/dead_bush_pot"), (Object)2), Pair.of(StructurePoolElement.single("trial_chambers/decor/undecorated_pot"), (Object)10), Pair.of(StructurePoolElement.single("trial_chambers/decor/flow_pot"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/guster_pot"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/scrape_pot"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/candle_1"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/candle_2"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/candle_3"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/candle_4"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/decor/barrel"), (Object)2)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/decor_chamber", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.empty(), (Object)4), Pair.of(StructurePoolElement.single("trial_chambers/decor/undecorated_pot"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/reward/all", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/reward/vault"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/reward/ominous_vault", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/reward/ominous_vault"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/reward/contents/default", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/reward/vault"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/chests/supply", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chests/connectors/supply"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/chests/contents/supply", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/chests/supply"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/spawner/ranged", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/ranged"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/spawner/slow_ranged", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/slow_ranged"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/spawner/melee", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/melee"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/spawner/small_melee", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/small_melee"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/spawner/breeze", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/breeze"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/spawner/all", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/ranged"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/melee"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/spawner/connectors/small_melee"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/spawner/contents/breeze", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.single("trial_chambers/spawner/breeze/breeze"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        Pools.register(poolRegisterable, "trial_chambers/dispensers/chamber", new StructureTemplatePool(holder, List.of(Pair.of(StructurePoolElement.empty(), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/dispensers/chamber"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/dispensers/wall_dispenser"), (Object)1), Pair.of(StructurePoolElement.single("trial_chambers/dispensers/floor_dispenser"), (Object)1)), StructureTemplatePool.Projection.RIGID));
        PoolAliasBindings.registerTargetsAsPools(poolRegisterable, holder, ALIAS_BINDINGS);
    }
}

