/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.Mth;

public class DoubleTag
extends NumericTag {
    private static final int SELF_SIZE_IN_BYTES = 16;
    public static final DoubleTag ZERO = new DoubleTag(0.0);
    public static final TagType<DoubleTag> TYPE = new TagType.StaticSize<DoubleTag>(){

        @Override
        @Override
        public DoubleTag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return DoubleTag.valueOf(1.readAccounted(dataInput, nbtAccounter));
        }

        @Override
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput input, StreamTagVisitor visitor, NbtAccounter tracker) throws IOException {
            return visitor.visit(1.readAccounted(input, tracker));
        }

        private static double readAccounted(DataInput input, NbtAccounter tracker) throws IOException {
            tracker.accountBytes(16L);
            return input.readDouble();
        }

        @Override
        @Override
        public int size() {
            return 8;
        }

        @Override
        @Override
        public String getName() {
            return "DOUBLE";
        }

        @Override
        @Override
        public String getPrettyName() {
            return "TAG_Double";
        }

        @Override
        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ Tag load(DataInput input, NbtAccounter tracker) throws IOException {
            return this.load(input, tracker);
        }
    };
    private final double data;

    private DoubleTag(double value) {
        this.data = value;
    }

    public static DoubleTag valueOf(double value) {
        if (value == 0.0) {
            return ZERO;
        }
        return new DoubleTag(value);
    }

    @Override
    @Override
    public void write(DataOutput output) throws IOException {
        output.writeDouble(this.data);
    }

    @Override
    @Override
    public int sizeInBytes() {
        return 16;
    }

    @Override
    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public TagType<DoubleTag> getType() {
        return TYPE;
    }

    @Override
    @Override
    public DoubleTag copy() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof DoubleTag && this.data == ((DoubleTag)object).data;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.data);
        return (int)(l ^ l >>> 32);
    }

    @Override
    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitDouble(this);
    }

    @Override
    @Override
    public long getAsLong() {
        return (long)Math.floor(this.data);
    }

    @Override
    @Override
    public int getAsInt() {
        return Mth.floor(this.data);
    }

    @Override
    @Override
    public short getAsShort() {
        return (short)(Mth.floor(this.data) & 0xFFFF);
    }

    @Override
    @Override
    public byte getAsByte() {
        return (byte)(Mth.floor(this.data) & 0xFF);
    }

    @Override
    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    @Override
    public float getAsFloat() {
        return (float)this.data;
    }

    @Override
    @Override
    public Number getAsNumber() {
        return this.data;
    }

    @Override
    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor visitor) {
        return visitor.visit(this.data);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

