/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.Mth;

public class FloatTag
extends NumericTag {
    private static final int SELF_SIZE_IN_BYTES = 12;
    public static final FloatTag ZERO = new FloatTag(0.0f);
    public static final TagType<FloatTag> TYPE = new TagType.StaticSize<FloatTag>(){

        @Override
        @Override
        public FloatTag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return FloatTag.valueOf(1.readAccounted(dataInput, nbtAccounter));
        }

        @Override
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput input, StreamTagVisitor visitor, NbtAccounter tracker) throws IOException {
            return visitor.visit(1.readAccounted(input, tracker));
        }

        private static float readAccounted(DataInput input, NbtAccounter tracker) throws IOException {
            tracker.accountBytes(12L);
            return input.readFloat();
        }

        @Override
        @Override
        public int size() {
            return 4;
        }

        @Override
        @Override
        public String getName() {
            return "FLOAT";
        }

        @Override
        @Override
        public String getPrettyName() {
            return "TAG_Float";
        }

        @Override
        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ Tag load(DataInput input, NbtAccounter tracker) throws IOException {
            return this.load(input, tracker);
        }
    };
    private final float data;

    private FloatTag(float value) {
        this.data = value;
    }

    public static FloatTag valueOf(float value) {
        if (value == 0.0f) {
            return ZERO;
        }
        return new FloatTag(value);
    }

    @Override
    @Override
    public void write(DataOutput output) throws IOException {
        output.writeFloat(this.data);
    }

    @Override
    @Override
    public int sizeInBytes() {
        return 12;
    }

    @Override
    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public TagType<FloatTag> getType() {
        return TYPE;
    }

    @Override
    @Override
    public FloatTag copy() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof FloatTag && this.data == ((FloatTag)object).data;
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.data);
    }

    @Override
    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitFloat(this);
    }

    @Override
    @Override
    public long getAsLong() {
        return (long)this.data;
    }

    @Override
    @Override
    public int getAsInt() {
        return Mth.floor(this.data);
    }

    @Override
    @Override
    public short getAsShort() {
        return (short)(Mth.floor(this.data) & 0xFFFF);
    }

    @Override
    @Override
    public byte getAsByte() {
        return (byte)(Mth.floor(this.data) & 0xFF);
    }

    @Override
    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    @Override
    public float getAsFloat() {
        return this.data;
    }

    @Override
    @Override
    public Number getAsNumber() {
        return Float.valueOf(this.data);
    }

    @Override
    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor visitor) {
        return visitor.visit(this.data);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

