/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.slf4j.Logger;

public final class NbtUtils {
    private static final Comparator<ListTag> YXZ_LISTTAG_INT_COMPARATOR = Comparator.comparingInt(nbt -> nbt.getInt(1)).thenComparingInt(nbt -> nbt.getInt(0)).thenComparingInt(nbt -> nbt.getInt(2));
    private static final Comparator<ListTag> YXZ_LISTTAG_DOUBLE_COMPARATOR = Comparator.comparingDouble(nbt -> nbt.getDouble(1)).thenComparingDouble(nbt -> nbt.getDouble(0)).thenComparingDouble(nbt -> nbt.getDouble(2));
    public static final String SNBT_DATA_TAG = "data";
    private static final char PROPERTIES_START = '{';
    private static final char PROPERTIES_END = '}';
    private static final String ELEMENT_SEPARATOR = ",";
    private static final char KEY_VALUE_SEPARATOR = ':';
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').limit(2);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INDENT = 2;
    private static final int NOT_FOUND = -1;

    private NbtUtils() {
    }

    @VisibleForTesting
    public static boolean compareNbt(@Nullable Tag standard, @Nullable Tag subject, boolean ignoreListOrder) {
        if (standard == subject) {
            return true;
        }
        if (standard == null) {
            return true;
        }
        if (subject == null) {
            return false;
        }
        if (!standard.getClass().equals(subject.getClass())) {
            return false;
        }
        if (standard instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)standard;
            CompoundTag compoundTag2 = (CompoundTag)subject;
            if (compoundTag2.size() < compoundTag.size()) {
                return false;
            }
            for (String string : compoundTag.getAllKeys()) {
                Tag tag = compoundTag.get(string);
                if (NbtUtils.compareNbt(tag, compoundTag2.get(string), ignoreListOrder)) continue;
                return false;
            }
            return true;
        }
        if (standard instanceof ListTag) {
            ListTag listTag = (ListTag)standard;
            if (ignoreListOrder) {
                ListTag listTag2 = (ListTag)subject;
                if (listTag.isEmpty()) {
                    return listTag2.isEmpty();
                }
                if (listTag2.size() < listTag.size()) {
                    return false;
                }
                for (Tag tag2 : listTag) {
                    boolean bl = false;
                    for (Tag tag3 : listTag2) {
                        if (!NbtUtils.compareNbt(tag2, tag3, ignoreListOrder)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return false;
                }
                return true;
            }
        }
        return standard.equals(subject);
    }

    public static IntArrayTag createUUID(UUID uuid) {
        return new IntArrayTag(UUIDUtil.uuidToIntArray(uuid));
    }

    public static UUID loadUUID(Tag element) {
        if (element.getType() != IntArrayTag.TYPE) {
            throw new IllegalArgumentException("Expected UUID-Tag to be of type " + IntArrayTag.TYPE.getName() + ", but found " + element.getType().getName() + ".");
        }
        int[] is = ((IntArrayTag)element).getAsIntArray();
        if (is.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + is.length + ".");
        }
        return UUIDUtil.uuidFromIntArray(is);
    }

    public static Optional<BlockPos> readBlockPos(CompoundTag nbt, String key) {
        int[] is = nbt.getIntArray(key);
        return is.length == 3 ? Optional.of(new BlockPos(is[0], is[1], is[2])) : Optional.empty();
    }

    public static Tag writeBlockPos(BlockPos pos) {
        return new IntArrayTag(new int[]{pos.getX(), pos.getY(), pos.getZ()});
    }

    public static BlockState readBlockState(HolderGetter<Block> blockLookup, CompoundTag nbt) {
        Optional optional;
        if (!nbt.contains("Name", 8)) {
            return Blocks.AIR.defaultBlockState();
        }
        ResourceLocation resourceLocation = ResourceLocation.tryParse(nbt.getString("Name"));
        Optional<Object> optional2 = optional = resourceLocation != null ? blockLookup.get(ResourceKey.create(Registries.BLOCK, resourceLocation)) : Optional.empty();
        if (optional.isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        Block block = (Block)((Holder)optional.get()).value();
        BlockState blockState = block.defaultBlockState();
        if (nbt.contains("Properties", 10)) {
            CompoundTag compoundTag = nbt.getCompound("Properties");
            StateDefinition<Block, BlockState> stateDefinition = block.getStateDefinition();
            for (String string : compoundTag.getAllKeys()) {
                Property<?> property = stateDefinition.getProperty(string);
                if (property == null) continue;
                blockState = NbtUtils.setValueHelper(blockState, property, string, compoundTag, nbt);
            }
        }
        return blockState;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S state, Property<T> property, String key, CompoundTag properties, CompoundTag root) {
        Optional<T> optional = property.getValue(properties.getString(key));
        if (optional.isPresent()) {
            return (S)((StateHolder)state.setValue(property, (Comparable)((Comparable)optional.get())));
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{key, properties.getString(key), root});
        return state;
    }

    public static CompoundTag writeBlockState(BlockState state) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("Name", BuiltInRegistries.BLOCK.getKey(state.getBlock()).toString());
        Map<Property<?>, Comparable<?>> map = state.getValues();
        if (!map.isEmpty()) {
            CompoundTag compoundTag2 = new CompoundTag();
            for (Map.Entry<Property<?>, Comparable<?>> entry : map.entrySet()) {
                Property<?> property = entry.getKey();
                compoundTag2.putString(property.getName(), NbtUtils.getName(property, entry.getValue()));
            }
            compoundTag.put("Properties", compoundTag2);
        }
        return compoundTag;
    }

    public static CompoundTag writeFluidState(FluidState state) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("Name", BuiltInRegistries.FLUID.getKey(state.getType()).toString());
        Map<Property<?>, Comparable<?>> map = state.getValues();
        if (!map.isEmpty()) {
            CompoundTag compoundTag2 = new CompoundTag();
            for (Map.Entry<Property<?>, Comparable<?>> entry : map.entrySet()) {
                Property<?> property = entry.getKey();
                compoundTag2.putString(property.getName(), NbtUtils.getName(property, entry.getValue()));
            }
            compoundTag.put("Properties", compoundTag2);
        }
        return compoundTag;
    }

    private static <T extends Comparable<T>> String getName(Property<T> property, Comparable<?> value) {
        return property.getName(value);
    }

    public static String prettyPrint(Tag nbt) {
        return NbtUtils.prettyPrint(nbt, false);
    }

    public static String prettyPrint(Tag nbt, boolean withArrayContents) {
        return NbtUtils.prettyPrint(new StringBuilder(), nbt, 0, withArrayContents).toString();
    }

    public static StringBuilder prettyPrint(StringBuilder stringBuilder, Tag nbt, int depth, boolean withArrayContents) {
        switch (nbt.getId()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                stringBuilder.append(nbt);
                break;
            }
            case 7: {
                ByteArrayTag byteArrayTag = (ByteArrayTag)nbt;
                byte[] bs = byteArrayTag.getAsByteArray();
                int i = bs.length;
                NbtUtils.indent(depth, stringBuilder).append("byte[").append(i).append("] {\n");
                if (withArrayContents) {
                    NbtUtils.indent(depth + 1, stringBuilder);
                    for (int j = 0; j < bs.length; ++j) {
                        if (j != 0) {
                            stringBuilder.append(',');
                        }
                        if (j % 16 == 0 && j / 16 > 0) {
                            stringBuilder.append('\n');
                            if (j < bs.length) {
                                NbtUtils.indent(depth + 1, stringBuilder);
                            }
                        } else if (j != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%02X", bs[j] & 0xFF));
                    }
                } else {
                    NbtUtils.indent(depth + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                NbtUtils.indent(depth, stringBuilder).append('}');
                break;
            }
            case 9: {
                ListTag listTag = (ListTag)nbt;
                int k = listTag.size();
                byte l = listTag.getElementType();
                String string = l == 0 ? "undefined" : TagTypes.getType(l).getPrettyName();
                NbtUtils.indent(depth, stringBuilder).append("list<").append(string).append(">[").append(k).append("] [");
                if (k != 0) {
                    stringBuilder.append('\n');
                }
                for (int m = 0; m < k; ++m) {
                    if (m != 0) {
                        stringBuilder.append(",\n");
                    }
                    NbtUtils.indent(depth + 1, stringBuilder);
                    NbtUtils.prettyPrint(stringBuilder, listTag.get(m), depth + 1, withArrayContents);
                }
                if (k != 0) {
                    stringBuilder.append('\n');
                }
                NbtUtils.indent(depth, stringBuilder).append(']');
                break;
            }
            case 10: {
                CompoundTag compoundTag = (CompoundTag)nbt;
                ArrayList list = Lists.newArrayList(compoundTag.getAllKeys());
                Collections.sort(list);
                NbtUtils.indent(depth, stringBuilder).append('{');
                if (stringBuilder.length() - stringBuilder.lastIndexOf("\n") > 2 * (depth + 1)) {
                    stringBuilder.append('\n');
                    NbtUtils.indent(depth + 1, stringBuilder);
                }
                int r = list.stream().mapToInt(String::length).max().orElse(0);
                String string2 = Strings.repeat((String)" ", (int)r);
                for (int s = 0; s < list.size(); ++s) {
                    if (s != 0) {
                        stringBuilder.append(",\n");
                    }
                    String string3 = (String)list.get(s);
                    NbtUtils.indent(depth + 1, stringBuilder).append('\"').append(string3).append('\"').append(string2, 0, string2.length() - string3.length()).append(": ");
                    NbtUtils.prettyPrint(stringBuilder, compoundTag.get(string3), depth + 1, withArrayContents);
                }
                if (!list.isEmpty()) {
                    stringBuilder.append('\n');
                }
                NbtUtils.indent(depth, stringBuilder).append('}');
                break;
            }
            case 11: {
                IntArrayTag intArrayTag = (IntArrayTag)nbt;
                int[] is = intArrayTag.getAsIntArray();
                int n = 0;
                for (int o : is) {
                    n = Math.max(n, String.format(Locale.ROOT, "%X", o).length());
                }
                int p = is.length;
                NbtUtils.indent(depth, stringBuilder).append("int[").append(p).append("] {\n");
                if (withArrayContents) {
                    NbtUtils.indent(depth + 1, stringBuilder);
                    for (int q = 0; q < is.length; ++q) {
                        if (q != 0) {
                            stringBuilder.append(',');
                        }
                        if (q % 16 == 0 && q / 16 > 0) {
                            stringBuilder.append('\n');
                            if (q < is.length) {
                                NbtUtils.indent(depth + 1, stringBuilder);
                            }
                        } else if (q != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%0" + n + "X", is[q]));
                    }
                } else {
                    NbtUtils.indent(depth + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                NbtUtils.indent(depth, stringBuilder).append('}');
                break;
            }
            case 12: {
                LongArrayTag longArrayTag = (LongArrayTag)nbt;
                long[] ls = longArrayTag.getAsLongArray();
                long t = 0L;
                for (long u : ls) {
                    t = Math.max(t, (long)String.format(Locale.ROOT, "%X", u).length());
                }
                long v = ls.length;
                NbtUtils.indent(depth, stringBuilder).append("long[").append(v).append("] {\n");
                if (withArrayContents) {
                    NbtUtils.indent(depth + 1, stringBuilder);
                    for (int w = 0; w < ls.length; ++w) {
                        if (w != 0) {
                            stringBuilder.append(',');
                        }
                        if (w % 16 == 0 && w / 16 > 0) {
                            stringBuilder.append('\n');
                            if (w < ls.length) {
                                NbtUtils.indent(depth + 1, stringBuilder);
                            }
                        } else if (w != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%0" + t + "X", ls[w]));
                    }
                } else {
                    NbtUtils.indent(depth + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                NbtUtils.indent(depth, stringBuilder).append('}');
                break;
            }
            default: {
                stringBuilder.append("<UNKNOWN :(>");
            }
        }
        return stringBuilder;
    }

    private static StringBuilder indent(int depth, StringBuilder stringBuilder) {
        int i = stringBuilder.lastIndexOf("\n") + 1;
        int j = stringBuilder.length() - i;
        for (int k = 0; k < 2 * depth - j; ++k) {
            stringBuilder.append(' ');
        }
        return stringBuilder;
    }

    public static Component toPrettyComponent(Tag element) {
        return new TextComponentTagVisitor("").visit(element);
    }

    public static String structureToSnbt(CompoundTag compound) {
        return new SnbtPrinterTagVisitor().visit(NbtUtils.packStructureTemplate(compound));
    }

    public static CompoundTag snbtToStructure(String string) throws CommandSyntaxException {
        return NbtUtils.unpackStructureTemplate(TagParser.parseTag(string));
    }

    @VisibleForTesting
    static CompoundTag packStructureTemplate(CompoundTag compound) {
        boolean bl = compound.contains("palettes", 9);
        ListTag listTag = bl ? compound.getList("palettes", 9).getList(0) : compound.getList("palette", 10);
        ListTag listTag3 = listTag.stream().map(CompoundTag.class::cast).map(NbtUtils::packBlockState).map(StringTag::valueOf).collect(Collectors.toCollection(ListTag::new));
        compound.put("palette", listTag3);
        if (bl) {
            ListTag listTag4 = new ListTag();
            ListTag listTag5 = compound.getList("palettes", 9);
            listTag5.stream().map(ListTag.class::cast).forEach(nbt -> {
                CompoundTag compoundTag = new CompoundTag();
                for (int i = 0; i < nbt.size(); ++i) {
                    compoundTag.putString(listTag3.getString(i), NbtUtils.packBlockState(nbt.getCompound(i)));
                }
                listTag4.add(compoundTag);
            });
            compound.put("palettes", listTag4);
        }
        if (compound.contains("entities", 9)) {
            ListTag listTag6 = compound.getList("entities", 10);
            ListTag listTag7 = listTag6.stream().map(CompoundTag.class::cast).sorted(Comparator.comparing(nbt -> nbt.getList("pos", 6), YXZ_LISTTAG_DOUBLE_COMPARATOR)).collect(Collectors.toCollection(ListTag::new));
            compound.put("entities", listTag7);
        }
        ListTag listTag8 = compound.getList("blocks", 10).stream().map(CompoundTag.class::cast).sorted(Comparator.comparing(nbt -> nbt.getList("pos", 3), YXZ_LISTTAG_INT_COMPARATOR)).peek(nbt -> nbt.putString("state", listTag3.getString(nbt.getInt("state")))).collect(Collectors.toCollection(ListTag::new));
        compound.put(SNBT_DATA_TAG, listTag8);
        compound.remove("blocks");
        return compound;
    }

    @VisibleForTesting
    static CompoundTag unpackStructureTemplate(CompoundTag compound) {
        ListTag listTag = compound.getList("palette", 8);
        Map map = (Map)listTag.stream().map(StringTag.class::cast).map(StringTag::getAsString).collect(ImmutableMap.toImmutableMap(Function.identity(), NbtUtils::unpackBlockState));
        if (compound.contains("palettes", 9)) {
            compound.put("palettes", compound.getList("palettes", 10).stream().map(CompoundTag.class::cast).map(nbt -> map.keySet().stream().map(nbt::getString).map(NbtUtils::unpackBlockState).collect(Collectors.toCollection(ListTag::new))).collect(Collectors.toCollection(ListTag::new)));
            compound.remove("palette");
        } else {
            compound.put("palette", map.values().stream().collect(Collectors.toCollection(ListTag::new)));
        }
        if (compound.contains(SNBT_DATA_TAG, 9)) {
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            object2IntMap.defaultReturnValue(-1);
            for (int i = 0; i < listTag.size(); ++i) {
                object2IntMap.put((Object)listTag.getString(i), i);
            }
            ListTag listTag2 = compound.getList(SNBT_DATA_TAG, 10);
            for (int j = 0; j < listTag2.size(); ++j) {
                CompoundTag compoundTag = listTag2.getCompound(j);
                String string = compoundTag.getString("state");
                int k = object2IntMap.getInt((Object)string);
                if (k == -1) {
                    throw new IllegalStateException("Entry " + string + " missing from palette");
                }
                compoundTag.putInt("state", k);
            }
            compound.put("blocks", listTag2);
            compound.remove(SNBT_DATA_TAG);
        }
        return compound;
    }

    @VisibleForTesting
    static String packBlockState(CompoundTag compound) {
        StringBuilder stringBuilder = new StringBuilder(compound.getString("Name"));
        if (compound.contains("Properties", 10)) {
            CompoundTag compoundTag = compound.getCompound("Properties");
            String string = compoundTag.getAllKeys().stream().sorted().map(key -> key + ":" + compoundTag.get((String)key).getAsString()).collect(Collectors.joining(ELEMENT_SEPARATOR));
            stringBuilder.append('{').append(string).append('}');
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    static CompoundTag unpackBlockState(String string) {
        String string2;
        CompoundTag compoundTag = new CompoundTag();
        int i = string.indexOf(123);
        if (i >= 0) {
            string2 = string.substring(0, i);
            CompoundTag compoundTag2 = new CompoundTag();
            if (i + 2 <= string.length()) {
                String string3 = string.substring(i + 1, string.indexOf(125, i));
                COMMA_SPLITTER.split((CharSequence)string3).forEach(property -> {
                    List list = COLON_SPLITTER.splitToList((CharSequence)property);
                    if (list.size() == 2) {
                        compoundTag2.putString((String)list.get(0), (String)list.get(1));
                    } else {
                        LOGGER.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)string);
                    }
                });
                compoundTag.put("Properties", compoundTag2);
            }
        } else {
            string2 = string;
        }
        compoundTag.putString("Name", string2);
        return compoundTag;
    }

    public static CompoundTag addCurrentDataVersion(CompoundTag nbt) {
        int i = SharedConstants.getCurrentVersion().getDataVersion().getVersion();
        return NbtUtils.addDataVersion(nbt, i);
    }

    public static CompoundTag addDataVersion(CompoundTag nbt, int dataVersion) {
        nbt.putInt("DataVersion", dataVersion);
        return nbt;
    }

    public static int getDataVersion(CompoundTag nbt, int fallback) {
        return nbt.contains("DataVersion", 99) ? nbt.getInt("DataVersion") : fallback;
    }
}

