/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INLINE_LIST_THRESHOLD = 8;
    private static final int MAX_DEPTH = 64;
    private static final ByteCollection INLINE_ELEMENT_TYPES = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_KEY = ChatFormatting.AQUA;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_STRING = ChatFormatting.GREEN;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_NUMBER = ChatFormatting.GOLD;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_NUMBER_TYPE = ChatFormatting.RED;
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String NAME_VALUE_SEPARATOR = String.valueOf(':');
    private static final String ELEMENT_SEPARATOR = String.valueOf(',');
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private static final String LIST_TYPE_SEPARATOR = ";";
    private static final String ELEMENT_SPACING = " ";
    private static final String STRUCT_OPEN = "{";
    private static final String STRUCT_CLOSE = "}";
    private static final String NEWLINE = "\n";
    private static final Component TOO_DEEP = Component.literal("<...>").withStyle(ChatFormatting.GRAY);
    private final String indentation;
    private final int indentDepth;
    private final int depth;
    private Component result = CommonComponents.EMPTY;

    public TextComponentTagVisitor(String prefix) {
        this(prefix, 0, 0);
    }

    private TextComponentTagVisitor(String prefix, int indentationLevel, int depth) {
        this.indentation = prefix;
        this.indentDepth = indentationLevel;
        this.depth = depth;
    }

    public Component visit(Tag element) {
        element.accept(this);
        return this.result;
    }

    @Override
    @Override
    public void visitString(StringTag element) {
        String string = StringTag.quoteAndEscape(element.getAsString());
        String string2 = string.substring(0, 1);
        MutableComponent component = Component.literal(string.substring(1, string.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_STRING);
        this.result = Component.literal(string2).append(component).append(string2);
    }

    @Override
    @Override
    public void visitByte(ByteTag element) {
        MutableComponent component = Component.literal("b").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(element.getAsNumber())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    @Override
    public void visitShort(ShortTag element) {
        MutableComponent component = Component.literal("s").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(element.getAsNumber())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    @Override
    public void visitInt(IntTag element) {
        this.result = Component.literal(String.valueOf(element.getAsNumber())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    @Override
    public void visitLong(LongTag element) {
        MutableComponent component = Component.literal("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(element.getAsNumber())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    @Override
    public void visitFloat(FloatTag element) {
        MutableComponent component = Component.literal("f").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(element.getAsFloat())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    @Override
    public void visitDouble(DoubleTag element) {
        MutableComponent component = Component.literal("d").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = Component.literal(String.valueOf(element.getAsDouble())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    @Override
    public void visitByteArray(ByteArrayTag element) {
        MutableComponent component = Component.literal("B").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent mutableComponent = Component.literal(LIST_OPEN).append(component).append(LIST_TYPE_SEPARATOR);
        byte[] bs = element.getAsByteArray();
        for (int i = 0; i < bs.length; ++i) {
            MutableComponent mutableComponent2 = Component.literal(String.valueOf(bs[i])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            mutableComponent.append(ELEMENT_SPACING).append(mutableComponent2).append(component);
            if (i == bs.length - 1) continue;
            mutableComponent.append(ELEMENT_SEPARATOR);
        }
        mutableComponent.append(LIST_CLOSE);
        this.result = mutableComponent;
    }

    @Override
    @Override
    public void visitIntArray(IntArrayTag element) {
        MutableComponent component = Component.literal("I").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent mutableComponent = Component.literal(LIST_OPEN).append(component).append(LIST_TYPE_SEPARATOR);
        int[] is = element.getAsIntArray();
        for (int i = 0; i < is.length; ++i) {
            mutableComponent.append(ELEMENT_SPACING).append(Component.literal(String.valueOf(is[i])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER));
            if (i == is.length - 1) continue;
            mutableComponent.append(ELEMENT_SEPARATOR);
        }
        mutableComponent.append(LIST_CLOSE);
        this.result = mutableComponent;
    }

    @Override
    @Override
    public void visitLongArray(LongArrayTag element) {
        MutableComponent component = Component.literal("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent mutableComponent = Component.literal(LIST_OPEN).append(component).append(LIST_TYPE_SEPARATOR);
        long[] ls = element.getAsLongArray();
        for (int i = 0; i < ls.length; ++i) {
            MutableComponent component2 = Component.literal(String.valueOf(ls[i])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            mutableComponent.append(ELEMENT_SPACING).append(component2).append(component);
            if (i == ls.length - 1) continue;
            mutableComponent.append(ELEMENT_SEPARATOR);
        }
        mutableComponent.append(LIST_CLOSE);
        this.result = mutableComponent;
    }

    @Override
    @Override
    public void visitList(ListTag element) {
        if (element.isEmpty()) {
            this.result = Component.literal("[]");
            return;
        }
        if (this.depth >= 64) {
            this.result = Component.literal(LIST_OPEN).append(TOO_DEEP).append(LIST_CLOSE);
            return;
        }
        if (INLINE_ELEMENT_TYPES.contains(element.getElementType()) && element.size() <= 8) {
            String string = ELEMENT_SEPARATOR + ELEMENT_SPACING;
            MutableComponent mutableComponent = Component.literal(LIST_OPEN);
            for (int i = 0; i < element.size(); ++i) {
                if (i != 0) {
                    mutableComponent.append(string);
                }
                mutableComponent.append(this.buildSubTag(element.get(i), false));
            }
            mutableComponent.append(LIST_CLOSE);
            this.result = mutableComponent;
            return;
        }
        MutableComponent mutableComponent2 = Component.literal(LIST_OPEN);
        if (!this.indentation.isEmpty()) {
            mutableComponent2.append(NEWLINE);
        }
        String string2 = Strings.repeat((String)this.indentation, (int)(this.indentDepth + 1));
        for (int j = 0; j < element.size(); ++j) {
            MutableComponent mutableComponent3 = Component.literal(string2);
            mutableComponent3.append(this.buildSubTag(element.get(j), true));
            if (j != element.size() - 1) {
                mutableComponent3.append(ELEMENT_SEPARATOR).append(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
            }
            mutableComponent2.append(mutableComponent3);
        }
        if (!this.indentation.isEmpty()) {
            mutableComponent2.append(NEWLINE).append(Strings.repeat((String)this.indentation, (int)this.indentDepth));
        }
        mutableComponent2.append(LIST_CLOSE);
        this.result = mutableComponent2;
    }

    @Override
    @Override
    public void visitCompound(CompoundTag compound) {
        if (compound.isEmpty()) {
            this.result = Component.literal("{}");
            return;
        }
        if (this.depth >= 64) {
            this.result = Component.literal(STRUCT_OPEN).append(TOO_DEEP).append(STRUCT_CLOSE);
            return;
        }
        MutableComponent mutableComponent = Component.literal(STRUCT_OPEN);
        Collection<String> collection = compound.getAllKeys();
        if (LOGGER.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(compound.getAllKeys());
            Collections.sort(list);
            collection = list;
        }
        if (!this.indentation.isEmpty()) {
            mutableComponent.append(NEWLINE);
        }
        String string = Strings.repeat((String)this.indentation, (int)(this.indentDepth + 1));
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            MutableComponent mutableComponent2 = Component.literal(string).append(TextComponentTagVisitor.handleEscapePretty(string2)).append(NAME_VALUE_SEPARATOR).append(ELEMENT_SPACING).append(this.buildSubTag(compound.get(string2), true));
            if (iterator.hasNext()) {
                mutableComponent2.append(ELEMENT_SEPARATOR).append(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
            }
            mutableComponent.append(mutableComponent2);
        }
        if (!this.indentation.isEmpty()) {
            mutableComponent.append(NEWLINE).append(Strings.repeat((String)this.indentation, (int)this.indentDepth));
        }
        mutableComponent.append(STRUCT_CLOSE);
        this.result = mutableComponent;
    }

    private Component buildSubTag(Tag element, boolean indent) {
        return new TextComponentTagVisitor(this.indentation, indent ? this.indentDepth + 1 : this.indentDepth, this.depth + 1).visit(element);
    }

    protected static Component handleEscapePretty(String name) {
        if (SIMPLE_VALUE.matcher(name).matches()) {
            return Component.literal(name).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        }
        String string = StringTag.quoteAndEscape(name);
        String string2 = string.substring(0, 1);
        MutableComponent component = Component.literal(string.substring(1, string.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        return Component.literal(string2).append(component).append(string2);
    }

    @Override
    @Override
    public void visitEnd(EndTag element) {
        this.result = CommonComponents.EMPTY;
    }
}

