/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import io.papermc.paper.adventure.AdventureComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;

public class ComponentUtils {
    public static final String DEFAULT_SEPARATOR_TEXT = ", ";
    public static final Component DEFAULT_SEPARATOR = Component.literal(", ").withStyle(ChatFormatting.GRAY);
    public static final Component DEFAULT_NO_STYLE_SEPARATOR = Component.literal(", ");

    public static MutableComponent mergeStyles(MutableComponent text, Style style) {
        if (style.isEmpty()) {
            return text;
        }
        Style style2 = text.getStyle();
        if (style2.isEmpty()) {
            return text.setStyle(style);
        }
        return style2.equals(style) ? text : text.setStyle(style2.applyTo(style));
    }

    public static Optional<MutableComponent> updateForEntity(@Nullable CommandSourceStack source, Optional<Component> text, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        return text.isPresent() ? Optional.of(ComponentUtils.updateForEntity(source, text.get(), sender, depth)) : Optional.empty();
    }

    public static MutableComponent updateForEntity(@Nullable CommandSourceStack source, Component text, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (depth > 100) {
            return text.copy();
        }
        if (text instanceof AdventureComponent) {
            AdventureComponent adventureComponent = (AdventureComponent)text;
            text = adventureComponent.deepConverted();
        }
        MutableComponent mutableComponent = text.getContents().resolve(source, sender, depth + 1);
        for (Component component : text.getSiblings()) {
            mutableComponent.append(ComponentUtils.updateForEntity(source, component, sender, depth + 1));
        }
        return mutableComponent.withStyle(ComponentUtils.resolveStyle(source, text.getStyle(), sender, depth));
    }

    private static Style resolveStyle(@Nullable CommandSourceStack source, Style style, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        Component component;
        HoverEvent hoverEvent = style.getHoverEvent();
        if (hoverEvent != null && (component = hoverEvent.getValue(HoverEvent.Action.SHOW_TEXT)) != null) {
            HoverEvent hoverEvent2 = new HoverEvent(HoverEvent.Action.SHOW_TEXT, ComponentUtils.updateForEntity(source, component, sender, depth + 1));
            return style.withHoverEvent(hoverEvent2);
        }
        return style;
    }

    public static Component formatList(Collection<String> strings) {
        return ComponentUtils.formatAndSortList(strings, string -> Component.literal(string).withStyle(ChatFormatting.GREEN));
    }

    public static <T extends Comparable<T>> Component formatAndSortList(Collection<T> elements, Function<T, Component> transformer) {
        if (elements.isEmpty()) {
            return CommonComponents.EMPTY;
        }
        if (elements.size() == 1) {
            return transformer.apply((Comparable)elements.iterator().next());
        }
        ArrayList list = Lists.newArrayList(elements);
        list.sort(Comparable::compareTo);
        return ComponentUtils.formatList(list, transformer);
    }

    public static <T> Component formatList(Collection<? extends T> elements, Function<T, Component> transformer) {
        return ComponentUtils.formatList(elements, DEFAULT_SEPARATOR, transformer);
    }

    public static <T> MutableComponent formatList(Collection<? extends T> elements, Optional<? extends Component> separator, Function<T, Component> transformer) {
        return ComponentUtils.formatList(elements, (Component)DataFixUtils.orElse(separator, (Object)DEFAULT_SEPARATOR), transformer);
    }

    public static Component formatList(Collection<? extends Component> texts, Component separator) {
        return ComponentUtils.formatList(texts, separator, Function.identity());
    }

    public static <T> MutableComponent formatList(Collection<? extends T> elements, Component separator, Function<T, Component> transformer) {
        if (elements.isEmpty()) {
            return Component.empty();
        }
        if (elements.size() == 1) {
            return transformer.apply(elements.iterator().next()).copy();
        }
        MutableComponent mutableComponent = Component.empty();
        boolean bl = true;
        for (T object : elements) {
            if (!bl) {
                mutableComponent.append(separator);
            }
            mutableComponent.append(transformer.apply(object));
            bl = false;
        }
        return mutableComponent;
    }

    public static MutableComponent wrapInSquareBrackets(Component text) {
        return Component.translatable("chat.square_brackets", text);
    }

    public static Component fromMessage(Message message) {
        return message instanceof Component ? (Component)message : Component.literal(message.getString());
    }

    public static boolean isTranslationResolvable(@Nullable Component text) {
        ComponentContents componentContents;
        if (text != null && (componentContents = text.getContents()) instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            String string = translatableContents.getKey();
            String string2 = translatableContents.getFallback();
            return string2 != null || Language.getInstance().has(string);
        }
        return true;
    }

    public static MutableComponent copyOnClickText(String string) {
        return ComponentUtils.wrapInSquareBrackets(Component.literal(string).withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, string)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, Component.translatable("chat.copy.click"))).withInsertion(string)));
    }
}

