/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.time.Instant;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;

public record SignedMessageBody(String content, Instant timeStamp, long salt, LastSeenMessages lastSeen) {
    public static final MapCodec<SignedMessageBody> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("content").forGetter(SignedMessageBody::content), (App)ExtraCodecs.INSTANT_ISO8601.fieldOf("time_stamp").forGetter(SignedMessageBody::timeStamp), (App)Codec.LONG.fieldOf("salt").forGetter(SignedMessageBody::salt), (App)LastSeenMessages.CODEC.optionalFieldOf("last_seen", (Object)LastSeenMessages.EMPTY).forGetter(SignedMessageBody::lastSeen)).apply((Applicative)instance, SignedMessageBody::new));

    public static SignedMessageBody unsigned(String content) {
        return new SignedMessageBody(content, Instant.now(), 0L, LastSeenMessages.EMPTY);
    }

    public void updateSignature(SignatureUpdater.Output updater) throws SignatureException {
        updater.update(Longs.toByteArray((long)this.salt));
        updater.update(Longs.toByteArray((long)this.timeStamp.getEpochSecond()));
        byte[] bs = this.content.getBytes(StandardCharsets.UTF_8);
        updater.update(Ints.toByteArray((int)bs.length));
        updater.update(bs);
        this.lastSeen.updateSignature(updater);
    }

    public Packed pack(MessageSignatureCache storage) {
        return new Packed(this.content, this.timeStamp, this.salt, this.lastSeen.pack(storage));
    }

    public record Packed(String content, Instant timeStamp, long salt, LastSeenMessages.Packed lastSeen) {
        public Packed(FriendlyByteBuf buf) {
            this(buf.readUtf(256), buf.readInstant(), buf.readLong(), new LastSeenMessages.Packed(buf));
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeUtf(this.content, 256);
            buf.writeInstant(this.timeStamp);
            buf.writeLong(this.salt);
            this.lastSeen.write(buf);
        }

        public Optional<SignedMessageBody> unpack(MessageSignatureCache storage) {
            return this.lastSeen.unpack(storage).map(lastSeenMessages -> new SignedMessageBody(this.content, this.timeStamp, this.salt, (LastSeenMessages)lastSeenMessages));
        }
    }
}

