/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.logging.LogUtils;
import java.time.Instant;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.Signer;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.bukkit.event.player.PlayerKickEvent;
import org.leavesmc.leaves.LeavesConfig;
import org.slf4j.Logger;

public class SignedMessageChain {
    static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    SignedMessageLink nextLink;
    Instant lastTimeStamp = Instant.EPOCH;

    public SignedMessageChain(UUID sender, UUID sessionId) {
        this.nextLink = SignedMessageLink.root(sender, sessionId);
    }

    public Encoder encoder(Signer signer) {
        return body -> {
            SignedMessageLink signedMessageLink = this.nextLink;
            if (signedMessageLink == null) {
                return null;
            }
            this.nextLink = signedMessageLink.advance();
            return new MessageSignature(signer.sign(updatable -> PlayerChatMessage.updateSignature(updatable, signedMessageLink, body)));
        };
    }

    public Decoder decoder(final ProfilePublicKey playerPublicKey) {
        final SignatureValidator signatureValidator = playerPublicKey.createSignatureValidator();
        return new Decoder(){

            @Override
            public PlayerChatMessage unpack(@Nullable MessageSignature signature, SignedMessageBody body) throws DecodeException {
                if (signature == null) {
                    throw new DecodeException(DecodeException.MISSING_PROFILE_KEY);
                }
                if (playerPublicKey.data().hasExpired()) {
                    throw new DecodeException(DecodeException.EXPIRED_PROFILE_KEY, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
                }
                SignedMessageLink signedMessageLink = SignedMessageChain.this.nextLink;
                if (signedMessageLink == null) {
                    throw new DecodeException(DecodeException.CHAIN_BROKEN);
                }
                if (!LeavesConfig.disableCheckOutOfOrderCommand && body.timeStamp().isBefore(SignedMessageChain.this.lastTimeStamp)) {
                    this.setChainBroken();
                    throw new DecodeException(DecodeException.OUT_OF_ORDER_CHAT, PlayerKickEvent.Cause.OUT_OF_ORDER_CHAT);
                }
                SignedMessageChain.this.lastTimeStamp = body.timeStamp();
                PlayerChatMessage playerChatMessage = new PlayerChatMessage(signedMessageLink, signature, body, null, FilterMask.PASS_THROUGH);
                if (!playerChatMessage.verify(signatureValidator)) {
                    this.setChainBroken();
                    throw new DecodeException(DecodeException.INVALID_SIGNATURE);
                }
                if (playerChatMessage.hasExpiredServer(Instant.now())) {
                    LOGGER.warn("Received expired chat: '{}'. Is the client/server system time unsynchronized?", (Object)body.content());
                }
                SignedMessageChain.this.nextLink = signedMessageLink.advance();
                return playerChatMessage;
            }

            @Override
            public void setChainBroken() {
                SignedMessageChain.this.nextLink = null;
            }
        };
    }

    @FunctionalInterface
    public static interface Encoder {
        public static final Encoder UNSIGNED = body -> null;

        @Nullable
        public MessageSignature pack(SignedMessageBody var1);
    }

    @FunctionalInterface
    public static interface Decoder {
        public static Decoder unsigned(UUID sender, BooleanSupplier secureProfileEnforced) {
            return (signature, body) -> {
                if (secureProfileEnforced.getAsBoolean()) {
                    throw new DecodeException(DecodeException.MISSING_PROFILE_KEY);
                }
                return PlayerChatMessage.unsigned(sender, body.content());
            };
        }

        public PlayerChatMessage unpack(@Nullable MessageSignature var1, SignedMessageBody var2) throws DecodeException;

        default public void setChainBroken() {
        }
    }

    public static class DecodeException
    extends ThrowingComponent {
        static final Component MISSING_PROFILE_KEY = Component.translatable("chat.disabled.missingProfileKey");
        static final Component CHAIN_BROKEN = Component.translatable("chat.disabled.chain_broken");
        static final Component EXPIRED_PROFILE_KEY = Component.translatable("chat.disabled.expiredProfileKey");
        static final Component INVALID_SIGNATURE = Component.translatable("chat.disabled.invalid_signature");
        static final Component OUT_OF_ORDER_CHAT = Component.translatable("chat.disabled.out_of_order_chat");
        public final PlayerKickEvent.Cause kickCause;

        public DecodeException(Component message, PlayerKickEvent.Cause event) {
            super(message);
            this.kickCause = event;
        }

        public DecodeException(Component message) {
            this(message, PlayerKickEvent.Cause.UNKNOWN);
        }
    }
}

