/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;

public class IdDispatchCodec<B extends ByteBuf, V, T>
implements StreamCodec<B, V> {
    private static final int UNKNOWN_TYPE = -1;
    private final Function<V, ? extends T> typeGetter;
    private final List<Entry<B, V, T>> byId;
    private final Object2IntMap<T> toId;

    IdDispatchCodec(Function<V, ? extends T> packetIdGetter, List<Entry<B, V, T>> packetTypes, Object2IntMap<T> typeToIndex) {
        this.typeGetter = packetIdGetter;
        this.byId = packetTypes;
        this.toId = typeToIndex;
    }

    @Override
    @Override
    public V decode(B byteBuf) {
        int i = VarInt.read(byteBuf);
        if (i < 0 || i >= this.byId.size()) {
            throw new DecoderException("Received unknown packet id " + i);
        }
        Entry<B, V, T> entry = this.byId.get(i);
        try {
            return (V)entry.serializer.decode(byteBuf);
        }
        catch (Exception exception) {
            throw new DecoderException("Failed to decode packet '" + String.valueOf(entry.type) + "'", (Throwable)exception);
        }
    }

    @Override
    @Override
    public void encode(B byteBuf, V object) {
        T object2 = this.typeGetter.apply(object);
        int i = this.toId.getOrDefault(object2, -1);
        if (i == -1) {
            throw new EncoderException("Sending unknown packet '" + String.valueOf(object2) + "'");
        }
        VarInt.write(byteBuf, i);
        Entry<B, V, T> entry = this.byId.get(i);
        try {
            StreamCodec streamCodec = entry.serializer;
            streamCodec.encode(byteBuf, object);
        }
        catch (Exception exception) {
            throw new EncoderException("Failed to encode packet '" + String.valueOf(object2) + "'", (Throwable)exception);
        }
    }

    public static <B extends ByteBuf, V, T> Builder<B, V, T> builder(Function<V, ? extends T> packetIdGetter) {
        return new Builder(packetIdGetter);
    }

    @Override
    public /* synthetic */ void encode(Object buf, Object value) {
        this.encode((B)((ByteBuf)buf), (V)value);
    }

    @Override
    public /* synthetic */ Object decode(Object buf) {
        return this.decode((B)((ByteBuf)buf));
    }

    record Entry<B, V, T>(StreamCodec<? super B, ? extends V> serializer, T type) {
    }

    public static class Builder<B extends ByteBuf, V, T> {
        private final List<Entry<B, V, T>> entries = new ArrayList<Entry<B, V, T>>();
        private final Function<V, ? extends T> typeGetter;

        Builder(Function<V, ? extends T> packetIdGetter) {
            this.typeGetter = packetIdGetter;
        }

        public Builder<B, V, T> add(T id, StreamCodec<? super B, ? extends V> codec) {
            this.entries.add(new Entry<B, V, T>(codec, id));
            return this;
        }

        public IdDispatchCodec<B, V, T> build() {
            Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
            object2IntOpenHashMap.defaultReturnValue(-2);
            for (Entry<B, V, T> entry : this.entries) {
                int i = object2IntOpenHashMap.size();
                int j = object2IntOpenHashMap.putIfAbsent(entry.type, i);
                if (j == -2) continue;
                throw new IllegalStateException("Duplicate registration for type " + String.valueOf(entry.type));
            }
            return new IdDispatchCodec<B, V, T>(this.typeGetter, List.copyOf(this.entries), object2IntOpenHashMap);
        }
    }
}

