/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.thread.BlockableEventLoop;
import org.leavesmc.leaves.LeavesLogger;
import org.leavesmc.leaves.util.UpdateSuppressionException;
import org.slf4j.Logger;

public class PacketUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ConcurrentLinkedDeque<PacketListener> packetProcessing = new ConcurrentLinkedDeque();
    static final AtomicLong totalMainThreadPacketsProcessed = new AtomicLong();

    public static long getTotalProcessedPackets() {
        return totalMainThreadPacketsProcessed.get();
    }

    public static List<PacketListener> getCurrentPacketProcessors() {
        ArrayList<PacketListener> ret = new ArrayList<PacketListener>(4);
        for (PacketListener listener : packetProcessing) {
            ret.add(listener);
        }
        return ret;
    }

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> packet, T listener, ServerLevel world) throws RunningOnDifferentThreadException {
        PacketUtils.ensureRunningOnSameThread(packet, listener, world.getServer());
    }

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> packet, T listener, BlockableEventLoop<?> engine) throws RunningOnDifferentThreadException {
        if (!engine.isSameThread()) {
            engine.executeIfPossible(() -> {
                packetProcessing.push(listener);
                try {
                    if (listener instanceof ServerCommonPacketListenerImpl) {
                        ServerCommonPacketListenerImpl serverCommonPacketListener = (ServerCommonPacketListenerImpl)listener;
                        if (serverCommonPacketListener.processedDisconnect) {
                            return;
                        }
                    }
                    if (listener.shouldHandleMessage(packet)) {
                        try {
                            packet.handle(listener);
                        }
                        catch (UpdateSuppressionException exception) {
                            LeavesLogger.LOGGER.info(exception.getMessage());
                        }
                        catch (Exception exception) {
                            ReportedException reportedexception;
                            if (exception instanceof ReportedException && (reportedexception = (ReportedException)exception).getCause() instanceof OutOfMemoryError) {
                                throw PacketUtils.makeReportedException(exception, packet, listener);
                            }
                            listener.onPacketError(packet, exception);
                        }
                    } else {
                        LOGGER.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                    }
                }
                finally {
                    totalMainThreadPacketsProcessed.getAndIncrement();
                    packetProcessing.pop();
                }
            });
            throw RunningOnDifferentThreadException.RUNNING_ON_DIFFERENT_THREAD;
        }
    }

    public static <T extends PacketListener> ReportedException makeReportedException(Exception exception, Packet<T> packet, T listener) {
        if (exception instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)exception;
            PacketUtils.fillCrashReport(reportedexception.getReport(), listener, packet);
            return reportedexception;
        }
        CrashReport crashreport = CrashReport.forThrowable(exception, "Main thread packet handler");
        PacketUtils.fillCrashReport(crashreport, listener, packet);
        return new ReportedException(crashreport);
    }

    private static <T extends PacketListener> void fillCrashReport(CrashReport report, T listener, Packet<T> packet) {
        CrashReportCategory crashreportsystemdetails = report.addCategory("Incoming Packet");
        crashreportsystemdetails.setDetail("Type", () -> packet.type().toString());
        crashreportsystemdetails.setDetail("Is Terminal", () -> Boolean.toString(packet.isTerminal()));
        crashreportsystemdetails.setDetail("Is Skippable", () -> Boolean.toString(packet.isSkippable()));
        listener.fillCrashReport(report);
    }
}

