/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class HolderSetCodec<E>
implements Codec<HolderSet<E>> {
    private final ResourceKey<? extends Registry<E>> registryKey;
    private final Codec<Holder<E>> elementCodec;
    private final Codec<List<Holder<E>>> homogenousListCodec;
    private final Codec<Either<TagKey<E>, List<Holder<E>>>> registryAwareCodec;

    private static <E> Codec<List<Holder<E>>> homogenousList(Codec<Holder<E>> entryCodec, boolean alwaysSerializeAsList) {
        Codec codec = entryCodec.listOf().validate(ExtraCodecs.ensureHomogenous(Holder::kind));
        if (alwaysSerializeAsList) {
            return codec;
        }
        return Codec.either((Codec)codec, entryCodec).xmap(either -> either.map(entries -> entries, List::of), entries -> entries.size() == 1 ? Either.right((Holder)entries.get(0)) : Either.left(entries));
    }

    public static <E> Codec<HolderSet<E>> create(ResourceKey<? extends Registry<E>> registryRef, Codec<Holder<E>> entryCodec, boolean alwaysSerializeAsList) {
        return new HolderSetCodec<E>(registryRef, entryCodec, alwaysSerializeAsList);
    }

    private HolderSetCodec(ResourceKey<? extends Registry<E>> registry, Codec<Holder<E>> entryCodec, boolean alwaysSerializeAsList) {
        this.registryKey = registry;
        this.elementCodec = entryCodec;
        this.homogenousListCodec = HolderSetCodec.homogenousList(entryCodec, alwaysSerializeAsList);
        this.registryAwareCodec = Codec.either(TagKey.hashedCodec(registry), this.homogenousListCodec);
    }

    public <T> DataResult<Pair<HolderSet<E>, T>> decode(DynamicOps<T> dynamicOps, T object) {
        RegistryOps registryOps;
        Optional optional;
        if (dynamicOps instanceof RegistryOps && (optional = (registryOps = (RegistryOps)dynamicOps).getter(this.registryKey)).isPresent()) {
            HolderGetter holderGetter = optional.get();
            return this.registryAwareCodec.decode(dynamicOps, object).flatMap(pair -> {
                DataResult dataResult = ((Either)pair.getFirst()).map(tag -> HolderSetCodec.lookupTag(holderGetter, tag), entries -> DataResult.success(HolderSet.direct(entries)));
                return dataResult.map(entries -> Pair.of((Object)entries, (Object)pair.getSecond()));
            });
        }
        return this.decodeWithoutRegistry(dynamicOps, object);
    }

    private static <E> DataResult<HolderSet<E>> lookupTag(HolderGetter<E> registry, TagKey<E> tag) {
        return registry.get(tag).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Missing tag: '" + String.valueOf(tag.location()) + "' in '" + String.valueOf(tag.registry().location()) + "'"));
    }

    public <T> DataResult<T> encode(HolderSet<E> holderSet, DynamicOps<T> dynamicOps, T object) {
        RegistryOps registryOps;
        Optional optional;
        if (dynamicOps instanceof RegistryOps && (optional = (registryOps = (RegistryOps)dynamicOps).owner(this.registryKey)).isPresent()) {
            if (!holderSet.canSerializeIn(optional.get())) {
                return DataResult.error(() -> "HolderSet " + String.valueOf(holderSet) + " is not valid in current registry set");
            }
            return this.registryAwareCodec.encode(holderSet.unwrap().mapRight(List::copyOf), dynamicOps, object);
        }
        return this.encodeWithoutRegistry(holderSet, dynamicOps, object);
    }

    private <T> DataResult<Pair<HolderSet<E>, T>> decodeWithoutRegistry(DynamicOps<T> ops, T input) {
        return this.elementCodec.listOf().decode(ops, input).flatMap(pair -> {
            ArrayList<Holder.Direct> list = new ArrayList<Holder.Direct>();
            for (Holder holder : (List)pair.getFirst()) {
                if (holder instanceof Holder.Direct) {
                    Holder.Direct direct = (Holder.Direct)holder;
                    list.add(direct);
                    continue;
                }
                return DataResult.error(() -> "Can't decode element " + String.valueOf(holder) + " without registry");
            }
            return DataResult.success((Object)new Pair(HolderSet.direct(list), pair.getSecond()));
        });
    }

    private <T> DataResult<T> encodeWithoutRegistry(HolderSet<E> entryList, DynamicOps<T> ops, T prefix) {
        return this.homogenousListCodec.encode(entryList.stream().toList(), ops, prefix);
    }

    public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
        return this.encode((HolderSet)object, dynamicOps, object2);
    }
}

