/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class GiveCommand {
    public static final int MAX_ALLOWED_ITEMSTACKS = 100;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("give").requires(commandlistenerwrapper -> commandlistenerwrapper.hasPermission(2))).then(Commands.argument("targets", EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument("item", ItemArgument.item(commandRegistryAccess)).executes(commandcontext -> GiveCommand.giveItem((CommandSourceStack)commandcontext.getSource(), ItemArgument.getItem(commandcontext, "item"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), 1))).then(Commands.argument("count", IntegerArgumentType.integer((int)1)).executes(commandcontext -> GiveCommand.giveItem((CommandSourceStack)commandcontext.getSource(), ItemArgument.getItem(commandcontext, "item"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"))))))));
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("pgive").requires(css -> css.hasPermission(2))).then(Commands.argument("targets", EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument("item", new ItemArgument(commandRegistryAccess, true)).executes(ctx -> GiveCommand.giveItem((CommandSourceStack)ctx.getSource(), ItemArgument.getItem(ctx, "item"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)ctx, "targets"), 1))).then(Commands.argument("count", IntegerArgumentType.integer((int)1)).executes(ctx -> GiveCommand.giveItem((CommandSourceStack)ctx.getSource(), ItemArgument.getItem(ctx, "item"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)ctx, "targets"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"))))))).build();
        GiveCommand.setClientNodes((CommandNode<CommandSourceStack>)node);
        dispatcher.getRoot().addChild((CommandNode)node);
    }

    static void setClientNodes(CommandNode<CommandSourceStack> node) {
        ArgumentCommandNode argumentNode;
        if (node instanceof ArgumentCommandNode && (argumentNode = (ArgumentCommandNode)node).getType() instanceof ItemArgument) {
            node.clientNode = new ArgumentCommandNode(argumentNode.getName(), (ArgumentType)StringArgumentType.greedyString(), argumentNode.getCommand(), argumentNode.getRequirement(), argumentNode.getRedirect(), argumentNode.getRedirectModifier(), argumentNode.isFork(), (ctx, builder) -> builder.buildFuture());
        }
        node.getChildren().forEach(GiveCommand::setClientNodes);
    }

    private static int giveItem(CommandSourceStack source, ItemInput item, Collection<ServerPlayer> targets, int count) throws CommandSyntaxException {
        ItemStack itemstack = item.createItemStack(1, false);
        Component displayName = itemstack.getDisplayName();
        int j = itemstack.getMaxStackSize();
        int k = j * 100;
        if (count > k) {
            source.sendFailure(Component.translatable("commands.give.failed.toomanyitems", k, itemstack.getDisplayName()));
            return 0;
        }
        for (ServerPlayer entityplayer : targets) {
            int l = count;
            while (l > 0) {
                ItemEntity entityitem;
                int i1 = Math.min(j, l);
                l -= i1;
                ItemStack itemstack1 = item.createItemStack(i1, false);
                boolean flag = entityplayer.getInventory().add(itemstack1);
                if (flag && itemstack1.isEmpty()) {
                    entityitem = entityplayer.drop(itemstack, false, false, false);
                    if (entityitem != null) {
                        entityitem.makeFakeItem();
                    }
                    entityplayer.level().playSound(null, entityplayer.getX(), entityplayer.getY(), entityplayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((entityplayer.getRandom().nextFloat() - entityplayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    entityplayer.containerMenu.broadcastChanges();
                    continue;
                }
                entityitem = entityplayer.drop(itemstack1, false);
                if (entityitem == null) continue;
                entityitem.setNoPickUpDelay();
                entityitem.setTarget(entityplayer.getUUID());
            }
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.give.success.single", count, displayName, ((ServerPlayer)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.give.success.single", count, displayName, targets.size()), true);
        }
        return targets.size();
    }
}

