/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ObjectiveCriteriaArgument;
import net.minecraft.commands.arguments.OperationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.StyleArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.FixedFormat;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class ScoreboardCommand {
    private static final SimpleCommandExceptionType ERROR_OBJECTIVE_ALREADY_EXISTS = new SimpleCommandExceptionType((Message)Component.translatable("commands.scoreboard.objectives.add.duplicate"));
    private static final SimpleCommandExceptionType ERROR_DISPLAY_SLOT_ALREADY_EMPTY = new SimpleCommandExceptionType((Message)Component.translatable("commands.scoreboard.objectives.display.alreadyEmpty"));
    private static final SimpleCommandExceptionType ERROR_DISPLAY_SLOT_ALREADY_SET = new SimpleCommandExceptionType((Message)Component.translatable("commands.scoreboard.objectives.display.alreadySet"));
    private static final SimpleCommandExceptionType ERROR_TRIGGER_ALREADY_ENABLED = new SimpleCommandExceptionType((Message)Component.translatable("commands.scoreboard.players.enable.failed"));
    private static final SimpleCommandExceptionType ERROR_NOT_TRIGGER = new SimpleCommandExceptionType((Message)Component.translatable("commands.scoreboard.players.enable.invalid"));
    private static final Dynamic2CommandExceptionType ERROR_NO_VALUE = new Dynamic2CommandExceptionType((objective, target) -> Component.translatableEscape("commands.scoreboard.players.get.null", objective, target));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("scoreboard").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("objectives").then(Commands.literal("list").executes(context -> ScoreboardCommand.listObjectives((CommandSourceStack)context.getSource())))).then(Commands.literal("add").then(Commands.argument("objective", StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument("criteria", ObjectiveCriteriaArgument.criteria()).executes(context -> ScoreboardCommand.addObjective((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"objective"), ObjectiveCriteriaArgument.getCriteria((CommandContext<CommandSourceStack>)context, "criteria"), Component.literal(StringArgumentType.getString((CommandContext)context, (String)"objective"))))).then(Commands.argument("displayName", ComponentArgument.textComponent(registryAccess)).executes(context -> ScoreboardCommand.addObjective((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"objective"), ObjectiveCriteriaArgument.getCriteria((CommandContext<CommandSourceStack>)context, "criteria"), ComponentArgument.getComponent((CommandContext<CommandSourceStack>)context, "displayName")))))))).then(Commands.literal("modify").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("objective", ObjectiveArgument.objective()).then(Commands.literal("displayname").then(Commands.argument("displayName", ComponentArgument.textComponent(registryAccess)).executes(context -> ScoreboardCommand.setDisplayName((CommandSourceStack)context.getSource(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective"), ComponentArgument.getComponent((CommandContext<CommandSourceStack>)context, "displayName")))))).then(ScoreboardCommand.createRenderTypeModify())).then(Commands.literal("displayautoupdate").then(Commands.argument("value", BoolArgumentType.bool()).executes(commandContext -> ScoreboardCommand.setDisplayAutoUpdate((CommandSourceStack)commandContext.getSource(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"value")))))).then(ScoreboardCommand.addNumberFormats(registryAccess, Commands.literal("numberformat"), (commandContext, numberFormat) -> ScoreboardCommand.setObjectiveFormat((CommandSourceStack)commandContext.getSource(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective"), numberFormat)))))).then(Commands.literal("remove").then(Commands.argument("objective", ObjectiveArgument.objective()).executes(context -> ScoreboardCommand.removeObjective((CommandSourceStack)context.getSource(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective")))))).then(Commands.literal("setdisplay").then(((RequiredArgumentBuilder)Commands.argument("slot", ScoreboardSlotArgument.displaySlot()).executes(context -> ScoreboardCommand.clearDisplaySlot((CommandSourceStack)context.getSource(), ScoreboardSlotArgument.getDisplaySlot((CommandContext<CommandSourceStack>)context, "slot")))).then(Commands.argument("objective", ObjectiveArgument.objective()).executes(context -> ScoreboardCommand.setDisplaySlot((CommandSourceStack)context.getSource(), ScoreboardSlotArgument.getDisplaySlot((CommandContext<CommandSourceStack>)context, "slot"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("players").then(((LiteralArgumentBuilder)Commands.literal("list").executes(context -> ScoreboardCommand.listTrackedPlayers((CommandSourceStack)context.getSource()))).then(Commands.argument("target", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).executes(context -> ScoreboardCommand.listTrackedPlayerScores((CommandSourceStack)context.getSource(), ScoreHolderArgument.getName((CommandContext<CommandSourceStack>)context, "target")))))).then(Commands.literal("set").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).then(Commands.argument("score", IntegerArgumentType.integer()).executes(context -> ScoreboardCommand.setScore((CommandSourceStack)context.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "targets"), ObjectiveArgument.getWritableObjective((CommandContext<CommandSourceStack>)context, "objective"), IntegerArgumentType.getInteger((CommandContext)context, (String)"score")))))))).then(Commands.literal("get").then(Commands.argument("target", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).executes(context -> ScoreboardCommand.getScore((CommandSourceStack)context.getSource(), ScoreHolderArgument.getName((CommandContext<CommandSourceStack>)context, "target"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective"))))))).then(Commands.literal("add").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).then(Commands.argument("score", IntegerArgumentType.integer((int)0)).executes(context -> ScoreboardCommand.addScore((CommandSourceStack)context.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "targets"), ObjectiveArgument.getWritableObjective((CommandContext<CommandSourceStack>)context, "objective"), IntegerArgumentType.getInteger((CommandContext)context, (String)"score")))))))).then(Commands.literal("remove").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).then(Commands.argument("score", IntegerArgumentType.integer((int)0)).executes(context -> ScoreboardCommand.removeScore((CommandSourceStack)context.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "targets"), ObjectiveArgument.getWritableObjective((CommandContext<CommandSourceStack>)context, "objective"), IntegerArgumentType.getInteger((CommandContext)context, (String)"score")))))))).then(Commands.literal("reset").then(((RequiredArgumentBuilder)Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).executes(context -> ScoreboardCommand.resetScores((CommandSourceStack)context.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "targets")))).then(Commands.argument("objective", ObjectiveArgument.objective()).executes(context -> ScoreboardCommand.resetScore((CommandSourceStack)context.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective"))))))).then(Commands.literal("enable").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).suggests((context, builder) -> ScoreboardCommand.suggestTriggers((CommandSourceStack)context.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "targets"), builder)).executes(context -> ScoreboardCommand.enableTrigger((CommandSourceStack)context.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective"))))))).then(((LiteralArgumentBuilder)Commands.literal("display").then(Commands.literal("name").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(((RequiredArgumentBuilder)Commands.argument("objective", ObjectiveArgument.objective()).then(Commands.argument("name", ComponentArgument.textComponent(registryAccess)).executes(commandContext -> ScoreboardCommand.setScoreDisplay((CommandSourceStack)commandContext.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)commandContext, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective"), ComponentArgument.getComponent((CommandContext<CommandSourceStack>)commandContext, "name"))))).executes(commandContext -> ScoreboardCommand.setScoreDisplay((CommandSourceStack)commandContext.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)commandContext, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective"), null)))))).then(Commands.literal("numberformat").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ScoreboardCommand.addNumberFormats(registryAccess, Commands.argument("objective", ObjectiveArgument.objective()), (commandContext, numberFormat) -> ScoreboardCommand.setScoreNumberFormat((CommandSourceStack)commandContext.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)commandContext, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)commandContext, "objective"), numberFormat))))))).then(Commands.literal("operation").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("targetObjective", ObjectiveArgument.objective()).then(Commands.argument("operation", OperationArgument.operation()).then(Commands.argument("source", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("sourceObjective", ObjectiveArgument.objective()).executes(context -> ScoreboardCommand.performOperation((CommandSourceStack)context.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "targets"), ObjectiveArgument.getWritableObjective((CommandContext<CommandSourceStack>)context, "targetObjective"), OperationArgument.getOperation((CommandContext<CommandSourceStack>)context, "operation"), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)context, "source"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "sourceObjective"))))))))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addNumberFormats(CommandBuildContext registryAccess, ArgumentBuilder<CommandSourceStack, ?> argumentBuilder, NumberFormatCommandExecutor executor) {
        return ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)argumentBuilder.then(Commands.literal("blank").executes(context -> executor.run((CommandContext<CommandSourceStack>)context, BlankFormat.INSTANCE)))).then(Commands.literal("fixed").then(Commands.argument("contents", ComponentArgument.textComponent(registryAccess)).executes(context -> {
            Component component = ComponentArgument.getComponent((CommandContext<CommandSourceStack>)context, "contents");
            return executor.run((CommandContext<CommandSourceStack>)context, new FixedFormat(component));
        })))).then(Commands.literal("styled").then(Commands.argument("style", StyleArgument.style(registryAccess)).executes(context -> {
            Style style = StyleArgument.getStyle((CommandContext<CommandSourceStack>)context, "style");
            return executor.run((CommandContext<CommandSourceStack>)context, new StyledFormat(style));
        })))).executes(context -> executor.run((CommandContext<CommandSourceStack>)context, null));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createRenderTypeModify() {
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder = Commands.literal("rendertype");
        for (ObjectiveCriteria.RenderType renderType : ObjectiveCriteria.RenderType.values()) {
            literalArgumentBuilder.then(Commands.literal(renderType.getId()).executes(context -> ScoreboardCommand.setRenderType((CommandSourceStack)context.getSource(), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)context, "objective"), renderType)));
        }
        return literalArgumentBuilder;
    }

    private static CompletableFuture<Suggestions> suggestTriggers(CommandSourceStack source, Collection<ScoreHolder> targets, SuggestionsBuilder builder) {
        ArrayList list = Lists.newArrayList();
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (Objective objective : scoreboard.getObjectives()) {
            if (objective.getCriteria() != ObjectiveCriteria.TRIGGER) continue;
            boolean bl = false;
            for (ScoreHolder scoreHolder : targets) {
                ReadOnlyScoreInfo readOnlyScoreInfo = scoreboard.getPlayerScoreInfo(scoreHolder, objective);
                if (readOnlyScoreInfo != null && !readOnlyScoreInfo.isLocked()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            list.add(objective.getName());
        }
        return SharedSuggestionProvider.suggest(list, builder);
    }

    private static int getScore(CommandSourceStack source, ScoreHolder scoreHolder, Objective objective) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        ReadOnlyScoreInfo readOnlyScoreInfo = scoreboard.getPlayerScoreInfo(scoreHolder, objective);
        if (readOnlyScoreInfo == null) {
            throw ERROR_NO_VALUE.create((Object)objective.getName(), (Object)scoreHolder.getFeedbackDisplayName());
        }
        source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.get.success", scoreHolder.getFeedbackDisplayName(), readOnlyScoreInfo.value(), objective.getFormattedDisplayName()), false);
        return readOnlyScoreInfo.value();
    }

    private static Component getFirstTargetName(Collection<ScoreHolder> targets) {
        return targets.iterator().next().getFeedbackDisplayName();
    }

    private static int performOperation(CommandSourceStack source, Collection<ScoreHolder> targets, Objective targetObjective, OperationArgument.Operation operation, Collection<ScoreHolder> sources, Objective sourceObjectives) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        int i = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess scoreAccess = scoreboard.getOrCreatePlayerScore(scoreHolder, targetObjective);
            for (ScoreHolder scoreHolder2 : sources) {
                ScoreAccess scoreAccess2 = scoreboard.getOrCreatePlayerScore(scoreHolder2, sourceObjectives);
                operation.apply(scoreAccess, scoreAccess2);
            }
            i += scoreAccess.get();
        }
        if (targets.size() == 1) {
            int j = i;
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.operation.success.single", targetObjective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets), j), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.operation.success.multiple", targetObjective.getFormattedDisplayName(), targets.size()), true);
        }
        return i;
    }

    private static int enableTrigger(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective) throws CommandSyntaxException {
        if (objective.getCriteria() != ObjectiveCriteria.TRIGGER) {
            throw ERROR_NOT_TRIGGER.create();
        }
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        int i = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess scoreAccess = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
            if (!scoreAccess.locked()) continue;
            scoreAccess.unlock();
            ++i;
        }
        if (i == 0) {
            throw ERROR_TRIGGER_ALREADY_ENABLED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.enable.success.single", objective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets)), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.enable.success.multiple", objective.getFormattedDisplayName(), targets.size()), true);
        }
        return i;
    }

    private static int resetScores(CommandSourceStack source, Collection<ScoreHolder> targets) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.resetAllPlayerScores(scoreHolder);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.reset.all.single", ScoreboardCommand.getFirstTargetName(targets)), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.reset.all.multiple", targets.size()), true);
        }
        return targets.size();
    }

    private static int resetScore(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.resetSinglePlayerScore(scoreHolder, objective);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.reset.specific.single", objective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets)), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.reset.specific.multiple", objective.getFormattedDisplayName(), targets.size()), true);
        }
        return targets.size();
    }

    private static int setScore(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, int score) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.getOrCreatePlayerScore(scoreHolder, objective).set(score);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.set.success.single", objective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets), score), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.set.success.multiple", objective.getFormattedDisplayName(), targets.size(), score), true);
        }
        return score * targets.size();
    }

    private static int setScoreDisplay(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, @Nullable Component displayName) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.getOrCreatePlayerScore(scoreHolder, objective).display(displayName);
        }
        if (displayName == null) {
            if (targets.size() == 1) {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.name.clear.success.single", ScoreboardCommand.getFirstTargetName(targets), objective.getFormattedDisplayName()), true);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.name.clear.success.multiple", targets.size(), objective.getFormattedDisplayName()), true);
            }
        } else if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.name.set.success.single", displayName, ScoreboardCommand.getFirstTargetName(targets), objective.getFormattedDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.name.set.success.multiple", displayName, targets.size(), objective.getFormattedDisplayName()), true);
        }
        return targets.size();
    }

    private static int setScoreNumberFormat(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, @Nullable NumberFormat numberFormat) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        for (ScoreHolder scoreHolder : targets) {
            scoreboard.getOrCreatePlayerScore(scoreHolder, objective).numberFormatOverride(numberFormat);
        }
        if (numberFormat == null) {
            if (targets.size() == 1) {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.numberFormat.clear.success.single", ScoreboardCommand.getFirstTargetName(targets), objective.getFormattedDisplayName()), true);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.numberFormat.clear.success.multiple", targets.size(), objective.getFormattedDisplayName()), true);
            }
        } else if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.numberFormat.set.success.single", ScoreboardCommand.getFirstTargetName(targets), objective.getFormattedDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.display.numberFormat.set.success.multiple", targets.size(), objective.getFormattedDisplayName()), true);
        }
        return targets.size();
    }

    private static int addScore(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, int score) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        int i = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess scoreAccess = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
            scoreAccess.set(scoreAccess.get() + score);
            i += scoreAccess.get();
        }
        if (targets.size() == 1) {
            int j = i;
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.add.success.single", score, objective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets), j), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.add.success.multiple", score, objective.getFormattedDisplayName(), targets.size()), true);
        }
        return i;
    }

    private static int removeScore(CommandSourceStack source, Collection<ScoreHolder> targets, Objective objective, int score) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        int i = 0;
        for (ScoreHolder scoreHolder : targets) {
            ScoreAccess scoreAccess = scoreboard.getOrCreatePlayerScore(scoreHolder, objective);
            scoreAccess.set(scoreAccess.get() - score);
            i += scoreAccess.get();
        }
        if (targets.size() == 1) {
            int j = i;
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.remove.success.single", score, objective.getFormattedDisplayName(), ScoreboardCommand.getFirstTargetName(targets), j), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.remove.success.multiple", score, objective.getFormattedDisplayName(), targets.size()), true);
        }
        return i;
    }

    private static int listTrackedPlayers(CommandSourceStack source) {
        Collection<ScoreHolder> collection = source.getServer().getScoreboard().getTrackedPlayers();
        if (collection.isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.list.empty"), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.list.success", collection.size(), ComponentUtils.formatList(collection, ScoreHolder::getFeedbackDisplayName)), false);
        }
        return collection.size();
    }

    private static int listTrackedPlayerScores(CommandSourceStack source, ScoreHolder scoreHolder) {
        Object2IntMap<Objective> object2IntMap = source.getServer().getScoreboard().listPlayerScores(scoreHolder);
        if (object2IntMap.isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.list.entity.empty", scoreHolder.getFeedbackDisplayName()), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.list.entity.success", scoreHolder.getFeedbackDisplayName(), object2IntMap.size()), false);
            Object2IntMaps.fastForEach(object2IntMap, entry -> source.sendSuccess(() -> Component.translatable("commands.scoreboard.players.list.entity.entry", ((Objective)entry.getKey()).getFormattedDisplayName(), entry.getIntValue()), false));
        }
        return object2IntMap.size();
    }

    private static int clearDisplaySlot(CommandSourceStack source, DisplaySlot slot) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        if (scoreboard.getDisplayObjective(slot) == null) {
            throw ERROR_DISPLAY_SLOT_ALREADY_EMPTY.create();
        }
        ((Scoreboard)scoreboard).setDisplayObjective(slot, null);
        source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.display.cleared", slot.getSerializedName()), true);
        return 0;
    }

    private static int setDisplaySlot(CommandSourceStack source, DisplaySlot slot, Objective objective) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        if (scoreboard.getDisplayObjective(slot) == objective) {
            throw ERROR_DISPLAY_SLOT_ALREADY_SET.create();
        }
        ((Scoreboard)scoreboard).setDisplayObjective(slot, objective);
        source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.display.set", slot.getSerializedName(), objective.getDisplayName()), true);
        return 0;
    }

    private static int setDisplayName(CommandSourceStack source, Objective objective, Component displayName) {
        if (!objective.getDisplayName().equals(displayName)) {
            objective.setDisplayName(displayName);
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.displayname", objective.getName(), objective.getFormattedDisplayName()), true);
        }
        return 0;
    }

    private static int setDisplayAutoUpdate(CommandSourceStack source, Objective objective, boolean enable) {
        if (objective.displayAutoUpdate() != enable) {
            objective.setDisplayAutoUpdate(enable);
            if (enable) {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.displayAutoUpdate.enable", objective.getName(), objective.getFormattedDisplayName()), true);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.displayAutoUpdate.disable", objective.getName(), objective.getFormattedDisplayName()), true);
            }
        }
        return 0;
    }

    private static int setObjectiveFormat(CommandSourceStack source, Objective objective, @Nullable NumberFormat format) {
        objective.setNumberFormat(format);
        if (format != null) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.objectiveFormat.set", objective.getName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.objectiveFormat.clear", objective.getName()), true);
        }
        return 0;
    }

    private static int setRenderType(CommandSourceStack source, Objective objective, ObjectiveCriteria.RenderType type) {
        if (objective.getRenderType() != type) {
            objective.setRenderType(type);
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.modify.rendertype", objective.getFormattedDisplayName()), true);
        }
        return 0;
    }

    private static int removeObjective(CommandSourceStack source, Objective objective) {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        scoreboard.removeObjective(objective);
        source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.remove.success", objective.getFormattedDisplayName()), true);
        return scoreboard.getObjectives().size();
    }

    private static int addObjective(CommandSourceStack source, String objective, ObjectiveCriteria criteria, Component displayName) throws CommandSyntaxException {
        ServerScoreboard scoreboard = source.getServer().getScoreboard();
        if (scoreboard.getObjective(objective) != null) {
            throw ERROR_OBJECTIVE_ALREADY_EXISTS.create();
        }
        scoreboard.addObjective(objective, criteria, displayName, criteria.getDefaultRenderType(), false, null);
        Objective objective2 = scoreboard.getObjective(objective);
        source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.add.success", objective2.getFormattedDisplayName()), true);
        return scoreboard.getObjectives().size();
    }

    private static int listObjectives(CommandSourceStack source) {
        Collection<Objective> collection = source.getServer().getScoreboard().getObjectives();
        if (collection.isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.list.empty"), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.scoreboard.objectives.list.success", collection.size(), ComponentUtils.formatList(collection, Objective::getFormattedDisplayName)), false);
        }
        return collection.size();
    }

    @FunctionalInterface
    public static interface NumberFormatCommandExecutor {
        public int run(CommandContext<CommandSourceStack> var1, @Nullable NumberFormat var2) throws CommandSyntaxException;
    }
}

