/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.MoreObjects;
import com.mojang.logging.LogUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.core.RegistryAccess;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class Settings<T extends Settings<T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Properties properties;
    private static final boolean skipComments = Boolean.getBoolean("Paper.skipServerPropertiesComments");
    private OptionSet options = null;

    public Settings(Properties properties, OptionSet options) {
        this.properties = properties;
        this.options = options;
    }

    private String getOverride(String name, String value) {
        if (this.options != null && this.options.has(name)) {
            return String.valueOf(this.options.valueOf(name));
        }
        return value;
    }

    public static Properties loadFromFile(Path path) {
        try {
            if (!path.toFile().exists()) {
                return new Properties();
            }
            try {
                Properties properties1;
                try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);){
                    CharsetDecoder charsetdecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    Properties properties = new Properties();
                    properties.load(new InputStreamReader(inputstream, charsetdecoder));
                    properties1 = properties;
                }
                return properties1;
            }
            catch (CharacterCodingException charactercodingexception) {
                Properties properties1;
                LOGGER.info("Failed to load properties as UTF-8 from file {}, trying ISO_8859_1", (Object)path);
                try (BufferedReader bufferedreader = Files.newBufferedReader(path, StandardCharsets.ISO_8859_1);){
                    Properties properties = new Properties();
                    properties.load(bufferedreader);
                    properties1 = properties;
                }
                return properties1;
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to load properties from file: {}", (Object)path, (Object)ioexception);
            return new Properties();
        }
    }

    public void store(Path path) {
        try {
            if (path.toFile().exists() && !path.toFile().canWrite()) {
                LOGGER.warn("Can not write to file {}, skipping.", (Object)path);
                return;
            }
            OutputStream outputstream = Files.newOutputStream(path, new OpenOption[0]);
            BufferedOutputStream bufferedOutputStream = !skipComments ? new BufferedOutputStream(outputstream) : new BufferedOutputStream(this, outputstream){
                private boolean isRightAfterNewline = true;
                private boolean isComment = false;

                @Override
                public void write(@NotNull byte[] b) throws IOException {
                    this.write(b, 0, b.length);
                }

                @Override
                public void write(@NotNull byte[] bbuf, int off, int len) throws IOException {
                    int latest_offset = off;
                    for (int index = off; index < off + len; ++index) {
                        boolean isNewline;
                        byte c = bbuf[index];
                        boolean bl = isNewline = c == 10 || c == 13;
                        if (isNewline && this.isComment) {
                            this.isComment = false;
                            latest_offset = index + 1;
                        }
                        if (c == 35 && this.isRightAfterNewline) {
                            this.isComment = true;
                            if (index != latest_offset) {
                                super.write(bbuf, latest_offset, index - latest_offset);
                            }
                        }
                        this.isRightAfterNewline = isNewline;
                    }
                    if (latest_offset < off + len && !this.isComment) {
                        super.write(bbuf, latest_offset, off + len - latest_offset);
                    }
                }
            };
            try (BufferedWriter bufferedwriter = new BufferedWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, StandardCharsets.UTF_8.newEncoder()));){
                this.properties.store(bufferedwriter, "Minecraft server properties");
            }
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to store properties to file: {}", (Object)path);
        }
    }

    private static <V extends Number> Function<String, V> wrapNumberDeserializer(Function<String, V> parser) {
        return s -> {
            try {
                return (Number)parser.apply((String)s);
            }
            catch (NumberFormatException numberformatexception) {
                return null;
            }
        };
    }

    protected static <V> Function<String, V> dispatchNumberOrString(IntFunction<V> intParser, Function<String, V> fallbackParser) {
        return s -> {
            try {
                return intParser.apply(Integer.parseInt(s));
            }
            catch (NumberFormatException numberformatexception) {
                return fallbackParser.apply((String)s);
            }
        };
    }

    @Nullable
    public String getStringRaw(String key) {
        return this.getOverride(key, this.properties.getProperty(key));
    }

    @Nullable
    protected <V> V getLegacy(String key, Function<String, V> stringifier) {
        String s1 = this.getStringRaw(key);
        if (s1 == null) {
            return null;
        }
        this.properties.remove(key);
        return stringifier.apply(s1);
    }

    protected <V> V get(String key, Function<String, V> parser, Function<V, String> stringifier, V fallback) {
        try {
            return this.get0(key, parser, stringifier, fallback);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load invalidly configured property '" + key + "'", ex);
        }
    }

    private <V> V get0(String s, Function<String, V> function, Function<V, String> function1, V v0) {
        String s1 = this.getStringRaw(s);
        Object v1 = MoreObjects.firstNonNull(s1 != null ? function.apply(s1) : null, v0);
        this.properties.put(s, function1.apply(v1));
        return (V)v1;
    }

    protected <V> MutableValue<V> getMutable(String key, Function<String, V> parser, Function<V, String> stringifier, V fallback) {
        String s1 = this.getStringRaw(key);
        Object v1 = MoreObjects.firstNonNull(s1 != null ? parser.apply(s1) : null, fallback);
        this.properties.put(key, stringifier.apply(v1));
        return new MutableValue<Object>(key, v1, stringifier);
    }

    protected <V> V get(String key, Function<String, V> parser, UnaryOperator<V> parsedTransformer, Function<V, String> stringifier, V fallback) {
        return (V)this.get(key, s1 -> {
            Object v1 = parser.apply((String)s1);
            return v1 != null ? parsedTransformer.apply(v1) : null;
        }, stringifier, fallback);
    }

    protected <V> V get(String key, Function<String, V> parser, V fallback) {
        return (V)this.get(key, parser, Objects::toString, fallback);
    }

    protected <V> MutableValue<V> getMutable(String key, Function<String, V> parser, V fallback) {
        return this.getMutable(key, parser, Objects::toString, fallback);
    }

    protected String get(String key, String fallback) {
        return this.get(key, Function.identity(), Function.identity(), fallback);
    }

    @Nullable
    protected String getLegacyString(String key) {
        return (String)this.getLegacy(key, Function.identity());
    }

    protected int get(String key, int fallback) {
        return this.get(key, Settings.wrapNumberDeserializer(Integer::parseInt), Integer.valueOf(fallback));
    }

    protected MutableValue<Integer> getMutable(String key, int fallback) {
        return this.getMutable(key, Settings.wrapNumberDeserializer(Integer::parseInt), fallback);
    }

    protected int get(String key, UnaryOperator<Integer> transformer, int fallback) {
        return this.get(key, Settings.wrapNumberDeserializer(Integer::parseInt), transformer, Objects::toString, fallback);
    }

    protected long get(String key, long fallback) {
        return this.get(key, Settings.wrapNumberDeserializer(Long::parseLong), fallback);
    }

    protected boolean get(String key, boolean fallback) {
        return this.get(key, Boolean::valueOf, fallback);
    }

    protected MutableValue<Boolean> getMutable(String key, boolean fallback) {
        return this.getMutable(key, Boolean::valueOf, fallback);
    }

    @Nullable
    protected Boolean getLegacyBoolean(String key) {
        return this.getLegacy(key, Boolean::valueOf);
    }

    protected Properties cloneProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        return properties;
    }

    protected abstract T reload(RegistryAccess var1, Properties var2, OptionSet var3);

    public class MutableValue<V>
    implements Supplier<V> {
        private final String key;
        private final V value;
        private final Function<V, String> serializer;

        MutableValue(String s, V object, Function function) {
            this.key = s;
            this.value = object;
            this.serializer = function;
        }

        @Override
        public V get() {
            return this.value;
        }

        public T update(RegistryAccess registryManager, V value) {
            Properties properties = Settings.this.cloneProperties();
            properties.put(this.key, this.serializer.apply(value));
            return Settings.this.reload(registryManager, properties, Settings.this.options);
        }
    }
}

