/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import com.destroystokyo.paper.gui.GuiStatsComponent;
import com.google.common.collect.Lists;
import com.mojang.logging.LogQueues;
import com.mojang.logging.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.gui.PlayerListComponent;
import org.slf4j.Logger;

public class MinecraftServerGui
extends JComponent {
    private static final Font MONOSPACED = new Font("Monospaced", 0, 12);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TITLE = "Minecraft server";
    private static final String SHUTDOWN_TITLE = "Minecraft server - shutting down!";
    private final DedicatedServer server;
    private Thread logAppenderThread;
    private final Collection<Runnable> finalizers = Lists.newArrayList();
    final AtomicBoolean isClosing = new AtomicBoolean();
    private static final Pattern ANSI = Pattern.compile("\\e\\[[\\d;]*[^\\d;]");

    public static MinecraftServerGui showFrameFor(final DedicatedServer server) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JFrame jframe = new JFrame(TITLE);
        final MinecraftServerGui servergui = new MinecraftServerGui(server);
        jframe.setDefaultCloseOperation(2);
        jframe.add(servergui);
        jframe.pack();
        jframe.setLocationRelativeTo(null);
        jframe.setVisible(true);
        jframe.setName(TITLE);
        try {
            jframe.setIconImage(ImageIO.read(Objects.requireNonNull(MinecraftServerGui.class.getClassLoader().getResourceAsStream("logo.png"))));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowevent) {
                if (!servergui.isClosing.getAndSet(true)) {
                    jframe.setTitle(MinecraftServerGui.SHUTDOWN_TITLE);
                    server.halt(true);
                    servergui.runFinalizers();
                }
            }
        });
        Objects.requireNonNull(jframe);
        servergui.addFinalizer(jframe::dispose);
        servergui.start();
        return servergui;
    }

    private MinecraftServerGui(DedicatedServer server) {
        this.server = server;
        this.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.buildOnboardingPanel(), "North");
            this.add((Component)this.buildChatPanel(), "Center");
            this.add((Component)this.buildInfoPanel(), "West");
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't build server GUI", (Throwable)exception);
        }
    }

    public void addFinalizer(Runnable task) {
        this.finalizers.add(task);
    }

    private JComponent buildInfoPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        GuiStatsComponent guistatscomponent = new GuiStatsComponent(this.server);
        Collection<Runnable> collection = this.finalizers;
        Objects.requireNonNull(guistatscomponent);
        collection.add(guistatscomponent::close);
        jpanel.add((Component)guistatscomponent, "North");
        jpanel.add((Component)this.buildPlayerPanel(), "Center");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Stats"));
        return jpanel;
    }

    private JComponent buildOnboardingPanel() {
        final String onboardingLink = "https://docs.leavesmc.org/leaves/guides/next-steps";
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("If you need help setting up your server you can visit:");
        jLabel.setFont(MONOSPACED);
        JLabel link = new JLabel("<html><u> " + onboardingLink + "</u></html>");
        link.setFont(MONOSPACED);
        link.setCursor(new Cursor(12));
        link.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create(onboardingLink));
                }
                catch (IOException exception) {
                    LOGGER.error("Unable to find a default browser. Please manually visit the website: " + onboardingLink, (Throwable)exception);
                }
                catch (UnsupportedOperationException exception) {
                    LOGGER.error("This platform does not support the BROWSE action. Please manually visit the website: " + onboardingLink, (Throwable)exception);
                }
                catch (SecurityException exception) {
                    LOGGER.error("This action has been denied by the security manager. Please manually visit the website: " + onboardingLink, (Throwable)exception);
                }
            }
        });
        jPanel.add(jLabel);
        jPanel.add(link);
        return jPanel;
    }

    private JComponent buildPlayerPanel() {
        PlayerListComponent jlist = new PlayerListComponent(this.server);
        JScrollPane jscrollpane = new JScrollPane(jlist, 22, 30);
        jscrollpane.setBorder(new TitledBorder(new EtchedBorder(), "Players"));
        return jscrollpane;
    }

    private JComponent buildChatPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JTextArea jtextarea = new JTextArea();
        JScrollPane jscrollpane = new JScrollPane(jtextarea, 22, 30);
        jtextarea.setEditable(false);
        jtextarea.setFont(MONOSPACED);
        JTextField jtextfield = new JTextField();
        jtextfield.addActionListener(actionevent -> {
            String s = jtextfield.getText().trim();
            if (!s.isEmpty()) {
                this.server.handleConsoleInput(s, this.server.createCommandSourceStack());
            }
            jtextfield.setText("");
        });
        jtextarea.addFocusListener(new FocusAdapter(this){

            @Override
            public void focusGained(FocusEvent focusevent) {
            }
        });
        jpanel.add((Component)jscrollpane, "Center");
        jpanel.add((Component)jtextfield, "South");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Log and chat"));
        this.logAppenderThread = new Thread(() -> {
            String s;
            while ((s = LogQueues.getNextLogEvent((String)"ServerGuiConsole")) != null) {
                this.print(jtextarea, jscrollpane, s);
            }
        });
        this.logAppenderThread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        this.logAppenderThread.setDaemon(true);
        return jpanel;
    }

    public void start() {
        this.logAppenderThread.start();
    }

    public void close() {
        if (!this.isClosing.getAndSet(true)) {
            this.runFinalizers();
        }
    }

    void runFinalizers() {
        this.finalizers.forEach(Runnable::run);
    }

    public void print(JTextArea textArea, JScrollPane scrollPane, String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.print(textArea, scrollPane, message));
        } else {
            Document document = textArea.getDocument();
            JScrollBar jscrollbar = scrollPane.getVerticalScrollBar();
            boolean flag = false;
            if (scrollPane.getViewport().getView() == textArea) {
                flag = (double)jscrollbar.getValue() + jscrollbar.getSize().getHeight() + (double)(MONOSPACED.getSize() * 4) > (double)jscrollbar.getMaximum();
            }
            try {
                document.insertString(document.getLength(), ANSI.matcher(message).replaceAll(""), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (flag) {
                jscrollbar.setValue(Integer.MAX_VALUE);
            }
        }
    }
}

